/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.eso.ohs.apps.OHSApplication;
import org.eso.ohs.core.utilities.ConnectionPool;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.javamail.MailManagement;
import org.eso.ohs.dbase.DbaseHandlerUnknown;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase2.FindingChartsDBIO;
import org.eso.ohs.dbase.phase2.ReadmeFileDBIO;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.CalibrationBlock;
import org.eso.ohs.dfs.FindingChart;
import org.eso.ohs.dfs.ObservationBlock;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.Readme;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.dfs.Summary;
import org.eso.ohs.instruments.TemplateVersionInfo;
import org.eso.ohs.persistence.AppConfig;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.DirectoryNode;
import org.eso.ohs.persistence.Media;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;
import org.eso.ohs.phase2.obHistory.OBHistory;
import org.jdom.JDOMException;

public abstract class DbaseStorageMgr
implements StorageManager {
    private static final String rcsid = "$Id: DbaseStorageMgr.java,v 1.67 2005/02/11 11:00:27 tcanavan Exp $";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$DbaseStorageMgr == null ? (class$org$eso$ohs$dbase$DbaseStorageMgr = DbaseStorageMgr.class$("org.eso.ohs.dbase.DbaseStorageMgr")) : class$org$eso$ohs$dbase$DbaseStorageMgr));
    private DirectoryNode rootNode_;
    private int userId_;
    private Media device_ = Media.DBASE;
    protected HandlerRegistry registry_;
    static /* synthetic */ Class class$org$eso$ohs$dbase$DbaseStorageMgr;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObservationBlock;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObservingRun;
    static /* synthetic */ Class class$org$eso$ohs$dfs$CalibrationBlock;
    static /* synthetic */ Class class$java$lang$Object;

    public DbaseStorageMgr(Media media) {
        this();
        this.device_ = media;
    }

    public DbaseStorageMgr() {
        this.createRegistry();
        this.rootNode_ = new DirectoryNode(-2L);
    }

    protected abstract void createRegistry();

    public void setUserId(int n) {
        this.userId_ = n;
        this.registry_.setUserId(n);
    }

    public int getUserId() {
        return this.userId_;
    }

    protected Connection acquireConnection(Class clazz) throws ObjectIOException, SQLException {
        Config config = Config.getCfg();
        String string = BusinessObject.getSuffix(clazz);
        String string2 = config.getUrl(string);
        String string3 = config.getDbUserName();
        String string4 = config.getDbPassword();
        stdlog_.debug((Object)("The url: \"" + string2 + "\" the user \"" + string3 + "\" "));
        return ConnectionPool.getPool().acquireConnection(string2, string3, string4);
    }

    protected abstract Connection acquireConnection() throws ObjectIOException, SQLException;

    protected void releaseConnection(Connection connection) throws ObjectIOException {
        ConnectionPool.getPool().releaseConnection(connection);
    }

    public DirectoryNode getRoot() {
        return this.rootNode_;
    }

    public String[] verifyTemplateSignatures(TemplateVersionInfo[] templateVersionInfoArray) throws ObjectIOException {
        return new String[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FindingChart[] populateFindingCharts(long l) throws ObjectIOException {
        FindingChart[] findingChartArray;
        Connection connection = null;
        try {
            try {
                FindingChart[] findingChartArray2;
                connection = this.acquireConnection(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
                findingChartArray = findingChartArray2 = FindingChartsDBIO.read(connection, Config.getCfg().uniqueToTableId(l), true);
                Object var9_7 = null;
                if (connection == null) return findingChartArray;
            }
            catch (SQLException sQLException) {
                Throwable throwable = null;
                Object var9_8 = null;
                if (connection == null) throw new ObjectIOException(throwable.getMessage());
                this.releaseConnection(connection);
                throw new ObjectIOException(throwable.getMessage());
            }
            catch (IOException iOException) {
                throw new ObjectIOException(iOException);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                throw new ObjectIOException(objectNotFoundException);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (connection == null) throw throwable;
            this.releaseConnection(connection);
            throw throwable;
        }
        this.releaseConnection(connection);
        return findingChartArray;
    }

    public void checkInReadme(ObservingRun observingRun) throws ObjectIOException {
        block13: {
            Connection connection = null;
            ObjectIOException objectIOException = null;
            String string = null;
            try {
                connection = this.acquireConnection(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
                string = ReadmeFileDBIO.write(connection, observingRun);
                connection.commit();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    sQLException2.printStackTrace();
                }
                objectIOException = new ObjectIOException(sQLException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                objectIOException = new ObjectIOException(iOException.getMessage());
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                objectNotFoundException.printStackTrace();
                objectIOException = new ObjectIOException(objectNotFoundException.getMessage());
            }
            catch (ObjectIOException objectIOException2) {
                objectIOException = objectIOException2;
            }
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                this.releaseConnection(connection);
            }
            if (objectIOException != null) {
                throw objectIOException;
            }
            if (objectIOException != null || string == null || string.length() <= 0) break block13;
            try {
                this.sendEmail(string, observingRun.getProgId() + " CHECKED IN ", "Readme file checked in please run OT for details");
            }
            catch (MessagingException messagingException) {
                stdlog_.error((Object)messagingException.getMessage());
            }
        }
    }

    private synchronized void sendEmail(String string, String string2, String string3) throws MessagingException {
        MailManagement mailManagement = new MailManagement();
        mailManagement.setSmtpHost(AppConfig.getAppConfig().getSmtpName());
        stdlog_.debug((Object)("Seding Mail " + string));
        mailManagement.postTextPlainMail(string, "", string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void usdSubmit(ObservingRun observingRun) throws ObjectIOException {
        block10: {
            Connection connection = null;
            try {
                try {
                    connection = this.acquireConnection(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
                    int n = ReadmeFileDBIO.getReadmeExists(connection, Config.getCfg().uniqueToTableId(observingRun.getId()));
                    int n2 = ReadmeFileDBIO.getHasObs(connection, Config.getCfg().uniqueToTableId(observingRun.getId()));
                    if (n2 <= 0 && n <= 0) {
                        throw new ObjectIOException(" No OBs or Readme have been submiited for this run. usd-submit failed");
                    }
                    if (n2 <= 0) {
                        throw new ObjectIOException(" No OBs have been submitted for this run. usd-submit failed");
                    }
                    if (n <= 0) {
                        throw new ObjectIOException(" No Readme has been submitted for this run. usd-submit failed");
                    }
                    boolean bl = ReadmeFileDBIO.notAcceptedAndCheckedOut(connection, Config.getCfg().uniqueToTableId(observingRun.getId()));
                    if (bl) {
                        throw new ObjectIOException(" Please checkin your readme file for this run");
                    }
                    Object var9_8 = null;
                    if (connection == null) break block10;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    throw new ObjectIOException(sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (connection == null) throw throwable;
                this.releaseConnection(connection);
                throw throwable;
            }
            this.releaseConnection(connection);
        }
        try {
            this.sendEmail(AppConfig.getAppConfig().getP2PPSubmit(), observingRun.getProgId(), "");
            return;
        }
        catch (MessagingException messagingException) {
            stdlog_.error((Object)messagingException.getMessage());
            throw new ObjectIOException("ESO mail server is down\nPlease try again later");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String checkOutReadme(ObservingRun observingRun) throws ObjectIOException {
        String string;
        String string2;
        block6: {
            Connection connection = null;
            string2 = null;
            string = null;
            try {
                try {
                    connection = this.acquireConnection(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
                    string2 = ReadmeFileDBIO.checkOut(connection, Config.getCfg().uniqueToTableId(observingRun.getId()));
                    string = ReadmeFileDBIO.getUSDEmailAddress(connection, Config.getCfg().uniqueToTableId(observingRun.getId()));
                }
                catch (SQLException sQLException) {
                    throw new ObjectIOException(sQLException);
                }
                Object var8_5 = null;
                if (connection == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (connection == null) throw throwable;
                this.releaseConnection(connection);
                throw throwable;
            }
            this.releaseConnection(connection);
        }
        if (string == null) return string2;
        if (string.length() <= 0) return string2;
        try {
            this.sendEmail(string, observingRun.getProgId() + " Readme Checked Out ", "");
            return string2;
        }
        catch (MessagingException messagingException) {
            stdlog_.error((Object)messagingException.getMessage());
            return string2;
        }
    }

    public byte[] downloadInstrumentPackage(String string, float f) throws ObjectIOException {
        return null;
    }

    public Media getMedia() {
        return this.device_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized long getNewId(Class clazz, long l) throws ObjectIOException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Config config = Config.getCfg();
        if (l != 0L) {
            return config.tableToUniqueId(config.uniqueToTableId(l), clazz);
        }
        try {
            String string = Config.getCfg().getDbName(ObservationBlock.getSuffix());
            connection = this.acquireConnection(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
            statement = connection.prepareCall("{? = call " + string + "..opc_get_key(?)}");
            statement.registerOutParameter(1, 4);
            statement.setString(2, "BUS_OBJ_ID");
            stdlog_.debug((Object)(">>>>>>>>>>>>> C Statement " + statement));
            statement.execute();
            statement.getMoreResults();
            statement.getMoreResults();
            resultSet = statement.getResultSet();
            if (resultSet == null) throw new ObjectIOException("DbaseStorageMgr: could not generate a new database id");
            resultSet.next();
            stdlog_.debug((Object)(" !!!!!!!!! Config " + Config.getCfg().tableToUniqueId(resultSet.getLong(1), clazz)));
            long l2 = Config.getCfg().tableToUniqueId(resultSet.getLong(1), clazz);
            return l2;
        }
        catch (SQLException sQLException) {
            throw new ObjectIOException(sQLException);
        }
        finally {
            block19: {
                if (connection == null) break block19;
                try {
                    block18: {
                        try {
                            if (statement == null) break block18;
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                            Object var19_22 = null;
                            this.releaseConnection(connection);
                            break block19;
                        }
                    }
                    Object var19_21 = null;
                }
                catch (Throwable throwable) {
                    Object var19_23 = null;
                    this.releaseConnection(connection);
                    throw throwable;
                }
                this.releaseConnection(connection);
            }
        }
    }

    public DirectoryNode find(long l, Class clazz) {
        return this.getRoot();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loginUser(String string) throws ObjectIOException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.acquireConnection(class$org$eso$ohs$dfs$ObservingRun == null ? (class$org$eso$ohs$dfs$ObservingRun = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservingRun")) : class$org$eso$ohs$dfs$ObservingRun);
            if (connection == null) {
                stdlog_.debug((Object)"?? Connection is NULL");
            }
            statement = connection.prepareStatement("SELECT item_password from eso_users WHERE id = ? AND item_password = ?");
            statement.setInt(1, this.getUserId());
            statement.setString(2, string);
            statement.execute();
            ResultSet resultSet = statement.getResultSet();
            if (!resultSet.next()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"SQLException", (Throwable)sQLException);
            String string2 = "Cannot connect to the database server:\n";
            String string3 = " in configuration file.";
            String string4 = string2 + "invalid user ID or password" + string3;
            String string5 = string2 + "password" + string3;
            SQLException sQLException2 = sQLException;
            while (true) {
                if (sQLException2 == null) {
                    throw new ObjectIOException(sQLException);
                }
                if (sQLException2.getErrorCode() == 4002) {
                    throw new ObjectIOException(sQLException, string4);
                }
                if (sQLException2.getErrorCode() == 4067) {
                    throw new ObjectIOException(sQLException, string5);
                }
                sQLException2 = sQLException2.getNextException();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            stdlog_.debug((Object)("!! GET CLASS " + exception.getClass()));
            throw new ObjectIOException(exception);
        }
        finally {
            block26: {
                if (connection == null) break block26;
                try {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new ObjectIOException(sQLException);
                    }
                    Object var14_23 = null;
                }
                catch (Throwable throwable) {
                    Object var14_24 = null;
                    this.releaseConnection(connection);
                    throw throwable;
                }
                this.releaseConnection(connection);
            }
        }
    }

    public StorageManager.UnpackedStorableObject read(DirectoryNode directoryNode, long l, Class clazz) throws ObjectNotFoundException, ObjectIOException {
        stdlog_.debug((Object)"read DirectoryNode");
        return this.read(l, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StorageManager.UnpackedStorableObject read(long l, Class clazz) throws ObjectNotFoundException, ObjectIOException {
        stdlog_.debug((Object)"read");
        stdlog_.debug((Object)("Reading handler " + clazz));
        DbaseIOHandler dbaseIOHandler = this.registry_.getHandler(clazz);
        stdlog_.debug((Object)(" handler is " + dbaseIOHandler.getClass().getName()));
        StorageManager.UnpackedStorableObject unpackedStorableObject = null;
        Connection connection = null;
        Statement statement = null;
        l = Config.getCfg().uniqueToTableId(l);
        stdlog_.debug((Object)(">>>>>>>>>>> Id " + l));
        try {
            stdlog_.debug((Object)(" Id " + l));
            connection = this.acquireConnection();
            statement = connection.createStatement();
            stdlog_.debug((Object)(" Id 2" + l));
            StorageManager.UnpackedStorableObject unpackedStorableObject2 = unpackedStorableObject = dbaseIOHandler.read(connection, l);
            return unpackedStorableObject2;
        }
        catch (IOException iOException) {
            stdlog_.error((Object)"", (Throwable)iOException);
            throw new ObjectIOException(iOException);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"", (Throwable)sQLException);
            throw new ObjectIOException(sQLException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stdlog_.error((Object)"", (Throwable)illegalArgumentException);
            throw new ObjectIOException(illegalArgumentException);
        }
        finally {
            block16: {
                if (connection == null) break block16;
                try {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        stdlog_.error((Object)"", (Throwable)sQLException);
                        throw new ObjectIOException(sQLException);
                    }
                    Object var15_16 = null;
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    this.releaseConnection(connection);
                    throw throwable;
                }
                this.releaseConnection(connection);
            }
        }
    }

    public StorageManager.UnpackedStorableObject[] read(DirectoryNode directoryNode, String string, String string2, Class clazz) throws ObjectNotFoundException, ObjectIOException {
        return this.read(string, string2, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StorageManager.UnpackedStorableObject[] read(String string, String string2, Class clazz) throws ObjectNotFoundException, ObjectIOException {
        stdlog_.info((Object)("WhereSql:" + string2 + "; type=" + clazz));
        DbaseIOHandler dbaseIOHandler = this.registry_.getHandler(clazz);
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.acquireConnection();
            statement = connection.createStatement();
            StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray2 = unpackedStorableObjectArray = dbaseIOHandler.read(statement, string2, string);
            return unpackedStorableObjectArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ObjectIOException(iOException);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new ObjectIOException(sQLException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            throw new ObjectIOException(illegalArgumentException);
        }
        finally {
            block16: {
                if (connection == null) break block16;
                try {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        throw new ObjectIOException(sQLException);
                    }
                    Object var15_17 = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    this.releaseConnection(connection);
                    throw throwable;
                }
                this.releaseConnection(connection);
            }
        }
    }

    public void write(DirectoryNode directoryNode, long l, Class clazz, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        Connection connection = null;
        stdlog_.debug((Object)("WRITE: id=" + l + "(" + Config.getCfg().uniqueToTableId(l) + "); type=" + clazz));
        try {
            connection = this.acquireConnection();
            connection.setAutoCommit(false);
            this.store(connection, true, l, clazz, unpackedStorableObject);
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            sQLException.printStackTrace();
            throw new ObjectIOException(sQLException);
        }
        finally {
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                this.releaseConnection(connection);
            }
        }
    }

    private void store(Connection connection, boolean bl, long l, Class clazz, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        DbaseIOHandler dbaseIOHandler = this.registry_.getHandler(clazz);
        System.out.println(dbaseIOHandler.getManagedClass());
        Statement statement = null;
        stdlog_.debug((Object)("id in store method ------------------------------> " + l));
        l = Config.getCfg().uniqueToTableId(l);
        try {
            stdlog_.debug((Object)("IS NEW " + bl));
            if (bl) {
                dbaseIOHandler.write(connection, l, unpackedStorableObject);
            } else {
                dbaseIOHandler.update(connection, l, unpackedStorableObject);
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                throw new ObjectIOException(sQLException2);
            }
            throw new ObjectIOException(sQLException);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new ObjectIOException(sQLException);
            }
        }
    }

    public void multiStore(StorageManager.MultiObjSpec[] multiObjSpecArray) throws ObjectIOException {
        Connection connection = null;
        stdlog_.debug((Object)("MULTISTORE: #objs = " + multiObjSpecArray.length));
        try {
            connection = this.acquireConnection();
            connection.setAutoCommit(false);
            int n = 0;
            while (n < multiObjSpecArray.length) {
                stdlog_.debug((Object)("**************** mos index *********** " + n));
                StorageManager.MultiObjSpec multiObjSpec = multiObjSpecArray[n];
                if (multiObjSpec.obj == null) {
                    System.out.println("***************** There is a problem in multi *************");
                }
                if (multiObjSpec.obj.getObject() == null) {
                    System.out.println("***************** There is a problem in multi *************");
                }
                long l = multiObjSpec.obj.getObject().getId();
                stdlog_.debug((Object)("multistore: obj " + n + " = " + l));
                this.store(connection, multiObjSpec.isNew(), l, multiObjSpec.getCls(), multiObjSpec.obj);
                ++n;
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            throw new ObjectIOException(sQLException);
        }
        finally {
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                this.releaseConnection(connection);
            }
        }
        CalibrationBlock calibrationBlock = this.getCalBlk(multiObjSpecArray);
        try {
            OBHistory.addEvent(Config.getCfg().uniqueToTableId(calibrationBlock.getId()), null, OHSApplication.getShortDesc(), new Integer(calibrationBlock.getOwnerId()).toString(), calibrationBlock.getStatus());
        }
        catch (SQLException sQLException) {
            throw new ObjectIOException(sQLException);
        }
    }

    private CalibrationBlock getCalBlk(StorageManager.MultiObjSpec[] multiObjSpecArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < multiObjSpecArray.length) {
            if (multiObjSpecArray[n].getCls().equals(class$org$eso$ohs$dfs$CalibrationBlock == null ? DbaseStorageMgr.class$("org.eso.ohs.dfs.CalibrationBlock") : class$org$eso$ohs$dfs$CalibrationBlock) || multiObjSpecArray[n].getCls().equals(class$org$eso$ohs$dfs$ObservationBlock == null ? DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock") : class$org$eso$ohs$dfs$ObservationBlock)) {
                CalibrationBlock calibrationBlock = (CalibrationBlock)multiObjSpecArray[n].obj.getObject();
                return calibrationBlock;
            }
            ++n;
        }
        return null;
    }

    public void update(DirectoryNode directoryNode, long l, Class clazz, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        Connection connection = null;
        stdlog_.debug((Object)("UPDATE: id=" + l + "(" + Config.getCfg().uniqueToTableId(l) + "); type=" + clazz));
        try {
            connection = this.acquireConnection();
            connection.setAutoCommit(false);
            this.store(connection, false, l, clazz, unpackedStorableObject);
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                throw new ObjectIOException(sQLException2);
            }
            throw new ObjectIOException(sQLException);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        finally {
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                this.releaseConnection(connection);
            }
        }
    }

    public void delete(DirectoryNode directoryNode, long l, Class clazz) throws ObjectIOException {
        StorageManager.IdType idType = new StorageManager.IdType(l, clazz);
        stdlog_.debug((Object)("DELETE: id=" + l + "(" + Config.getCfg().uniqueToTableId(l) + "); type=" + clazz));
        this.multiDelete(new StorageManager.IdType[]{idType});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete(StorableObject storableObject, Class clazz) throws ObjectIOException {
        Config config = Config.getCfg();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.acquireConnection();
            statement = connection.createStatement();
            long l = config.uniqueToTableId(storableObject.getId());
            DbaseIOHandler dbaseIOHandler = this.registry_.getHandler(clazz);
            dbaseIOHandler.delete(statement, storableObject);
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw new ObjectIOException(sQLException);
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            throw new ObjectIOException(sQLException);
        }
        finally {
            block21: {
                if (connection != null) {
                    try {
                        block20: {
                            try {
                                if (statement == null) break block20;
                                statement.close();
                            }
                            catch (SQLException sQLException) {
                                sQLException.printStackTrace();
                                Object var15_18 = null;
                                this.releaseConnection(connection);
                                break block21;
                            }
                        }
                        Object var15_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_19 = null;
                        this.releaseConnection(connection);
                        throw throwable;
                    }
                    this.releaseConnection(connection);
                }
            }
        }
        try {
            if (!clazz.equals(class$org$eso$ohs$dfs$CalibrationBlock == null ? (class$org$eso$ohs$dfs$CalibrationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.CalibrationBlock")) : class$org$eso$ohs$dfs$CalibrationBlock)) {
                if (!clazz.equals(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock)) return;
            }
            OBHistory.addEvent(Config.getCfg().uniqueToTableId(storableObject.getId()), null, OHSApplication.getShortDesc(), new Integer(this.getUserId()).toString(), "P");
            return;
        }
        catch (SQLException sQLException) {
            throw new ObjectIOException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void multiDelete(StorageManager.IdType[] idTypeArray) throws ObjectIOException {
        Config config = Config.getCfg();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.acquireConnection();
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            int n = 0;
            while (true) {
                if (n >= idTypeArray.length) {
                    connection.commit();
                    break;
                }
                long l = config.uniqueToTableId(idTypeArray[n].id);
                DbaseIOHandler dbaseIOHandler = this.registry_.getHandler(idTypeArray[n].objType);
                dbaseIOHandler.delete(statement, l);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw new ObjectIOException(sQLException);
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            throw new ObjectIOException(sQLException);
        }
        finally {
            block25: {
                if (connection != null) {
                    try {
                        block24: {
                            try {
                                connection.setAutoCommit(true);
                                if (statement == null) break block24;
                                statement.close();
                            }
                            catch (SQLException sQLException) {
                                sQLException.printStackTrace();
                                Object var14_18 = null;
                                this.releaseConnection(connection);
                                break block25;
                            }
                        }
                        Object var14_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        this.releaseConnection(connection);
                        throw throwable;
                    }
                    this.releaseConnection(connection);
                }
            }
        }
        try {
            int n = 0;
            while (true) {
                if (n >= idTypeArray.length) {
                    return;
                }
                if (idTypeArray[n].objType.equals(class$org$eso$ohs$dfs$CalibrationBlock == null ? DbaseStorageMgr.class$("org.eso.ohs.dfs.CalibrationBlock") : class$org$eso$ohs$dfs$CalibrationBlock) || idTypeArray[n].objType.equals(class$org$eso$ohs$dfs$ObservationBlock == null ? DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock") : class$org$eso$ohs$dfs$ObservationBlock)) {
                    OBHistory.addEvent(Config.getCfg().uniqueToTableId(idTypeArray[n].id), null, OHSApplication.getShortDesc(), new Integer(this.getUserId()).toString(), "P");
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            throw new ObjectIOException(sQLException);
        }
    }

    public void move(long l, Class clazz, DirectoryNode directoryNode, DirectoryNode directoryNode2) throws ObjectNotFoundException, ObjectIOException {
    }

    public void initialise() {
    }

    public boolean createDirectory(DirectoryNode directoryNode, long l) {
        return false;
    }

    public boolean moveDirectory(DirectoryNode directoryNode, DirectoryNode directoryNode2) throws ObjectNotFoundException {
        return false;
    }

    public boolean deleteDirectory(DirectoryNode directoryNode) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Summary[] listObjects(DirectoryNode directoryNode) throws ObjectIOException {
        Object[] objectArray;
        Enumeration enumeration = this.registry_.objectTypes();
        Vector<Object> vector = new Vector<Object>();
        Connection connection = null;
        Statement statement = null;
        block13: while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                DbaseIOHandler dbaseIOHandler = this.registry_.getHandler(clazz);
                objectArray = dbaseIOHandler.listObjects(statement);
                int n = 0;
                while (true) {
                    if (n >= objectArray.length) {
                        statement.close();
                        statement = null;
                        continue block13;
                    }
                    vector.addElement(objectArray[n]);
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new ObjectIOException(sQLException);
            }
            finally {
                if (connection != null) {
                    try {
                        block17: {
                            try {
                                if (statement == null) break block17;
                                statement.close();
                            }
                            catch (SQLException sQLException) {
                                sQLException.printStackTrace();
                                Object var15_16 = null;
                                this.releaseConnection(connection);
                            }
                        }
                        Object var15_15 = null;
                        this.releaseConnection(connection);
                    }
                    catch (Throwable throwable) {
                        Object var15_17 = null;
                        this.releaseConnection(connection);
                        throw throwable;
                    }
                }
            }
        }
        objectArray = new Summary[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        return "DbaseStorageMgr[rootNode=" + this.getRoot() + "]";
    }

    public void update(StorableObject storableObject, Class clazz) throws ObjectIOException {
        CalibrationBlock calibrationBlock = null;
        String string = null;
        if (storableObject instanceof CalibrationBlock) {
            string = calibrationBlock.getStatus();
            calibrationBlock = (CalibrationBlock)storableObject;
        }
        DbaseIOHandler dbaseIOHandler = this.registry_.getHandler(clazz);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.acquireConnection();
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            dbaseIOHandler.update(statement, storableObject);
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                throw new ObjectIOException(sQLException2);
            }
            throw new ObjectIOException(sQLException);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                this.releaseConnection(connection);
            }
        }
        if (calibrationBlock != null) {
            try {
                if (!string.equals(calibrationBlock.getStatus())) {
                    OBHistory.addEvent(Config.getCfg().uniqueToTableId(calibrationBlock.getId()), null, OHSApplication.getShortDesc(), new Integer(Config.getCfg().getUserName()).toString(), calibrationBlock.getStatus());
                }
            }
            catch (SQLException sQLException) {
                throw new ObjectIOException(sQLException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Readme populateReadmeFile(ObservingRun observingRun) throws ObjectIOException {
        Readme readme;
        Connection connection = null;
        Object var3_3 = null;
        try {
            try {
                connection = this.acquireConnection(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
                readme = ReadmeFileDBIO.read(connection, observingRun);
                Object var8_6 = null;
                if (connection == null) return readme;
            }
            catch (SQLException sQLException) {
                throw new ObjectIOException(sQLException);
            }
            catch (JDOMException jDOMException) {
                throw new ObjectIOException(jDOMException);
            }
            catch (IOException iOException) {
                throw new ObjectIOException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (connection == null) throw throwable;
            this.releaseConnection(connection);
            throw throwable;
        }
        this.releaseConnection(connection);
        return readme;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Readme populateReadmeFileReplicate(ObservingRun observingRun) throws ObjectIOException {
        Readme readme;
        Connection connection = null;
        Object var3_3 = null;
        try {
            try {
                connection = this.acquireConnection(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
                readme = ReadmeFileDBIO.readReadmeReplicate(connection, observingRun);
                Object var8_6 = null;
                if (connection == null) return readme;
            }
            catch (SQLException sQLException) {
                throw new ObjectIOException(sQLException);
            }
            catch (JDOMException jDOMException) {
                throw new ObjectIOException(jDOMException);
            }
            catch (IOException iOException) {
                throw new ObjectIOException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (connection == null) throw throwable;
            this.releaseConnection(connection);
            throw throwable;
        }
        this.releaseConnection(connection);
        return readme;
    }

    public void setReadmeFileStatus(String string, long l) throws ObjectIOException {
        Connection connection = null;
        Object var5_4 = null;
        ObjectIOException objectIOException = null;
        try {
            connection = this.acquireConnection(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = DbaseStorageMgr.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
            ReadmeFileDBIO.setReadmeFileStatus(connection, string, l);
            connection.commit();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            objectIOException = new ObjectIOException(sQLException.getMessage());
        }
        catch (ObjectIOException objectIOException2) {
            objectIOException = objectIOException2;
        }
        if (connection != null) {
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.releaseConnection(connection);
        }
        if (objectIOException != null) {
            throw objectIOException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class HandlerRegistry {
        private int userId_;
        private Hashtable ioHandlers_ = new Hashtable();

        public HandlerRegistry() {
            this.initialiseRegistry();
        }

        public void setUserId(int n) {
            this.userId_ = n;
        }

        public int getUserId() {
            return this.userId_;
        }

        protected void initialiseRegistry() {
            stdlog_.debug((Object)"dbase.DbaseStorageMgr initialiseRegistry");
            this.register(new DbaseHandlerUnknown());
        }

        public Enumeration objectTypes() {
            return this.ioHandlers_.keys();
        }

        protected void register(DbaseIOHandler dbaseIOHandler) {
            stdlog_.debug((Object)(" register handler : " + dbaseIOHandler.getClass().getName()));
            stdlog_.debug((Object)("Registering class " + dbaseIOHandler.getManagedClass()));
            this.ioHandlers_.put(dbaseIOHandler.getManagedClass(), dbaseIOHandler);
            stdlog_.debug((Object)" done ");
        }

        private DbaseIOHandler lookup(Class clazz) {
            return (DbaseIOHandler)this.ioHandlers_.get(clazz);
        }

        public DbaseIOHandler getHandler(Class clazz) {
            stdlog_.debug((Object)("!!!!!!!!!!!!!!!!!!!!!! Lookup Class !!!!!!!!!!!!!!!! " + clazz));
            DbaseIOHandler dbaseIOHandler = this.lookup(clazz);
            if (dbaseIOHandler == null) {
                dbaseIOHandler = this.lookup(class$java$lang$Object == null ? (class$java$lang$Object = DbaseStorageMgr.class$("java.lang.Object")) : class$java$lang$Object);
            }
            dbaseIOHandler.setUserId(this.getUserId());
            return dbaseIOHandler;
        }
    }
}

