/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dfs.Cycle;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class DbaseHandlerCycle
extends DbaseIOHandler {
    public static int PROPOSAL_SUBMISSION_PHASE = 1;
    private static final int MAX_PHASE1_CYCLES = 100000;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerCycle == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerCycle = DbaseHandlerCycle.class$("org.eso.ohs.dbase.phase1.DbaseHandlerCycle")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerCycle));
    private Hashtable cycleProperties_ = null;
    private Hashtable baselines_ = null;
    private Hashtable lambdacouples_ = null;
    private Hashtable telescopesInstruments_ = null;
    public static final String CYCLE_LABEL = "label";
    public static final String CYCLE_ID = "id";
    public static final String PERIOD = "period";
    public static final String DESCRIPTION = "description";
    public static final String STEP_ID = "step_id";
    public static final String CYCLE_PROP_ID = "cycle_id";
    public static final String CYCLE_PROP_KEY = "cycle_key";
    public static final String CYCLE_PROP_VALUES = "cycle_values";
    public static final String COUNTRIES = "countries";
    public static final String RUN_CODES = "runCodeValues";
    public static final String ALT_RUN_CODES = "altRunCodeValues";
    public static final String PERIOD_LIST = "periodList";
    public static final String OBS_MODE_VALUES = "obsModeValues";
    public static final String MOON_LIST = "moonList";
    public static final String SEEING_VALUES = "seeingValues";
    public static final String SKY_TRANSPARENCY_VALUES = "skyTransparencyValues";
    public static final String SUB_CATEGORY_CODES = "subCategoryCodes";
    public static final String EQUINOX = "equinox";
    public static final String VALID_MONTHS = "validMonths";
    public static final String SPECIAL_INSTRUMENTS = "specialInstruments";
    public static final String INTERF_INSTRUMENTS = "interf_instruments";
    public static final String BASELINES_ROOTNAME = "baselines.";
    public static final String LAMBDACOUPLES_ROOTNAME = "lambdacouples.";
    public static final String OFFERED_ID = "cycle_id";
    public static final String OFFERED_INSTRUMENT = "instrument_code";
    public static final String OFFERED_TELESCOPE = "telescope_code";
    public static final String INSTRUMENTS_CODE = "code";
    public static final String INSTRUMENTS_TEL = "tel";
    public static final String INSTRUMENTS_ID = "id";
    public static final String TELESCOPES_CODE = "code";
    public static final String TELESCOPES_ITEM_NAME = "item_name";
    protected static String cycle_fields = null;
    protected static String cycle_select_sql = null;
    protected static String cycle_sql = null;
    protected static String cycle_properties_fields = null;
    protected static String cycle_properties_select_sql = null;
    protected static String cycle_properties_sql = null;
    static /* synthetic */ Class class$org$eso$ohs$dfs$Cycle;
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerCycle;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$Cycle == null ? (class$org$eso$ohs$dfs$Cycle = DbaseHandlerCycle.class$("org.eso.ohs.dfs.Cycle")) : class$org$eso$ohs$dfs$Cycle;
    }

    public DbaseHandlerCycle() {
        cycle_fields = Phase1SelectStmt.cyclesTable.get() + "." + CYCLE_LABEL + "," + Phase1SelectStmt.cyclesTable.get() + "." + "id" + "," + Phase1SelectStmt.cyclesTable.get() + "." + PERIOD + "," + Phase1SelectStmt.cyclesTable.get() + "." + DESCRIPTION + "," + Phase1SelectStmt.cyclesTable.get() + "." + STEP_ID;
        cycle_select_sql = "SELECT DISTINCT " + cycle_fields;
        cycle_sql = cycle_select_sql + " FROM " + Phase1SelectStmt.cyclesTable.get();
        cycle_properties_fields = Phase1SelectStmt.cyclePropertiesTable.get() + "." + "cycle_id" + "," + Phase1SelectStmt.cyclePropertiesTable.get() + "." + CYCLE_PROP_KEY + "," + Phase1SelectStmt.cyclePropertiesTable.get() + "." + CYCLE_PROP_VALUES;
        cycle_properties_select_sql = "SELECT DISTINCT " + cycle_properties_fields;
        cycle_properties_sql = cycle_properties_select_sql + " FROM " + Phase1SelectStmt.cyclePropertiesTable.get();
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectIOException, ObjectNotFoundException, SQLException {
        Cycle cycle = (Cycle)this.newInstance();
        long l2 = l;
        String string = cycle_sql + " WHERE " + "id" + " = " + l2;
        ResultSet resultSet = this.getResultSet(statement, string);
        resultSet.next();
        cycle.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$Cycle == null ? (class$org$eso$ohs$dfs$Cycle = DbaseHandlerCycle.class$("org.eso.ohs.dfs.Cycle")) : class$org$eso$ohs$dfs$Cycle));
        this.setCyclesFields(cycle, resultSet);
        resultSet.close();
        this.retrieveCycleProperties(statement, l2);
        this.retrieveBaselines(statement, l2);
        this.retrieveLambdacouples(statement, l2);
        this.retrieveTelescopesInstruments(statement, l2);
        this.setCyclePropertiesFields(cycle);
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(cycle);
        return unpackedStorableObject;
    }

    private void retrieveCycleProperties(Statement statement, long l) throws SQLException, ObjectNotFoundException {
        this.cycleProperties_ = new Hashtable();
        String string = cycle_properties_sql + " WHERE " + "cycle_id" + " = " + l;
        ResultSet resultSet = this.getResultSet(statement, string);
        while (resultSet.next()) {
            String string2 = resultSet.getString(CYCLE_PROP_KEY);
            String string3 = resultSet.getString(CYCLE_PROP_VALUES);
            if (string2.indexOf(".") != -1) continue;
            this.cycleProperties_.put(string2, string3);
        }
        resultSet.close();
    }

    private void retrieveBaselines(Statement statement, long l) throws SQLException, ObjectNotFoundException {
        this.baselines_ = new Hashtable();
        String string = "SELECT cycle_key,cycle_values FROM " + Phase1SelectStmt.cyclePropertiesTable.get() + " WHERE " + "cycle_id" + " = " + l + " AND " + CYCLE_PROP_KEY + " like '" + BASELINES_ROOTNAME + "%'";
        stdlog_.info((Object)(" Baselines: " + string));
        ResultSet resultSet = this.getResultSet(statement, string);
        while (resultSet.next()) {
            String string2 = resultSet.getString(CYCLE_PROP_KEY);
            String string3 = string2.substring(BASELINES_ROOTNAME.length());
            String[] stringArray = TextUtils.stringToStringArray(resultSet.getString(CYCLE_PROP_VALUES), " ", true);
            this.baselines_.put(string3, stringArray);
            stdlog_.debug((Object)("baseline Key: " + string3 + " gets value: " + stringArray));
        }
        resultSet.close();
    }

    private void retrieveLambdacouples(Statement statement, long l) throws SQLException, ObjectNotFoundException {
        this.lambdacouples_ = new Hashtable();
        String string = "SELECT cycle_key,cycle_values FROM " + Phase1SelectStmt.cyclePropertiesTable.get() + " WHERE " + "cycle_id" + " = " + l + " AND " + CYCLE_PROP_KEY + " like '" + LAMBDACOUPLES_ROOTNAME + "%'";
        ResultSet resultSet = this.getResultSet(statement, string);
        while (resultSet.next()) {
            String string2 = resultSet.getString(CYCLE_PROP_KEY);
            String string3 = string2.substring(LAMBDACOUPLES_ROOTNAME.length());
            String[] stringArray = TextUtils.stringToStringArray(resultSet.getString(CYCLE_PROP_VALUES), " ", true);
            this.lambdacouples_.put(string3, stringArray);
            stdlog_.debug((Object)("lambdacouples Key: " + string3 + " gets value: " + stringArray));
        }
        resultSet.close();
    }

    private void retrieveTelescopesInstruments(Statement statement, long l) throws SQLException, ObjectNotFoundException {
        String string;
        Object object;
        String string2 = Phase1SelectStmt.offeredTable.get();
        String string3 = string2 + "." + OFFERED_INSTRUMENT;
        String string4 = string2 + "." + OFFERED_TELESCOPE;
        String[] stringArray = new String[]{};
        this.telescopesInstruments_ = new Hashtable();
        Vector vector = new Vector();
        String string5 = "SELECT " + string3 + "," + string4 + " FROM " + string2 + " WHERE " + string2 + "." + "cycle_id" + " = " + l;
        stdlog_.info((Object)("Telescopes: " + string5));
        ResultSet resultSet = this.getResultSet(statement, string5);
        while (resultSet.next()) {
            object = resultSet.getString(OFFERED_TELESCOPE).trim();
            string = resultSet.getString(OFFERED_INSTRUMENT).trim();
            stdlog_.debug((Object)("Telescope in the vector: " + (String)object));
            stdlog_.debug((Object)("Inserting the instruments in the vector: " + string));
            vector = this.telescopesInstruments_.containsKey(object) ? (Vector)this.telescopesInstruments_.get(object) : new Vector();
            vector.add(string);
            this.telescopesInstruments_.put(object, vector);
        }
        resultSet.close();
        object = this.telescopesInstruments_.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            stdlog_.debug((Object)("Inserting the telescope in the array: " + string));
            Vector vector2 = (Vector)this.telescopesInstruments_.get(string);
            stringArray = vector2.toArray(new String[vector2.size()]);
            this.telescopesInstruments_.put(string, stringArray);
        }
    }

    private String[] getArrayFromCollection(Collection collection) {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                vector.add(string);
                ++n;
            }
        }
        stringArray = vector.toArray(new String[vector.size()]);
        return stringArray;
    }

    private ResultSet getResultSet(Statement statement, String string) throws SQLException, ObjectNotFoundException {
        stdlog_.debug((Object)string);
        boolean bl = statement.execute(string);
        if (bl) {
            ResultSet resultSet = statement.executeQuery(string);
            return resultSet;
        }
        throw new ObjectNotFoundException("Object not found in database");
    }

    public StorageManager.UnpackedStorableObject[] read(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        Cycle cycle = null;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = cycle_sql + string2 + " WHERE " + string;
        stdlog_.info((Object)string3);
        ResultSet resultSet = statement.executeQuery(string3);
        try {
            Vector<Cycle> vector = new Vector<Cycle>();
            while (resultSet.next()) {
                cycle = (Cycle)this.newInstance();
                vector.addElement(cycle);
                this.setCyclesFields(cycle, resultSet);
                cycle.setId(Config.getCfg().tableToUniqueId(resultSet.getInt("id"), class$org$eso$ohs$dfs$Cycle == null ? DbaseHandlerCycle.class$("org.eso.ohs.dfs.Cycle") : class$org$eso$ohs$dfs$Cycle));
            }
            resultSet.close();
            unpackedStorableObjectArray = new StorageManager.UnpackedStorableObject[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                cycle = (Cycle)vector.elementAt(n);
                long l = cycle.getCycleId();
                this.retrieveCycleProperties(statement, l);
                this.retrieveBaselines(statement, l);
                this.retrieveLambdacouples(statement, l);
                this.retrieveTelescopesInstruments(statement, l);
                this.setCyclePropertiesFields(cycle);
                unpackedStorableObjectArray[n] = new StorageManager.UnpackedStorableObject(cycle);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return unpackedStorableObjectArray;
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        throw new ObjectIOException("no such method implemented");
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
    }

    public void update(Statement statement, StorableObject storableObject) throws ObjectIOException, SQLException {
        Cycle cycle = (Cycle)storableObject;
        this.updateCycleFields(statement, cycle);
        this.updateCycleProperties(statement, cycle);
        this.updateBaselines(statement, cycle);
        this.updateLambdacouples(statement, cycle);
        this.updateTelescopesInstruments(statement, cycle);
    }

    private void updateCycleFields(Statement statement, Cycle cycle) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CYCLE_LABEL);
        stringBuffer.append(" = '");
        stringBuffer.append(cycle.getLabel());
        stringBuffer.append("',");
        stringBuffer.append(PERIOD);
        stringBuffer.append(" = ");
        stringBuffer.append(cycle.getPeriod());
        stringBuffer.append(",");
        stringBuffer.append(DESCRIPTION);
        stringBuffer.append(" = '");
        stringBuffer.append(cycle.getDescription());
        stringBuffer.append("',");
        stringBuffer.append(STEP_ID);
        stringBuffer.append(" = ");
        stringBuffer.append(cycle.getStepId());
        String string = "  \n UPDATE  " + Phase1SelectStmt.cyclesTable.get() + " SET " + stringBuffer.toString() + " WHERE " + "id" + " = " + Config.getCfg().uniqueToTableId(cycle.getId());
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    private void updateCycleProperties(Statement statement, Cycle cycle) throws SQLException {
        String string;
        long l = cycle.getCycleId();
        this.refreshCyclePropertiesTable(cycle);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        stringBuffer.append("\n");
        Enumeration enumeration = this.cycleProperties_.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Object v = this.cycleProperties_.get(string);
            String[] stringArray = (String[])this.cycleProperties_.get(string);
            String string2 = TextUtils.arrayToString(stringArray, " ", true);
            stringBuffer.append("UPDATE ");
            stringBuffer.append(Phase1SelectStmt.cyclePropertiesTable.get());
            stringBuffer.append(" SET ");
            stringBuffer.append(CYCLE_PROP_VALUES);
            stringBuffer.append(" = '");
            stringBuffer.append(string2);
            stringBuffer.append("' WHERE ");
            stringBuffer.append("cycle_id");
            stringBuffer.append(" = ");
            stringBuffer.append(l);
            stringBuffer.append(" AND ");
            stringBuffer.append(CYCLE_PROP_KEY);
            stringBuffer.append(" = '");
            stringBuffer.append(string);
            stringBuffer.append("'");
            stringBuffer.append("\n");
        }
        string = stringBuffer.toString();
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    private void refreshCyclePropertiesTable(Cycle cycle) {
        this.cycleProperties_.put(COUNTRIES, cycle.getCountries());
        this.cycleProperties_.put(RUN_CODES, cycle.getRuncodeValues());
        this.cycleProperties_.put(ALT_RUN_CODES, cycle.getAltcodeValues());
        this.cycleProperties_.put(OBS_MODE_VALUES, cycle.getObsModeValues());
        this.cycleProperties_.put(PERIOD_LIST, cycle.getPeriodListString());
        this.cycleProperties_.put(MOON_LIST, cycle.getMoonList());
        this.cycleProperties_.put(SEEING_VALUES, cycle.getSeeingValues());
        this.cycleProperties_.put(SKY_TRANSPARENCY_VALUES, cycle.getSkyTransparencyValues());
        this.cycleProperties_.put(SUB_CATEGORY_CODES, cycle.getSubCategoryCodes());
        this.cycleProperties_.put(EQUINOX, cycle.getEquinox());
        this.cycleProperties_.put(VALID_MONTHS, cycle.getValidMonths());
        this.cycleProperties_.put(SPECIAL_INSTRUMENTS, cycle.getSpecialInstruments());
        this.cycleProperties_.put(INTERF_INSTRUMENTS, cycle.getInterferometricInstruments());
    }

    private void updateBaselines(Statement statement, Cycle cycle) throws SQLException {
        this.baselines_ = cycle.getBaselinesTable();
        int n = cycle.getCycleId();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        stringBuffer.append("\n");
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(Phase1SelectStmt.cyclePropertiesTable.get());
        stringBuffer.append(" WHERE ");
        stringBuffer.append("cycle_id");
        stringBuffer.append(" = ");
        stringBuffer.append(n);
        stringBuffer.append(" AND ");
        stringBuffer.append(CYCLE_PROP_KEY);
        stringBuffer.append(" like '");
        stringBuffer.append(BASELINES_ROOTNAME);
        stringBuffer.append("%' \n");
        Enumeration enumeration = this.baselines_.keys();
        StringBuffer stringBuffer2 = this.buildUpdateQuery(n, enumeration, this.baselines_, BASELINES_ROOTNAME);
        String string = stringBuffer.toString() + stringBuffer2.toString();
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    private void updateLambdacouples(Statement statement, Cycle cycle) throws SQLException {
        this.lambdacouples_ = cycle.getLambdacouplesTable();
        int n = cycle.getCycleId();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        stringBuffer.append("\n");
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(Phase1SelectStmt.cyclePropertiesTable.get());
        stringBuffer.append(" WHERE ");
        stringBuffer.append("cycle_id");
        stringBuffer.append(" = ");
        stringBuffer.append(n);
        stringBuffer.append(" AND ");
        stringBuffer.append(CYCLE_PROP_KEY);
        stringBuffer.append(" like '");
        stringBuffer.append(LAMBDACOUPLES_ROOTNAME);
        stringBuffer.append("%' \n");
        Enumeration enumeration = this.lambdacouples_.keys();
        StringBuffer stringBuffer2 = this.buildUpdateQuery(n, enumeration, this.lambdacouples_, LAMBDACOUPLES_ROOTNAME);
        String string = stringBuffer.toString() + stringBuffer2.toString();
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    private void updateTelescopesInstruments(Statement statement, Cycle cycle) throws SQLException {
        this.telescopesInstruments_ = cycle.getTelescopesInstrumentsTable();
        int n = cycle.getCycleId();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        stringBuffer.append("\n");
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(Phase1SelectStmt.offeredTable.get());
        stringBuffer.append(" WHERE ");
        stringBuffer.append("cycle_id");
        stringBuffer.append(" = ");
        stringBuffer.append(n);
        stringBuffer.append(" \n");
        Enumeration enumeration = this.telescopesInstruments_.keys();
        StringBuffer stringBuffer2 = this.buildUpdateTelInstQuery(n, enumeration, this.telescopesInstruments_);
        String string = stringBuffer.toString() + stringBuffer2.toString();
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    private StringBuffer buildUpdateQuery(int n, Enumeration enumeration, Hashtable hashtable, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration2 = enumeration;
        while (enumeration2.hasMoreElements()) {
            String string2 = (String)enumeration2.nextElement();
            Object v = hashtable.get(string2);
            String[] stringArray = (String[])v;
            String string3 = TextUtils.arrayToString(stringArray, " ", true);
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(Phase1SelectStmt.cyclePropertiesTable.get());
            stringBuffer.append("(");
            stringBuffer.append("cycle_id");
            stringBuffer.append(",");
            stringBuffer.append(CYCLE_PROP_KEY);
            stringBuffer.append(",");
            stringBuffer.append(CYCLE_PROP_VALUES);
            stringBuffer.append(")");
            stringBuffer.append(" VALUES(");
            stringBuffer.append(n);
            stringBuffer.append(",'");
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append("','");
            stringBuffer.append(string3);
            stringBuffer.append("') \n ");
        }
        return stringBuffer;
    }

    private StringBuffer buildUpdateTelInstQuery(int n, Enumeration enumeration, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration2 = enumeration;
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            Object v = hashtable.get(string);
            String[] stringArray = (String[])v;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                stringBuffer.append("INSERT INTO ");
                stringBuffer.append(Phase1SelectStmt.offeredTable.get());
                stringBuffer.append("(");
                stringBuffer.append("cycle_id");
                stringBuffer.append(",");
                stringBuffer.append(OFFERED_TELESCOPE);
                stringBuffer.append(",");
                stringBuffer.append(OFFERED_INSTRUMENT);
                stringBuffer.append(")");
                stringBuffer.append(" VALUES(");
                stringBuffer.append(n);
                stringBuffer.append(",'");
                stringBuffer.append(string);
                stringBuffer.append("','");
                stringBuffer.append(string2);
                stringBuffer.append("') \n ");
                ++n2;
            }
        }
        return stringBuffer;
    }

    public void delete(Statement statement, long l) throws ObjectIOException {
    }

    protected void setCyclesFields(Cycle cycle, ResultSet resultSet) throws SQLException {
        cycle.setLabel(resultSet.getString(CYCLE_LABEL));
        cycle.setPeriod(resultSet.getInt(PERIOD));
        cycle.setDescription(resultSet.getString(DESCRIPTION));
        cycle.setStepId(resultSet.getInt(STEP_ID));
    }

    protected void setCyclePropertiesFields(Cycle cycle) throws SQLException {
        cycle.setCountries(TextUtils.stringToStringArray((String)this.cycleProperties_.get(COUNTRIES), " ", true));
        cycle.setRuncodeValues(TextUtils.stringToStringArray((String)this.cycleProperties_.get(RUN_CODES), " ", true));
        cycle.setAltcodeValues(TextUtils.stringToStringArray((String)this.cycleProperties_.get(ALT_RUN_CODES), " ", true));
        cycle.setObsModeValues(TextUtils.stringToStringArray((String)this.cycleProperties_.get(OBS_MODE_VALUES), " ", true));
        cycle.setPeriodList(TextUtils.stringToIntObjArray((String)this.cycleProperties_.get(PERIOD_LIST), " "));
        cycle.setMoonList(TextUtils.stringToStringArray((String)this.cycleProperties_.get(MOON_LIST), " ", true));
        cycle.setSeeingValues(TextUtils.stringToStringArray((String)this.cycleProperties_.get(SEEING_VALUES), " ", true));
        cycle.setSkyTransparencyValues(TextUtils.stringToStringArray((String)this.cycleProperties_.get(SKY_TRANSPARENCY_VALUES), " ", true));
        cycle.setSubCategoryCodes(TextUtils.stringToStringArray((String)this.cycleProperties_.get(SUB_CATEGORY_CODES), " ", true));
        cycle.setEquinox(TextUtils.stringToStringArray((String)this.cycleProperties_.get(EQUINOX), " ", true));
        cycle.setValidMonths(TextUtils.stringToStringArray((String)this.cycleProperties_.get(VALID_MONTHS), " ", true));
        cycle.setSpecialInstruments(TextUtils.stringToStringArray((String)this.cycleProperties_.get(SPECIAL_INSTRUMENTS), " ", true));
        cycle.setInterferometricInstruments(TextUtils.stringToStringArray((String)this.cycleProperties_.get(INTERF_INSTRUMENTS), " ", true));
        cycle.setBaselinesTable(this.baselines_);
        cycle.setLambdaCouplesTable(this.lambdacouples_);
        cycle.setTelescopesInstrumentsTable(this.telescopesInstruments_);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

