/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dfs.SchedRun;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class DbaseHandlerSchedRun
extends DbaseIOHandler {
    private static final String rcsid = "$Id: DbaseHandlerSchedRun.java,v 1.17 2004/10/08 14:25:11 ddorigo Exp $";
    public static final float GRADE_CONV = 10.0f;
    public static final float TIME_CONV = 10.0f;
    static final String run_sql = "SELECT " + Phase1SelectStmt.schedRepTable.get() + ".period, " + Phase1SelectStmt.schedRepTable.get() + ".progid, " + Phase1SelectStmt.schedRepTable.get() + ".obs_mode, " + Phase1SelectStmt.schedRepTable.get() + ".tel, " + Phase1SelectStmt.schedRepTable.get() + ".from_date, " + Phase1SelectStmt.schedRepTable.get() + ".to_date, " + Phase1SelectStmt.schedRepTable.get() + ".nights, " + Phase1SelectStmt.schedRepTable.get() + ".pi_coi, " + Phase1SelectStmt.schedRepTable.get() + ".affil, " + Phase1SelectStmt.schedRepTable.get() + ".inst, " + Phase1SelectStmt.schedRepTable.get() + ".remarks, " + Phase1SelectStmt.schedRepTable.get() + ".title, " + Phase1SelectStmt.schedRepTable.get() + ".observer, " + Phase1SelectStmt.schedRepTable.get() + ".id, " + Phase1SelectStmt.schedRepTable.get() + ".run_id, " + Phase1SelectStmt.schedRepTable.get() + ".night_assistant, " + Phase1SelectStmt.schedRepTable.get() + ".support_astronomer, " + Phase1SelectStmt.schedRepTable.get() + ".month, " + Phase1SelectStmt.schedRepTable.get() + ".moon, " + Phase1SelectStmt.schedRepTable.get() + ".seeing, " + Phase1SelectStmt.schedRepTable.get() + ".rank, " + Phase1SelectStmt.schedRepTable.get() + ".night_fract , " + Phase1SelectStmt.schedRepTable.get() + ".rank_class, " + Phase1SelectStmt.schedRepTable.get() + ".last_mod , " + Phase1SelectStmt.schedRepTable.get() + ".published, " + Phase1SelectStmt.schedRepTable.get() + ".ipversion, " + Phase1SelectStmt.schedRepTable.get() + ".observer_email \n" + "FROM " + Phase1SelectStmt.schedRepTable.get() + " ";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerSchedRun == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerSchedRun = DbaseHandlerSchedRun.class$("org.eso.ohs.dbase.phase1.DbaseHandlerSchedRun")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerSchedRun));
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerSchedRun;
    static /* synthetic */ Class class$org$eso$ohs$dfs$SchedRun;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$SchedRun == null ? (class$org$eso$ohs$dfs$SchedRun = DbaseHandlerSchedRun.class$("org.eso.ohs.dfs.SchedRun")) : class$org$eso$ohs$dfs$SchedRun;
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectNotFoundException, IOException, SQLException {
        ResultSet resultSet = null;
        SchedRun schedRun = (SchedRun)this.newInstance();
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(schedRun);
        String string = run_sql + "WHERE " + Phase1SelectStmt.schedRepTable.get() + ".id = " + l + "\n";
        stdlog_.debug((Object)string);
        resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Object not found in database");
        }
        schedRun.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$SchedRun == null ? (class$org$eso$ohs$dfs$SchedRun = DbaseHandlerSchedRun.class$("org.eso.ohs.dfs.SchedRun")) : class$org$eso$ohs$dfs$SchedRun));
        this.setRunFields(schedRun, resultSet);
        resultSet.close();
        return unpackedStorableObject;
    }

    public StorageManager.UnpackedStorableObject[] read(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        if (string2 == null) {
            string2 = "";
        }
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        SchedRun schedRun = null;
        String string3 = run_sql + string2 + " WHERE " + string;
        stdlog_.debug((Object)string3);
        ResultSet resultSet = statement.executeQuery(string3);
        try {
            Vector<SchedRun> vector = new Vector<SchedRun>();
            while (resultSet.next()) {
                schedRun = (SchedRun)this.newInstance();
                vector.addElement(schedRun);
                schedRun.setId(Config.getCfg().tableToUniqueId(resultSet.getInt("id"), class$org$eso$ohs$dfs$SchedRun == null ? DbaseHandlerSchedRun.class$("org.eso.ohs.dfs.SchedRun") : class$org$eso$ohs$dfs$SchedRun));
                this.setRunFields(schedRun, resultSet);
            }
            resultSet.close();
            unpackedStorableObjectArray = new StorageManager.UnpackedStorableObject[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                schedRun = (SchedRun)vector.elementAt(n);
                unpackedStorableObjectArray[n] = new StorageManager.UnpackedStorableObject(schedRun);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return unpackedStorableObjectArray;
    }

    protected void setRunFields(SchedRun schedRun, ResultSet resultSet) throws SQLException {
        schedRun.setTableId(resultSet.getInt("id"));
        schedRun.setPeriod(resultSet.getInt("period"));
        schedRun.setProgId(resultSet.getString("progid"));
        schedRun.setObsMode(resultSet.getString("obs_mode"));
        schedRun.setTelescope(resultSet.getString("tel"));
        schedRun.setFromDate(resultSet.getLong("from_date"));
        schedRun.setToDate(resultSet.getLong("to_date"));
        schedRun.setNight(resultSet.getFloat("nights"));
        schedRun.setPiCoi(resultSet.getString("pi_coi"));
        schedRun.setAffil(resultSet.getString("affil"));
        schedRun.setInstrument(resultSet.getString("inst"));
        schedRun.setRemarks(resultSet.getString("remarks"));
        schedRun.setTitle(resultSet.getString("title"));
        schedRun.setObserver(TextUtils.getEmptySqlStringIfNull(resultSet.getString("observer")));
        schedRun.setObserverEmail(TextUtils.getEmptySqlStringIfNull(resultSet.getString("observer_email")));
        schedRun.setRunId(resultSet.getLong("run_id"));
        schedRun.setNightAssistant(resultSet.getString("night_assistant"));
        schedRun.setSupportAssistant(resultSet.getString("support_astronomer"));
        String string = resultSet.getString("month");
        if (string == null || string.trim().equals("")) {
            string = "any";
        }
        schedRun.setMonth(string);
        schedRun.setMoon(resultSet.getString("moon"));
        schedRun.setSeeing(resultSet.getInt("seeing"));
        schedRun.setRank(resultSet.getInt("rank"));
        schedRun.setNightFract_(resultSet.getString("night_fract"));
        schedRun.setRankClass(TextUtils.getEmptySqlStringIfNull(resultSet.getString("rank_class")).trim());
        schedRun.setLastMod(resultSet.getString("last_mod"));
        schedRun.setPublished(resultSet.getInt("published"));
        schedRun.setIpversion(resultSet.getBigDecimal("ipversion"));
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        stdlog_.debug((Object)("the obj must be saved with id " + l));
        SchedRun schedRun = (SchedRun)unpackedStorableObject.getObject();
        long l2 = Config.getCfg().uniqueToTableId(schedRun.getId());
        String string = this.buildWriteStmt(schedRun, l2);
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"INSERT error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public String buildWriteStmt(SchedRun schedRun, long l) {
        String string = "INSERT INTO " + Phase1SelectStmt.schedRepTable.get() + " (id, period, progid, obs_mode, tel, " + "from_date, to_date, nights, pi_coi, " + "affil, inst, remarks, title, observer, " + "observer_email, run_id, night_assistant, " + "support_astronomer, rank_class, month, moon, " + "seeing, rank, published, ipversion) VALUES (" + l + ", " + schedRun.getPeriod() + ", " + "'" + TextUtils.quoteSqlString(schedRun.getProgId()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getObsMode()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getTelescope()) + "'" + ", " + schedRun.getFromDate() + ", " + schedRun.getToDate() + ", " + schedRun.getNight() + ", " + "'" + TextUtils.quoteSqlString(schedRun.getPiCoi()) + "'" + ",  " + "'" + TextUtils.quoteSqlString(schedRun.getAffil()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getInstrument()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getRemarks()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getTitle()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getObserver()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getObserverEmail()) + "'" + ", " + schedRun.getRunId() + ", " + "'" + TextUtils.quoteSqlString(schedRun.getNightAssistant()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getSupportAssistant()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getRankClass()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getMonth()) + "'" + ", " + "'" + TextUtils.quoteSqlString(schedRun.getMoon()) + "'" + ", " + schedRun.getSeeing() + ", " + schedRun.getRank() + ", " + schedRun.getPublished() + ", " + this.convertIpVersion(schedRun) + ")";
        return string;
    }

    private String convertIpVersion(SchedRun schedRun) {
        String string = "null";
        if (schedRun.getIpversion() != null) {
            string = schedRun.getIpversion().toString();
        }
        return string;
    }

    public void update(Statement statement, StorableObject storableObject) throws SQLException {
        SchedRun schedRun = (SchedRun)storableObject;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" period = ");
        stringBuffer.append(schedRun.getPeriod());
        stringBuffer.append("\n");
        stringBuffer.append(", progid = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getProgId()));
        stringBuffer.append("'\n");
        stringBuffer.append(", obs_mode = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getObsMode()));
        stringBuffer.append("'\n");
        stringBuffer.append(", tel = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getTelescope()));
        stringBuffer.append("'\n");
        stringBuffer.append(", from_date = ");
        stringBuffer.append(schedRun.getFromDate());
        stringBuffer.append("\n");
        stringBuffer.append(", to_date = ");
        stringBuffer.append(schedRun.getToDate());
        stringBuffer.append("\n");
        stringBuffer.append(", nights = ");
        stringBuffer.append(schedRun.getNight());
        stringBuffer.append("\n");
        stringBuffer.append(", pi_coi = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getPiCoi()));
        stringBuffer.append("'\n");
        stringBuffer.append(", affil = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getAffil()));
        stringBuffer.append("'\n");
        stringBuffer.append(", inst = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getInstrument()));
        stringBuffer.append("'\n");
        stringBuffer.append(", remarks = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getRemarks()));
        stringBuffer.append("'\n");
        stringBuffer.append(", title = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getTitle()));
        stringBuffer.append("'\n");
        stringBuffer.append(", observer = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getObserver()));
        stringBuffer.append("'\n");
        stringBuffer.append(", run_id = ");
        stringBuffer.append(schedRun.getRunId());
        stringBuffer.append("\n");
        stringBuffer.append(", month = '");
        stringBuffer.append(schedRun.getMonth());
        stringBuffer.append("'\n");
        stringBuffer.append(", moon = '");
        stringBuffer.append(schedRun.getMoon());
        stringBuffer.append("'\n");
        stringBuffer.append(", seeing = ");
        stringBuffer.append(schedRun.getSeeing());
        stringBuffer.append("\n");
        stringBuffer.append(", rank = ");
        stringBuffer.append(schedRun.getRank());
        stringBuffer.append("\n");
        stringBuffer.append(", rank_class = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getRankClass()));
        stringBuffer.append("'\n");
        stringBuffer.append(", published = ");
        stringBuffer.append(schedRun.getPublished());
        stringBuffer.append("\n");
        stringBuffer.append(", ipversion = ");
        stringBuffer.append(this.convertIpVersion(schedRun));
        stringBuffer.append("\n");
        stringBuffer.append(", observer_email = '");
        stringBuffer.append(TextUtils.quoteSqlString(schedRun.getObserverEmail()));
        stringBuffer.append("'\n");
        String string = "UPDATE " + Phase1SelectStmt.schedRepTable.get() + "" + " SET " + stringBuffer + " WHERE id = " + schedRun.getTableId();
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws SQLException {
        stdlog_.debug((Object)"update object");
        StorableObject storableObject = unpackedStorableObject.getObject();
        this.update(statement, storableObject);
        stdlog_.debug((Object)"update object done");
    }

    public void delete(Statement statement, StorableObject storableObject) throws ObjectIOException {
        SchedRun schedRun = (SchedRun)storableObject;
        long l = this.checkObsBlockConstraint(statement, schedRun.getRunId());
        if (l != 0L) {
            throw new ObjectIOException("There are " + l + " observing blocks referring to this run.");
        }
        this.deleteSchedRun(statement, schedRun.getTableId());
    }

    private void deleteSchedRun(Statement statement, long l) throws ObjectIOException {
        String string = " \n DELETE  FROM " + Phase1SelectStmt.schedRepTable.get() + " WHERE id = " + l;
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"delete error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing delete: " + string);
        }
    }

    private long checkObsBlockConstraint(Statement statement, long l) throws ObjectIOException {
        ResultSet resultSet = null;
        long l2 = 0L;
        String string = " \n SELECT count(*)  FROM " + Phase1SelectStmt.obsBlocksTable.get() + " WHERE run_id = " + l;
        try {
            stdlog_.debug((Object)string);
            resultSet = statement.executeQuery(string);
            if (!resultSet.next()) {
                throw new ObjectIOException("Object not found in database");
            }
            l2 = resultSet.getLong(1);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return l2;
    }

    public void delete(Statement statement, long l) throws ObjectIOException, SQLException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

