/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ConnectionPool;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase2.ReadmeFileDBIO;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.ConstraintSetDTO;
import org.eso.ohs.dfs.ObservationBlock;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.USDReadmeDatails;
import org.eso.ohs.dfs.USGLog;
import org.eso.ohs.persistence.AppConfig;
import org.eso.ohs.persistence.Config;

public class USDFileDBIO {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase2$ReadmeFileDBIO == null ? (class$org$eso$ohs$dbase$phase2$ReadmeFileDBIO = USDFileDBIO.class$("org.eso.ohs.dbase.phase2.ReadmeFileDBIO")) : class$org$eso$ohs$dbase$phase2$ReadmeFileDBIO));
    private static String obrepDbName = Config.getCfg().getDbName(ObservationBlock.getSuffix());
    private static String opcDbName = Config.getCfg().getDbName(ObservingRun.getSuffix());
    public static String usgFile = obrepDbName + "..usg_file";
    private static String CS = obrepDbName + "..constraint_sets";
    public static String usgSupportNotes = obrepDbName + "..usg_support_notes";
    public static String usgFileReplicate = obrepDbName + "..usg_file_replicate";
    public static String OB = obrepDbName + "..obs_blocks";
    private static String obs_runs = opcDbName + "..obs_runs";
    private static String proposed = opcDbName + "..proposed";
    private static String user_affialiations = opcDbName + "..user_affiliations";
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase2$ReadmeFileDBIO;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObservationBlock;

    public static USDReadmeDatails read(Connection connection, long l) throws SQLException {
        Object[] objectArray;
        Object object;
        USDFileDBIO.setTextSize(connection);
        USDReadmeDatails uSDReadmeDatails = new USDReadmeDatails();
        String string = "SELECT " + usgFile + ".review_status, " + usgFile + ".special_remarks, " + usgFile + ".mts_abstract, " + usgFile + ".pre_imaging, " + usgFile + ".special_cal," + usgFile + ".time_criti," + usgFile + ".carryover_not_derived from " + usgFile + "," + ReadmeFileDBIO.readmeFile + " where " + usgFile + ".run_id = ? AND " + usgFile + ".run_id = " + ReadmeFileDBIO.readmeFile + ".run_id";
        System.out.println(string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        while (resultSet.next()) {
            String string2;
            object = resultSet.getString("review_status");
            uSDReadmeDatails.setReviewStatus(resultSet.getString("review_status").trim());
            objectArray = resultSet.getString("special_remarks");
            if (objectArray != null) {
                uSDReadmeDatails.setSpecialComments(objectArray.trim());
            }
            if ((string2 = resultSet.getString("mts_abstract")) != null) {
                uSDReadmeDatails.setMtsAbstract(string2.trim());
            }
            uSDReadmeDatails.setPreImaging(resultSet.getBoolean("pre_imaging"));
            uSDReadmeDatails.setSpecialCal(resultSet.getBoolean("special_cal"));
            uSDReadmeDatails.setTimeCritical(resultSet.getBoolean("time_criti"));
            uSDReadmeDatails.setCarryOver(resultSet.getBoolean("carryover_not_derived"));
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        if (!bl) {
            throw new SQLException("USD file not available for this Observing Run");
        }
        if (AppConfig.getAppConfig().getBoolean("USD.ENABLED")) {
            string = "SELECT " + usgSupportNotes + ".log_time," + usgSupportNotes + ".support_history" + " from " + usgSupportNotes + " where " + usgSupportNotes + ".run_id = ?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            object = new Vector();
            while (resultSet.next()) {
                objectArray = new USGLog();
                objectArray.setLogMessage(resultSet.getString("support_history"));
                objectArray.setLogTime(resultSet.getLong("log_time"));
                ((Vector)object).addElement(objectArray);
            }
            objectArray = new USGLog[((Vector)object).size()];
            ((Vector)object).copyInto(objectArray);
            uSDReadmeDatails.setUsgLog((USGLog[])objectArray);
            uSDReadmeDatails.setUsdStaffName(USDFileDBIO.getUSDStaffName(connection, l));
        }
        USDFileDBIO.totalCalAndOB(connection, uSDReadmeDatails, l);
        uSDReadmeDatails.setChilean(USDFileDBIO.isChileanFlag(connection, l));
        uSDReadmeDatails.setCsDtos(USDFileDBIO.getConstraintSet(connection, l));
        return uSDReadmeDatails;
    }

    public static USDReadmeDatails readReplicate(Connection connection, long l) throws SQLException {
        USDFileDBIO.setTextSize(connection);
        USDReadmeDatails uSDReadmeDatails = new USDReadmeDatails();
        String string = "SELECT " + usgFile + ".review_status, " + usgFile + ".special_remarks, " + usgFile + ".mts_abstract, " + usgFile + ".pre_imaging, " + usgFile + ".special_cal," + usgFile + ".time_criti," + usgFile + ".carryover_not_derived from " + usgFile + "," + ReadmeFileDBIO.RP + " where " + usgFile + ".run_id = ? AND " + usgFile + ".run_id = " + ReadmeFileDBIO.RP + ".run_id";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        while (resultSet.next()) {
            String string2;
            String string3 = resultSet.getString("review_status");
            uSDReadmeDatails.setReviewStatus(resultSet.getString("review_status").trim());
            String string4 = resultSet.getString("special_remarks");
            if (string4 != null) {
                uSDReadmeDatails.setSpecialComments(string4.trim());
            }
            if ((string2 = resultSet.getString("mts_abstract")) != null) {
                uSDReadmeDatails.setMtsAbstract(string2.trim());
            }
            uSDReadmeDatails.setPreImaging(resultSet.getBoolean("pre_imaging"));
            uSDReadmeDatails.setSpecialCal(resultSet.getBoolean("special_cal"));
            uSDReadmeDatails.setTimeCritical(resultSet.getBoolean("time_criti"));
            uSDReadmeDatails.setCarryOver(resultSet.getBoolean("carryover_not_derived"));
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        USDFileDBIO.totalCalAndOB(connection, uSDReadmeDatails, l);
        uSDReadmeDatails.setChilean(USDFileDBIO.isChileanFlag(connection, l));
        uSDReadmeDatails.setCsDtos(USDFileDBIO.getConstraintSet(connection, l));
        if (!bl) {
            throw new SQLException("USD file not available for this Observing Run");
        }
        return uSDReadmeDatails;
    }

    public static void totalCalAndOB(Connection connection, USDReadmeDatails uSDReadmeDatails, long l) throws SQLException {
        String string = "SELECT count(*) from " + OB + " WHERE " + OB + ".run_id = ?" + " AND " + OB + ".type = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        preparedStatement.setString(2, "C");
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = -1;
        while (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        uSDReadmeDatails.setTotalCBS(n);
        resultSet.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        preparedStatement.setString(2, "O");
        n = -1;
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        uSDReadmeDatails.setTotalOBs(n);
        resultSet.close();
        preparedStatement.close();
    }

    public static void write(Connection connection, USDReadmeDatails uSDReadmeDatails, long l) throws ObjectIOException {
        ObjectIOException objectIOException = null;
        try {
            long l2 = Config.getCfg().uniqueToTableId(l);
            USGLog[] uSGLogArray = uSDReadmeDatails.getUsgLog();
            long[] lArray = new long[uSGLogArray.length];
            int n = 0;
            while (n < lArray.length) {
                lArray[n] = DbaseIOHandler.getDbId(connection);
                ++n;
            }
            USDFileDBIO.setTextSize(connection);
            String string = "UPDATE " + usgFile + " set " + usgFile + ".review_status = ?, " + usgFile + ".special_remarks = ? , " + usgFile + ".mts_abstract = ? , " + usgFile + ".pre_imaging = ?, " + usgFile + ".special_cal= ? ," + usgFile + ".time_criti = ? ," + usgFile + ".carryover_not_derived = ? " + " where " + usgFile + ".run_id = ?";
            stdlog_.debug((Object)string);
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, uSDReadmeDatails.getReviewStatus());
            preparedStatement.setString(2, uSDReadmeDatails.getSpecialComments());
            preparedStatement.setString(3, uSDReadmeDatails.getMtsAbstract());
            preparedStatement.setBoolean(4, uSDReadmeDatails.isPreImaging());
            preparedStatement.setBoolean(5, uSDReadmeDatails.isSpecialCal());
            preparedStatement.setBoolean(6, uSDReadmeDatails.isTimeCritical());
            preparedStatement.setBoolean(7, uSDReadmeDatails.isCarryOver());
            preparedStatement.setLong(8, l2);
            preparedStatement.execute();
            preparedStatement.close();
            string = " DELETE from " + usgSupportNotes + " where " + usgSupportNotes + ".run_id = ?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.execute();
            preparedStatement.close();
            int n2 = 0;
            while (n2 < uSGLogArray.length) {
                string = " INSERT INTO " + usgSupportNotes + " (run_id,usg_support_notes_id,support_history,log_time)" + " VALUES (?,?,?,?)";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setLong(1, l2);
                preparedStatement.setLong(2, lArray[n2]);
                preparedStatement.setString(3, uSGLogArray[n2].getLogMessage());
                preparedStatement.setLong(4, uSGLogArray[n2].getLogTime());
                preparedStatement.execute();
                preparedStatement.close();
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            objectIOException = new ObjectIOException(sQLException.getMessage());
        }
        catch (ObjectIOException objectIOException2) {
            objectIOException = objectIOException2;
        }
        if (connection != null) {
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            ConnectionPool.getPool().releaseConnection(connection);
        }
        if (objectIOException != null) {
            throw objectIOException;
        }
    }

    public static void write(USDReadmeDatails uSDReadmeDatails, long l) throws ObjectIOException {
        String string = BusinessObject.getSuffix(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = USDFileDBIO.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
        String string2 = Config.getCfg().getUrl(string);
        String string3 = Config.getCfg().getDbUserName();
        String string4 = Config.getCfg().getDbPassword();
        ObjectIOException objectIOException = null;
        stdlog_.debug((Object)("The url: \"" + string2 + "\" the user \"" + string3 + "\" "));
        Connection connection = null;
        try {
            connection = ConnectionPool.getPool().acquireConnection(string2, string3, string4);
            USDFileDBIO.write(connection, uSDReadmeDatails, l);
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            objectIOException = new ObjectIOException(sQLException.getMessage());
        }
        if (connection != null) {
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            ConnectionPool.getPool().releaseConnection(connection);
        }
        if (objectIOException != null) {
            throw objectIOException;
        }
    }

    public static USDReadmeDatails read(long l) throws ObjectIOException {
        String string = BusinessObject.getSuffix(class$org$eso$ohs$dfs$ObservationBlock == null ? (class$org$eso$ohs$dfs$ObservationBlock = USDFileDBIO.class$("org.eso.ohs.dfs.ObservationBlock")) : class$org$eso$ohs$dfs$ObservationBlock);
        String string2 = Config.getCfg().getUrl(string);
        String string3 = Config.getCfg().getDbUserName();
        String string4 = Config.getCfg().getDbPassword();
        ObjectIOException objectIOException = null;
        stdlog_.debug((Object)("The url: \"" + string2 + "\" the user \"" + string3 + "\" "));
        Connection connection = null;
        USDReadmeDatails uSDReadmeDatails = null;
        long l2 = Config.getCfg().uniqueToTableId(l);
        try {
            connection = ConnectionPool.getPool().acquireConnection(string2, string3, string4);
            uSDReadmeDatails = USDFileDBIO.read(connection, l2);
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            objectIOException = new ObjectIOException(sQLException.getMessage());
        }
        if (connection != null) {
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            ConnectionPool.getPool().releaseConnection(connection);
        }
        if (objectIOException != null) {
            throw objectIOException;
        }
        return uSDReadmeDatails;
    }

    public static ConstraintSetDTO[] getConstraintSet(Connection connection, long l) throws SQLException {
        Object[] objectArray;
        String string = "select DISTINCT " + CS + ".seeing," + CS + ".airmass," + CS + ".moon_distance," + CS + ".sky_transparency," + CS + ".fli," + "count(*) AS OBCOUNT" + " from " + OB + "," + CS + " where run_id = ? " + " AND " + OB + ".ob_id=" + CS + ".cs_id" + " group by " + CS + ".seeing," + CS + ".airmass," + CS + ".moon_distance," + CS + ".sky_transparency," + CS + ".fli" + " order by OBCOUNT desc";
        stdlog_.debug((Object)string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Object[]> vector = new Vector<Object[]>();
        while (resultSet.next()) {
            objectArray = new ConstraintSetDTO();
            objectArray.setSeeing(resultSet.getFloat("seeing"));
            objectArray.setSkyTransparency(resultSet.getString("sky_transparency"));
            objectArray.setAirmass(resultSet.getFloat("airmass"));
            objectArray.setFractionalLunarIllumination(resultSet.getFloat("fli"));
            objectArray.setMoonAngularDistance(resultSet.getInt("moon_distance") / 3600000);
            objectArray.setCount(resultSet.getInt("OBCOUNT"));
            vector.addElement(objectArray);
        }
        objectArray = new ConstraintSetDTO[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getUSDStaffName(Connection connection, long l) throws SQLException {
        String string = "SELECT " + obrepDbName + "..usg_staff.firstname, " + obrepDbName + "..usg_staff.lastname " + " from " + obrepDbName + "..run_states," + obrepDbName + "..usg_staff" + " WHERE " + obrepDbName + "..run_states.run_id = ?" + " AND " + obrepDbName + "..run_states.cs_acronym" + " = " + obrepDbName + "..usg_staff.cs_acronym";
        stdlog_.debug((Object)string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        while (resultSet.next()) {
            string2 = resultSet.getString(1);
            string3 = resultSet.getString(2);
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        if (bl) {
            return string2 + " " + string3;
        }
        return "N/A";
    }

    public static boolean isChileanFlag(Connection connection, long l) throws SQLException {
        String string = " SELECT " + user_affialiations + ".country_code" + " FROM " + user_affialiations + "," + obs_runs + "," + proposed + " WHERE " + obs_runs + ".programme_id =" + proposed + ".programme_id" + " AND " + proposed + ".pi_flag=0" + " AND " + proposed + ".user_id =" + user_affialiations + ".user_id" + " AND " + obs_runs + ".id = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string2 = null;
        while (resultSet.next()) {
            string2 = resultSet.getString(1);
        }
        resultSet.close();
        preparedStatement.close();
        return string2 != null && string2.equals("RCH");
    }

    private static void setTextSize(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("set TEXTSIZE 1000000");
        statement.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

