/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

public class ConstraintSetDTO {
    private int count;
    private float airmass_ = 5.0f;
    private float fractionalLunarIllumination_ = 1.0f;
    private int moonAngularDistance_ = 30;
    private float seeing_ = 2.0f;
    private String skyTransparency_ = validSkyTransparency_[0];
    private static final String[] validSkyTransparency_ = new String[]{"Photometric", "Clear", "Variable, thin cirrus", "Variable, thick cirrus"};
    private static final String[] skyTransparencyDbRange = new String[]{"1PHO", "2CLR", "3THN", "4THK"};

    public static String[] getValidSkyTransparency() {
        String[] stringArray = new String[validSkyTransparency_.length];
        System.arraycopy(validSkyTransparency_, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public static String[] getDbSkyTransparency() {
        String[] stringArray = new String[skyTransparencyDbRange.length];
        System.arraycopy(skyTransparencyDbRange, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public static String fromDbSkyTransparency(String string) {
        int n = 0;
        while (n < skyTransparencyDbRange.length) {
            if (skyTransparencyDbRange[n].equals(string)) {
                return validSkyTransparency_[n];
            }
            ++n;
        }
        return null;
    }

    public String toDbSkyTransparency(String string) {
        int n = 0;
        while (n < validSkyTransparency_.length) {
            if (validSkyTransparency_[n].equals(string)) {
                return skyTransparencyDbRange[n];
            }
            ++n;
        }
        return null;
    }

    public float getAirmass() {
        return this.airmass_;
    }

    public float getFractionalLunarIllumination() {
        return this.fractionalLunarIllumination_;
    }

    public String getSkyTransparency() {
        return this.skyTransparency_;
    }

    public int getMoonAngularDistance() {
        return this.moonAngularDistance_;
    }

    public float getSeeing() {
        return this.seeing_;
    }

    public void setAirmass(float f) {
        if (f < 1.0f || f > 5.0f) {
            throw new IllegalArgumentException("airmass not in range 1 to 5");
        }
        this.airmass_ = f;
    }

    public void setFractionalLunarIllumination(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("fractional lunar illumination not in range 0 to 1");
        }
        this.fractionalLunarIllumination_ = f;
    }

    public void setMoonAngularDistance(int n) {
        if (n < 0 || n > 180) {
            throw new IllegalArgumentException("moon angular distance not in range 0 to 180");
        }
        this.moonAngularDistance_ = n;
    }

    public void setSeeing(float f) {
        if ((double)f < 0.2 || (double)f > 2.0) {
            throw new IllegalArgumentException("seeing/image quality not in range 0.2 to 2.0");
        }
        this.seeing_ = f;
    }

    public void setSkyTransparency(String string) {
        this.skyTransparency_ = string;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }
}

