/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.persistence;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ConnectionPool;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.persistence.Config;

public class DBdataHelper {
    public static final String ZIP_EXTENSION = ".zip";
    private String url = null;
    private String userName = null;
    private String passwd = null;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$persistence$DBdataHelper == null ? (class$org$eso$ohs$persistence$DBdataHelper = DBdataHelper.class$("org.eso.ohs.persistence.DBdataHelper")) : class$org$eso$ohs$persistence$DBdataHelper));
    private static final int BUFFERSIZE = 0x100000;
    private static DBdataHelper singleton = null;
    private static boolean logEnabled_ = false;
    private Level logLevel_ = null;
    static /* synthetic */ Class class$org$eso$ohs$persistence$DBdataHelper;

    public DBdataHelper() {
    }

    public DBdataHelper(String string, String string2, String string3) {
        this.initializeConnection(string, string2, string3);
    }

    public void initializeConnection(String string, String string2, String string3) {
        this.url = string;
        this.userName = string2;
        this.passwd = string3;
    }

    public static DBdataHelper getInstance() {
        if (singleton == null) {
            singleton = new DBdataHelper();
        }
        return singleton;
    }

    public Connection acquireConnection() throws ObjectIOException, SQLException {
        if (this.url == null || this.userName == null || this.passwd == null) {
            Config config = Config.getCfg();
            if (config == null) {
                throw new ObjectIOException("configuration object not initialized");
            }
            this.url = config.getUrl("OR");
            this.userName = config.getDbUserName();
            this.passwd = config.getDbPassword();
        }
        return ConnectionPool.getPool().acquireConnection(this.url, this.userName, this.passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getBinaryFile(File file, String string) throws ObjectIOException {
        Object var3_3 = null;
        Connection connection = null;
        Statement statement = null;
        ObjectIOException objectIOException = null;
        File file2 = null;
        if (file == null) {
            throw new ObjectIOException("file class is null");
        }
        try {
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                file2 = this.getZippedFile(file, string, statement);
                DBdataHelper.getStdlog().debug((Object)"rs closed");
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var12_9 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return file2;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)("IllegalArgumentException error Sql statement: " + string), (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var12_10 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return file2;
                throw objectIOException;
            }
            catch (IOException iOException) {
                DBdataHelper.getStdlog().error((Object)("IOException filename : " + file.getPath()), (Throwable)iOException);
                objectIOException = new ObjectIOException(iOException);
                Object var12_11 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return file2;
                throw objectIOException;
            }
            Object var12_8 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) return file2;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getFile(File file, String string) throws ObjectIOException {
        Object var3_3 = null;
        Connection connection = null;
        Statement statement = null;
        File file2 = null;
        ObjectIOException objectIOException = null;
        try {
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                file2 = this.getFile(file, string, statement);
                DBdataHelper.getStdlog().debug((Object)"rs closed");
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var12_9 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return file2;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)("IllegalArgumentException error Sql statement: " + string), (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var12_10 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return file2;
                throw objectIOException;
            }
            catch (IOException iOException) {
                DBdataHelper.getStdlog().error((Object)("IOException filename : " + file.getPath()), (Throwable)iOException);
                objectIOException = new ObjectIOException(iOException);
                Object var12_11 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return file2;
                throw objectIOException;
            }
            Object var12_8 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) return file2;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    public File getFile(File file, String string, Statement statement) throws SQLException, ObjectIOException, IOException {
        int n = 1;
        File file2 = file;
        ResultSet resultSet = this.execQuery(string, statement);
        if (!resultSet.next()) {
            DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string));
            throw new ObjectIOException("No data retreived from select");
        }
        InputStream inputStream = resultSet.getBinaryStream(n);
        byte[] byArray = new byte[0x100000];
        int n2 = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        if (inputStream != null) {
            while ((n2 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        resultSet.close();
        return file2;
    }

    public File getZippedFile(File file, String string, Statement statement) throws SQLException, ObjectIOException, IOException {
        int n = 1;
        ResultSet resultSet = this.execQuery(string, statement);
        if (!resultSet.next()) {
            DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string));
            throw new ObjectIOException("No data retreived from select");
        }
        InputStream inputStream = resultSet.getBinaryStream(n);
        File file2 = DBdataHelper.unzip(file, inputStream);
        inputStream.close();
        resultSet.close();
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream(String string) throws ObjectIOException {
        int n = 1;
        InputStream inputStream = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Object var7_7 = null;
        ObjectIOException objectIOException = null;
        try {
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                this.execQuery(string, statement);
                if (!resultSet.next()) {
                    DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string));
                    throw new ObjectIOException("No data retreived from select");
                }
                inputStream = resultSet.getBinaryStream(n);
                resultSet.close();
                DBdataHelper.getStdlog().debug((Object)"rs closed");
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var12_10 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return inputStream;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)("IllegalArgumentException error Sql statement: " + string), (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var12_11 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return inputStream;
                throw objectIOException;
            }
            Object var12_9 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) return inputStream;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    public void updateBinaryZippedStream(File file, String string) throws ObjectIOException {
        Object object;
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        Object var5_5 = null;
        try {
            object = new DataInputStream(new FileInputStream(file));
            ((DataInputStream)object).readFully(byArray);
            ((FilterInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            DBdataHelper.getStdlog().error((Object)("File not found : " + file.getName()), (Throwable)fileNotFoundException);
            throw new ObjectIOException(fileNotFoundException);
        }
        catch (IOException iOException) {
            DBdataHelper.getStdlog().error((Object)("IO error : " + file.getName()), (Throwable)iOException);
            throw new ObjectIOException(iOException);
        }
        object = file.getName();
        File file2 = new File((String)object + ZIP_EXTENSION);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            gZIPOutputStream.write(byArray, 0, byArray.length);
            gZIPOutputStream.flush();
            gZIPOutputStream.close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            DBdataHelper.getStdlog().error((Object)("File not found : " + file.getName()), (Throwable)fileNotFoundException);
            throw new ObjectIOException(fileNotFoundException);
        }
        catch (IOException iOException) {
            DBdataHelper.getStdlog().error((Object)("IO error : " + file.getName()), (Throwable)iOException);
            throw new ObjectIOException(iOException);
        }
        this.updateBinaryStream(file2, string);
        file2.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateBinaryStream(File file, String string) throws ObjectIOException {
        int n = (int)file.length();
        String string2 = file.getName();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        DataInputStream dataInputStream = null;
        ObjectIOException objectIOException = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            DBdataHelper.getStdlog().error((Object)("FileNotFoundException filename : " + string2), (Throwable)fileNotFoundException);
            throw new ObjectIOException(fileNotFoundException);
        }
        DBdataHelper.getStdlog().info((Object)string);
        try {
            try {
                connection = this.acquireConnection();
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setBinaryStream(1, (InputStream)dataInputStream, n);
                preparedStatement.execute();
                connection.commit();
                dataInputStream.close();
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var13_12 = null;
                this.freeConnection(connection, preparedStatement);
                if (objectIOException == null) return;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)("IllegalArgumentException error Sql statement: " + string), (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var13_13 = null;
                this.freeConnection(connection, preparedStatement);
                if (objectIOException == null) return;
                throw objectIOException;
            }
            catch (IOException iOException) {
                DBdataHelper.getStdlog().error((Object)("IOLException error Sql statement: " + string), (Throwable)iOException);
                objectIOException = new ObjectIOException(iOException);
                Object var13_14 = null;
                this.freeConnection(connection, preparedStatement);
                if (objectIOException == null) return;
                throw objectIOException;
            }
            Object var13_11 = null;
            this.freeConnection(connection, preparedStatement);
            if (objectIOException == null) return;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.freeConnection(connection, preparedStatement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    public void insertBinaryZippedFile(File file, String string, Connection connection) throws ObjectIOException, SQLException, IOException {
        DBdataHelper.getStdlog().debug((Object)("inserting file: " + file.getAbsolutePath() + "\n Statement: " + string));
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        this.insertBinaryZippedFile(file, preparedStatement);
        preparedStatement.close();
    }

    protected void insertBinaryZippedFile(File file, PreparedStatement preparedStatement) throws ObjectIOException, SQLException, IOException {
        File file2 = this.convertToZip(file);
        int n = (int)file2.length();
        String string = file2.getAbsolutePath();
        DataInputStream dataInputStream = null;
        Object var7_7 = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            DBdataHelper.getStdlog().error((Object)("FileNotFoundException filename : " + string), (Throwable)fileNotFoundException);
            throw new ObjectIOException(fileNotFoundException);
        }
        preparedStatement.setBinaryStream(1, (InputStream)dataInputStream, n);
        preparedStatement.execute();
        dataInputStream.close();
        file2.delete();
    }

    protected void insertBinaryFile(File file, PreparedStatement preparedStatement) throws ObjectIOException, SQLException, IOException {
        int n = (int)file.length();
        String string = file.getAbsolutePath();
        DataInputStream dataInputStream = null;
        Object var6_6 = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            DBdataHelper.getStdlog().error((Object)("FileNotFoundException filename : " + string), (Throwable)fileNotFoundException);
            throw new ObjectIOException(fileNotFoundException);
        }
        if (n > 0) {
            preparedStatement.setBinaryStream(1, (InputStream)dataInputStream, n);
            preparedStatement.execute();
        }
        dataInputStream.close();
    }

    public void insertBinaryZippedFile(File file, String string) throws ObjectIOException {
        File file2 = this.convertToZip(file);
        this.insertBinaryFile(file2, string);
        file2.delete();
    }

    private File convertToZip(File file) throws ObjectIOException {
        Object object;
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        try {
            object = new DataInputStream(new FileInputStream(file));
            ((DataInputStream)object).readFully(byArray);
            ((FilterInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            DBdataHelper.getStdlog().error((Object)("File not found : " + file.getName()), (Throwable)fileNotFoundException);
            throw new ObjectIOException(fileNotFoundException);
        }
        catch (IOException iOException) {
            DBdataHelper.getStdlog().error((Object)("IO error : " + file.getName()), (Throwable)iOException);
            throw new ObjectIOException(iOException);
        }
        object = file.getAbsolutePath();
        File file2 = new File((String)object + ZIP_EXTENSION);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            gZIPOutputStream.write(byArray, 0, byArray.length);
            gZIPOutputStream.flush();
            gZIPOutputStream.close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            DBdataHelper.getStdlog().error((Object)("File not found : " + file.getName()), (Throwable)fileNotFoundException);
            throw new ObjectIOException(fileNotFoundException);
        }
        catch (IOException iOException) {
            DBdataHelper.getStdlog().error((Object)("IO error : " + file.getName()), (Throwable)iOException);
            throw new ObjectIOException(iOException);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertBinaryFile(File file, String string) throws ObjectIOException {
        Connection connection = null;
        Object var4_4 = null;
        DBdataHelper.getStdlog().debug((Object)string);
        ObjectIOException objectIOException = null;
        try {
            try {
                connection = this.acquireConnection();
                this.insertBinaryFile(file, string, connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var10_7 = null;
                this.freeConnection(connection);
                if (objectIOException == null) return;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)("IllegalArgumentException error Sql statement: " + string), (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var10_8 = null;
                this.freeConnection(connection);
                if (objectIOException == null) return;
                throw objectIOException;
            }
            catch (IOException iOException) {
                DBdataHelper.getStdlog().error((Object)("IOLException error Sql statement: " + string), (Throwable)iOException);
                objectIOException = new ObjectIOException(iOException);
                Object var10_9 = null;
                this.freeConnection(connection);
                if (objectIOException == null) return;
                throw objectIOException;
            }
            Object var10_6 = null;
            this.freeConnection(connection);
            if (objectIOException == null) return;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.freeConnection(connection);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    public void insertBinaryFile(File file, String string, Connection connection) throws SQLException, ObjectIOException, IOException {
        DBdataHelper.getStdlog().debug((Object)("inserting file: " + file.getAbsolutePath() + "\n Statement: " + string));
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        this.insertBinaryFile(file, preparedStatement);
        preparedStatement.close();
    }

    private static File unzip(File file, InputStream inputStream) throws IOException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        byte[] byArray = new byte[0x100000];
        int n = 0;
        DBdataHelper.getStdlog().debug((Object)"unzip start ");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while ((n = gZIPInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        gZIPInputStream.close();
        DBdataHelper.getStdlog().debug((Object)("unzip end  " + file.getAbsolutePath()));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] readStringArray(String string) throws ObjectIOException {
        String[] stringArray = null;
        Connection connection = null;
        Statement statement = null;
        Object var5_5 = null;
        ObjectIOException objectIOException = null;
        try {
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                stringArray = this.readStringArray(string, statement);
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var10_8 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return stringArray;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)("IllegalArgumentException error Sql statement: " + string), (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var10_9 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return stringArray;
                throw objectIOException;
            }
            Object var10_7 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) return stringArray;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    public String[] readStringArray(String string, Statement statement) throws SQLException {
        int n = 1;
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = this.execQuery(string, statement);
        while (resultSet.next()) {
            vector.addElement(resultSet.getString(n));
        }
        resultSet.close();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ResultSet execQuery(String string, Statement statement) throws SQLException {
        DBdataHelper.getStdlog().debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void freeConnection(Connection connection, Statement statement) {
        block10: {
            DBdataHelper.getStdlog().debug((Object)" freeConnection");
            if (connection != null) {
                block9: {
                    if (statement == null) break block9;
                    statement.close();
                }
                Object var5_3 = null;
                try {
                    this.releaseConnection(connection);
                }
                catch (ObjectIOException objectIOException) {
                    DBdataHelper.getStdlog().error((Object)"Error while releasing connection: ", (Throwable)objectIOException);
                }
                break block10;
                {
                    catch (SQLException sQLException) {
                        DBdataHelper.getStdlog().error((Object)"SQLException ", (Throwable)sQLException);
                        Object var5_4 = null;
                        try {
                            this.releaseConnection(connection);
                        }
                        catch (ObjectIOException objectIOException) {
                            DBdataHelper.getStdlog().error((Object)"Error while releasing connection: ", (Throwable)objectIOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        this.releaseConnection(connection);
                    }
                    catch (ObjectIOException objectIOException) {
                        DBdataHelper.getStdlog().error((Object)"Error while releasing connection: ", (Throwable)objectIOException);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void freeConnection(Connection connection) {
        block2: {
            DBdataHelper.getStdlog().debug((Object)" freeConnection");
            if (connection == null) break block2;
            try {
                this.releaseConnection(connection);
            }
            catch (ObjectIOException objectIOException) {
                DBdataHelper.getStdlog().error((Object)"Error while releasing connection: ", (Throwable)objectIOException);
            }
        }
    }

    public void setAutoCommitAndFreeConnection(Connection connection, Statement statement) throws ObjectIOException {
        if (connection != null) {
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)sQLException);
            }
        }
        this.freeConnection(connection, statement);
    }

    public void rollbackConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            DBdataHelper.getStdlog().error((Object)"rollback failed: ", (Throwable)sQLException);
        }
    }

    public Long[] readLongObjArray(String string) throws ObjectIOException {
        long[] lArray = this.readLongArray(string);
        Long[] longArray = new Long[lArray.length];
        int n = 0;
        while (n < lArray.length) {
            longArray[n] = new Long(lArray[n]);
            ++n;
        }
        return longArray;
    }

    public Integer[] readIntObjArray(String string) throws ObjectIOException {
        int[] nArray = this.readIntArray(string);
        Integer[] integerArray = new Integer[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            integerArray[n] = new Integer(nArray[n]);
            ++n;
        }
        return integerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] readIntArray(String string) throws ObjectIOException {
        int n = 1;
        Connection connection = null;
        Statement statement = null;
        Vector<Integer> vector = new Vector<Integer>();
        ResultSet resultSet = null;
        ObjectIOException objectIOException = null;
        int[] nArray = new int[]{};
        try {
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                resultSet = this.execQuery(string, statement);
                while (resultSet.next()) {
                    vector.addElement(new Integer(resultSet.getInt(n)));
                }
                resultSet.close();
                nArray = new int[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    Integer n3 = (Integer)vector.elementAt(n2);
                    nArray[n2] = n3;
                    ++n2;
                }
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var12_14 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return nArray;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)"IllegalArgumentException error", (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var12_15 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return nArray;
                throw objectIOException;
            }
            Object var12_13 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) return nArray;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] readLongArray(String string) throws ObjectIOException {
        int n = 1;
        Connection connection = null;
        Statement statement = null;
        Vector<Long> vector = new Vector<Long>();
        ResultSet resultSet = null;
        DBdataHelper.getStdlog().debug((Object)string);
        ObjectIOException objectIOException = null;
        long[] lArray = new long[]{};
        try {
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                resultSet = this.execQuery(string, statement);
                while (resultSet.next()) {
                    vector.addElement(new Long(resultSet.getLong(n)));
                }
                resultSet.close();
                lArray = new long[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    Long l = (Long)vector.elementAt(n2);
                    lArray[n2] = l;
                    ++n2;
                }
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var12_14 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return lArray;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)"IllegalArgumentException error", (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var12_15 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return lArray;
                throw objectIOException;
            }
            Object var12_13 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) return lArray;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    public int readIntValue(String string) throws ObjectIOException {
        Connection connection = null;
        Statement statement = null;
        int n = -1;
        ObjectIOException objectIOException = null;
        try {
            connection = this.acquireConnection();
        }
        catch (Exception exception) {
            DBdataHelper.getStdlog().error((Object)("Cannot connect: " + string), (Throwable)exception);
            objectIOException = new ObjectIOException(exception);
            throw objectIOException;
        }
        try {
            try {
                statement = connection.createStatement();
                n = this.readIntValue(string, statement);
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)"IllegalArgumentException error", (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                throw objectIOException;
            }
            Object var9_8 = null;
            this.freeConnection(connection, statement);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.freeConnection(connection, statement);
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readString(String string) throws ObjectIOException {
        Connection connection = null;
        Statement statement = null;
        String string2 = "";
        ObjectIOException objectIOException = null;
        try {
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                string2 = this.readString(string, statement);
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var9_7 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return string2;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)"IllegalArgumentException error", (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var9_8 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return string2;
                throw objectIOException;
            }
            Object var9_6 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) return string2;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long readLongValue(String string) throws ObjectIOException {
        Connection connection = null;
        Statement statement = null;
        long l = -1L;
        ObjectIOException objectIOException = null;
        try {
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                l = this.readLongValue(string, statement);
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)("Sql statement error: " + string), (Throwable)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var10_7 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return l;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)"IllegalArgumentException error", (Throwable)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var10_8 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return l;
                throw objectIOException;
            }
            Object var10_6 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) return l;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    public int readIntValue(String string, Statement statement) throws SQLException, ObjectIOException {
        int n = 1;
        ResultSet resultSet = this.execQuery(string, statement);
        int n2 = -1;
        if (!resultSet.next()) {
            resultSet.close();
            throw new ObjectIOException(" value not found in select: " + string);
        }
        n2 = resultSet.getInt(n);
        resultSet.close();
        return n2;
    }

    public String readString(String string, Statement statement) throws SQLException, ObjectIOException {
        int n = 1;
        ResultSet resultSet = this.execQuery(string, statement);
        if (!resultSet.next()) {
            resultSet.close();
            throw new ObjectIOException(" value not found in select: " + string);
        }
        String string2 = resultSet.getString(n);
        resultSet.close();
        return string2;
    }

    public long readLongValue(String string, Statement statement) throws SQLException, ObjectIOException {
        int n = 1;
        ResultSet resultSet = this.execQuery(string, statement);
        long l = -1L;
        if (!resultSet.next()) {
            resultSet.close();
            throw new ObjectIOException(" value not found in select: " + string);
        }
        l = resultSet.getLong(n);
        resultSet.close();
        return l;
    }

    public void releaseConnection(Connection connection) throws ObjectIOException {
        ConnectionPool.getPool().releaseConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execUpdate(String string) throws ObjectIOException {
        Connection connection = null;
        Statement statement = null;
        ObjectIOException objectIOException = null;
        try {
            try {
                connection = this.acquireConnection();
                statement = connection.createStatement();
                this.execUpdate(string, statement);
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                Object var8_6 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return;
                throw objectIOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBdataHelper.getStdlog().error((Object)illegalArgumentException);
                objectIOException = new ObjectIOException(illegalArgumentException);
                Object var8_7 = null;
                this.freeConnection(connection, statement);
                if (objectIOException == null) return;
                throw objectIOException;
            }
            Object var8_5 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) return;
            throw objectIOException;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.freeConnection(connection, statement);
            if (objectIOException == null) throw throwable;
            throw objectIOException;
        }
    }

    public void execUpdate(String string, Statement statement) throws SQLException {
        DBdataHelper.getStdlog().debug((Object)string);
        statement.executeUpdate(string);
    }

    private static Logger getStdlog() {
        return stdlog_;
    }

    public void enableLog() {
        stdlog_.setLevel(this.logLevel_);
    }

    public void disableLog() {
        this.logLevel_ = stdlog_.getLevel();
        stdlog_.setLevel(Level.FATAL);
    }

    public void testConnection() throws ObjectIOException {
        Connection connection = null;
        ObjectIOException objectIOException = null;
        try {
            try {
                connection = this.acquireConnection();
            }
            catch (SQLException sQLException) {
                DBdataHelper.getStdlog().error((Object)sQLException);
                objectIOException = new ObjectIOException(sQLException);
                throw objectIOException;
            }
            Object var5_3 = null;
            this.freeConnection(connection);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.freeConnection(connection);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

