/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.persistence;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eso.ohs.dfs.StorableObject;

public class DirectoryNode
implements Serializable {
    static final long serialVersionUID = 93976372643102550L;
    private StorableObject sobj_;
    private long id_;
    private DirectoryNode parent_;
    private DirectoryNode[] subDirs_;

    public DirectoryNode(long l) {
        this(null, l);
    }

    public DirectoryNode(DirectoryNode directoryNode, long l) {
        this.parent_ = directoryNode;
        this.id_ = l;
    }

    public boolean hasParent() {
        return this.parent_ != null;
    }

    public DirectoryNode getParent() {
        return this.parent_;
    }

    public StorableObject getObject() {
        return this.sobj_;
    }

    public void setObject(StorableObject storableObject) {
        this.sobj_ = storableObject;
    }

    public String getDescription() {
        return this.sobj_ == null ? "" : this.sobj_.getName();
    }

    public void setDescription(String string) {
        if (this.sobj_ != null) {
            this.sobj_.setName(string);
        }
    }

    public long getId() {
        return this.id_;
    }

    public boolean hasSubdir(long l) {
        return this.getDirectory(l) != null;
    }

    public DirectoryNode getDirectory(long l) {
        DirectoryNode directoryNode = null;
        if (this.subDirs_ != null) {
            int n = 0;
            while (n < this.subDirs_.length) {
                if (this.subDirs_[n] != null && l == this.subDirs_[n].id_) {
                    directoryNode = this.subDirs_[n];
                    break;
                }
                ++n;
            }
        }
        return directoryNode;
    }

    public int getChildCount() {
        int n = 0;
        if (this.subDirs_ != null) {
            int n2 = 0;
            while (n2 < this.subDirs_.length) {
                if (this.subDirs_[n2] != null) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public DirectoryNode[] getDirectories() {
        if (this.subDirs_ == null) {
            return new DirectoryNode[0];
        }
        int n = this.getChildCount();
        DirectoryNode[] directoryNodeArray = new DirectoryNode[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.subDirs_.length) {
            if (this.subDirs_[n2] != null) {
                directoryNodeArray[n3++] = this.subDirs_[n2];
            }
            ++n2;
        }
        return directoryNodeArray;
    }

    public DirectoryNode[] ancestors() {
        Vector<DirectoryNode> vector = new Vector<DirectoryNode>();
        DirectoryNode directoryNode = this;
        while (directoryNode != null) {
            vector.insertElementAt(directoryNode, 0);
            directoryNode = directoryNode.getParent();
        }
        Object[] objectArray = new DirectoryNode[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isEmpty() {
        if (this.subDirs_ != null) {
            int n = 0;
            while (n < this.subDirs_.length) {
                if (this.subDirs_[n] != null) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public boolean mkdir(long l) {
        return this.insert(new DirectoryNode(this, l));
    }

    private boolean insert(DirectoryNode directoryNode) {
        if (this.subDirs_ == null) {
            this.subDirs_ = new DirectoryNode[]{null};
        }
        int n = 0;
        while (n < this.subDirs_.length) {
            if (this.subDirs_[n] == null) {
                this.subDirs_[n] = directoryNode;
                return true;
            }
            ++n;
        }
        DirectoryNode[] directoryNodeArray = new DirectoryNode[this.subDirs_.length + 2];
        System.arraycopy(this.subDirs_, 0, directoryNodeArray, 0, this.subDirs_.length);
        this.subDirs_ = directoryNodeArray;
        this.subDirs_[this.subDirs_.length - 1] = directoryNode;
        return true;
    }

    public boolean moveDirectory(DirectoryNode directoryNode) {
        int n = 0;
        while (n < this.parent_.subDirs_.length) {
            if (this.parent_.subDirs_[n] == this) {
                if (directoryNode.insert(this)) {
                    this.parent_.subDirs_[n] = null;
                    this.parent_ = directoryNode;
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean rmdir(long l) {
        int n = 0;
        while (n < this.subDirs_.length) {
            DirectoryNode directoryNode = this.subDirs_[n];
            if (directoryNode != null && l == directoryNode.id_) {
                if (!directoryNode.isEmpty()) {
                    return false;
                }
                this.subDirs_[n] = null;
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DirectoryNode[");
        stringBuffer.append("id=");
        stringBuffer.append(this.id_);
        if (this.parent_ != null) {
            stringBuffer.append(", parent=");
            stringBuffer.append(this.parent_.id_);
        }
        if (this.subDirs_ != null) {
            int n = 0;
            while (n < this.subDirs_.length) {
                if (this.subDirs_[n] != null) {
                    stringBuffer.append(",<");
                    stringBuffer.append(n);
                    stringBuffer.append(">=");
                    stringBuffer.append(this.subDirs_[n].id_);
                }
                ++n;
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Enumeration nodes() {
        return new Traversal(this);
    }

    private class Traversal
    implements Enumeration {
        Enumeration enum_ = null;
        DirectoryNode node_;
        int index_;

        public Traversal(DirectoryNode directoryNode2) {
            this.node_ = directoryNode2;
            this.index_ = -1;
        }

        public boolean hasMoreElements() {
            if (this.index_ < 0) {
                return true;
            }
            if (this.enum_ != null && this.enum_.hasMoreElements()) {
                return true;
            }
            if (this.node_.subDirs_ != null) {
                while (this.index_ < this.node_.subDirs_.length) {
                    if (this.node_.subDirs_[this.index_] != null) {
                        this.enum_ = new Traversal(this.node_.subDirs_[this.index_]);
                        ++this.index_;
                        return true;
                    }
                    ++this.index_;
                }
            }
            return false;
        }

        public Object nextElement() {
            if (this.index_ < 0) {
                this.index_ = 0;
                return this.node_;
            }
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("DirectoryNode");
            }
            return this.enum_.nextElement();
        }
    }
}

