/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.io.File;
import java.io.FilenameFilter;

public class ExtFileList {
    private String[] fileList_;
    private File dir_;

    public ExtFileList(String string, String string2) throws IllegalArgumentException {
        ExtensionFilenameFilter extensionFilenameFilter = new ExtensionFilenameFilter(string2);
        this.dir_ = new File(string);
        if (!this.dir_.isDirectory()) {
            throw new IllegalArgumentException("No Such Directory " + string);
        }
        this.fileList_ = this.dir_.list(extensionFilenameFilter);
    }

    public boolean isEmpty() {
        return this.fileList_.length <= 0;
    }

    public File getFileHandle(String string) {
        String string2 = this.dir_.getAbsolutePath() + File.separator + string;
        File file = new File(string2);
        boolean bl = this.exists(string);
        if (!file.exists() || !bl) {
            return null;
        }
        return file;
    }

    public boolean exists(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.fileList_.length) {
            if (string.equals(this.fileList_[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public String[] getFileList() {
        return this.fileList_;
    }

    public File[] getFileHandles() {
        if (this.isEmpty()) {
            return new File[0];
        }
        File[] fileArray = new File[this.fileList_.length];
        int n = 0;
        while (n < this.fileList_.length) {
            fileArray[n] = new File(this.dir_.getAbsolutePath() + File.separator + this.fileList_[n]);
            ++n;
        }
        return fileArray;
    }

    private class ExtensionFilenameFilter
    implements FilenameFilter {
        private String extension_;

        public ExtensionFilenameFilter(String string) {
            this.extension_ = string;
        }

        public boolean accept(File file, String string) {
            return string.endsWith(this.extension_);
        }
    }
}

