/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.FileCopyException;

public class FileIOUtils {
    private static final int DEFAULT_BUF_LEN = 64000;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$core$utilities$FileIOUtils == null ? (class$org$eso$ohs$core$utilities$FileIOUtils = FileIOUtils.class$("org.eso.ohs.core.utilities.FileIOUtils")) : class$org$eso$ohs$core$utilities$FileIOUtils));
    static boolean overwriteFlag_ = false;
    static /* synthetic */ Class class$org$eso$ohs$core$utilities$FileIOUtils;

    public static void stringToFile(String string, String string2) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
        bufferedWriter.write(string, 0, string.length());
        bufferedWriter.close();
    }

    public static void stringToFile(String string, File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string, 0, string.length());
        bufferedWriter.close();
    }

    public static String fileToString(String string) throws IOException {
        File file = new File(string);
        stdlog_.debug((Object)("Getting data from file " + file.getAbsolutePath()));
        FileReader fileReader = new FileReader(file);
        return FileIOUtils.fileToString(fileReader);
    }

    public static String fileToString(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        return FileIOUtils.fileToString(fileReader);
    }

    public static String fileToString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return FileIOUtils.fileToString(inputStreamReader);
    }

    public static String fileToString(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[64000];
        while (bufferedReader.ready()) {
            int n = bufferedReader.read(cArray, 0, cArray.length);
            if (n <= 0) break;
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static void copyFile(String string, String string2, boolean bl) throws IOException {
        overwriteFlag_ = bl;
        FileIOUtils.copyFile(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            Object object;
            if (!file.exists() || !file.isFile()) {
                throw new FileCopyException("FileCopy: no such source file: " + string);
            }
            if (!file.canRead()) {
                throw new FileCopyException("FileCopy: source file is unreadable: " + string);
            }
            if (file2.exists()) {
                if (!file2.isFile()) throw new FileCopyException("FileCopy: destination is not a file: " + string2);
                if (!overwriteFlag_) {
                    object = new BufferedReader(new InputStreamReader(System.in));
                    if (!file2.canWrite()) {
                        throw new FileCopyException("FileCopy: destination file is unwriteable: " + string2);
                    }
                    System.out.print("File " + string2 + " already exists.  Overwrite? (Y/N): ");
                    System.out.flush();
                    String string3 = ((BufferedReader)object).readLine();
                    if (!string3.equals("Y") && !string3.equals("y")) {
                        throw new FileCopyException("FileCopy: copy cancelled.");
                    }
                }
            } else {
                object = FileIOUtils.parent(file2);
                if (!((File)object).exists()) {
                    throw new FileCopyException("FileCopy: destination directory doesn't exist: " + string2);
                }
                if (!((File)object).canWrite()) {
                    throw new FileCopyException("FileCopy: destination directory is unwriteable: " + string2);
                }
            }
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while (true) {
                int n;
                if ((n = fileInputStream.read(byArray)) == -1) {
                    return;
                }
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] readBinaryFile(String string, int n) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        byte[] byArray = new byte[]{};
        bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = null;
        int n2 = 0;
        while ((n2 = ((InputStream)bufferedInputStream).read(byArray2, 0, n)) != -1) {
            byArray3 = new byte[byArray.length + n2];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, n2);
            byArray = byArray3;
            byArray3 = null;
        }
        return byArray;
    }

    public static void writeBinaryFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static byte[] convertInputStreamToBinary(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = null;
        int n2 = 0;
        while ((n2 = inputStream.read(byArray2, 0, n)) != -1) {
            byArray3 = new byte[byArray.length + n2];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, n2);
            byArray = byArray3;
            byArray3 = null;
        }
        return byArray;
    }

    public static byte[] convertInputStreamToBinary(InputStream inputStream) throws IOException {
        return FileIOUtils.convertInputStreamToBinary(inputStream, 64000);
    }

    public static byte[] readBinaryFile(String string) throws IOException {
        return FileIOUtils.readBinaryFile(string, 64000);
    }

    private static File parent(File file) {
        String string = file.getParent();
        if (string == null) {
            if (file.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(string);
    }

    public static InputStream getResourceStream(String string) throws IOException {
        URL uRL;
        InputStream inputStream = null;
        ClassLoader classLoader = (class$org$eso$ohs$core$utilities$FileIOUtils == null ? (class$org$eso$ohs$core$utilities$FileIOUtils = FileIOUtils.class$("org.eso.ohs.core.utilities.FileIOUtils")) : class$org$eso$ohs$core$utilities$FileIOUtils).getClassLoader();
        URL uRL2 = uRL = classLoader != null ? classLoader.getResource(string) : ClassLoader.getSystemResource(string);
        if (uRL != null) {
            inputStream = uRL.openStream();
            return inputStream;
        }
        File file = new File(string);
        inputStream = new FileInputStream(file);
        return inputStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

