/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dfs.CommentCard;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class DbaseHandlerCommentCard
extends DbaseIOHandler {
    private static final int MAX_PHASE1_USER = 1000000;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerCommentCard == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerCommentCard = DbaseHandlerCommentCard.class$("org.eso.ohs.dbase.phase1.DbaseHandlerCommentCard")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerCommentCard));
    private static DbaseHandlerCommentCard singleton_ = new DbaseHandlerCommentCard();
    public static final String RUN_ID = "run_id";
    public static final String USER_ID = "user_id";
    public static final String COMMENT_SHORT = "comment_short";
    public static final String COMMENT_LONG = "comment_long";
    public static final String COMMENT_FLAG = "comment_flag";
    protected static final String comment_fields = Phase1SelectStmt.commentsTable.get() + "." + "user_id" + "," + Phase1SelectStmt.commentsTable.get() + "." + "run_id" + "," + Phase1SelectStmt.commentsTable.get() + "." + "comment_short" + "," + Phase1SelectStmt.commentsTable.get() + "." + "comment_long" + "," + Phase1SelectStmt.commentsTable.get() + "." + "comment_flag";
    protected static final String comment_sql = "SELECT " + comment_fields + " FROM " + Phase1SelectStmt.commentsTable.get() + " ";
    static /* synthetic */ Class class$org$eso$ohs$dfs$CommentCard;
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerCommentCard;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$CommentCard == null ? (class$org$eso$ohs$dfs$CommentCard = DbaseHandlerCommentCard.class$("org.eso.ohs.dfs.CommentCard")) : class$org$eso$ohs$dfs$CommentCard;
    }

    public static long runIdFromId(long l) {
        stdlog_.debug((Object)("original run id: " + l));
        long l2 = l / 1000000L;
        return l2;
    }

    public static long userIdFromId(long l) {
        stdlog_.debug((Object)("original user id: " + l));
        long l2 = l % 1000000L;
        return l2;
    }

    public static long idForPhase1Comment(long l, long l2) {
        return l * 1000000L + l2;
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectIOException, ObjectNotFoundException, SQLException {
        CommentCard commentCard = (CommentCard)this.newInstance();
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(commentCard);
        String string = comment_sql + " WHERE " + this.splitObjIdWhereCondition(l);
        stdlog_.debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Object not found in database");
        }
        commentCard.setId(l);
        this.setCommentFields(commentCard, resultSet);
        if (resultSet.next()) {
            throw new ObjectIOException("More than one row retrieved.");
        }
        resultSet.close();
        return new StorageManager.UnpackedStorableObject(commentCard);
    }

    public StorageManager.UnpackedStorableObject[] read(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        CommentCard commentCard = null;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = comment_sql + string2 + " WHERE " + string;
        stdlog_.debug((Object)string3);
        ResultSet resultSet = statement.executeQuery(string3);
        try {
            Vector<CommentCard> vector = new Vector<CommentCard>();
            Vector<Long> vector2 = new Vector<Long>();
            while (resultSet.next()) {
                long l = DbaseHandlerCommentCard.idForPhase1Comment(resultSet.getLong(RUN_ID), resultSet.getLong(USER_ID));
                Long l2 = new Long(l);
                if (!vector2.contains(l2)) {
                    vector2.addElement(l2);
                    commentCard = (CommentCard)this.newInstance();
                    vector.addElement(commentCard);
                    this.setCommentFields(commentCard, resultSet);
                    commentCard.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$CommentCard == null ? DbaseHandlerCommentCard.class$("org.eso.ohs.dfs.CommentCard") : class$org$eso$ohs$dfs$CommentCard));
                    continue;
                }
                stdlog_.warn((Object)("The comment card " + l + " already retrieved. The SQL '" + string3 + "' returns duplicate rows."));
            }
            resultSet.close();
            unpackedStorableObjectArray = new StorageManager.UnpackedStorableObject[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                commentCard = (CommentCard)vector.elementAt(n);
                unpackedStorableObjectArray[n] = new StorageManager.UnpackedStorableObject(commentCard);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return unpackedStorableObjectArray;
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        CommentCard commentCard = (CommentCard)unpackedStorableObject.getObject();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DbaseHandlerCommentCard.userIdFromId(l));
        stringBuffer.append(",");
        stringBuffer.append(DbaseHandlerCommentCard.runIdFromId(l));
        stringBuffer.append(",NULL,'");
        stringBuffer.append(TextUtils.quoteSqlString(commentCard.getBody()));
        stringBuffer.append("', 1 ");
        String string = "  \n INSERT INTO " + Phase1SelectStmt.commentsTable.get() + " (" + comment_fields + " ) " + " VALUES (" + stringBuffer.toString() + " ) ";
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"update error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public void update(Statement statement, StorableObject storableObject) throws ObjectIOException, SQLException {
        CommentCard commentCard = (CommentCard)storableObject;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMENT_LONG);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(commentCard.getBody()));
        stringBuffer.append("',");
        stringBuffer.append(COMMENT_SHORT);
        stringBuffer.append(" = NULL ");
        String string = "  \n UPDATE  " + Phase1SelectStmt.commentsTable.get() + " SET " + stringBuffer.toString() + " WHERE " + this.splitObjIdWhereCondition(Config.getCfg().uniqueToTableId(commentCard.getId()));
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        CommentCard commentCard = (CommentCard)unpackedStorableObject.getObject();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMENT_LONG);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(commentCard.getBody()));
        stringBuffer.append("',");
        stringBuffer.append(COMMENT_SHORT);
        stringBuffer.append(" = NULL ");
        String string = "  \n UPDATE  " + Phase1SelectStmt.commentsTable.get() + " SET " + stringBuffer.toString() + " WHERE " + this.splitObjIdWhereCondition(l);
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"update error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public void delete(Statement statement, long l) throws ObjectIOException {
        String string = "  \n  \n DELETE  FROM " + Phase1SelectStmt.commentsTable.get() + " WHERE " + this.splitObjIdWhereCondition(l);
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"delete error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing delete: " + string);
        }
    }

    private String splitObjIdWhereCondition(long l) {
        return "run_id = " + DbaseHandlerCommentCard.runIdFromId(l) + " AND    " + USER_ID + "  = " + DbaseHandlerCommentCard.userIdFromId(l) + " AND    " + COMMENT_FLAG + "  = 1 ";
    }

    protected void setCommentFields(CommentCard commentCard, ResultSet resultSet) throws SQLException {
        commentCard.setRunId(resultSet.getLong(RUN_ID));
        commentCard.setUserId(resultSet.getLong(USER_ID));
        String string = resultSet.getString(COMMENT_SHORT);
        if (string == null) {
            string = resultSet.getString(COMMENT_LONG);
        }
        stdlog_.debug((Object)("-------------------------------------- >Set comment fields(body) with " + string));
        commentCard.setBody(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

