/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.Summary;
import org.eso.ohs.instruments.InstrumentList;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class DbaseHandlerOR
extends DbaseIOHandler {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerOR == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerOR = DbaseHandlerOR.class$("org.eso.ohs.dbase.phase1.DbaseHandlerOR")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerOR));
    private static final String rcsid = "$Id: DbaseHandlerOR.java,v 1.29 2004/12/21 10:35:04 tcanavan Exp $";
    private static String opcDB_ = Config.getCfg().getDbName(ObservingRun.getSuffix());
    private int ipVersioningStartPeriod_ = Config.getCfg().getStartPeriodForIPVersioning();
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerOR;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObservingRun;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$ObservingRun == null ? (class$org$eso$ohs$dfs$ObservingRun = DbaseHandlerOR.class$("org.eso.ohs.dfs.ObservingRun")) : class$org$eso$ohs$dfs$ObservingRun;
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectIOException, ObjectNotFoundException, SQLException {
        Vector vector = new Vector();
        ObservingRun observingRun = (ObservingRun)this.newInstance();
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(observingRun);
        Config config = Config.getCfg();
        String string = "SELECT DISTINCT runs.id, runs.rank, schd.nights, prog.gto, schd.rank_class, runs.programme_id, runs.run_desc, schd.inst AS inst_code, schd.ipversion, schd.obs_mode, schd.tel AS tel_code, schd.progid, usrs.item_name AS firstname, usrs.surname_dl AS surname_dl, prog.title, schd.period " + this.fromClause() + " WHERE " + "runs.id = " + l + this.joinConditions();
        stdlog_.debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Object not found in database");
        }
        String[] stringArray = InstrumentList.getInstance().getInstrumentNames();
        observingRun.setInstrumentList(stringArray);
        int n = resultSet.getInt("id");
        long l2 = config.tableToUniqueId(n, class$org$eso$ohs$dfs$ObservingRun == null ? (class$org$eso$ohs$dfs$ObservingRun = DbaseHandlerOR.class$("org.eso.ohs.dfs.ObservingRun")) : class$org$eso$ohs$dfs$ObservingRun);
        observingRun.setId(l2);
        observingRun.setRank(resultSet.getShort("rank"));
        observingRun.setGto(resultSet.getShort("gto"));
        observingRun.setRankClass(resultSet.getString("rank_class"));
        observingRun.setInstCode(resultSet.getString("inst_code"));
        observingRun.setPIName(resultSet.getString("firstname") + " " + resultSet.getString("surname_dl"));
        float f = resultSet.getFloat("ipversion");
        if (f <= 0.0f) {
            f = 0.0f;
        }
        observingRun.setIPVersion(f);
        observingRun.setObsMode(resultSet.getString("obs_mode"));
        observingRun.setTelescope(resultSet.getString("tel_code"));
        if (observingRun.isServiceMode()) {
            observingRun.setDecimalHours(resultSet.getFloat("nights"));
        } else {
            observingRun.setDecimalNights(resultSet.getInt("nights"));
        }
        observingRun.setTitle(resultSet.getString("title"));
        observingRun.setPeriod(resultSet.getInt("period"));
        observingRun.setProgrammeId(resultSet.getInt("programme_id"));
        observingRun.setRunDescription(resultSet.getString("run_desc"));
        observingRun.setProgId(resultSet.getString("progid"));
        if (observingRun.getObsMode() == null) {
            throw new ObjectIOException("CONTACT ESO: bad Observing Run in database: no mode: " + l);
        }
        observingRun.setName(observingRun.getProgId() + "/" + observingRun.getObsMode().toUpperCase() + "M" + "/" + observingRun.getInstCode());
        resultSet.close();
        stdlog_.debug((Object)("ObservingRun Created id:" + l + " Period:" + observingRun.getPeriod() + " Inst:" + observingRun.getInstCode() + " IPVersion:" + observingRun.getIPVersion()));
        return new StorageManager.UnpackedStorableObject(observingRun);
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws SQLException {
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws SQLException {
    }

    public void delete(Statement statement, long l) throws SQLException {
    }

    public Summary[] listObjects(Statement statement) throws ObjectIOException {
        Object[] objectArray;
        Vector<Summary> vector = new Vector<Summary>();
        String string = this.ipVersioningStartPeriod_ > 0 ? " AND (schd.period < " + this.ipVersioningStartPeriod_ + " OR schd.ipversion IS NOT NULL ) " : "";
        String string2 = "SELECT DISTINCT runs.id, prog.period, prog.title " + this.fromClause() + " WHERE " + "prop.user_id = " + this.getUserId() + " AND " + "prop.pi_flag = 0 " + " AND " + "schd.published = 1 " + string + this.joinConditions();
        System.out.println(string2);
        stdlog_.debug((Object)string2);
        try {
            objectArray = statement.executeQuery(string2);
            while (objectArray.next()) {
                Summary summary = new Summary();
                summary.setObjectClass(class$org$eso$ohs$dfs$ObservingRun == null ? DbaseHandlerOR.class$("org.eso.ohs.dfs.ObservingRun") : class$org$eso$ohs$dfs$ObservingRun);
                summary.setId(Config.getCfg().tableToUniqueId(objectArray.getLong("id"), class$org$eso$ohs$dfs$ObservingRun == null ? DbaseHandlerOR.class$("org.eso.ohs.dfs.ObservingRun") : class$org$eso$ohs$dfs$ObservingRun));
                summary.setPropertyValue("Id", new Long(summary.getId()));
                summary.setPropertyValue("period", objectArray.getObject("period"));
                summary.setPropertyValue("title", objectArray.getObject("title"));
                vector.addElement(summary);
            }
            objectArray.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new ObjectIOException(sQLException);
        }
        objectArray = new Summary[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String fromClause() {
        String string = " FROM " + opcDB_ + "..obs_runs runs, " + opcDB_ + "..sched_rep schd, " + opcDB_ + "..obs_programmes prog, " + opcDB_ + "..proposed prop," + opcDB_ + "..eso_users usrs ";
        return string;
    }

    private String joinConditions() {
        String string = " AND runs.id = schd.run_id AND runs.programme_id = prog.id  AND prog.id = prop.programme_id  AND prop.pi_flag = 0  AND usrs.id = prop.user_id";
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

