/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.dbb.client.StarcatDate;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.dfs.ObsProgramme;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;
import org.eso.ohs.phrs.common.OpticonType;
import org.eso.ohs.phrs.common.RrmType;
import org.eso.ohs.phrs.common.XmmType;

public class DbaseHandlerObsProgramme
extends DbaseIOHandler {
    public static final String BASIC_FLAG = "00000000000000000";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerObsProgramme == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerObsProgramme = DbaseHandlerObsProgramme.class$("org.eso.ohs.dbase.phase1.DbaseHandlerObsProgramme")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerObsProgramme));
    private static DbaseHandlerObsProgramme singleton_ = null;
    public static final int XMM_FLAG_POS = 0;
    public static final String FLAGS = "flags";
    public static final String CYCLE_LABEL = "label";
    public static final String CYCLE_ID = "cycle_id";
    public static final String PERIOD = "period";
    public static final String PANEL = "panel";
    public static final String SUBPANEL = "subpanel";
    public static final String OPC_SUBPANEL = "opc_subpanel";
    public static final String NUMBER = "number";
    public static final String ID = "id";
    public static final String TITLE = "title";
    public static final String ATTACHMENTS = "attachments";
    public static final String PROPOSALID = "proposalID";
    public static final String PROPOSALCODE = "proposal_code";
    public static final String POST_ADDRESS = "post_address";
    public static final String EMAIL_ADDRESS = "email_address";
    public static final String INDATE = "date_received";
    public static final String PROCDATE = "date_processed";
    public static final String PRINTED = "printed";
    public static final String IGNORED = "ignored";
    public static final String OBSRUN = "obs_runs_num";
    public static final String KEYPROG = "key_prog";
    public static final String GTO = "gto";
    protected static final String prog_sql = "SELECT DISTINCT " + Phase1SelectStmt.programmesTable.get() + "." + "id" + "," + Phase1SelectStmt.programmesTable.get() + "." + "cycle_id" + "," + Phase1SelectStmt.programmesTable.get() + "." + "period" + "," + Phase1SelectStmt.programmesTable.get() + "." + "panel" + "," + Phase1SelectStmt.programmesTable.get() + "." + "subpanel" + "," + Phase1SelectStmt.programmesTable.get() + "." + "opc_subpanel" + "," + Phase1SelectStmt.programmesTable.get() + "." + "number" + "," + Phase1SelectStmt.programmesTable.get() + "." + "title" + "," + Phase1SelectStmt.programmesTable.get() + "." + "attachments" + "," + Phase1SelectStmt.programmesTable.get() + "." + "proposalID" + "," + Phase1SelectStmt.programmesTable.get() + "." + "proposal_code" + "," + Phase1SelectStmt.programmesTable.get() + "." + "post_address" + "," + Phase1SelectStmt.programmesTable.get() + "." + "flags" + "," + Phase1SelectStmt.programmesTable.get() + "." + "email_address" + "," + Phase1SelectStmt.programmesTable.get() + "." + "date_received" + "," + Phase1SelectStmt.programmesTable.get() + "." + "date_processed" + "," + Phase1SelectStmt.programmesTable.get() + "." + "printed" + "," + Phase1SelectStmt.programmesTable.get() + "." + "ignored" + "," + Phase1SelectStmt.programmesTable.get() + "." + "obs_runs_num" + "," + Phase1SelectStmt.programmesTable.get() + "." + "key_prog" + "," + Phase1SelectStmt.programmesTable.get() + "." + "gto" + "," + Phase1SelectStmt.cyclesTable.get() + "." + "label" + " FROM " + Phase1SelectStmt.programmesTable.get() + ", " + Phase1SelectStmt.cyclesTable.get() + " ";
    protected static final String cycle_join = Phase1SelectStmt.programmesTable.get() + "." + "cycle_id" + " = " + Phase1SelectStmt.cyclesTable.get() + ".id ";
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerObsProgramme;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObsProgramme;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$ObsProgramme == null ? (class$org$eso$ohs$dfs$ObsProgramme = DbaseHandlerObsProgramme.class$("org.eso.ohs.dfs.ObsProgramme")) : class$org$eso$ohs$dfs$ObsProgramme;
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectIOException, ObjectNotFoundException, SQLException {
        stdlog_.debug((Object)("read method: id " + l));
        ObsProgramme obsProgramme = (ObsProgramme)this.newInstance();
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(obsProgramme);
        String string = prog_sql + " WHERE " + Phase1SelectStmt.programmesTable.get() + "." + ID + " = " + l + " AND    " + cycle_join;
        stdlog_.debug((Object)("sql statement: " + string));
        stdlog_.debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Object not found in database");
        }
        obsProgramme.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$ObsProgramme == null ? (class$org$eso$ohs$dfs$ObsProgramme = DbaseHandlerObsProgramme.class$("org.eso.ohs.dfs.ObsProgramme")) : class$org$eso$ohs$dfs$ObsProgramme));
        this.setProgFields(obsProgramme, resultSet);
        resultSet.close();
        return new StorageManager.UnpackedStorableObject(obsProgramme);
    }

    public StorageManager.UnpackedStorableObject[] read(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        if (string2 == null) {
            string2 = "";
        }
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        ObsProgramme obsProgramme = null;
        String string3 = prog_sql + string2 + " WHERE " + cycle_join + " AND " + string;
        stdlog_.debug((Object)string3);
        ResultSet resultSet = statement.executeQuery(string3);
        try {
            Vector<ObsProgramme> vector = new Vector<ObsProgramme>();
            while (resultSet.next()) {
                obsProgramme = (ObsProgramme)this.newInstance();
                vector.addElement(obsProgramme);
                obsProgramme.setId(Config.getCfg().tableToUniqueId(resultSet.getInt(ID), class$org$eso$ohs$dfs$ObsProgramme == null ? DbaseHandlerObsProgramme.class$("org.eso.ohs.dfs.ObsProgramme") : class$org$eso$ohs$dfs$ObsProgramme));
                stdlog_.debug((Object)("prog retrieved:" + resultSet.getInt(ID)));
                this.setProgFields(obsProgramme, resultSet);
            }
            resultSet.close();
            unpackedStorableObjectArray = new StorageManager.UnpackedStorableObject[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                obsProgramme = (ObsProgramme)vector.elementAt(n);
                unpackedStorableObjectArray[n] = new StorageManager.UnpackedStorableObject(obsProgramme);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return unpackedStorableObjectArray;
    }

    protected void setProgFields(ObsProgramme obsProgramme, ResultSet resultSet) throws SQLException {
        obsProgramme.setPeriod(resultSet.getInt(PERIOD));
        obsProgramme.setTableId(resultSet.getInt(ID));
        obsProgramme.setCycle(resultSet.getInt(CYCLE_ID));
        obsProgramme.setCycleLabel(resultSet.getString(CYCLE_LABEL));
        obsProgramme.setPanel(resultSet.getString(PANEL));
        obsProgramme.setSubpanel(resultSet.getString(SUBPANEL));
        obsProgramme.setOpcSubpanel(resultSet.getInt(OPC_SUBPANEL));
        obsProgramme.setNumber(resultSet.getInt(NUMBER));
        obsProgramme.setTitle(resultSet.getString(TITLE));
        obsProgramme.setAttachments(resultSet.getInt(ATTACHMENTS));
        obsProgramme.setProposalID(resultSet.getString(PROPOSALID));
        obsProgramme.setProposalCode(resultSet.getString(PROPOSALCODE));
        obsProgramme.setPostAddr(resultSet.getString(POST_ADDRESS));
        obsProgramme.setEmailAddr(resultSet.getString(EMAIL_ADDRESS));
        String string = resultSet.getString(FLAGS);
        this.checkOpticon(obsProgramme, string);
        this.checkXmm(obsProgramme, string);
        this.checkRrm(obsProgramme, string);
        obsProgramme.setInDate(StarcatDate.fromStarcatDate(resultSet.getLong(INDATE)));
        obsProgramme.setProcDate(StarcatDate.fromStarcatDate(resultSet.getLong(PROCDATE)));
        obsProgramme.setIgnored(resultSet.getBoolean(IGNORED));
        obsProgramme.setPrinted(resultSet.getInt(PRINTED));
        obsProgramme.setObsRunsNum(resultSet.getInt(OBSRUN));
        obsProgramme.setKeyprog(resultSet.getInt(KEYPROG));
        obsProgramme.setGto(resultSet.getInt(GTO));
    }

    private void checkOpticon(ObsProgramme obsProgramme, String string) {
        if (string != null && string.length() > 1 && string.charAt(1) == OpticonType.OPTICON_FLAG) {
            obsProgramme.setOpticon(true);
        } else {
            obsProgramme.setOpticon(false);
        }
    }

    private void checkXmm(ObsProgramme obsProgramme, String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == XmmType.XMM_FLAG) {
            obsProgramme.setXmm(true);
        } else {
            obsProgramme.setXmm(false);
        }
    }

    private void checkRrm(ObsProgramme obsProgramme, String string) {
        if (string != null && string.length() > 2 && string.charAt(2) == RrmType.RRM_FLAG) {
            obsProgramme.setRrm(true);
        } else {
            obsProgramme.setRrm(false);
        }
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        throw new ObjectIOException("Operation not supported for this object");
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException, SQLException {
        stdlog_.debug((Object)"update object");
        StorableObject storableObject = unpackedStorableObject.getObject();
        this.update(statement, storableObject);
        stdlog_.debug((Object)"update object done");
    }

    public void update(Statement statement, StorableObject storableObject) throws ObjectIOException, SQLException {
        ObsProgramme obsProgramme = (ObsProgramme)storableObject;
        StringBuffer stringBuffer = new StringBuffer(BASIC_FLAG);
        stdlog_.debug((Object)("Initial flags:           " + stringBuffer));
        if (obsProgramme.isOpticon()) {
            stringBuffer.replace(1, 2, "1");
        }
        stdlog_.debug((Object)("Flags after opticon set: " + stringBuffer));
        if (obsProgramme.isXmm()) {
            stringBuffer.replace(0, 1, "1");
        }
        stdlog_.debug((Object)("Flags after xmm set:     " + stringBuffer));
        if (obsProgramme.isRrm()) {
            stringBuffer.replace(2, 3, "1");
        }
        stdlog_.debug((Object)("Flags after rrm set:     " + stringBuffer));
        String string = "UPDATE " + Phase1SelectStmt.programmesTable.get() + " " + "SET " + PERIOD + " = " + obsProgramme.getPeriod() + ", " + CYCLE_ID + " = " + obsProgramme.getCycle() + ", " + PANEL + " = '" + obsProgramme.getPanel() + "', " + SUBPANEL + " = '" + obsProgramme.getSubpanel() + "', " + OPC_SUBPANEL + " = " + obsProgramme.getOpcSubpanel() + ", " + PROPOSALID + " = '" + obsProgramme.getProposalID() + "', " + PROPOSALCODE + " = '" + obsProgramme.getProposalCode() + "', " + EMAIL_ADDRESS + " = '" + TextUtils.quoteSqlString(obsProgramme.getEmailAddr()) + "', " + FLAGS + " = '" + TextUtils.quoteSqlString(stringBuffer.toString()) + "', " + TITLE + " = '" + TextUtils.quoteSqlString(obsProgramme.getTitle()) + "', " + IGNORED + " = " + (obsProgramme.getIgnored() ? 1 : 0) + ", " + PRINTED + " = " + obsProgramme.getPrinted() + ", " + KEYPROG + " = " + obsProgramme.getKeyprog() + ", " + GTO + " = " + obsProgramme.getGto() + " " + "WHERE " + ID + " = " + Config.getCfg().uniqueToTableId(obsProgramme.getId()) + "\n\n";
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    public void delete(Statement statement, long l) throws ObjectIOException {
        throw new ObjectIOException("Operation not supported for this object");
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return null;
    }

    public static DbaseHandlerObsProgramme getDbaseHandlerObsProgramme() {
        if (singleton_ == null) {
            singleton_ = new DbaseHandlerObsProgramme();
        }
        return singleton_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

