/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dfs.ReportCard;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class DbaseHandlerReportCard
extends DbaseIOHandler {
    private static final int MAX_PHASE1_USER = 1000000;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerReportCard == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerReportCard = DbaseHandlerReportCard.class$("org.eso.ohs.dbase.phase1.DbaseHandlerReportCard")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerReportCard));
    private static DbaseHandlerReportCard singleton_ = new DbaseHandlerReportCard();
    public static final String RUN_ID = "run_id";
    public static final String USER_ID = "user_id";
    public static final String COMMENT_SHORT = "comment_short";
    public static final String COMMENT_LONG = "comment_long";
    public static final String COMMENT_FLAG = "comment_flag";
    public static final String NIGHTS = "nights";
    public static final String GRADE = "grade";
    public static final String CONFLICTS = "conflicts";
    protected static final String comment_fields = Phase1SelectStmt.commentsTable.get() + "." + "run_id" + "," + Phase1SelectStmt.commentsTable.get() + "." + "user_id" + "," + Phase1SelectStmt.commentsTable.get() + "." + "comment_flag" + "," + Phase1SelectStmt.commentsTable.get() + "." + "comment_long" + "," + Phase1SelectStmt.commentsTable.get() + "." + "comment_short" + "," + Phase1SelectStmt.ratedTable.get() + "." + "nights" + "," + Phase1SelectStmt.ratedTable.get() + "." + "grade";
    protected static final String comment_fields_only = Phase1SelectStmt.commentsTable.get() + "." + "run_id" + "," + Phase1SelectStmt.commentsTable.get() + "." + "user_id" + "," + Phase1SelectStmt.commentsTable.get() + "." + "comment_flag" + "," + Phase1SelectStmt.commentsTable.get() + "." + "comment_long" + "," + Phase1SelectStmt.commentsTable.get() + "." + "comment_short";
    protected static final String rated_fields = Phase1SelectStmt.ratedTable.get() + "." + "run_id" + "," + Phase1SelectStmt.ratedTable.get() + "." + "user_id" + "," + Phase1SelectStmt.ratedTable.get() + "." + "nights" + "," + Phase1SelectStmt.ratedTable.get() + "." + "grade" + "," + Phase1SelectStmt.ratedTable.get() + "." + "conflicts";
    protected static final String comment_sql = "SELECT " + comment_fields + " FROM " + Phase1SelectStmt.commentsTable.get() + "," + Phase1SelectStmt.ratedTable.get() + " ";
    protected static final String rated_sql_ = "SELECT " + rated_fields + " FROM " + Phase1SelectStmt.ratedTable.get() + " ";
    static /* synthetic */ Class class$org$eso$ohs$dfs$ReportCard;
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerReportCard;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$ReportCard == null ? (class$org$eso$ohs$dfs$ReportCard = DbaseHandlerReportCard.class$("org.eso.ohs.dfs.ReportCard")) : class$org$eso$ohs$dfs$ReportCard;
    }

    public static long runIdFromId(long l) {
        long l2 = l / 1000000L;
        return l2;
    }

    public static long userIdFromId(long l) {
        long l2 = l % 1000000L;
        return l2;
    }

    public static long idForPhase1Comment(long l, long l2) {
        return l * 1000000L + l2;
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectIOException, ObjectNotFoundException, SQLException {
        ReportCard reportCard = (ReportCard)this.newInstance();
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(reportCard);
        String string = rated_sql_ + " WHERE " + this.splitRunIdUserIdWhereCondition(l);
        stdlog_.debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            resultSet.close();
            throw new ObjectNotFoundException("Cannot  retrieve report card");
        }
        this.setRatedFields(reportCard, resultSet);
        reportCard.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$ReportCard == null ? (class$org$eso$ohs$dfs$ReportCard = DbaseHandlerReportCard.class$("org.eso.ohs.dfs.ReportCard")) : class$org$eso$ohs$dfs$ReportCard));
        resultSet.close();
        this.loadReportCardBody(statement, reportCard);
        return new StorageManager.UnpackedStorableObject(reportCard);
    }

    private String joinRatedComment() {
        String string = Phase1SelectStmt.ratedTable.get() + ".run_id = " + Phase1SelectStmt.commentsTable.get() + ".run_id AND " + Phase1SelectStmt.ratedTable.get() + ".user_id = " + Phase1SelectStmt.commentsTable.get() + ".user_id ";
        return string;
    }

    public StorageManager.UnpackedStorableObject[] read(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        ReportCard reportCard = null;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = rated_sql_ + string2 + " WHERE " + string;
        stdlog_.info((Object)string3);
        ResultSet resultSet = statement.executeQuery(string3);
        try {
            Vector<ReportCard> vector = new Vector<ReportCard>();
            Vector<Long> vector2 = new Vector<Long>();
            while (resultSet.next()) {
                long l = DbaseHandlerReportCard.idForPhase1Comment(resultSet.getLong(RUN_ID), resultSet.getLong(USER_ID));
                Long l2 = new Long(l);
                if (!vector2.contains(l2)) {
                    vector2.addElement(l2);
                    reportCard = (ReportCard)this.newInstance();
                    vector.addElement(reportCard);
                    this.setRatedFields(reportCard, resultSet);
                    reportCard.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$ReportCard == null ? DbaseHandlerReportCard.class$("org.eso.ohs.dfs.ReportCard") : class$org$eso$ohs$dfs$ReportCard));
                    continue;
                }
                stdlog_.warn((Object)("The report card " + l + " already retrieved. The SQL '" + string3 + "' returns duplicate rows."));
            }
            resultSet.close();
            int n = 0;
            while (n < vector.size()) {
                ReportCard reportCard2 = (ReportCard)vector.elementAt(n);
                this.loadReportCardBody(statement, reportCard2);
                ++n;
            }
            unpackedStorableObjectArray = new StorageManager.UnpackedStorableObject[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                reportCard = (ReportCard)vector.elementAt(n2);
                unpackedStorableObjectArray[n2] = new StorageManager.UnpackedStorableObject(reportCard);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"Error retrieving card list: ", (Throwable)sQLException);
        }
        return unpackedStorableObjectArray;
    }

    private void loadReportCardBody(Statement statement, ReportCard reportCard) throws SQLException, ObjectIOException {
        long l = Config.getCfg().uniqueToTableId(reportCard.getId());
        String string = "SELECT comment_short,comment_long  FROM " + Phase1SelectStmt.commentsTable.get() + " WHERE " + this.splitRunIdUserIdWhereCondition(l) + " AND comment_flag = 0";
        stdlog_.info((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            resultSet.close();
            this.insertCommentRow(statement, reportCard.getId(), "");
        } else {
            this.setCommentFieldsOnly(reportCard, resultSet);
            resultSet.close();
        }
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        ReportCard reportCard = (ReportCard)unpackedStorableObject.getObject();
        this.insertCommentRow(statement, l, reportCard.getBody());
    }

    private void insertCommentRow(Statement statement, long l, String string) throws ObjectIOException {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = Config.getCfg().uniqueToTableId(l);
        stringBuffer.append(DbaseHandlerReportCard.runIdFromId(l2));
        stringBuffer.append(",");
        stringBuffer.append(DbaseHandlerReportCard.userIdFromId(l2));
        stringBuffer.append(",0,'");
        stringBuffer.append(TextUtils.quoteSqlString(string));
        stringBuffer.append("', NULL ");
        String string2 = "  \n INSERT INTO " + Phase1SelectStmt.commentsTable.get() + " (" + comment_fields_only + " ) " + " VALUES (" + stringBuffer.toString() + " ) ";
        stdlog_.debug((Object)string2);
        try {
            statement.executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"update error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string2);
        }
    }

    public void update(Statement statement, StorableObject storableObject) throws ObjectIOException, SQLException {
        ReportCard reportCard = (ReportCard)storableObject;
        long l = Config.getCfg().uniqueToTableId(reportCard.getId());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMENT_LONG);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(reportCard.getBody()));
        stringBuffer.append("',");
        stringBuffer.append(COMMENT_SHORT);
        stringBuffer.append(" = NULL ");
        String string = "  \n UPDATE  " + Phase1SelectStmt.commentsTable.get() + " SET " + stringBuffer.toString() + " WHERE " + this.splitRunIdUserIdWhereCondition(l) + " \n" + "UPDATE " + Phase1SelectStmt.ratedTable.get() + " SET " + NIGHTS + " = " + reportCard.getNights() + "," + GRADE + " = " + reportCard.getGrade() + "," + CONFLICTS + " = " + reportCard.getIntConflicts() + " WHERE " + this.splitRunIdUserIdWhereCondition(l);
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        ReportCard reportCard = (ReportCard)unpackedStorableObject.getObject();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMENT_LONG);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(reportCard.getBody()));
        stringBuffer.append("',");
        stringBuffer.append(COMMENT_SHORT);
        stringBuffer.append(" = NULL ");
        String string = "  \n UPDATE  " + Phase1SelectStmt.commentsTable.get() + " SET " + stringBuffer.toString() + " WHERE " + this.splitObjIdWhereCondition(l) + " \n" + "UPDATE " + Phase1SelectStmt.ratedTable.get() + " SET " + NIGHTS + " = " + reportCard.getNights() + "," + GRADE + " = " + reportCard.getGrade() + " WHERE " + RUN_ID + " = " + DbaseHandlerReportCard.runIdFromId(l) + " AND    " + USER_ID + "  = " + DbaseHandlerReportCard.userIdFromId(l);
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"update error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public void delete(Statement statement, long l) throws ObjectIOException {
        String string = " \n DELETE  FROM " + Phase1SelectStmt.commentsTable.get() + " WHERE " + this.splitObjIdWhereCondition(l);
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"update error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    private String splitObjIdWhereCondition(long l) {
        return Phase1SelectStmt.ratedTable.get() + "." + RUN_ID + " = " + DbaseHandlerReportCard.runIdFromId(l) + " AND    " + Phase1SelectStmt.ratedTable.get() + "." + USER_ID + "  = " + DbaseHandlerReportCard.userIdFromId(l) + " AND    " + Phase1SelectStmt.commentsTable.get() + "." + COMMENT_FLAG + "  = 0 ";
    }

    private String splitRunIdUserIdWhereCondition(long l) {
        return "run_id = " + DbaseHandlerReportCard.runIdFromId(l) + " AND    " + USER_ID + "  = " + DbaseHandlerReportCard.userIdFromId(l);
    }

    protected void setCommentFields(ReportCard reportCard, ResultSet resultSet) throws SQLException {
        reportCard.setRunId(resultSet.getLong(RUN_ID));
        reportCard.setUserId(resultSet.getLong(USER_ID));
        reportCard.setNights(resultSet.getInt(NIGHTS));
        reportCard.setGrade(resultSet.getInt(GRADE));
        String string = resultSet.getString(COMMENT_SHORT);
        if (string == null) {
            string = resultSet.getString(COMMENT_LONG);
        }
        reportCard.setBody(string);
    }

    protected void setCommentFieldsOnly(ReportCard reportCard, ResultSet resultSet) throws SQLException {
        String string = resultSet.getString(COMMENT_SHORT);
        if (string == null) {
            string = resultSet.getString(COMMENT_LONG);
        }
        reportCard.setBody(string);
    }

    protected void setRatedFields(ReportCard reportCard, ResultSet resultSet) throws SQLException {
        reportCard.setRunId(resultSet.getLong(RUN_ID));
        reportCard.setUserId(resultSet.getLong(USER_ID));
        reportCard.setNights(resultSet.getInt(NIGHTS));
        reportCard.setGrade(resultSet.getInt(GRADE));
        reportCard.setConflicts(resultSet.getInt(CONFLICTS));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

