/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.util.Calendar;
import org.eso.ohs.core.dbb.sql.DbbSqlTable;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dfs.Affiliation;

public class Phase1SelectStmt {
    private static String QUESTION_MARK = " ? ";
    public static DbbSqlTable refStarTable = new DbbSqlTable("reference_stars");
    public static DbbSqlTable runSchedReqTable = new DbbSqlTable("run_sched_requirements");
    public static DbbSqlTable runTimingConstrTable = new DbbSqlTable("run_timing_constraints");
    public static DbbSqlTable runLinksTable = new DbbSqlTable("run_links");
    public static DbbSqlTable instConfTable = new DbbSqlTable("ins_setup");
    public static DbbSqlTable propSummaryLogTable = new DbbSqlTable("proposal_log");
    public static String[] USER_ROLE = new String[]{"user"};
    public static final DbbSqlTable ratedTable = new DbbSqlTable("rated");
    public static final DbbSqlTable commentsTable = new DbbSqlTable("comments");
    public static final DbbSqlTable obsBlocksTable = new DbbSqlTable("obs_blocks");
    public static final DbbSqlTable proposalSummaryTable = new DbbSqlTable("proposal_summary");
    public static final DbbSqlTable figureSummaryTable = new DbbSqlTable("proposal_pictures");
    public static final DbbSqlTable textFieldsTable = new DbbSqlTable("text_fields");
    public static final DbbSqlTable runCommentTable = new DbbSqlTable("run_comment");
    public static final DbbSqlTable programmesTable = new DbbSqlTable("obs_programmes");
    public static final DbbSqlTable runsTable = new DbbSqlTable("obs_runs");
    public static final DbbSqlTable telescopeTable = new DbbSqlTable("opc_telescopes");
    public static final DbbSqlTable instrumentTable = new DbbSqlTable("opc_instruments");
    public static final DbbSqlTable offeredTable = new DbbSqlTable("offered");
    public static final DbbSqlTable usersTable = new DbbSqlTable("eso_users");
    public static final DbbSqlTable usersRolesTable = new DbbSqlTable("eso_users_roles");
    public static final DbbSqlTable usersViewTable = new DbbSqlTable("users_view");
    public static final DbbSqlTable esoUsersRolesTable = new DbbSqlTable("eso_users_roles");
    public static final DbbSqlTable schedRepTable = new DbbSqlTable("sched_rep");
    public static final DbbSqlTable proposedTable = new DbbSqlTable("proposed");
    public static final DbbSqlTable proposalOutputTable = new DbbSqlTable("proposalOut");
    public static final DbbSqlTable affiliationsTable = new DbbSqlTable("user_affiliations");
    public static final DbbSqlTable targetsTable = new DbbSqlTable("targets");
    public static final DbbSqlTable vltiTargetsTable = new DbbSqlTable("vlti_targets");
    public static final DbbSqlTable runTargetsTable = new DbbSqlTable("vlti_target_runs");
    public static final DbbSqlTable figuresTable = new DbbSqlTable("figures");
    public static final DbbSqlTable latexTable = new DbbSqlTable("latex_source");
    public static final DbbSqlTable cutoffTable = new DbbSqlTable("opc_cutoff");
    public static final DbbSqlTable cyclesTable = new DbbSqlTable("cycles");
    public static final DbbSqlTable cyclePropertiesTable = new DbbSqlTable("cycle_prop");
    public static final DbbSqlTable stepsTable = new DbbSqlTable("steps");
    public static final DbbSqlTable refereesTable = new DbbSqlTable("referees");
    public static final DbbSqlTable refAvgView = new DbbSqlTable("referee_avg");
    public static final DbbSqlTable htmlFragTable = new DbbSqlTable("html_fragment");
    public static final DbbSqlTable ipPeriodsTable = new DbbSqlTable("obrep2", "ip_periods");
    public static final String beginTransaction = " ";
    public static final String commitTransaction = " COMMIT ";
    private static final String orderByReferee = "ORDER BY chair desc\n";

    public static void setQuestionMark(String string) {
        QUESTION_MARK = string;
    }

    public static String getQuestionMark() {
        return QUESTION_MARK;
    }

    public static String selProgrammePanels() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  panel ").append(" FROM ").append(programmesTable.get()).append(beginTransaction).append(" WHERE panel != ' ' ").append(" ORDER by panel");
        return stringBuffer.toString();
    }

    public static String selProgrammePanels(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  panel ").append(" FROM ").append(programmesTable.get()).append(beginTransaction).append(" WHERE panel != ' ' ");
        if (!string.equals("()")) {
            stringBuffer = stringBuffer.append(" AND ").append(programmesTable.get()).append(".period in ").append(string);
        }
        stringBuffer = stringBuffer.append(" ORDER by panel");
        return stringBuffer.toString();
    }

    public static String selAllSubPanels() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  subpanel ").append(" FROM ").append(programmesTable.get()).append(beginTransaction).append(" WHERE panel != ' ' ").append(" AND subpanel != NULL ").append(" ORDER by subpanel");
        return stringBuffer.toString();
    }

    public static String selAllOpcSubpanel() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  opc_subpanel ").append(" FROM ").append(programmesTable.get()).append(beginTransaction).append(" WHERE panel != ' ' ").append(" ORDER by opc_subpanel");
        return stringBuffer.toString();
    }

    public static String selRefereeAvgPeriods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT run = run_id/1000000 from ").append(refAvgView.get());
        return stringBuffer.toString();
    }

    public static String selAllModes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT obs_mode from  ").append(runsTable.get()).append(" where id > 68000000");
        return stringBuffer.toString();
    }

    public static String selAllAffiliations() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT country_code from ").append(affiliationsTable.get());
        return stringBuffer.toString();
    }

    public static String selAllCycles() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id ").append(" FROM ").append(cyclesTable.get()).append(beginTransaction).append(" ORDER BY id DESC");
        return stringBuffer.toString();
    }

    public static String selAllCyclesLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT label ").append(" FROM ").append(cyclesTable.get()).append(beginTransaction).append(" ORDER BY label DESC");
        return stringBuffer.toString();
    }

    public static String wcAllCycles() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cyclesTable.get()).append(".period > 0").append(" ORDER BY period DESC, label ASC  ");
        return stringBuffer.toString();
    }

    public static String wcAllSteps() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stepsTable.get()).append(" ORDER BY id DESC, label ASC  ");
        return stringBuffer.toString();
    }

    public static String selAllTelescopes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  code ").append(" FROM ").append(telescopeTable.get());
        return stringBuffer.toString();
    }

    public static String selAllCutOffTelescopes(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(runsTable.get()).append(".tel_code ").append(" FROM ").append(runsTable.get()).append(", ").append(programmesTable.get()).append(beginTransaction).append(" WHERE  ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(l).append("\n AND ").append(programmesTable.get()).append(".ignored = 0");
        return stringBuffer.toString();
    }

    public static String selAllCutOffSubPanels(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  opc_subpanel ").append(" FROM ").append(cutoffTable.get()).append(beginTransaction).append(" WHERE opc_subpanel != NULL ");
        return stringBuffer.toString();
    }

    public static String selAllObservatory() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  observatory ").append(" FROM ").append(telescopeTable.get());
        return stringBuffer.toString();
    }

    public static void definePhase1TableDb(String string, String string2) {
        DbbSqlTable[] dbbSqlTableArray = new DbbSqlTable[]{runLinksTable, instConfTable, runTimingConstrTable, runSchedReqTable, refStarTable, runCommentTable, commentsTable, textFieldsTable, ratedTable, programmesTable, runsTable, usersTable, proposedTable, affiliationsTable, targetsTable, figuresTable, cutoffTable, telescopeTable, cyclesTable, stepsTable, refereesTable, esoUsersRolesTable, schedRepTable, vltiTargetsTable, runTargetsTable, offeredTable, instrumentTable, cyclePropertiesTable};
        int n = 0;
        while (n < dbbSqlTableArray.length) {
            dbbSqlTableArray[n].setDatabase(string);
            dbbSqlTableArray[n].setOwner(string2);
            ++n;
        }
    }

    public static void definePhase2TableDb(String string, String string2) {
        DbbSqlTable[] dbbSqlTableArray = new DbbSqlTable[]{obsBlocksTable};
        int n = 0;
        while (n < dbbSqlTableArray.length) {
            dbbSqlTableArray[n].setDatabase(string);
            dbbSqlTableArray[n].setOwner(string2);
            ++n;
        }
    }

    public static final String selPeriodFromCycle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  period ").append(" FROM ").append(cyclesTable.get()).append(beginTransaction).append(" WHERE ").append(cyclesTable.get()).append(".label = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static final String selCycleIdFromLabel(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id ").append(" FROM ").append(cyclesTable.get()).append(beginTransaction).append(" WHERE ").append(cyclesTable.get()).append(".label = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static final String selCycleLabel(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT label ").append(" FROM ").append(cyclesTable.get()).append(beginTransaction).append(" WHERE ").append(cyclesTable.get()).append(".id = ").append(n);
        return stringBuffer.toString();
    }

    public static final String selPeriodFromCycleId(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  period ").append(" FROM ").append(cyclesTable.get()).append(beginTransaction).append(" WHERE ").append(cyclesTable.get()).append(".id = ").append(n);
        return stringBuffer.toString();
    }

    public static final String selPeriods(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  period ").append(" FROM ").append(cyclesTable.get()).append(beginTransaction).append(" WHERE ").append(cyclesTable.get()).append(".period >= ").append(n).append(" ORDER BY period DESC");
        return stringBuffer.toString();
    }

    public static final String selectRunsRankData(int n, String string, int n2, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT ").append(runsTable.get()).append(".id, ").append(runsTable.get()).append(".programme_id, ").append(runsTable.get()).append(".grade, ").append(runsTable.get()).append(".rank\n").append(" FROM ").append(runsTable.get()).append(", ").append(programmesTable.get()).append(" WHERE obs_programmes.id = ").append(runsTable.get()).append(".programme_id\n").append(" AND  ").append(programmesTable.get()).append(".period = ").append(n).append(" AND  ").append(programmesTable.get()).append(".panel = '").append(string).append("' AND  ").append(programmesTable.get()).append(".ignored = 0\n").append(" AND  ").append(programmesTable.get()).append(".opc_subpanel = ").append(n2).append("\n AND ").append(runsTable.get()).append(".tel_code like '").append(string2).append("' AND ").append(runsTable.get()).append(".grade > 0\n").append("\n AND ").append(runsTable.get()).append(".assigned_time > 0\n").append(" AND  ").append(programmesTable.get()).append(".gto in ").append(string3).append("\n ORDER BY ").append(runsTable.get()).append(".grade, ").append(runsTable.get()).append(".rank");
        return stringBuffer.toString();
    }

    public static final String selNotRankedRuns(int n, String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(runsTable.get()).append(".run_code, ").append(programmesTable.get()).append(".gto\n").append("FROM ").append(programmesTable.get()).append(", ").append(runsTable.get()).append(" WHERE ").append(programmesTable.get()).append(".panel = '").append(string).append("' AND ").append(programmesTable.get()).append(".opc_subpanel = ").append(n2).append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(programmesTable.get()).append(".ignored = 0 \n").append("\n AND ").append(runsTable.get()).append(".grade <= 0 \n").append("AND ").append(programmesTable.get()).append(".period = ").append(n).append("\n").append("ORDER BY ").append(programmesTable.get()).append(".gto");
        return stringBuffer.toString();
    }

    public static final String selScheduled() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  scheduled ").append(" FROM ").append(runsTable.get()).append(beginTransaction).append(" WHERE ").append(" scheduled != null");
        return stringBuffer.toString();
    }

    public static String selAccessedLetterFlag(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) from ").append(affiliationsTable.get()).append(" WHERE user_id = ").append(l).append(" AND   cycle_id = ").append(l2).append(" AND   accessed_letter != NULL");
        return stringBuffer.toString();
    }

    public static String selWotEditCcFlag(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) from ").append(esoUsersRolesTable.get()).append(" WHERE login = '").append(l).append("' AND   letters_role = 'editComment'");
        return stringBuffer.toString();
    }

    public static String selCutoffValues(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(cutoffTable.get()).append(".cutoff FROM ").append(cutoffTable.get()).append(" WHERE ").append(cutoffTable.get()).append(".category = '").append(string).append("' AND ").append(cutoffTable.get()).append(".opc_subpanel = ").append(n).append("\n AND ").append(cutoffTable.get()).append(".code = '").append(string2).append("' ");
        return stringBuffer.toString();
    }

    public static String selWotEditRcFlag(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) from ").append(esoUsersRolesTable.get()).append(" WHERE login = '").append(l).append("' AND   letters_role = 'editReport'");
        return stringBuffer.toString();
    }

    public static String selAllPanels(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(refereesTable.get()).append(".panel ").append(" FROM ").append(refereesTable.get()).append(" WHERE ").append(refereesTable.get()).append(".panel != ' ' ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(refereesTable.get()).append(".opc_subpanel != NULL ").append(" ORDER by ").append(refereesTable.get()).append(".panel");
        return stringBuffer.toString();
    }

    public static String selAllCycleSteps() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(stepsTable.get()).append(".label ").append(" FROM ").append(stepsTable.get()).append(" ORDER BY id");
        return stringBuffer.toString();
    }

    public static String getStepId(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  ").append(stepsTable.get()).append(".id ").append(" FROM ").append(stepsTable.get()).append(" WHERE label= '").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String updateCycleStep(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE  ").append(cyclesTable.get()).append(" SET step_id = ").append(n).append(" WHERE label= '").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String selAllPanels(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(refereesTable.get()).append(".panel ").append(" FROM ").append(refereesTable.get()).append(", ").append(cyclesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".panel != ' ' ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append("\n AND ").append(refereesTable.get()).append(".opc_subpanel != NULL ").append("\n AND ").append(cyclesTable.get()).append(".label =  '").append(string).append("' ").append(" ORDER by ").append(refereesTable.get()).append(".panel");
        return stringBuffer.toString();
    }

    public static String selAllSubPanels(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(programmesTable.get()).append(".subpanel ").append(" FROM ").append(programmesTable.get()).append(", ").append(cyclesTable.get()).append(beginTransaction).append(" WHERE ").append(programmesTable.get()).append(".panel != ' ' ").append("\n AND ").append(programmesTable.get()).append(".subpanel != NULL ").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append("\n AND ").append(cyclesTable.get()).append(".label =  '").append(string).append("' ").append(" ORDER by ").append(programmesTable.get()).append(".subpanel");
        return stringBuffer.toString();
    }

    public static String selTelescopeUrl(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT url ").append(" FROM ").append(telescopeTable.get()).append(" WHERE code = '").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String selInstrumentUrl(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT url ").append(" FROM ").append(instrumentTable.get()).append(" WHERE code = '").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String selOpcSubpanelsFromProgrammes(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(programmesTable.get()).append(".opc_subpanel ").append(" FROM ").append(programmesTable.get()).append(beginTransaction).append(" WHERE ").append(programmesTable.get()).append(".panel != ' ' ").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(programmesTable.get()).append(".opc_subpanel != NULL ");
        return stringBuffer.toString();
    }

    public static String selAllOpcSubpanels(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(refereesTable.get()).append(".opc_subpanel ").append(" FROM ").append(refereesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".panel != ' ' ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(refereesTable.get()).append(".opc_subpanel != NULL ").append(" ORDER by ").append(refereesTable.get()).append(".opc_subpanel");
        return stringBuffer.toString();
    }

    public static String selOpcSubpanels(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(refereesTable.get()).append(".opc_subpanel ").append(" FROM ").append(refereesTable.get()).append(", ").append(cyclesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".panel = '").append(string).append("' ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append("\n AND ").append(refereesTable.get()).append(".opc_subpanel != NULL ").append("\n AND ").append(cyclesTable.get()).append(".label =  '").append(string2).append("' ").append(" ORDER by ").append(refereesTable.get()).append(".opc_subpanel");
        return stringBuffer.toString();
    }

    public static String selAllOpcSubpanels(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(refereesTable.get()).append(".opc_subpanel ").append(" FROM ").append(refereesTable.get()).append(", ").append(cyclesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".panel != ' ' ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append("\n AND ").append(refereesTable.get()).append(".opc_subpanel != NULL ").append("\n AND ").append(cyclesTable.get()).append(".label =  '").append(string).append("' ").append(" ORDER by ").append(refereesTable.get()).append(".opc_subpanel");
        return stringBuffer.toString();
    }

    public static String selCountProposals(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(distinct ").append(programmesTable.get()).append(".proposalID)").append(" FROM ").append(programmesTable.get()).append(",").append(ratedTable.get()).append(" , ").append(cyclesTable.get()).append(" , ").append(runsTable.get()).append(", ").append(refereesTable.get()).append(", ").append(telescopeTable.get()).append("  WHERE ").append(refereesTable.get()).append(".user_id = ").append(l).append(beginTransaction).append(" AND  ").append(refereesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append(" AND  ").append(telescopeTable.get()).append(".code = ").append(runsTable.get()).append(".tel_code ").append(" AND  ").append(ratedTable.get()).append(".user_id = ").append(refereesTable.get()).append(".user_id ").append(" AND  ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ").append(" AND  ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append(" AND  ").append(programmesTable.get()).append(".ignored = 0 ").append(" AND  ").append(programmesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append(" AND  ").append(cyclesTable.get()).append(".label = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String selPrRefereeComment(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  ").append(ratedTable.get()).append(".user_id").append(" FROM ").append(ratedTable.get()).append("  WHERE ").append(ratedTable.get()).append(".run_id = ").append(l).append(" AND    ").append(ratedTable.get()).append(".pr_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String selAcceptedRuns(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(runsTable.get()).append(" WHERE programme_id = ").append(l).append(" AND status = '+'");
        return stringBuffer.toString();
    }

    public static String selRejectedRuns(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(runsTable.get()).append(" WHERE programme_id = ").append(l).append(" AND status = '-'");
        return stringBuffer.toString();
    }

    public static String selCountProposalsVlt(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Phase1SelectStmt.selCountProposals(l, string)).append(" AND  ").append(telescopeTable.get()).append(".observatory = 'P' ");
        return stringBuffer.toString();
    }

    public static String selCountProposalsL(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Phase1SelectStmt.selCountProposals(l, string)).append(" AND  ").append(telescopeTable.get()).append(".observatory = 'L' ");
        return stringBuffer.toString();
    }

    public static String selPrCountProposals(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Phase1SelectStmt.selCountProposals(l, string)).append(" AND  ").append(ratedTable.get()).append(".pr_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String selPrCountProposalsVlt(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Phase1SelectStmt.selCountProposalsVlt(l, string)).append(" AND  ").append(ratedTable.get()).append(".pr_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String selPrCountProposalsL(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Phase1SelectStmt.selCountProposalsL(l, string)).append(" AND  ").append(ratedTable.get()).append(".pr_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String selCountReferProposal(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" select count(").append(refereesTable.get()).append(".user_id)").append(" from ").append(programmesTable.get()).append(",").append(refereesTable.get()).append(",").append(proposedTable.get()).append(" where ").append(programmesTable.get()).append(".id = ").append(l).append("\n AND ").append(proposedTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id ").append("\n AND ").append(proposedTable.get()).append(".user_id = ").append(refereesTable.get()).append(".user_id ").append("\n AND ").append(refereesTable.get()).append(".panel = ").append(programmesTable.get()).append(".panel ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(programmesTable.get()).append(".cycle_id ").append("\n AND ").append(refereesTable.get()).append(".opc_subpanel = ").append(n);
        return stringBuffer.toString();
    }

    public static String selAcronymOtherUser(int n, long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  ").append(refereesTable.get()).append(".acronym  ").append(" FROM ").append(refereesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".cycle_id = ").append(n).append(beginTransaction).append("\n AND ").append(refereesTable.get()).append(".user_id != ").append(l).append("\n AND ").append(refereesTable.get()).append(".acronym = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String moveRatedAll(long l, long l2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(ratedTable.get()).append(" SET  ").append(ratedTable.get()).append(".user_id =  ").append(l2).append(" FROM ").append(ratedTable.get()).append(", ").append(runsTable.get()).append(", ").append(programmesTable.get()).append(" WHERE ").append(programmesTable.get()).append(".cycle_id = ").append(n).append(beginTransaction).append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(l).append(beginTransaction).append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ").append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ");
        return stringBuffer.toString();
    }

    public static String selCutOffTelPanSubPan(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  cutoff ").append(" FROM ").append(cutoffTable.get()).append(beginTransaction).append(" WHERE category = '").append(string2).append("' ").append(" AND opc_subpanel = ").append(n).append(" AND code = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String selUsersIds(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id ").append(" FROM ").append(usersTable.get()).append(beginTransaction).append(" WHERE  id >= ").append(n).append(" AND  id < ").append(n2).append(" ORDER BY id ");
        return stringBuffer.toString();
    }

    public static String selAllCutOffPanels(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT panel ").append(" FROM ").append(refereesTable.get()).append(beginTransaction).append(" WHERE cycle_id = NULL ");
        return stringBuffer.toString();
    }

    public static String wcAllPanels(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".cycle_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String wcUsersFormPropIds(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(proposedTable.get()).append(".programme_id = ").append(l).append("\n AND ").append(proposedTable.get()).append(".user_id = ").append(usersTable.get()).append(".id ").append(" ORDER BY pi_flag ");
        return stringBuffer.toString();
    }

    public static String wcPIFormPropIds(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(proposedTable.get()).append(".programme_id = ").append(l).append("\n AND ").append(proposedTable.get()).append(".user_id = ").append(usersTable.get()).append(".id ").append(" AND pi_flag = 0 ");
        return stringBuffer.toString();
    }

    public static String wcUsersFormPropIdsTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(", ").append(proposedTable.get());
        return stringBuffer.toString();
    }

    public static String selUser(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id ").append(" FROM ").append(usersTable.get()).append(beginTransaction).append(" WHERE  id = ").append(n).append(" ORDER BY id ");
        return stringBuffer.toString();
    }

    public static final String selAllTelList(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(runsTable.get()).append(".tel_code ").append(" FROM ").append(runsTable.get()).append(" , ").append(telescopeTable.get()).append(" , ").append(programmesTable.get()).append(" WHERE  ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(runsTable.get()).append(".tel_code = ").append(telescopeTable.get()).append(".code ");
        if (!string2.equals("()")) {
            stringBuffer.append(" AND ").append(telescopeTable.get()).append(".observatory in ").append(string2);
        }
        if (!string.equals("()")) {
            stringBuffer.append(" AND ").append(programmesTable.get()).append(".period in ").append(string);
        }
        return stringBuffer.toString();
    }

    public static final String selAllTelInRun(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(runsTable.get()).append(".tel_code ").append(" FROM ").append(runsTable.get()).append(" , ").append(programmesTable.get()).append("").append(" WHERE  ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ");
        if (!string.equals("()")) {
            stringBuffer.append(" AND ").append(programmesTable.get()).append(".period in ").append(string);
        }
        return stringBuffer.toString();
    }

    public static final String selAllTelInRun(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(runsTable.get()).append(".tel_code ").append(" FROM ").append(runsTable.get()).append(" , ").append(programmesTable.get()).append("").append(" WHERE  ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(programmesTable.get()).append(".period = ").append(n);
        return stringBuffer.toString();
    }

    public static String selAllInstrsTelList(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(runsTable.get()).append(".inst_code ").append(" FROM ").append(runsTable.get()).append(" , ").append(programmesTable.get()).append("").append(" WHERE  ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ");
        if (!string2.equals("()")) {
            stringBuffer.append(" AND tel_code in ").append(string2).append(beginTransaction);
        }
        if (!string.equals("()")) {
            stringBuffer.append(" AND ").append(programmesTable.get()).append(".period in ").append(string);
        }
        return stringBuffer.toString();
    }

    public static String selAllInstrs(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(runsTable.get()).append(".inst_code ").append(" FROM ").append(runsTable.get()).append(" , ").append(programmesTable.get()).append("").append(" WHERE  ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append(" AND tel_code = '").append(string2).append("' ");
        if (!string.equals("()")) {
            stringBuffer.append(" AND ").append(programmesTable.get()).append(".period in ").append(string);
        }
        return stringBuffer.toString();
    }

    public static String selAllInstrs(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(runsTable.get()).append(".inst_code ").append(" FROM ").append(runsTable.get()).append(" , ").append(programmesTable.get()).append("").append(" WHERE  ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append(" AND tel_code = '").append(string).append("' ").append("\n AND ").append(programmesTable.get()).append(".period = ").append(n);
        return stringBuffer.toString();
    }

    public static String selAllSchedRepInstrs(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(schedRepTable.get()).append(".inst ").append("FROM ").append(schedRepTable.get()).append("").append(" WHERE ").append(schedRepTable.get()).append(".period in ").append(string).append(" AND tel in ").append(string2).append(beginTransaction).append(" and inst != ''").append(" order by inst ");
        return stringBuffer.toString();
    }

    public static String selSameSchedRunId(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(schedRepTable.get()).append(".id  FROM ").append(schedRepTable.get()).append(" WHERE ").append(schedRepTable.get()).append(".run_id = ").append(n);
        return stringBuffer.toString();
    }

    public static String wcSameSchedRunId(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(schedRepTable.get()).append(".run_id = ").append(n);
        return stringBuffer.toString();
    }

    public static String selCountSchedRunId(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT COUNT(*)").append(" FROM ").append(schedRepTable.get()).append(" WHERE ").append(schedRepTable.get()).append(".run_id = ").append(n);
        return stringBuffer.toString();
    }

    public static String selAllSchedRepTeles() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(schedRepTable.get()).append(".tel ").append("FROM ").append(schedRepTable.get()).append(" order by tel ");
        return stringBuffer.toString();
    }

    public static String getUserRole(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT letters_role FROM ").append(usersRolesTable.get()).append(", ").append(usersViewTable.get()).append(" WHERE ").append(usersViewTable.get()).append(".password = ").append("'").append(string).append("'").append("\n AND ").append(usersViewTable.get()).append(".login = ").append("'").append(n).append("'").append("\n AND ").append(usersRolesTable.get()).append(".login = ").append(usersViewTable.get()).append(".login");
        return stringBuffer.toString();
    }

    public static String selAllSchedRepInstrs() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(schedRepTable.get()).append(".inst").append(" FROM ").append(schedRepTable.get()).append(" where inst != ''").append(" order by inst ");
        return stringBuffer.toString();
    }

    public static String selSchedRepPublished(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(schedRepTable.get()).append(".published").append(" FROM ").append(schedRepTable.get()).append(" where id = ").append(l);
        return stringBuffer.toString();
    }

    public static String selAllSchedRepInstrs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(schedRepTable.get()).append(".inst").append(" FROM ").append(schedRepTable.get()).append(" WHERE tel = '").append(string).append("'").append(" order by inst ");
        return stringBuffer.toString();
    }

    public static String selAllSchedRepTeles(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(schedRepTable.get()).append(".tel ").append("FROM ").append(schedRepTable.get()).append("").append(" WHERE ").append(schedRepTable.get()).append(".period in ").append(string).append("\n AND ").append(schedRepTable.get()).append(".tel != ''").append(" order by tel ");
        return stringBuffer.toString();
    }

    public static String selAllInstrs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(runsTable.get()).append(".inst_code ").append(" FROM ").append(runsTable.get()).append(" , ").append(programmesTable.get()).append("").append(" WHERE  ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ");
        if (!string.equals("()")) {
            stringBuffer.append(" AND ").append(programmesTable.get()).append(".period in ").append(string);
        }
        return stringBuffer.toString();
    }

    public static String selAllSchedRepInstrsPeriods(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(schedRepTable.get()).append(".inst").append(" FROM ").append(schedRepTable.get()).append(" WHERE ").append(schedRepTable.get()).append(".period in ").append(string).append("\n AND ").append(schedRepTable.get()).append(".inst != '' ").append(" order by inst ");
        return stringBuffer.toString();
    }

    public static String selProgrLatexSource(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  latex_text ").append(" FROM ").append(latexTable.get()).append(" WHERE programme_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String selRefereeAcronym(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  ").append(refereesTable.get()).append(".acronym  ").append(" FROM ").append(refereesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".cycle_id = ").append(n).append(beginTransaction).append("\n AND ").append(refereesTable.get()).append(".acronym = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String selRefereeAcronym(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  ").append(refereesTable.get()).append(".acronym  ").append(" FROM ").append(refereesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".cycle_id = ").append(n).append(beginTransaction).append(" ORDER BY  ").append(refereesTable.get()).append(".acronym");
        return stringBuffer.toString();
    }

    public static String selRefAcronymInProposal(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(refereesTable.get()).append(".acronym  ").append(" FROM ").append(refereesTable.get()).append(", ").append(programmesTable.get()).append(", ").append(proposedTable.get()).append(" WHERE ").append(programmesTable.get()).append(".id = ").append(l).append("\n AND ").append(proposedTable.get()).append(".user_id = ").append(refereesTable.get()).append(".user_id ").append("\n AND ").append(proposedTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id ").append("\n AND ").append(programmesTable.get()).append(".panel = ").append(refereesTable.get()).append(".panel ").append("\n AND ").append(programmesTable.get()).append(".opc_subpanel = ").append(refereesTable.get()).append(".opc_subpanel ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(programmesTable.get()).append(".cycle_id ").append(" order by ").append(programmesTable.get()).append(".panel, ").append(programmesTable.get()).append(".opc_subpanel, ").append(programmesTable.get()).append(".proposal_code");
        return stringBuffer.toString();
    }

    public static String selIPVersion(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT MAX (").append(ipPeriodsTable.get()).append(".version) ").append("FROM ").append(ipPeriodsTable.get()).append(" WHERE ").append(ipPeriodsTable.get()).append(".inst_name = '").append(string).append("'").append("\n AND ").append(ipPeriodsTable.get()).append(".period = ").append(n);
        return stringBuffer.toString();
    }

    public static String insertCyclesMissingUser(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" INSERT INTO ").append(affiliationsTable.get()).append(" SELECT DISTINCT ").append(n2).append(", ").append(affiliationsTable.get()).append(".period , ").append(affiliationsTable.get()).append(".country_code , ").append(affiliationsTable.get()).append(".affiliation , ").append(affiliationsTable.get()).append(".cycle_id ").append(" FROM ").append(cyclesTable.get()).append(", ").append(affiliationsTable.get()).append(" WHERE ").append(affiliationsTable.get()).append(".user_id = ").append(n).append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string).append("' ").append("\n AND ").append(cyclesTable.get()).append(".id = ").append(affiliationsTable.get()).append(".cycle_id \n ");
        return stringBuffer.toString();
    }

    public static String selCyclesMissingUser(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(cyclesTable.get()).append(".label ").append(" FROM ").append(cyclesTable.get()).append(", ").append(programmesTable.get()).append(", ").append(proposedTable.get()).append(" WHERE ").append(proposedTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id ").append("\n AND ").append(proposedTable.get()).append(".user_id = ").append(n).append("\n AND ").append(cyclesTable.get()).append(".id = ").append(programmesTable.get()).append(".cycle_id ").append("\n AND ").append(programmesTable.get()).append(".cycle_id not in ").append(" (SELECT DISTINCT ").append(affiliationsTable.get()).append(".cycle_id ").append(" FROM ").append(affiliationsTable.get()).append(" WHERE ").append(affiliationsTable.get()).append(".user_id = ").append(n2).append(") ");
        return stringBuffer.toString();
    }

    public static String selUserRefereeAcronym(int n, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  ").append(refereesTable.get()).append(".acronym ").append(" FROM ").append(refereesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".cycle_id = ").append(n).append(beginTransaction).append("\n AND ").append(refereesTable.get()).append(".user_id = ").append(l).append(beginTransaction).append(" ORDER BY  ").append(refereesTable.get()).append(".acronym");
        return stringBuffer.toString();
    }

    public static String selUserReferees(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT DISTINCT ").append(refereesTable.get()).append(".acronym ").append(" FROM ").append(refereesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".user_id = ").append(l).append(beginTransaction).append(" ORDER BY  ").append(refereesTable.get()).append(".acronym");
        return stringBuffer.toString();
    }

    public static String selUserFromProposed(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT  ").append(proposedTable.get()).append(".user_id ").append(" FROM ").append(proposedTable.get()).append(beginTransaction).append(" WHERE ").append(proposedTable.get()).append(".programme_id = ").append(l).append(" AND pi_flag = 0");
        return stringBuffer.toString();
    }

    public static String selRatedCount(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT count(*)").append(" FROM ").append(ratedTable.get()).append(beginTransaction).append(" WHERE ").append(ratedTable.get()).append(".user_id = ").append(l).append(beginTransaction);
        return stringBuffer.toString();
    }

    public static String selRatedCycles(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(cyclesTable.get()).append(".label ").append(" FROM ").append(cyclesTable.get()).append(", ").append(ratedTable.get()).append(", ").append(runsTable.get()).append(", ").append(programmesTable.get()).append(" WHERE ").append(ratedTable.get()).append(".user_id = ").append(l).append(beginTransaction).append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ").append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ");
        return stringBuffer.toString();
    }

    public static String selRunNotRated(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT convert(char(15),").append(runsTable.get()).append(".run_code) + convert(char(12),").append(programmesTable.get()).append(".panel) + convert(char(16),").append(programmesTable.get()).append(".opc_subpanel) + convert(char(12),").append(runsTable.get()).append(".tel_code) + convert(char(14),").append(runsTable.get()).append(".inst_code) + convert(char(12),").append(refereesTable.get()).append(".acronym) + convert(char(30),").append(refereesTable.get()).append(".email) ").append(" FROM ").append(cyclesTable.get()).append(", ").append(ratedTable.get()).append(", ").append(runsTable.get()).append(", ").append(programmesTable.get()).append(", ").append(refereesTable.get()).append(" WHERE ").append(ratedTable.get()).append(".user_id = ").append(refereesTable.get()).append(".user_id ").append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ").append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append("\n AND ").append(programmesTable.get()).append(".panel = '").append(string2).append("' ").append("\n AND ").append(programmesTable.get()).append(".ignored = 0 ").append(" AND ( ").append(ratedTable.get()).append(".grade = -1 ").append(" OR ").append(ratedTable.get()).append(".grade = null) ").append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string).append("' ").append(" order by ").append(programmesTable.get()).append(".panel, ").append(programmesTable.get()).append(".opc_subpanel,  ").append(refereesTable.get()).append(".acronym  ");
        return stringBuffer.toString();
    }

    public static String moveProposed(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" UPDATE ").append(proposedTable.get()).append(beginTransaction).append(" SET  ").append(proposedTable.get()).append(".user_id =  ").append(n2).append(" WHERE ").append(proposedTable.get()).append(".user_id = ").append(n).append(beginTransaction);
        return stringBuffer.toString();
    }

    public static String moveReferee(long l, long l2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(refereesTable.get()).append(beginTransaction).append(" SET  ").append(refereesTable.get()).append(".user_id =  ").append(l2).append(" WHERE ").append(refereesTable.get()).append(".cycle_id = ").append(n).append(beginTransaction).append("\n AND ").append(refereesTable.get()).append(".user_id = ").append(l).append(beginTransaction);
        return stringBuffer.toString();
    }

    public static String deleteUser(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n DELETE FROM ").append(affiliationsTable.get()).append(beginTransaction).append(" WHERE ").append(affiliationsTable.get()).append(".user_id = ").append(l).append(beginTransaction).append("\n DELETE FROM ").append(usersTable.get()).append(beginTransaction).append(" WHERE ").append(usersTable.get()).append(".id = ").append(l).append(beginTransaction);
        return stringBuffer.toString();
    }

    public static String schedRepDbDelete(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE ").append("FROM ").append(schedRepTable.get()).append(" WHERE ").append(schedRepTable.get()).append(".id = ").append(n);
        return stringBuffer.toString();
    }

    public static String schedRepSetPublishedFlag(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(schedRepTable.get()).append(" SET published = ").append(n).append(" WHERE ").append(schedRepTable.get()).append(".id = ").append(l);
        return stringBuffer.toString();
    }

    public static String obsRunGetRow(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select programme_id, run_desc from ").append(runsTable.get()).append(" where id = ").append(n);
        return stringBuffer.toString();
    }

    public static String obsRunGetCountRow(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select count(id) from ").append(runsTable.get()).append(" where id = ").append(n);
        return stringBuffer.toString();
    }

    public static String selNotAuthorizedReferees(String[] stringArray) {
        String string = TextUtils.arrayToString(stringArray, "', '", false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n SELECT DISTINCT ").append(esoUsersRolesTable.get()).append(".login ").append(" FROM ").append(esoUsersRolesTable.get()).append(" WHERE ").append(esoUsersRolesTable.get()).append(".login in ( '").append(string).append(" ') ").append(" AND (").append(esoUsersRolesTable.get()).append(".login not in ( ").append("\n SELECT DISTINCT ").append(esoUsersRolesTable.get()).append(".login ").append(" FROM ").append(esoUsersRolesTable.get()).append(" WHERE ").append(esoUsersRolesTable.get()).append(".letters_role  = 'viewComment' ").append("\n AND ").append(esoUsersRolesTable.get()).append(".login in ( '").append(string).append(" ') )  ").append(" OR ").append(esoUsersRolesTable.get()).append(".login not in ( ").append("\n SELECT DISTINCT ").append(esoUsersRolesTable.get()).append(".login ").append(" FROM ").append(esoUsersRolesTable.get()).append(" WHERE ").append(esoUsersRolesTable.get()).append(".letters_role  = 'viewReport' ").append("\n AND ").append(esoUsersRolesTable.get()).append(".login in ( '").append(string).append(" ') ))  ");
        return stringBuffer.toString();
    }

    public static String insertWotViewCcRcFlag(String[] stringArray) {
        String string = TextUtils.arrayToString(stringArray, "', '", false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n DELETE FROM ").append(esoUsersRolesTable.get()).append(beginTransaction).append("\n WHERE ").append(esoUsersRolesTable.get()).append(".login in ( '").append(string).append(" ') ").append("\n AND (").append(esoUsersRolesTable.get()).append(".letters_role = 'viewComment' ").append("\n OR ").append(esoUsersRolesTable.get()).append(".letters_role = 'viewReport' )");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("\n INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES ('").append(stringArray[n]).append("', 'viewComment')");
            stringBuffer.append("\n INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES ('").append(stringArray[n]).append("', 'viewReport')");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String insertRefDdtRole(String[] stringArray) {
        String string = TextUtils.arrayToString(stringArray, "', '", false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n DELETE FROM ").append(esoUsersRolesTable.get()).append(beginTransaction).append("\n WHERE ").append(esoUsersRolesTable.get()).append(".letters_role = 'refDdt' ");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("\n INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES ('").append(stringArray[n]).append("', 'refDdt')");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String selProgrPicture(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  postscript_text ").append(" FROM ").append(figuresTable.get()).append(beginTransaction).append(" WHERE programme_id = ").append(l).append(" AND file_name = '").append(string).append("' ").append(" AND received_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String selProgrPicture(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  postscript_text ").append(" FROM ").append(figuresTable.get()).append(beginTransaction).append(",").append(programmesTable.get()).append(" WHERE ").append(figuresTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id").append(" AND ").append(programmesTable.get()).append(".proposal_code = '").append(string).append("'").append(" AND file_name = '").append(string2).append("' ").append(" AND received_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String selReceivedFigures(long l) {
        StringBuffer stringBuffer = new StringBuffer(Phase1SelectStmt.selFigures(l));
        stringBuffer.append(" AND received_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String selFigures(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT   file_name ").append(" FROM ").append(figuresTable.get()).append(beginTransaction).append(" WHERE programme_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String selReceivedFiguresInCache(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT   picture_name ").append(" FROM ").append(figureSummaryTable.get()).append(beginTransaction).append(" WHERE summary_id = ").append(l).append(" AND status in (").append(1).append(", ").append(3).append(")");
        return stringBuffer.toString();
    }

    public static String selEmptyFiguresInCache(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  count(*) ").append(" FROM ").append(figureSummaryTable.get()).append(beginTransaction).append(" WHERE summary_id = ").append(l).append(" AND status = ").append(0);
        return stringBuffer.toString();
    }

    public static String selReceivedFigure(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT file_name ").append(" FROM ").append(figuresTable.get()).append(beginTransaction).append(" WHERE programme_id = ").append(l).append(" AND file_name = ").append("'").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String selAttachedFigures(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) ").append(" FROM ").append(figuresTable.get()).append(beginTransaction).append(" WHERE programme_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String selReceivedFigures(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT   file_name ").append(" FROM ").append(figuresTable.get()).append(beginTransaction).append(",").append(programmesTable.get()).append(" WHERE ").append(figuresTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id").append(" AND ").append(programmesTable.get()).append(".proposal_code = '").append(string).append("'").append(" AND received_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String selMissingFigures(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT   file_name ").append(" FROM ").append(figuresTable.get()).append(beginTransaction).append(" WHERE programme_id = ").append(l).append(" AND received_flag = 0 ");
        return stringBuffer.toString();
    }

    public static String selCardReferee(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  DISTINCT ").append(refereesTable.get()).append(".acronym ").append("FROM ").append(ratedTable.get()).append(" , ").append(commentsTable.get()).append(" , ").append(usersTable.get()).append(", ").append(refereesTable.get()).append(", ").append(programmesTable.get()).append(", ").append(runsTable.get()).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(l).append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ").append("\n AND ").append(usersTable.get()).append(".id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(commentsTable.get()).append(".run_id ").append("\n AND ").append(commentsTable.get()).append(".user_id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(programmesTable.get()).append(".cycle_id ").append("\n AND ").append(usersTable.get()).append(".id = ").append(refereesTable.get()).append(".user_id ").append(" ORDER BY  ").append(refereesTable.get()).append(".acronym");
        return stringBuffer.toString();
    }

    public static String selPrimaryReferee(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT  DISTINCT ").append(refereesTable.get()).append(".acronym ").append("FROM ").append(ratedTable.get()).append(" , ").append(usersTable.get()).append(", ").append(refereesTable.get()).append(", ").append(programmesTable.get()).append(", ").append(runsTable.get()).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(l).append(" AND  ").append(ratedTable.get()).append(".pr_flag = 1 ").append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ").append("\n AND ").append(usersTable.get()).append(".id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(programmesTable.get()).append(".cycle_id ").append("\n AND ").append(usersTable.get()).append(".id = ").append(refereesTable.get()).append(".user_id ");
        return stringBuffer.toString();
    }

    public static String selSubpanelRefUserId(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(refereesTable.get()).append(".user_id ").append("FROM  ").append(refereesTable.get()).append(", ").append(runsTable.get()).append(", ").append(programmesTable.get()).append(" WHERE ").append(runsTable.get()).append(".id = ").append(l).append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(programmesTable.get()).append(".panel = ").append(refereesTable.get()).append(".panel ").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(refereesTable.get()).append(".cycle_id ").append("\n AND ").append(programmesTable.get()).append(".opc_subpanel = ").append(refereesTable.get()).append(".opc_subpanel ");
        return stringBuffer.toString();
    }

    public static String selDateStart(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(schedRepTable.get()).append(".from_date ").append("FROM  ").append(schedRepTable.get()).append(beginTransaction).append(" WHERE ").append(schedRepTable.get()).append(".run_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String selDateEnd(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(schedRepTable.get()).append(".to_date ").append("FROM  ").append(schedRepTable.get()).append(beginTransaction).append(" WHERE ").append(schedRepTable.get()).append(".run_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String selCommentShort(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(commentsTable.get()).append(".comment_short ").append("FROM  ").append(commentsTable.get()).append(beginTransaction).append(" WHERE ").append(commentsTable.get()).append(".run_id = ").append(l).append("\n AND ").append(commentsTable.get()).append(".comment_flag = 1");
        return stringBuffer.toString();
    }

    public static String selCommentLong(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(commentsTable.get()).append(".comment_long ").append("FROM  ").append(commentsTable.get()).append(beginTransaction).append(" WHERE ").append(commentsTable.get()).append(".run_id = ").append(l).append("\n AND ").append(commentsTable.get()).append(".comment_flag = 1");
        return stringBuffer.toString();
    }

    public static String selRunComment(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(runCommentTable.get()).append(".comment ").append("FROM ").append(runCommentTable.get()).append(beginTransaction).append(" WHERE ").append(runCommentTable.get()).append(".run_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String selHtlmFragmentText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(htmlFragTable.get()).append(".fragment ").append("FROM  ").append(htmlFragTable.get()).append(" WHERE ").append(htmlFragTable.get()).append(".keyword = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String selHtlmFragmentTitle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(htmlFragTable.get()).append(".title ").append("FROM  ").append(htmlFragTable.get()).append(" WHERE ").append(htmlFragTable.get()).append(".keyword = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String selHtlmFragmentKeywords() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(htmlFragTable.get()).append(".keyword ").append("FROM  ").append(htmlFragTable.get());
        return stringBuffer.toString();
    }

    public static String selLargeRefAcronym(int n, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  ").append(refereesTable.get()).append(".acronym ").append("FROM  ").append(refereesTable.get()).append(beginTransaction).append(" WHERE ").append(refereesTable.get()).append(".opc_member = 1 ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(n).append(" UNION ").append("SELECT DISTINCT ").append(refereesTable.get()).append(".acronym ").append("FROM  ").append(refereesTable.get()).append(", ").append(runsTable.get()).append(", ").append(programmesTable.get()).append(" WHERE ").append(runsTable.get()).append(".id = ").append(l).append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(programmesTable.get()).append(".panel = ").append(refereesTable.get()).append(".panel ").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(refereesTable.get()).append(".cycle_id ").append(" ORDER BY  ").append(refereesTable.get()).append(".acronym");
        return stringBuffer.toString();
    }

    public static String selRefereeId(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT   ").append(refereesTable.get()).append(".user_id ").append("FROM  ").append(refereesTable.get()).append(", ").append(runsTable.get()).append(", ").append(programmesTable.get()).append("").append(" WHERE ").append(runsTable.get()).append(".id = ").append(l).append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append(" AND  ").append(refereesTable.get()).append(".acronym =  '").append(string).append("' ").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(refereesTable.get()).append(".cycle_id ");
        return stringBuffer.toString();
    }

    public static String selActiveReferee(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT   ").append(refereesTable.get()).append(".acronym ").append("FROM ").append(ratedTable.get()).append(" , ").append(refereesTable.get()).append(beginTransaction).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(l).append("\n AND ").append(refereesTable.get()).append(".user_id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(n).append(" ORDER BY  ").append(refereesTable.get()).append(".acronym");
        return stringBuffer.toString();
    }

    public static String wcReferees(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".acronym != ''  ").append(" AND  ").append(refereesTable.get()).append(".panel = '").append(string).append("' ").append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string2).append("' ").append("   order by ").append(refereesTable.get()).append(".opc_subpanel, ").append(refereesTable.get()).append(".user_id desc ");
        return stringBuffer.toString();
    }

    public static String wcRefereesByCycle(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".acronym != ''  ").append("\n AND ").append(refereesTable.get()).append(".cycle_id =").append(n).append(beginTransaction);
        return stringBuffer.toString();
    }

    public static String wcRefereesByCycleLabel(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".acronym != ''  ").append(" AND ").append(cyclesTable.get()).append(".label ='").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String wcReferees(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" user_id = ").append(l).append(beginTransaction).append(orderByReferee);
        return stringBuffer.toString();
    }

    public static String wcReferees(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".acronym != '' ").append(" AND  ").append(refereesTable.get()).append(".panel = '").append(c).append("' ").append(" AND  ").append(refereesTable.get()).append(".opc_subpanel = ").append(n).append(beginTransaction).append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string).append("' ").append(orderByReferee);
        return stringBuffer.toString();
    }

    public static String wcCurrReferee(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".acronym = '").append(string).append("' ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(n).append(beginTransaction);
        return stringBuffer.toString();
    }

    public static String wcRefereeOpcMembers(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".acronym != '' ").append(" AND  ").append(refereesTable.get()).append(".panel = '").append(c).append("' ").append("\n AND ").append(refereesTable.get()).append(".opc_subpanel = ").append(n).append(beginTransaction).append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string).append("' ").append("\n AND ").append(refereesTable.get()).append(".opc_member = 1 ").append(orderByReferee);
        return stringBuffer.toString();
    }

    public static String wcRefereesPanel(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".acronym != '' ").append(" AND  ").append(refereesTable.get()).append(".panel = '").append(c).append("' ").append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string).append("' ").append(orderByReferee);
        return stringBuffer.toString();
    }

    public static String wcRefereeOpcMembers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".acronym != '' ").append(" AND ").append(cyclesTable.get()).append(".label = '").append(string).append("' ").append(" AND ").append(refereesTable.get()).append(".opc_member = 1 ").append(orderByReferee);
        return stringBuffer.toString();
    }

    public static String wcOpcReferees(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".acronym != '' ").append(" AND  ").append(refereesTable.get()).append(".panel = '").append(c).append("' ").append("\n AND ").append(refereesTable.get()).append(".opc_subpanel = ").append(n).append(beginTransaction).append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string).append("' ").append("\n AND ").append(refereesTable.get()).append(".opc_member = 1 ").append(orderByReferee);
        return stringBuffer.toString();
    }

    public static String wcAssignedReferees(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ratedTable.get()).append(".run_id = ").append(l).append(beginTransaction).append("\n AND ").append(refereesTable.get()).append(".user_id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(l2).append(" ORDER BY ").append(ratedTable.get()).append(".pr_flag desc \n\n");
        return stringBuffer.toString();
    }

    public static String wcAssignedPrimaryReferees(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ratedTable.get()).append(".run_id = ").append(l).append(beginTransaction).append("\n AND ").append(refereesTable.get()).append(".user_id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(l2).append("\n AND ").append(ratedTable.get()).append(".pr_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String wcAssignedRefereesTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(", ").append(ratedTable.get());
        return stringBuffer.toString();
    }

    public static String wcAssignedPrimaryRefereesTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(", ").append(ratedTable.get());
        return stringBuffer.toString();
    }

    public static String wcProgrammeTel(char c, String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append(" AND ").append(telescopeTable.get()).append(".observatory = 'P' ");
        } else {
            stringBuffer.append(" AND ").append(telescopeTable.get()).append(".observatory = 'L' ");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(programmesTable.get()).append(".panel = '").append(c).append("' ").append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append("\n AND ").append(runsTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id ").append("\n AND ").append(runsTable.get()).append(".tel_code = ").append(telescopeTable.get()).append(".code ").append("\n AND ").append(cyclesTable.get()).append(".id = ").append(programmesTable.get()).append(".cycle_id ").append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string).append("' ");
        if (bl) {
            stringBuffer2.append(" AND ").append(programmesTable.get()).append(".gto = 4 ");
        } else {
            stringBuffer2.append(" AND ").append(programmesTable.get()).append(".gto in (0,1,3) ");
        }
        stringBuffer2.append(stringBuffer.toString());
        return stringBuffer2.toString();
    }

    public static String wcProgrammeTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(runsTable.get());
        return stringBuffer.toString();
    }

    public static String wcProgrammeTableTel() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(runsTable.get()).append(" ,").append(telescopeTable.get());
        return stringBuffer.toString();
    }

    public static String wcRunTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(runsTable.get());
        return stringBuffer.toString();
    }

    public static String wcProgramme(char c, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(programmesTable.get()).append(".panel = '").append(c).append("' ").append("\n AND ").append(programmesTable.get()).append(".opc_subpanel = ").append(n).append(beginTransaction).append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append(" AND " + cyclesTable.get()).append(".id = ").append(programmesTable.get()).append(".cycle_id ").append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String wcProgrammeObsRun(long l, int n) {
        String string = programmesTable.get() + ".id = " + proposedTable.get() + ".programme_id" + " AND " + programmesTable.get() + ".ignored = 0" + " AND " + proposedTable.get() + ".user_id = " + l + " AND " + proposedTable.get() + ".pi_flag = 0" + " AND " + runsTable.get() + ".programme_id = " + programmesTable.get() + ".id " + " AND " + programmesTable.get() + ".cycle_id = " + n + " ORDER BY " + programmesTable.get() + ".id ";
        return string;
    }

    public static String wcProgrammeSched(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(programmesTable.get()).append(".id = ").append(proposedTable.get()).append(".programme_id").append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append("\n AND ").append(proposedTable.get()).append(".user_id = ").append(l).append("\n AND ").append(proposedTable.get()).append(".pi_flag = 0").append("\n AND ").append(runsTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id ").append("\n AND ").append(runsTable.get()).append(".id = ").append(schedRepTable.get()).append(".run_id ").append("\n AND ").append(schedRepTable.get()).append(".period = ").append(n).append(" ORDER BY ").append(programmesTable.get()).append(".id ");
        return stringBuffer.toString();
    }

    public static String wcRunsRatedTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(ratedTable.get()).append(" ,").append(programmesTable.get()).append(" ,").append(cyclesTable.get());
        return stringBuffer.toString();
    }

    public static String wcProgrammeSchedTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(proposedTable.get()).append(" ,").append(runsTable.get()).append(" ,").append(schedRepTable.get());
        return stringBuffer.toString();
    }

    public static String wcProgrammeObsRunTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(proposedTable.get()).append(" ,").append(runsTable.get());
        return stringBuffer.toString();
    }

    public static String wcRatedRefRunsTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(ratedTable.get()).append(" ,").append(programmesTable.get());
        return stringBuffer.toString();
    }

    public static String wcRatedRefRuns(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ").append("\n AND ").append(runsTable.get()).append(".programme_id = ").append(l).append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(l2).append(" ORDER BY ").append(runsTable.get()).append(".id ");
        return stringBuffer.toString();
    }

    public static String wcProgrammeCommentRef(String string, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ").append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append("\n AND ").append(cyclesTable.get()).append(".label = '").append(string).append("'").append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(refereesTable.get()).append(".user_id ").append("\n AND ").append(refereesTable.get()).append(".cycle_id = ").append(cyclesTable.get()).append(".id ").append("\n AND ").append(refereesTable.get()).append(".user_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String wcProgrammeCommentRefTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(runsTable.get()).append(" ,").append(ratedTable.get()).append(" ,").append(refereesTable.get());
        return stringBuffer.toString();
    }

    public static String wcRuns(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(runsTable.get()).append(".programme_id = ").append(l).append(" ORDER BY ").append(runsTable.get()).append(".id ");
        return stringBuffer.toString();
    }

    public static String wcRunProgrammesTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(programmesTable.get());
        return stringBuffer.toString();
    }

    public static String wcReportCard(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ratedTable.get()).append(".run_id = ").append(l).append(" ORDER BY ").append(ratedTable.get()).append(".run_id");
        return stringBuffer.toString();
    }

    public static String wcReportAndCommentCard(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(commentsTable.get()).append(".run_id = ").append(l).append(" ORDER BY ").append(commentsTable.get()).append(".run_id");
        return stringBuffer.toString();
    }

    public static String wcCommentCard(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(commentsTable.get()).append(".run_id = ").append(l).append("\n AND ").append(commentsTable.get()).append(".comment_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String wcRunCutOff(String string, int n, String string2, int n2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(runsTable.get()).append(".run_code like '%-").append(string3).append("'").append("\n AND ").append(runsTable.get()).append(".tel_code = '").append(string2).append("' AND ").append(programmesTable.get()).append(".cycle_id = ").append(n2).append("\n AND ").append(programmesTable.get()).append(".opc_subpanel = ").append(n).append("\n AND ").append(programmesTable.get()).append(".panel = '").append(string).append("' AND ").append(programmesTable.get()).append(".ignored = 0").append(" AND   ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id");
        return stringBuffer.toString();
    }

    public static String selectRunCodeList(String string, int n, String string2, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT ").append(runsTable.get()).append(".run_code ").append(" FROM ").append(runsTable.get()).append(", ").append(programmesTable.get()).append(" WHERE ").append(runsTable.get()).append(".tel_code = '").append(string2).append("' AND ").append(programmesTable.get()).append(".cycle_id = ").append(n2).append("\n AND ").append(programmesTable.get()).append(".opc_subpanel = ").append(n).append("\n AND ").append(programmesTable.get()).append(".panel = '").append(string).append("' AND ").append(programmesTable.get()).append(".ignored = 0").append(" AND   ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id");
        return stringBuffer.toString();
    }

    public static String wcBelowRuns(String string, String string2, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(runsTable.get()).append(".tel_code = '").append(string).append("' ").append(" AND   ").append(programmesTable.get()).append(".panel = '").append(string2).append("' ").append(" AND   ").append(programmesTable.get()).append(".opc_subpanel = ").append(n).append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(n3).append(" AND   ").append(runsTable.get()).append(".assigned_time > 0 ").append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append(" AND   ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id").append(" AND   ").append(runsTable.get()).append(".rank > ").append(n2);
        return stringBuffer.toString();
    }

    public static String wcAboveRuns(String string, String string2, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(runsTable.get()).append(".tel_code = '").append(string).append("' ").append(" AND   ").append(programmesTable.get()).append(".panel = '").append(string2).append("' ").append(" AND   ").append(programmesTable.get()).append(".opc_subpanel = ").append(n).append(" AND   ").append(programmesTable.get()).append(".cycle_id = ").append(n3).append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append(" AND   ").append(runsTable.get()).append(".assigned_time > 0 ").append(" AND   ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id").append(" AND   ").append(runsTable.get()).append(".rank <= ").append(n2);
        return stringBuffer.toString();
    }

    public static String wcSchedRuns(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(runsTable.get()).append(".programme_id = ").append(l).append(" AND ").append(runsTable.get()).append(".id = ").append(schedRepTable.get()).append(".run_id").append(" ORDER BY ").append(runsTable.get()).append(".id ");
        return stringBuffer.toString();
    }

    public static String wcSchedRunsPublished(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(runsTable.get()).append(".programme_id = ").append(l).append("\n AND ").append(runsTable.get()).append(".id = ").append(schedRepTable.get()).append(".run_id").append("\n AND ").append(schedRepTable.get()).append(".published = 1").append(" ORDER BY ").append(runsTable.get()).append(".id ");
        return stringBuffer.toString();
    }

    public static String wcSchedRunsPrivate(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(runsTable.get()).append(".programme_id = ").append(l).append("\n AND ").append(runsTable.get()).append(".id = ").append(schedRepTable.get()).append(".run_id").append("\n AND ").append(schedRepTable.get()).append(".published = 0").append(" ORDER BY ").append(runsTable.get()).append(".id ");
        return stringBuffer.toString();
    }

    public static String delRated(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE ").append(" FROM ").append(ratedTable.get()).append(beginTransaction).append("WHERE run_id  = ").append(l).append("\n\n");
        return stringBuffer.toString();
    }

    public static String updateObserver(String string, String string2, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(schedRepTable.get()).append("").append(" SET observer = '").append(string).append("' ").append(", observerEmail = '").append(string2).append("' ").append(" WHERE run_id  = ").append(l).append(beginTransaction);
        return stringBuffer.toString();
    }

    public static String updateCommentLong(String string, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(commentsTable.get()).append("").append(" SET comment_short = NULL").append(", comment_long = '").append(string).append("' ").append(" WHERE run_id  = ").append(l).append(" AND comment_flag = 1");
        return stringBuffer.toString();
    }

    public static String updatePrintedFlag(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(programmesTable.get()).append("").append(" SET printed = ").append(n).append(" WHERE id  = ").append(l);
        return stringBuffer.toString();
    }

    public static String insertCommentRow(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT ").append(commentsTable.get()).append("").append("(user_id, run_id, comment_flag) ").append(" VALUES (").append(l).append(", ").append(l2).append(", 1) ");
        return stringBuffer.toString();
    }

    public static String updateRunComment(String string, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(runCommentTable.get()).append("").append(" SET comment = '").append(string).append("' ").append(" WHERE run_id  = ").append(l);
        return stringBuffer.toString();
    }

    public static String insertActiveReferee(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" INSERT ").append(" INTO ").append(ratedTable.get()).append(beginTransaction).append(" (user_id, run_id, pr_flag, card_id, grade, nights, ").append(" strengths, weaknesses, feasibility, overall1, overall2)").append("VALUES (").append(l2).append(", ").append(l).append(", 0, 0, -1, 0, '', '', '', '', '') ");
        return stringBuffer.toString();
    }

    public static String updatePrimaryReferee(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" INSERT ").append(" INTO ").append(ratedTable.get()).append(beginTransaction).append(" (user_id, run_id, pr_flag, card_id, grade, nights, ").append(" strengths, weaknesses, feasibility, overall1, overall2)").append("VALUES (").append(l2).append(", ").append(l).append(", 1, 0, -1, 0, '', '', '', '', '') ");
        return stringBuffer.toString();
    }

    public static String updatePicture(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(figuresTable.get()).append(" set postscript_text = ").append(Phase1SelectStmt.getQuestionMark()).append(" WHERE file_name = '").append(string).append("'").append(" AND programme_id = ").append(n).append("\n\n");
        return stringBuffer.toString();
    }

    public static String updateReceivedFiguresFlag(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(figuresTable.get()).append(" set received_flag = 1 ").append(" WHERE file_name = '").append(string).append("'").append(" AND programme_id = ").append(l).append("\n\n");
        return stringBuffer.toString();
    }

    public static String selExpectedFigures(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT attachments FROM ").append(programmesTable.get()).append(" WHERE id = ").append(n);
        return stringBuffer.toString();
    }

    public static String updateAccessedLetterFlag(long l, long l2, long l3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(affiliationsTable.get()).append(" SET accessed_letter = ").append(l3).append(" WHERE user_id = ").append(l).append(" AND   cycle_id = ").append(l2);
        return stringBuffer.toString();
    }

    public static String insertWotEditCcFlag(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES('").append(l).append("', 'editComment')");
        return stringBuffer.toString();
    }

    public static String insertWotEditRcFlag(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES('").append(l).append("', 'editReport')");
        return stringBuffer.toString();
    }

    public static String deleteWotEditCcFlag(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE ").append(esoUsersRolesTable.get()).append(" WHERE login ='").append(l).append("' AND letters_role = 'editComment'");
        return stringBuffer.toString();
    }

    public static String insertReportCardPermissionFlag(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE ").append(esoUsersRolesTable.get()).append(" WHERE  login ='").append(l).append("' AND (letters_role = 'editReport'").append(" OR letters_role = 'viewReport')\n");
        stringBuffer.append("INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES('").append(l).append("', 'editReport')\n");
        stringBuffer.append("INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES('").append(l).append("', 'viewReport')\n");
        return stringBuffer.toString();
    }

    public static String insertCommentCardPermissionFlag(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE ").append(esoUsersRolesTable.get()).append(" WHERE  login ='").append(l).append("' AND (letters_role = 'editComment'").append(" OR letters_role = 'viewComment')\n");
        stringBuffer.append("INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES('").append(l).append("', 'editComment')\n");
        stringBuffer.append("INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES('").append(l).append("', 'viewComment')\n");
        return stringBuffer.toString();
    }

    public static String deleteWotEditRcFlag(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE ").append(esoUsersRolesTable.get()).append(" WHERE login ='").append(l).append("' AND letters_role = 'editReport'");
        return stringBuffer.toString();
    }

    public static String insRated(long l, long l2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(ratedTable.get()).append(" (user_id, run_id, pr_flag, card_id, comment_card_id) ").append("VALUES (").append(l).append(", ").append(l2).append(", ").append(n).append(", -1, -1)\n\n");
        return stringBuffer.toString();
    }

    public static String setPrimaryRef(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" \n\n UPDATE ").append(ratedTable.get()).append(" SET pr_flag = 0 ").append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(l2).append(" \n\n UPDATE ").append(ratedTable.get()).append(" SET pr_flag = 1 ").append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(l2).append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String copyRatedComment(long l, long l2, long l3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(ratedTable.get()).append(" (user_id, run_id, pr_flag, grade, nights, card_id, comment_card_id, conflicts) ").append("SELECT ").append(l2).append(", run_id,  pr_flag, grade, nights, card_id, comment_card_id, 0 ").append(" FROM ").append(ratedTable.get()).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(l3).append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(l).append("  \n\n UPDATE ").append(commentsTable.get()).append(" SET user_id = ").append(l2).append(" WHERE ").append(commentsTable.get()).append(".run_id = ").append(l3).append("\n AND ").append(commentsTable.get()).append(".user_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String deleteRatedComment(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" \n\n DELETE ").append(commentsTable.get()).append(" WHERE ").append(commentsTable.get()).append(".run_id = ").append(l2).append("\n AND ").append(commentsTable.get()).append(".user_id = ").append(l).append(" \n\n DELETE ").append(ratedTable.get()).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(l2).append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String insertRunComment(String string, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(runCommentTable.get()).append(" values(").append(l).append(",'").append(string).append("')");
        return stringBuffer.toString();
    }

    public static String insertLatexSourceRow(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(latexTable.get()).append(" (programme_id, abstract_text, latex_text) ").append(" VALUES (").append(l).append(",'").append(TextUtils.quoteSqlString(string)).append("','')");
        return stringBuffer.toString();
    }

    public static String insertPicture(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(figuresTable.get()).append(" (programme_id, file_name, postscript_text , received_flag) ").append("VALUES (").append(n).append(",'").append(string).append("','").append(string).append("',1)\n\n");
        return stringBuffer.toString();
    }

    public static String insertLatexSource(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(latexTable.get()).append(" set latex_text = ").append(Phase1SelectStmt.getQuestionMark()).append(" WHERE programme_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String insertFigureSource(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(figuresTable.get()).append(" set postscript_text = ").append(Phase1SelectStmt.getQuestionMark()).append(" WHERE programme_id = ").append(l).append(" AND file_name = '").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String wcCycleLabel(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cyclesTable.get()).append(".label = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String wcRefWithConflicts(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(refereesTable.get()).append(".user_id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(l).append("\n AND ").append(ratedTable.get()).append(".conflicts = 1 ");
        return stringBuffer.toString();
    }

    public static String wcRefWithConflictsTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(", ").append(ratedTable.get());
        return stringBuffer.toString();
    }

    public static String wcRefRated(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(refereesTable.get()).append(".user_id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String wcRefRatedTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(", ").append(ratedTable.get());
        return stringBuffer.toString();
    }

    public static String wcRefUsersList(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(refereesTable.get()).append(".user_id = ").append(usersTable.get()).append(".id ").append(" ORDER by ").append(refereesTable.get()).append(".panel, ").append(refereesTable.get()).append(".opc_subpanel, ").append(refereesTable.get()).append(".chair DESC, ").append(refereesTable.get()).append(".opc_member DESC, ").append(refereesTable.get()).append(".acronym ");
        return stringBuffer.toString();
    }

    public static String wcRefUsersListTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(", ").append(refereesTable.get());
        return stringBuffer.toString();
    }

    public static String selCycleFromReportCard(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT  ").append(refereesTable.get()).append(".cycle_id ").append(" FROM ").append(runsTable.get()).append(", ").append(refereesTable.get()).append(", ").append(ratedTable.get()).append(", ").append(programmesTable.get()).append(" WHERE  ").append(refereesTable.get()).append(".user_id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(programmesTable.get()).append(".id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ").append("\n AND ").append(runsTable.get()).append(".id = ").append(l2).append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(refereesTable.get()).append(".cycle_id ");
        return stringBuffer.toString();
    }

    public static String selCountEmptyCards(long l, int n, boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  count(*) ").append(" FROM ").append(commentsTable.get()).append(",").append(programmesTable.get()).append(",").append(runsTable.get()).append(",").append(ratedTable.get()).append(" WHERE ").append(commentsTable.get()).append(".user_id = ").append(l).append("\n AND ").append(commentsTable.get()).append(".run_id = ").append(runsTable.get()).append(".id").append("\n AND ").append(runsTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id").append("\n AND ").append(runsTable.get()).append(".run_desc = 'A'").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(commentsTable.get()).append(".comment_flag = ").append(n2).append(" AND (").append(commentsTable.get()).append(".comment_long like '' OR convert(varchar(1), ").append(commentsTable.get()).append(".comment_long) = null) AND (").append(commentsTable.get()).append(".comment_short = '' OR  ").append(commentsTable.get()).append(".comment_short = null)").append("\n AND ").append(ratedTable.get()).append(".conflicts = 0").append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(commentsTable.get()).append(".user_id").append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(commentsTable.get()).append(".run_id");
        return stringBuffer.toString();
    }

    public static String selCountConflicts(long l, long l2, long l3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  count(*) ").append(" FROM ").append(ratedTable.get()).append(" WHERE ").append(ratedTable.get()).append(".user_id = ").append(l).append("\n AND ").append(ratedTable.get()).append(".conflicts = 1").append("\n AND ").append(ratedTable.get()).append(".run_id > ").append(l2).append("\n AND ").append(ratedTable.get()).append(".run_id < ").append(l3);
        return stringBuffer.toString();
    }

    public static String selCountRated(long l, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(ratedTable.get()).append(",").append(programmesTable.get()).append(",").append(runsTable.get()).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id").append("\n AND ").append(runsTable.get()).append(".run_desc = 'A'").append("\n AND ").append(runsTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append("\n AND ").append(ratedTable.get()).append(".user_id=").append(l).append("\n AND ").append(ratedTable.get()).append(".conflicts = 0");
        if (bl) {
            stringBuffer.append(" AND ").append(ratedTable.get()).append(".pr_flag = 1 ");
        }
        return stringBuffer.toString();
    }

    public static String selCountRatedProgrammme(long l, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(ratedTable.get()).append(",").append(programmesTable.get()).append(",").append(runsTable.get()).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id").append("\n AND ").append(runsTable.get()).append(".run_desc = 'A'").append("\n AND ").append(runsTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append("\n AND ").append(ratedTable.get()).append(".user_id=").append(l).append("\n AND ").append(ratedTable.get()).append(".conflicts = 0");
        if (bl) {
            stringBuffer.append("\n AND ").append(ratedTable.get()).append(".pr_flag = 1 ");
        }
        return stringBuffer.toString();
    }

    public static String updateConflictsRated(int n, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(ratedTable.get()).append(" SET ").append(ratedTable.get()).append(".conflicts = ").append(n).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String selCountPrimaryRow(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(ratedTable.get()).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(l2).append("\n AND ").append(ratedTable.get()).append(".user_id=").append(l).append("\n AND ").append(ratedTable.get()).append(".pr_flag = 1 ");
        return stringBuffer.toString();
    }

    public static String selCountReferees(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(refereesTable.get()).append(" WHERE ").append(refereesTable.get()).append(".cycle_id = ").append(n);
        return stringBuffer.toString();
    }

    public static String selCountCommentCards(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(commentsTable.get()).append(",").append(programmesTable.get()).append(",").append(runsTable.get()).append(" WHERE ").append(commentsTable.get()).append(".run_id = ").append(runsTable.get()).append(".id").append("\n AND ").append(runsTable.get()).append(".run_desc = 'A'").append("\n AND ").append(runsTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append("\n AND ").append(commentsTable.get()).append(".comment_flag=1").append("\n AND ").append(commentsTable.get()).append(".user_id=").append(l);
        return stringBuffer.toString();
    }

    public static String selCountReportCards(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(commentsTable.get()).append(",").append(programmesTable.get()).append(",").append(runsTable.get()).append(",").append(ratedTable.get()).append(" WHERE ").append(commentsTable.get()).append(".run_id = ").append(runsTable.get()).append(".id").append("\n AND ").append(runsTable.get()).append(".run_desc = 'A'").append("\n AND ").append(runsTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id").append("\n AND ").append(programmesTable.get()).append(".cycle_id = ").append(n).append("\n AND ").append(programmesTable.get()).append(".ignored = 0").append("\n AND ").append(commentsTable.get()).append(".comment_flag=0").append("\n AND ").append(commentsTable.get()).append(".user_id=").append(l).append("\n AND ").append(ratedTable.get()).append(".conflicts = 0").append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(commentsTable.get()).append(".user_id").append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(commentsTable.get()).append(".run_id");
        return stringBuffer.toString();
    }

    public static String wcObserverEmpty() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( observer = '' or observer = NULL ").append(" or observer_email = '' or observer_email = NULL ) ");
        return stringBuffer.toString();
    }

    public static String insertAffiliation(Affiliation affiliation) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(affiliationsTable.get()).append(" (user_id,period,country_code,affiliation, cycle_id, accessed_letter) ").append("VALUES (").append(affiliation.getUserId()).append(", ").append(affiliation.getPeriod()).append(", '").append(affiliation.getCountryCode()).append("', '").append(affiliation.getInstitution()).append("', ").append(affiliation.getCycleId()).append(", null)\n\n");
        return stringBuffer.toString();
    }

    public static String selCyclesFromRun(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(programmesTable.get()).append(".cycle_id ").append(" FROM ").append(programmesTable.get()).append(", ").append(runsTable.get()).append(" WHERE ").append(runsTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id ").append("\n AND ").append(runsTable.get()).append(".id in ( ").append(string).append(") ");
        return stringBuffer.toString();
    }

    public static String selPrFlagFromRun(long l, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(ratedTable.get()).append(".pr_flag ").append(" FROM ").append(ratedTable.get()).append(", ").append(runsTable.get()).append(" WHERE ").append(runsTable.get()).append(".programme_id = ").append(l).append(beginTransaction).append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(l2).append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ");
        return stringBuffer.toString();
    }

    public static String countRatedCommented(long l, long l2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) ").append(" FROM ").append(ratedTable.get()).append(", ").append(commentsTable.get()).append(", ").append(runsTable.get()).append(" WHERE ").append(ratedTable.get()).append(".run_id = ").append(commentsTable.get()).append(".run_id ").append("\n AND ").append(commentsTable.get()).append(".user_id = ").append(ratedTable.get()).append(".user_id ").append("\n AND ").append(commentsTable.get()).append(".comment_flag = 0  ").append("\n AND ").append(runsTable.get()).append(".programme_id = ").append(l).append("\n AND ").append(ratedTable.get()).append(".user_id = ").append(l2).append("\n AND ").append(ratedTable.get()).append(".pr_flag  = ").append(n).append("\n AND ").append(ratedTable.get()).append(".run_id = ").append(runsTable.get()).append(".id ");
        return stringBuffer.toString();
    }

    public static String selAbstractFromRunId(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT abstract_text FROM ").append(runsTable.get()).append(", ").append(latexTable.get()).append(" WHERE ").append(latexTable.get()).append(".programme_id = ").append(runsTable.get()).append(".programme_id ").append("\n AND ").append(runsTable.get()).append(".id=").append(l);
        return stringBuffer.toString();
    }

    public static String wcAllWebLettersUsersTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(schedRepTable.get()).append(" ,").append(runsTable.get()).append(" ,").append(proposedTable.get()).append(" ,").append(programmesTable.get());
        return stringBuffer.toString();
    }

    public static String wcAllWebLettersUsers(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(proposedTable.get()).append(".pi_flag = 0 ").append(" AND  ").append(schedRepTable.get()).append(".period = ").append(n).append(" AND  ").append(schedRepTable.get()).append(".published = 1 ").append(" AND  ").append(schedRepTable.get()).append(".run_id =  ").append(runsTable.get()).append(".id ").append(" AND  ").append(programmesTable.get()).append(".id =  ").append(runsTable.get()).append(".programme_id ").append(" AND  ").append(programmesTable.get()).append(".id =  ").append(proposedTable.get()).append(".programme_id ").append(" AND  ").append(usersTable.get()).append(".id =  ").append(proposedTable.get()).append(".user_id ");
        return stringBuffer.toString();
    }

    public static String wcUserCycleTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(usersTable.get()).append(" ,").append(proposedTable.get()).append(" ,").append(programmesTable.get());
        return stringBuffer.toString();
    }

    public static String wcUserCycle(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(usersTable.get()).append(".id = ").append(n).append(" AND  ").append(usersTable.get()).append(".id =  ").append(proposedTable.get()).append(".user_id ").append(" AND  ").append(programmesTable.get()).append(".id =  ").append(proposedTable.get()).append(".programme_id ").append(" AND  ").append(programmesTable.get()).append(".cycle_id =  ").append(cyclesTable.get()).append(".id ").append(" AND  ").append(programmesTable.get()).append(".ignored =  0");
        return stringBuffer.toString();
    }

    public static String wcCycleFromLabel(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cyclesTable.get()).append(".label = '").append(string).append("'  AND ").append(cyclesTable.get()).append(".step_id = ").append(n);
        return stringBuffer.toString();
    }

    public static String wcCycleList(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cyclesTable.get()).append(".step_id = ").append(n);
        return stringBuffer.toString();
    }

    public static String insertWriterProposalLogEntry(long l, int n, String string, String string2) {
        long l2 = Calendar.getInstance().getTimeInMillis();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(propSummaryLogTable.getTable()).append("\n (summary_id, reference_obj, creation_date,  category,event_desc, originator )\n").append(" VALUES ( ").append(l).append(",1,").append(l2).append(",").append(n).append(",'").append(TextUtils.quoteSqlString(string)).append("','").append(string2).append("')");
        return stringBuffer.toString();
    }

    public static String wcRefereeDdt(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(refereesTable.get()).append(".user_id = ").append(l).append("\n AND ").append(esoUsersRolesTable.get()).append(".login = convert(varchar(32), ").append(refereesTable.get()).append(".user_id) ").append("\n AND ").append(esoUsersRolesTable.get()).append(".letters_role = 'refDdt' ").append("\n AND ").append(cyclesTable.get()).append(".step_id = 1 ");
        return stringBuffer.toString();
    }

    public static String wcRefereeDdtTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(esoUsersRolesTable.get());
        return stringBuffer.toString();
    }

    public static String wcUserRole(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(esoUsersRolesTable.get()).append(".login = convert(varchar(32), ").append(usersTable.get()).append(".id) ").append("\n AND ").append(esoUsersRolesTable.get()).append(".letters_role = '").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String wcUserRoleTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(esoUsersRolesTable.get());
        return stringBuffer.toString();
    }

    public static String updateProposalOutput(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(proposalOutputTable.get()).append(" set data = ").append(Phase1SelectStmt.getQuestionMark()).append(" WHERE programme_id = ").append(string);
        return stringBuffer.toString();
    }

    public static String deleteProposalOutput(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE ").append(proposalOutputTable.get()).append(" WHERE programme_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String insertProposalOutput(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(proposalOutputTable.get()).append(" (programme_id, format)").append(" VALUES (").append(string).append(" , '").append(string2).append("')\n ");
        stringBuffer.append(Phase1SelectStmt.updateProposalOutput(string, string2));
        return stringBuffer.toString();
    }

    public static String getProposalOut(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(proposalOutputTable.get()).append(".data FROM ").append(proposalOutputTable.get()).append(" WHERE ").append(proposalOutputTable.get()).append(".programme_id =  ").append(l);
        return stringBuffer.toString();
    }

    public static String getProposalOutFormat(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(proposalOutputTable.get()).append(".format FROM ").append(proposalOutputTable.get()).append(" WHERE ").append(proposalOutputTable.get()).append(".programme_id =  ").append(l);
        return stringBuffer.toString();
    }

    public static String countProposalOutEntry(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) ").append(" FROM ").append(proposalOutputTable.get()).append(" WHERE ").append(proposalOutputTable.get()).append(".programme_id =  ").append(l);
        return stringBuffer.toString();
    }

    public static String getNewUserId() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE unique_keys ").append("SET keyvalue = keyvalue + 1 ").append("WHERE keyname = 'ESOUSERS' \n").append("SELECT  keyvalue ").append("FROM unique_keys ").append("WHERE keyname = 'ESOUSERS' ");
        return stringBuffer.toString();
    }

    public static String insertRowPicture(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(figuresTable.getTable()).append("\n ( programme_id, file_name,postscript_text, received_flag )\n").append(" \nVALUES ( ").append(l).append(",'").append(TextUtils.quoteSqlString(string)).append("','',0)");
        return stringBuffer.toString();
    }

    public static String countPicture(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(figuresTable.getTable()).append(" WHERE ").append(" programme_id = ").append(l).append("\n AND file_name = '").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String selProposalSummaryCycle(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ").append(proposalSummaryTable.get()).append(".cycle_label ").append(" FROM ").append(proposalSummaryTable.get()).append(" WHERE ").append(proposalSummaryTable.get()).append(".id = ").append(l);
        return stringBuffer.toString();
    }

    public static String selProposalSummaryStatus(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  ").append(proposalSummaryTable.get()).append(".status ").append(" FROM ").append(proposalSummaryTable.get()).append(" WHERE ").append(proposalSummaryTable.get()).append(".id = ").append(l);
        return stringBuffer.toString();
    }

    public static String getLatexSourceCache(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(proposalSummaryTable.get()).append(".latex_source FROM ").append(proposalSummaryTable.get()).append(" WHERE ").append(proposalSummaryTable.get()).append(".id =  ").append(l);
        return stringBuffer.toString();
    }

    public static String getFigureBinaryInCache(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(figureSummaryTable.get()).append(".picture FROM ").append(figureSummaryTable.get()).append(" WHERE ").append(figureSummaryTable.get()).append(".summary_id =  ").append(l).append("\n AND ").append(figureSummaryTable.get()).append(".picture_name = '").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String wcRunsScheduledTables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ,").append(programmesTable.get());
        return stringBuffer.toString();
    }

    public static String wcRunsScheduled(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(runsTable.get()).append(".programme_id = ").append(programmesTable.get()).append(".id ").append(" \nAND ").append(runsTable.get()).append(".scheduled = 'S' ").append(" \nAND ").append(programmesTable.get()).append(".ignored = 0 ").append(" \nAND ").append(programmesTable.get()).append(".cycle_id = ").append(n);
        return stringBuffer.toString();
    }

    public static String countSchedRuns(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(schedRepTable.get()).append(" WHERE run_id = ").append(l);
        return stringBuffer.toString();
    }

    public static String getSchedRepId() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" opc_get_key 'SCHEDREP' ");
        return stringBuffer.toString();
    }

    public static String getProposalSummaryId() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" opc_get_key 'PROPOSAL_SUMMARY' ");
        return stringBuffer.toString();
    }

    public static String countReferee(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT count(*) FROM ").append(refereesTable.get()).append(" WHERE user_id = ").append(n);
        return stringBuffer.toString();
    }

    public static String countObsBlocks(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT count(*) FROM ").append(obsBlocksTable.get()).append(" WHERE user_id = ").append(n);
        return stringBuffer.toString();
    }

    public static String countSchedObsBlocks(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT count(*) FROM ").append(obsBlocksTable.get()).append(" WHERE prog_id = ").append(string);
        return stringBuffer.toString();
    }

    public static String selObsRunProgramme() {
        return null;
    }

    public static String selAllSchedModes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT distinct obs_mode FROM ").append(schedRepTable.get()).append(" WHERE period > 70 ");
        return stringBuffer.toString();
    }

    public static String getCountUser(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) FROM ").append(usersViewTable.get()).append(" WHERE ").append(usersViewTable.get()).append(".password = ").append("'").append(string).append("'").append("\n AND ").append(usersViewTable.get()).append(".login = ").append("'").append(n).append("'");
        return stringBuffer.toString();
    }

    public static String getRoles(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = TextUtils.arrayToString(stringArray, "', '", true);
        stringBuffer.append("SELECT DISTINCT letters_role FROM ").append(usersRolesTable.get()).append(" WHERE ").append(usersRolesTable.get()).append(".login in ('").append(string).append("') ");
        return stringBuffer.toString();
    }

    public static String getRoles(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT letters_role FROM ").append(usersRolesTable.get()).append(" WHERE ").append(usersRolesTable.get()).append(".login = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String deleteRole(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = TextUtils.arrayToString(stringArray, "', '", true);
        stringBuffer.append("DELETE ").append(usersRolesTable.get()).append(" WHERE ").append(usersRolesTable.get()).append(".login in ('").append(string2).append("')  ").append("\n AND ").append(usersRolesTable.get()).append(".letters_role = '").append(string).append("' ");
        return stringBuffer.toString();
    }

    public static String addRole(String[] stringArray, String string) {
        String string2 = TextUtils.arrayToString(stringArray, "', '", false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n DELETE FROM ").append(esoUsersRolesTable.get()).append(beginTransaction).append("\n WHERE ").append(esoUsersRolesTable.get()).append(".login in ( '").append(string2).append(" ') ").append("\n AND ").append(esoUsersRolesTable.get()).append(".letters_role = '").append(string).append("'");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("\n INSERT INTO ").append(esoUsersRolesTable.get()).append("(login, letters_role)").append(" VALUES ('").append(stringArray[n]).append("', '").append(string).append("')");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getTelescope(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(offeredTable.get()).append(".telescope_code FROM ").append(offeredTable.get()).append(" WHERE ").append(offeredTable.get()).append(".cycle_id =  ").append(l).append(" AND ").append(offeredTable.get()).append(".instrument_code =  '").append(string).append("'");
        return stringBuffer.toString();
    }

    public static String countReceivedFigures(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select count(*) from ").append(figuresTable.get()).append(" WHERE file_name = '").append(string).append("'").append(" AND programme_id = ").append(l).append("\n\n");
        return stringBuffer.toString();
    }
}

