/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ConnectionPool;
import org.eso.ohs.core.utilities.Convert;
import org.eso.ohs.core.utilities.FileIOUtils;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.SqlUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dfs.FindingChart;
import org.eso.ohs.dfs.ObservationBlock;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;

public class FindingChartsDBIO {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase2$FindingChartsDBIO == null ? (class$org$eso$ohs$dbase$phase2$FindingChartsDBIO = FindingChartsDBIO.class$("org.eso.ohs.dbase.phase2.FindingChartsDBIO")) : class$org$eso$ohs$dbase$phase2$FindingChartsDBIO));
    private static String obrepDbName = Config.getCfg().getDbName(ObservationBlock.getSuffix());
    private static String opcDB_ = Config.getCfg().getDbName(ObservingRun.getSuffix());
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase2$FindingChartsDBIO;

    public static FindingChart[] read(Connection connection, long l, boolean bl) throws ObjectIOException, SQLException, IOException, ObjectNotFoundException {
        Serializable serializable;
        Statement statement = connection.createStatement();
        int n = 2000000;
        statement.execute("set TEXTSIZE " + n);
        String string = "SELECT " + obrepDbName + "..finds.fc_id from " + obrepDbName + "..finds where " + obrepDbName + "..finds.ob_id = ?";
        stdlog_.debug((Object)string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Integer> vector = new Vector<Integer>();
        while (resultSet.next()) {
            serializable = new Integer(resultSet.getInt(1));
            if (vector.contains(serializable)) continue;
            vector.addElement((Integer)serializable);
        }
        string = !bl ? "SELECT " + obrepDbName + "..finding_charts.fc_name," + obrepDbName + "..finding_charts.fc_notes," + obrepDbName + "..finding_charts.fc_checksum from " + obrepDbName + "..finding_charts where " + obrepDbName + "..finding_charts.fc_id = ?" : "SELECT * from " + obrepDbName + "..finding_charts where " + obrepDbName + "..finding_charts.fc_id  = ?";
        stdlog_.debug((Object)string);
        preparedStatement = connection.prepareStatement(string);
        serializable = new Vector();
        int n2 = 0;
        while (n2 < vector.size()) {
            int n3 = (Integer)vector.elementAt(n2);
            preparedStatement.setInt(1, n3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                FindingChart findingChart = new FindingChart();
                findingChart.setFcName(resultSet.getString("fc_name").trim());
                String string2 = resultSet.getString("fc_notes");
                if (string2 != null) {
                    findingChart.setFcNotes(string2.trim());
                } else {
                    findingChart.setFcNotes("");
                }
                findingChart.setCheckSum(resultSet.getLong("fc_checksum"));
                if (bl) {
                    InputStream inputStream = resultSet.getBinaryStream("fc_data");
                    findingChart.setFcData(FileIOUtils.convertInputStreamToBinary(inputStream));
                }
                ((Vector)serializable).addElement(findingChart);
            }
            resultSet.close();
            ++n2;
        }
        Object[] objectArray = new FindingChart[((Vector)serializable).size()];
        ((Vector)serializable).copyInto(objectArray);
        return objectArray;
    }

    public static void write(Connection connection, long l, long l2, FindingChart[] findingChartArray) throws SQLException, ObjectIOException {
        String string = FindingChartsDBIO.getObservatory(connection, l2);
        int n = 0;
        while (n < findingChartArray.length) {
            Object object;
            long l3 = findingChartArray[n].getCheckSum();
            boolean bl = false;
            String string2 = "SELECT fc_id,fc_name,fc_checksum,run_id FROM finding_charts where fc_checksum = " + l3 + " AND finding_charts.run_id = " + l2;
            stdlog_.debug((Object)string2);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            long l4 = -1L;
            long l5 = -1L;
            String string3 = null;
            long l6 = -1L;
            while (resultSet.next()) {
                bl = true;
                l4 = resultSet.getInt("fc_id");
                l5 = resultSet.getInt("run_id");
                string3 = resultSet.getString("fc_name").trim();
                l6 = resultSet.getLong("fc_checksum");
            }
            resultSet.close();
            statement.close();
            if (bl) {
                if (!findingChartArray[n].getFcName().trim().equals(string3.trim()) && findingChartArray[n].getCheckSum() == l6) {
                    Vector vector = FindingChartsDBIO.getOBIds(connection, l4);
                    if (vector.size() > 0) {
                        object = FindingChartsDBIO.sameContentsMessage(n, string3, vector);
                        throw new SQLException(((StringBuffer)object).toString());
                    }
                    if (FindingChartsDBIO.findingChartNameExists(connection, findingChartArray[n].getFcName(), l2)) {
                        object = FindingChartsDBIO.sameNameMessage(findingChartArray[n].getFcName());
                        throw new SQLException(((StringBuffer)object).toString());
                    }
                    FindingChartsDBIO.updateFindingChartName(connection, l4, findingChartArray[n].getFcName());
                }
                FindingChartsDBIO.updateFinds(connection, l, l4, string);
            } else {
                Object object2;
                string2 = "SELECT fc_id,fc_name,fc_checksum,run_id FROM finding_charts where fc_name = " + SqlUtils.sqlEscapedString(findingChartArray[n].getFcName()) + " AND finding_charts.run_id = " + l2;
                stdlog_.debug((Object)string2);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
                boolean bl2 = false;
                l4 = -1L;
                string3 = null;
                l6 = -1L;
                l5 = -1L;
                while (resultSet.next()) {
                    bl2 = true;
                    l4 = resultSet.getInt("fc_id");
                    string3 = resultSet.getString("fc_name").trim();
                    l6 = resultSet.getLong("fc_checksum");
                    l5 = resultSet.getLong("run_id");
                }
                resultSet.close();
                statement.close();
                if (bl2) {
                    if (findingChartArray[n].getFcName().trim().equals(string3) && findingChartArray[n].getCheckSum() != l6) {
                        object = FindingChartsDBIO.getOBIds(connection, l4);
                        if (((Vector)object).size() > 0) {
                            object2 = FindingChartsDBIO.messageSameName(string3, (Vector)object);
                            throw new SQLException(((StringBuffer)object2).toString());
                        }
                        FindingChartsDBIO.updateFindingChartContents(connection, l4, findingChartArray[n]);
                    }
                    FindingChartsDBIO.updateFinds(connection, l, l4, string);
                } else {
                    object = findingChartArray[n].getFcData();
                    object2 = new ByteArrayInputStream((byte[])object);
                    l4 = DbaseIOHandler.getDbId();
                    string2 = "INSERT INTO finding_charts (fc_id,run_id,fc_name,fc_type,fc_checksum,fc_data,observatory,last_mod_date) VALUES (?,?,?,?,?,?,?,?)";
                    stdlog_.debug((Object)string2);
                    PreparedStatement preparedStatement = connection.prepareStatement(string2);
                    preparedStatement.setLong(1, l4);
                    preparedStatement.setLong(2, l2);
                    preparedStatement.setString(3, findingChartArray[n].getFcName());
                    preparedStatement.setString(4, findingChartArray[n].getFcType());
                    preparedStatement.setLong(5, l3);
                    preparedStatement.setBinaryStream(6, (InputStream)object2, ((ByteArrayInputStream)object2).available());
                    preparedStatement.setString(7, string);
                    preparedStatement.setLong(8, Convert.getCurrentTime());
                    preparedStatement.execute();
                    preparedStatement.close();
                    FindingChartsDBIO.updateFinds(connection, l, l4, string);
                }
            }
            ++n;
        }
    }

    public static String getObservatory(Connection connection, long l) throws SQLException {
        String string = "SELECT observatory from " + opcDB_ + "..opc_telescopes opc_telescopes, " + opcDB_ + "..sched_rep sched_rep " + " where sched_rep.run_id = " + l + " AND sched_rep.tel = opc_telescopes.code";
        stdlog_.debug((Object)string);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        String string2 = null;
        while (resultSet.next()) {
            string2 = resultSet.getString("observatory");
        }
        resultSet.close();
        statement.close();
        return string2;
    }

    public static StringBuffer messageSameName(String string, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("You have already checked in a finding chart\n");
        stringBuffer.append("which has the same name but different contents");
        stringBuffer.append("(" + string);
        stringBuffer.append(")\n");
        stringBuffer.append("If you wish to checkin your ob choose one of the following options\n");
        stringBuffer.append("1. Rename the finiding chart to a different name than (" + string + ")\n");
        stringBuffer.append("2. Checkout all of the OB's that are using this finding chart\n");
        stringBuffer.append("   Attach the new finding chart and checkin. See list below\n");
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append(vector.elementAt(n).toString() + "\n");
            ++n;
        }
        return stringBuffer;
    }

    private static StringBuffer sameContentsMessage(int n, String string, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("You have already checked in a finding chart\n");
        stringBuffer.append("which has a different name but the same contents");
        stringBuffer.append("(" + string);
        stringBuffer.append(")\n");
        stringBuffer.append("If you wish to checkin your ob choose one of the following options\n");
        stringBuffer.append("1. Change the finding chart contents\n");
        stringBuffer.append("2. Re-attach the orignal finding chart (" + string + ")\n");
        stringBuffer.append("3. Checkout all of the OB's that are using this finding chart\n");
        stringBuffer.append("   Attach the new finding chart and checkin. See list below :\n");
        int n2 = 0;
        while (n2 < vector.size()) {
            if (n == 0) {
                stringBuffer.append("   ");
            }
            stringBuffer.append(vector.elementAt(n2).toString() + "\n");
            ++n2;
        }
        return stringBuffer;
    }

    private static StringBuffer sameNameMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("You have already checked in a finding chart\n");
        stringBuffer.append("which has the same name");
        stringBuffer.append("(" + string);
        stringBuffer.append(") but different contents\n");
        return stringBuffer;
    }

    private static StringBuffer sameChecksumMessage(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("You have already checked in a finding chart\n");
        stringBuffer.append("which has the same checksum");
        stringBuffer.append("(" + l);
        stringBuffer.append(")\n");
        return stringBuffer;
    }

    public static void updateFinds(Connection connection, long l, long l2, String string) throws SQLException {
        String string2 = "INSERT INTO finds (fc_id,ob_id,observatory) VALUES (?,?,?)";
        stdlog_.debug((Object)string2);
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setLong(1, l2);
        preparedStatement.setLong(2, l);
        preparedStatement.setString(3, string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public static void updateFindingChartContents(Connection connection, long l, FindingChart findingChart) throws ObjectIOException, SQLException {
        String string = "UPDATE finding_charts set fc_data = ?,fc_checksum = ?,last_mod_date = ? where fc_id = ?";
        stdlog_.debug((Object)string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(findingChart.getFcData());
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byteArrayInputStream.available());
        preparedStatement.setLong(2, findingChart.getCheckSum());
        preparedStatement.setLong(3, Convert.getCurrentTime());
        preparedStatement.setLong(4, l);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public static void updateFindingChartName(Connection connection, long l, String string) throws ObjectIOException, SQLException {
        String string2 = "UPDATE finding_charts set fc_name =  ?,last_mod_date = ? where fc_id  = ?";
        stdlog_.debug((Object)string2);
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setString(1, string);
        preparedStatement.setLong(2, Convert.getCurrentTime());
        preparedStatement.setLong(3, l);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public static void updateFindingChartNotes(long l, String string) throws ObjectIOException {
        SQLException sQLException;
        Connection connection;
        block7: {
            Config config = Config.getCfg();
            String string2 = "UPDATE " + obrepDbName + "..finding_charts" + " set " + obrepDbName + "..finding_charts.fc_notes = ?" + " where " + obrepDbName + "..finding_charts.fc_checksum = ?";
            connection = null;
            Statement statement = null;
            sQLException = null;
            stdlog_.debug((Object)("FC ID " + l));
            stdlog_.debug((Object)("Notes " + string));
            try {
                connection = ConnectionPool.getPool().acquireConnection(config.getUrl(ObservationBlock.getSuffix()), config.getDbUserName(), config.getDbPassword());
                stdlog_.debug((Object)string2);
                statement = connection.prepareStatement(string2);
                statement.setString(1, string);
                statement.setLong(2, l);
                statement.executeUpdate();
                statement.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException3) {
                    if (sQLException3 != null) break block7;
                    sQLException = sQLException3;
                }
            }
        }
        if (connection != null) {
            ConnectionPool.getPool().releaseConnection(connection);
        }
        if (sQLException != null) {
            throw new ObjectIOException(sQLException);
        }
    }

    private static Vector getOBIds(Connection connection, long l) throws SQLException {
        String string = "SELECT DISTINCT ob_id from finds where fc_id = " + l;
        stdlog_.debug((Object)("Get OB Ids Text " + string));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        Vector<Integer> vector = new Vector<Integer>();
        while (resultSet.next()) {
            int n = resultSet.getInt("ob_id");
            if (vector.contains(new Integer(n))) continue;
            vector.addElement(new Integer(n));
        }
        return vector;
    }

    private static boolean findingChartNameExists(Connection connection, String string, long l) throws SQLException {
        String string2 = "SELECT fc_name from finding_charts,finds where fc_name = " + SqlUtils.sqlEscapedString(string) + " AND finding_charts.fc_id = finds.fc_id" + " AND finding_charts.run_id = " + l;
        stdlog_.debug((Object)("Finding Chart Name Exists " + string2));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        boolean bl = false;
        while (resultSet.next()) {
            bl = true;
        }
        return bl;
    }

    private static boolean findingChartContentsExists(Connection connection, long l) throws SQLException {
        String string = "SELECT fc_checksum from finding_charts,finds where fc_checksum = " + l + " AND finding_charts.fc_id = finds.fc_id";
        stdlog_.debug((Object)("Finding Chart Contents Exists " + string));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        boolean bl = false;
        while (resultSet.next()) {
            bl = true;
        }
        return bl;
    }

    public static void delete(Statement statement, long l) throws SQLException {
        String string = "delete from finds where ob_id = " + l;
        stdlog_.debug((Object)string);
        statement.executeUpdate(string);
    }

    public static void update(Connection connection, long l, long l2, FindingChart[] findingChartArray) throws SQLException, ObjectIOException {
        Statement statement = connection.createStatement();
        FindingChartsDBIO.delete(statement, l);
        FindingChartsDBIO.write(connection, l, l2, findingChartArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

