/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dfs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.AssocList;
import org.eso.ohs.core.utilities.PafFile;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.dfs.ObservationDescription;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.instruments.Parameter;
import org.eso.ohs.instruments.TemplateSignature;

public class CalibrationBlock
extends BusinessObject {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dfs$CalibrationBlock == null ? (class$org$eso$ohs$dfs$CalibrationBlock = CalibrationBlock.class$("org.eso.ohs.dfs.CalibrationBlock")) : class$org$eso$ohs$dfs$CalibrationBlock));
    private String instrumentComments;
    public static final String[] QC_GRADE_VALUES = new String[]{"A", "B", "C", "D", "X"};
    public static final String PARTIALLY_DEFINED = "P";
    public static final String DEFINED = "D";
    public static final String ACCEPTED = "+";
    public static final String REJECTED = "-";
    public static final String QUEUED = "Q";
    public static final String INITIATED = "I";
    public static final String STARTED = "S";
    public static final String EXECUTED = "X";
    public static final String ABORTED = "A";
    public static final String CANCELED = "K";
    public static final String VERIFIED = "V";
    public static final String COMPLETED = "C";
    public static final String RELEASED = "R";
    public static final String ALARM = "!";
    public static final String MUST_REPEAT = "M";
    public static final String PAUSED = "p";
    public static final int MIN_FLAMES_EXECTIME = 1200;
    public static final String CALBLK_TYPE = "C";
    private boolean execTimeUpToDate = true;
    public static final String OBSBLK_TYPE = "O";
    private transient PropertyChangeEvent execTmeEvent = new PropertyChangeEvent(this, "ExecutionTime", null, null);
    private static final AssocList statusValues_ = new AssocList().add("(P)artiallyDefined", "P").add("(D)efined", "D").add("(-)Rejected", "-").add("(+)Accepted", "+").add("(Q)ueued", "Q").add("(I)nitiated", "I").add("(S)tarted", "S").add("(p)aused", "p").add("(A)borted", "A").add("e(X)ecuted", "X").add("(M)ustRepeat", "M").add("(V)erified", "V").add("(!)Alarm", "!").add("(C)ompleted", "C").add("(R)eleased", "R").add("(K)anceled", "K");
    public static final AssocList bobStatusValues = new AssocList().add("VERIFYFAIL", "A").add("STARTED", "S").add("PAUSED", "p").add("CONTINUED", "S").add("ABORTED", "A").add("MUSTREPEAT", "M").add("TERMINATED", "X");
    static final long serialVersionUID = 3976534496581525077L;
    private transient ObservingRun obsRun_;
    private String obsComments_ = "";
    private transient ObservationDescription obsDesc_;
    private boolean standard_ = false;
    private String status_ = "P";
    public static final String EDITED_BY_USG = "E";
    private String userComments_ = "";
    private int userPriority_ = 1;
    private int executionTime_;
    private int copied_rank_;
    private String copied_obsMode_;
    protected transient PropertyChangeListener eventRedirector_ = new BusinessObject.EventForwarder(this);
    public static int FLAMES_SETUP = 60;
    private int execTime_;
    private int expTime_;
    private PropertyChangeEvent execTimeEvent;
    public static final String[] markLabels = new String[]{"(P)artially defined", "(D)efined, after phase II", "(-)Rejected, OB verification failed", "(+)Accepted OB verified", "(Q)ueued for scheduling", "(I)nitiated, passed on to VCS", "(S)tarted ,after VCS stated execution", "(P)aused ,during execution", "(A)borted", "e(X)ecuted ,all exposures taken", "(M)ust repeat", "(V)erified, Passed Quality Control", "(!)Alarm, QC not passed", "(C)ompleted,passed quality control", "(R)eleased,data was distributed", "(K)ancelled"};
    static /* synthetic */ Class class$org$eso$ohs$dfs$CalibrationBlock;

    public static AssocList getStatusValues() {
        return statusValues_;
    }

    public static String getStatusCode(int n) {
        return statusValues_.getValueFromIndex(n);
    }

    public static String getStatusCodeShortDescription(String string) {
        return statusValues_.getKeyFromObjectAsString(string);
    }

    public static String getLongStatusValue(String string) {
        return statusValues_.getKeyFromObjectAsString(string);
    }

    CalibrationBlock() {
    }

    public void convertIPVersion(float f) {
        this.obsDesc_.convertIPVersion(f);
    }

    public void refreshTemplates(boolean bl) throws IOException {
        this.refreshTemplates(bl, false);
    }

    public void refreshTemplates(boolean bl, boolean bl2) throws IOException {
        this.obsDesc_.refreshTemplates(bl, bl2);
        if (bl) {
            this.firePropertyChangeEvent();
        }
    }

    public float fetchIPVersionFromOd() {
        float f = -1.0f;
        if (this.getOd() != null) {
            f = this.getOd().getIPVersion();
        }
        return f;
    }

    public void putIPVersionToOd(float f) {
        if (this.getOd() != null) {
            this.getOd().setIPVersion(f);
        }
    }

    public String getType() {
        return "C";
    }

    public void setType(String string) {
    }

    public void setObsRun(ObservingRun observingRun) {
        if (observingRun == null) {
            throw new IllegalArgumentException("ObservingRun cannot be null");
        }
        this.obsRun_ = observingRun;
        this.firePropertyChangeEvent();
    }

    public ObservingRun getObsRun() {
        return this.obsRun_;
    }

    public void setObsComments(String string) {
        this.obsComments_ = string;
        this.firePropertyChangeEvent();
    }

    public String getObsComments() {
        if (this.obsComments_ == null) {
            return "";
        }
        return this.obsComments_;
    }

    public void setOd(ObservationDescription observationDescription) {
        if (this.obsDesc_ != null) {
            this.obsDesc_.removePropertyChangeListener(this.eventRedirector_);
        }
        this.obsDesc_ = observationDescription;
        if (this.obsDesc_ != null) {
            this.obsDesc_.addPropertyChangeListener(this.eventRedirector_);
        }
        this.firePropertyChangeEvent();
    }

    public ObservationDescription getOd() {
        return this.obsDesc_;
    }

    public void setStandard(boolean bl) {
        this.standard_ = bl;
        this.firePropertyChangeEvent();
    }

    public boolean getStandard() {
        return this.standard_;
    }

    public void setStatus(String string) {
        this.status_ = string;
        this.firePropertyChangeEvent();
    }

    public String getStatus() {
        if (this.status_ == null) {
            return "";
        }
        return this.status_;
    }

    public void setUserComments(String string) {
        this.userComments_ = string;
        this.firePropertyChangeEvent();
    }

    public String getUserComments() {
        if (this.userComments_ == null) {
            return "";
        }
        return this.userComments_;
    }

    public void setUserPriority(int n) {
        this.userPriority_ = n;
        this.firePropertyChangeEvent();
    }

    public int getUserPriority() {
        return this.userPriority_;
    }

    public TemplateSignature firstTS() {
        TemplateSignature[] templateSignatureArray = this.getOd().getSignatures();
        if (templateSignatureArray != null && templateSignatureArray.length > 0) {
            return templateSignatureArray[0];
        }
        return null;
    }

    public void setExecutionTime(int n) {
        stdlog_.debug((Object)(">>>>>>>!!!!!!!!!!!! Calling Execution Time" + n));
        this.executionTime_ = n;
        if (this.execTimeEvent == null) {
            this.execTmeEvent = new PropertyChangeEvent(this, "ExecutionTime", null, null);
        }
        this.firePropertyChangeEvent(this.execTmeEvent);
    }

    public int getExecutionTime() {
        if (this.executionTime_ < 0 || this.executionTime_ > 86399) {
            this.executionTime_ = -86399;
        }
        return this.executionTime_;
    }

    public void setExposureTime(int n) {
        stdlog_.debug((Object)("!!!!!!!!!!!!!!! Exposure Time " + n));
        this.expTime_ = n;
    }

    public int getExposureTime() {
        if (this.expTime_ < 0 || this.expTime_ > 86399) {
            this.expTime_ = -86399;
        }
        return this.expTime_;
    }

    public String toOBD(boolean bl, boolean bl2, long l, String string) {
        String string2 = null;
        string2 = bl ? this.getOBDHeader(string) + this.getOBDBody(l) : this.getOBDBody(l);
        string2 = string2 + "\n";
        string2 = string2 + "\n";
        if (this.getOd() != null) {
            TemplateSignature[] templateSignatureArray = this.getOd().getSignatures();
            int n = 0;
            while (n < templateSignatureArray.length) {
                string2 = string2 + this.toParameterFormat(templateSignatureArray[n], n + 2, bl2);
                ++n;
            }
        }
        return string2;
    }

    public String toOBD(boolean bl, long l, String string) throws IOException {
        return this.toOBD(bl, false, l, string);
    }

    protected String getOBDTemplateHeader(TemplateSignature templateSignature, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = templateSignature.getMode() == null ? "" : templateSignature.getMode();
        stringBuffer.append("# " + templateSignature.getTemplateType() + " template " + templateSignature.getTemplateName());
        stringBuffer.append("\n");
        stringBuffer.append("TPL.ID    \"" + templateSignature.getTemplateName() + "\"");
        stringBuffer.append("\n");
        stringBuffer.append("TPL.NAME  \"" + templateSignature.getTemplateDesc() + "\"");
        stringBuffer.append("\n");
        stringBuffer.append("TPL.MODE \"" + string + "\"");
        stringBuffer.append("\n");
        stringBuffer.append("TPL.SEQNO \"" + n + "\"");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getVIMOSADMParameterValue(Parameter parameter, boolean bl, String string) {
        String string2 = parameter.getValue();
        if (!string2.equals("NODEFAULT")) {
            try {
                PafFile pafFile = new PafFile(new StringReader(string2));
                pafFile.setKeywordValue("PAF.NAME", string + "-101-" + CalibrationBlock.getKeywordIndex(parameter.getParameterName()) + ".adm");
                if (!bl) {
                    return parameter.toOBDParameterString(pafFile.toFileString());
                }
                return parameter.toDisplayOBDParameterString(pafFile.toFileString());
            }
            catch (IOException iOException) {
                stdlog_.debug((Object)"This is not a paf file");
            }
        }
        return string2;
    }

    private static int getKeywordIndex(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < string.length()) {
            if (Character.isDigit(string.charAt(n4))) {
                n2 = n4;
            }
            ++n4;
        }
        String string2 = string.substring(n2, n2 + 1);
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public String toParameterFormat(TemplateSignature templateSignature, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getOBDTemplateHeader(templateSignature, n));
        Parameter[] parameterArray = templateSignature.getParamList();
        String string = TextUtils.currentISODateTime();
        int n2 = 0;
        while (n2 < parameterArray.length) {
            if (!parameterArray[n2].isFixed()) {
                if (parameterArray[n2].getParameterName().indexOf("INS.ADM") != -1 && this.getOd().getInstrument().equals("VIMOS")) {
                    stringBuffer.append(this.getVIMOSADMParameterValue(parameterArray[n2], bl, string));
                } else if (bl) {
                    stringBuffer.append(parameterArray[n2].toDisplayOBDParameterString());
                } else {
                    stringBuffer.append(parameterArray[n2].toOBDParameterString());
                }
            }
            ++n2;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected String getOBDHeader(String string) {
        String string2 = this.getName().replace(' ', '-').replace('\t', '-');
        String string3 = TextUtils.currentISODateTime();
        String string4 = "PAF.HDR.START;                             # Marks start of header\nPAF.TYPE           \"OB Description\"; # Type of param file\nPAF.ID             \"\"\nPAF.NAME           \"\"\nPAF.DESC           \"\"\nPAF.CRTE.NAME      \"" + string + "\";  # Creator" + "\nPAF.CRTE.DAYTIM    \"" + string3 + "\";      # Creation date" + "\nPAF.LCHG.NAME      \"\";                   # Who did last change" + "\nPAF.LCHG.DAYTIM    \"" + string3 + "\";      # Time of last change" + "\nPAF.CHCK.NAME      \"\";                   # Applic checking file" + "\nPAF.CHCK.DAYTIM    \"\";                   # Date of last check" + "\nPAF.CHCK.CHECKSUM  \"\";                   # Param file checksum" + "\nPAF.HDR.END" + "\n" + "\n";
        return string4;
    }

    protected String getOBDBody(long l) {
        String string = this.getName().replace(' ', '-').replace('\t', '-');
        String string2 = new Date().toString();
        String string3 = "# Observation Block description follows\n";
        string3 = string3 + "\n";
        string3 = string3 + "\nOBS.ID\t\"" + l + "\"\t# Observation block Id";
        string3 = string3 + "\nOBS.NAME\t\"" + string + "\"\t# Observation block Name";
        ObservingRun observingRun = this.getObsRun();
        String string4 = observingRun.getName();
        int n = string4.indexOf(47);
        if (n >= 0) {
            string4 = string4.substring(0, n);
        }
        string3 = string3 + "\nOBS.GRP\t      \"0\"\t\t# Unused";
        string3 = string3 + "\nOBS.PROG.ID    \"" + string4 + "\"";
        string3 = string3 + "\nOBS.PI-COI.ID  \"" + this.getOwnerId() + "\"";
        string3 = string3 + "\nOBS.PI-COI.NAME  \"UNKNOWN\"";
        string3 = string3 + "\nOBS.EXECTIME  \"" + this.getExecutionTime() + "\"";
        string3 = string3 + "\nOBS.OBSERVER  \"UNKNOWN\"";
        return string3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.eventRedirector_ = new BusinessObject.EventForwarder(this);
        objectInputStream.defaultReadObject();
    }

    public String verify() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.verify());
        if (this.getOd() == null) {
            stringBuffer.append("You have not defined an Observation Description.\n");
        } else {
            stringBuffer.append(this.getOd().verify());
        }
        return stringBuffer.toString();
    }

    public boolean verifyCheck() {
        String string = this.verify();
        return string.equals("");
    }

    public String verifyBO() {
        return super.verify();
    }

    public String[][] getResources() {
        return new String[0][];
    }

    public static String convertBobEventToStatus(String string) {
        String string2 = (String)bobStatusValues.valueFor(string);
        return string2 != null ? string2 : "?";
    }

    public static String getDisplayName() {
        return "CalBlock";
    }

    public static String getSuffix() {
        return "cb";
    }

    public BusinessObject[] getBusObjChildren() {
        BusinessObject[] businessObjectArray;
        if (this.getOd() != null) {
            BusinessObject[] businessObjectArray2 = new BusinessObject[1];
            businessObjectArray = businessObjectArray2;
            businessObjectArray2[0] = this.getOd();
        } else {
            businessObjectArray = new BusinessObject[]{};
        }
        return businessObjectArray;
    }

    public BusinessObject deepCopy() {
        CalibrationBlock calibrationBlock = null;
        ObservationDescription observationDescription = null;
        calibrationBlock = (CalibrationBlock)this.copy();
        if (this.getOd() != null) {
            observationDescription = (ObservationDescription)this.getOd().deepCopy();
            calibrationBlock.setOd(observationDescription);
        }
        return calibrationBlock;
    }

    public BusinessObject copy() {
        CalibrationBlock calibrationBlock = (CalibrationBlock)super.copy();
        calibrationBlock.eventRedirector_ = new BusinessObject.EventForwarder(calibrationBlock);
        calibrationBlock.setStatus(PARTIALLY_DEFINED);
        return calibrationBlock;
    }

    public boolean isFlames() {
        return this.getOd().getInstrument().equals("FLAMES");
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return businessVisitor.visit(this, object);
    }

    public String toReport(long l) {
        int n;
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        if (l != 0L) {
            stringBuffer.append(this.getName() + " (OB Id=" + l + ") ");
        } else {
            stringBuffer.append(this.getName());
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.getObsRun().getName() + "\n");
        String string = this.getUserComments();
        if (string != null && string.length() > 0) {
            stringBuffer.append("User Com. : ");
            objectArray = TextUtils.splitString(string, 60);
            n = 0;
            while (n < objectArray.length) {
                if (n != 0) {
                    stringBuffer.append("            ");
                }
                stringBuffer.append((String)objectArray[n] + "\n");
                ++n;
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("ObsDesc: " + this.obsDesc_.getName() + "\n");
        objectArray = this.obsDesc_.getSignatures();
        n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(((TemplateSignature)objectArray[n]).toReportString());
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("\n=====================================================\n");
        return stringBuffer.toString();
    }

    public boolean isExecTimeUpToDate() {
        return this.execTimeUpToDate;
    }

    public void setExecTimeUpToDate(boolean bl) {
        this.execTimeUpToDate = bl;
        this.firePropertyChangeEvent();
    }

    public void postProecess() {
    }

    public void setInstrumentComments(String string) {
        this.instrumentComments = string;
        this.firePropertyChangeEvent();
    }

    public String getInstrumentComments() {
        if (this.instrumentComments == null) {
            return "";
        }
        return this.instrumentComments;
    }

    public boolean equals(CalibrationBlock calibrationBlock) {
        if (this.getInstrumentComments().compareTo(calibrationBlock.getInstrumentComments()) != 0) {
            return false;
        }
        if (this.getObsComments().compareTo(calibrationBlock.getObsComments()) != 0) {
            return false;
        }
        if (this.getUserComments().compareTo(calibrationBlock.getUserComments()) != 0) {
            return false;
        }
        if (this.getUserPriority() != calibrationBlock.getUserPriority()) {
            return false;
        }
        if (this.getStatus().compareTo(calibrationBlock.getStatus()) != 0) {
            return false;
        }
        return this.getOd().equals(calibrationBlock.getOd());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class StatusValue
    implements Serializable {
        static final long serialVersionUID = 6564143740396077923L;
        public final String internal;
        public final String displayed;

        public StatusValue(String string, String string2) {
            this.internal = string2;
            this.displayed = string;
        }

        public StatusValue(String string, String string2, String string3) {
            this.internal = string2;
            this.displayed = string3;
        }
    }
}

