/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ExtFileList;
import org.eso.ohs.core.utilities.PafData;
import org.eso.ohs.core.utilities.PafFile;
import org.eso.ohs.instruments.InstrumentConstraintConfig;
import org.eso.ohs.instruments.InstrumentList;
import org.eso.ohs.instruments.TemplateSignatureFactory;
import org.eso.ohs.instruments.TemplateSignatureMetaData;
import org.eso.ohs.instruments.TemplateSignatureSummary;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import org.xml.sax.InputSource;

public class Instrument {
    private static final String rcsid = "$Id: Instrument.java,v 1.49 2005/01/12 09:41:59 tcanavan Exp $";
    private static final String[] mandatoryInstrumentValues = new String[]{"PAF.TYPE", "PAF.NAME"};
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$Instrument == null ? (class$org$eso$ohs$instruments$Instrument = Instrument.class$("org.eso.ohs.instruments.Instrument")) : class$org$eso$ohs$instruments$Instrument));
    public static final String[] instrumentTypes = new String[]{"science", "calib", "test"};
    protected PafFile pafFile_;
    private int numRecords;
    private String instrumentFile_;
    private long lastModified_;
    private String instrumentName_;
    private String version_;
    private float versionNumber_ = -1.0f;
    private String telescopeName_;
    private String tsfDirectory_;
    private String[] modes_ = null;
    private String[] templateNames_ = null;
    private TemplateSignatureSummary[] templateSummaryList_ = new TemplateSignatureSummary[0];
    private PafData[] instrumentData_;
    private String fileType_;
    private Hashtable instrumentValues_;
    private String[] pafLinesMissing_;
    private boolean indexOutOfDate_ = false;
    private String labelInstComment;
    private boolean instComments = false;
    private String[] tmplErrList_ = new String[0];
    private Vector mandatoryKeywordsMissing_ = new Vector();
    private Vector mandatoryValuesMissing_ = new Vector();
    private String compileErrorMsg_;
    private InstrumentConstraintConfig[] csConfList;
    private InstrumentConstraintConfig[] readmeConfList;
    static /* synthetic */ Class class$org$eso$ohs$instruments$Instrument;

    public Instrument(String string) throws IOException, IllegalArgumentException {
        this(string, string + File.separator + "default.isf");
    }

    public Instrument(String string, String string2) throws IOException, IllegalArgumentException {
        this.instrumentFile_ = string2;
        this.tsfDirectory_ = string;
        this.init();
    }

    private void init() throws IOException, IllegalArgumentException {
        this.lastModified_ = new File(this.instrumentFile_).lastModified();
        this.pafFile_ = new PafFile(this.instrumentFile_);
        this.instrumentValues_ = new Hashtable();
        this.compileErrorMsg_ = this.pafFile_.getCompileErrorMsg();
        if (this.compileErrorMsg_ != null && this.compileErrorMsg_.length() > 0) {
            return;
        }
        this.pafLinesMissing_ = this.pafFile_.getPafLinesMissing();
        if (this.pafLinesMissing_ != null && this.pafLinesMissing_.length > 0) {
            return;
        }
        this.instrumentName_ = this.pafFile_.getPafName();
        this.fileType_ = this.pafFile_.getPafType();
        this.setValuesFromIdentifierList();
        File file = new File(this.tsfDirectory_);
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException("No Such Directory " + this.tsfDirectory_);
        }
        if (!file.canRead()) {
            throw new IOException("No read access righs to directory " + this.tsfDirectory_);
        }
        this.initConstraintMetaData();
        this.initReadmeMetaData();
        this.initCommentsMetaFile();
    }

    public boolean hasReadmeData() {
        return this.readmeConfList != null;
    }

    private void initReadmeMetaData() throws IOException {
        File file = this.initReadmeMetaFile();
        stdlog_.debug((Object)file.getAbsolutePath());
        stdlog_.debug((Object)file.exists());
        if (!file.exists()) {
            return;
        }
        stdlog_.debug((Object)"");
        this.readmeConfList = this.initMetaData(file, "Readme");
    }

    private void initConstraintMetaData() throws IOException {
        File file = this.initConstraintMetaFile();
        this.csConfList = this.initMetaData(file, "Constraints");
    }

    private InstrumentConstraintConfig[] initMetaData(File file, String string) throws IOException {
        SimpleType simpleType;
        SchemaReader schemaReader = new SchemaReader(new InputSource(file.getAbsolutePath()));
        Schema schema = schemaReader.read();
        ElementDecl elementDecl = schema.getElementDecl(string);
        Enumeration enumeration = schema.getSimpleTypes();
        HashMap<String, SimpleType> hashMap = new HashMap<String, SimpleType>();
        while (enumeration.hasMoreElements()) {
            simpleType = (SimpleType)enumeration.nextElement();
            hashMap.put(simpleType.getName(), simpleType);
        }
        simpleType = new Vector();
        String string2 = elementDecl.getName();
        XMLType xMLType = elementDecl.getType();
        if (xMLType instanceof ComplexType) {
            ComplexType complexType = (ComplexType)xMLType;
            Enumeration enumeration2 = complexType.enumerate();
            while (enumeration2.hasMoreElements()) {
                Group group = (Group)enumeration2.nextElement();
                Enumeration enumeration3 = group.enumerate();
                while (enumeration3.hasMoreElements()) {
                    Facet facet;
                    String string3;
                    InstrumentConstraintConfig instrumentConstraintConfig = new InstrumentConstraintConfig();
                    ElementDecl elementDecl2 = (ElementDecl)enumeration3.nextElement();
                    XMLType xMLType2 = elementDecl2.getType();
                    if (!(xMLType2 instanceof ComplexType)) continue;
                    ComplexType complexType2 = (ComplexType)xMLType2;
                    instrumentConstraintConfig.setName(elementDecl2.getName());
                    ElementDecl elementDecl3 = complexType2.getElementDecl("TypeInfo");
                    XMLType xMLType3 = elementDecl3.getType();
                    if (xMLType3.getBaseType() != null) {
                        string3 = xMLType3.getBaseType().getName();
                        instrumentConstraintConfig.getMetaData().setBaseType(string3);
                    }
                    instrumentConstraintConfig.getMetaData().setDefaultValue(elementDecl3.getDefaultValue());
                    string3 = xMLType3.getName();
                    SimpleType simpleType2 = (SimpleType)hashMap.get(string3);
                    Enumeration enumeration4 = simpleType2.getFacets();
                    Vector vector = new Vector();
                    while (enumeration4.hasMoreElements()) {
                        facet = (Facet)enumeration4.nextElement();
                        this.setMetaInfo(instrumentConstraintConfig, facet, vector);
                    }
                    facet = new String[vector.size()];
                    vector.copyInto((Object[])facet);
                    instrumentConstraintConfig.getMetaData().setAllowedValues((String[])facet);
                    stdlog_.debug((Object)("Instrument " + instrumentConstraintConfig.getMetaData().getMinExclusive()));
                    this.setInstConfig(instrumentConstraintConfig, complexType2);
                    simpleType.addElement(instrumentConstraintConfig);
                }
            }
        }
        Object[] objectArray = new InstrumentConstraintConfig[simpleType.size()];
        simpleType.copyInto(objectArray);
        return objectArray;
    }

    private void initCommentsMetaFile() throws FileNotFoundException, IOException {
        File file = new File(this.tsfDirectory_ + File.separator + "comments" + File.separator + "comments.cf");
        stdlog_.debug((Object)("Comments " + file.getAbsolutePath()));
        if (!file.exists()) {
            return;
        }
        PafFile pafFile = new PafFile(file.getAbsolutePath());
        this.labelInstComment = pafFile.getValueForKeyword("INST.LABEL");
        if (this.labelInstComment != null && this.labelInstComment.length() > 0) {
            this.instComments = true;
        }
        stdlog_.debug((Object)("LAbel inst comment " + this.labelInstComment));
    }

    private File initConstraintMetaFile() throws FileNotFoundException {
        File file = new File(this.tsfDirectory_ + File.separator + "constraints" + File.separator + "constraints.xsd");
        if (!file.exists()) {
            file = new File("config" + File.separator + "constraints.xsd");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Constraint file unavaialve");
        }
        return file;
    }

    private File initReadmeMetaFile() throws FileNotFoundException {
        File file = new File(this.tsfDirectory_ + File.separator + "readme" + File.separator + "readme.xsd");
        return file;
    }

    private void setInstConfig(InstrumentConstraintConfig instrumentConstraintConfig, ComplexType complexType) {
        String string;
        ElementDecl elementDecl = complexType.getElementDecl("Labels");
        instrumentConstraintConfig.setLabel(elementDecl.getFixedValue());
        elementDecl = complexType.getElementDecl("ToolTip");
        if (elementDecl != null) {
            instrumentConstraintConfig.setToolTip(elementDecl.getFixedValue());
        }
        if ((elementDecl = complexType.getElementDecl("TypeInfo")) != null) {
            instrumentConstraintConfig.setSuperType(elementDecl.getType().getName());
        }
        if ((elementDecl = complexType.getElementDecl("DBCOLUMN")) != null) {
            instrumentConstraintConfig.setDbColumn(elementDecl.getFixedValue());
        }
        if ((elementDecl = complexType.getElementDecl("FKCOLUMN")) != null) {
            instrumentConstraintConfig.setFkColumn(elementDecl.getFixedValue());
        }
        if ((elementDecl = complexType.getElementDecl("FKTABLE")) != null) {
            instrumentConstraintConfig.setFkTable(elementDecl.getFixedValue());
        }
        if ((elementDecl = complexType.getElementDecl("PAFKEYWORD")) != null) {
            instrumentConstraintConfig.setPafKeyword(elementDecl.getFixedValue());
        }
        if ((elementDecl = complexType.getElementDecl("compulsory")) != null && (string = elementDecl.getFixedValue()).equals("true")) {
            instrumentConstraintConfig.setCompulsory(true);
        }
        if ((elementDecl = complexType.getElementDecl("isProperty")) != null && (string = elementDecl.getFixedValue()).equals("true")) {
            instrumentConstraintConfig.setProperty(true);
        }
    }

    private void setMetaInfo(InstrumentConstraintConfig instrumentConstraintConfig, Facet facet, Vector vector) {
        if (facet.getName().equals("minInclusive")) {
            instrumentConstraintConfig.getMetaData().setMinInclusive(new Double(facet.getValue()));
        }
        if (facet.getName().equals("maxInclusive")) {
            instrumentConstraintConfig.getMetaData().setMaxInclusive(new Double(facet.getValue()));
        }
        if (facet.getName().equals("maxLength")) {
            instrumentConstraintConfig.getMetaData().setMaxLength(new Double(facet.getValue()).intValue());
        }
        if (facet.getName().equals("minLength")) {
            instrumentConstraintConfig.getMetaData().setMaxLength(new Double(facet.getValue()).intValue());
        }
        if (facet.getName().equals("pattern")) {
            instrumentConstraintConfig.getMetaData().setPattern(facet.getValue());
        }
        if (facet.getName().equals("enumeration")) {
            vector.addElement(facet.getValue());
        }
        stdlog_.debug((Object)("Instrument configuration " + instrumentConstraintConfig.getMetaData().getMinExclusive()));
    }

    public boolean refreshRequired() {
        long l = new File(this.instrumentFile_).lastModified();
        return l != this.lastModified_;
    }

    public boolean refreshInstrument() {
        String string = this.getInstrumentName();
        float f = this.getVersionNumber();
        boolean bl = true;
        try {
            this.init();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        if (!bl) {
            InstrumentList.getInstance().removeInstrument(string, f);
        }
        return bl;
    }

    public boolean isIndexOutOfDate() {
        return this.indexOutOfDate_;
    }

    public boolean hasInvalidTemplates() {
        int n = 0;
        while (n < this.tmplErrList_.length) {
            stdlog_.debug((Object)("MIPS error: " + n + " " + this.tmplErrList_[n]));
            ++n;
        }
        return this.tmplErrList_.length > 0 || this.templateSummaryList_.length <= 0;
    }

    public boolean hasExecTimeCalc() {
        File file = new File(this.tsfDirectory_ + File.separator + "exectime");
        if (file.exists() && file.isDirectory()) {
            stdlog_.debug((Object)("Directory  " + file));
            ExtFileList extFileList = new ExtFileList(file.getAbsolutePath(), ".tcl");
            String[] stringArray = extFileList.getFileList();
            if (stringArray.length > 0) {
                stdlog_.debug((Object)"Filelist > 0");
                return true;
            }
        }
        return false;
    }

    public void initIndexFile() throws IOException {
        File file = new File(this.tsfDirectory_);
        String string = this.tsfDirectory_ + File.separator + "summary.idx";
        boolean bl = false;
        File file2 = new File(string);
        if (file2.exists()) {
            if (file2.lastModified() < file.lastModified()) {
                bl = true;
            } else {
                ExtFileList extFileList = new ExtFileList(this.tsfDirectory_, ".tsf");
                File[] fileArray = extFileList.getFileHandles();
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].lastModified() > file2.lastModified()) {
                        bl = true;
                    }
                    ++n;
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            if (file.canWrite()) {
                this.writeIndexFile(string);
            } else {
                this.indexOutOfDate_ = true;
            }
        }
        this.readIndexFile(this.tsfDirectory_ + File.separator + "summary.idx");
    }

    public void setMandatoryKeywordsMissing() {
        Vector vector = this.pafFile_.getIdVector();
        if (!vector.contains("TELESCOPE")) {
            this.mandatoryKeywordsMissing_.addElement("TELESCOPE");
        }
        if (!vector.contains("VERSION")) {
            this.mandatoryKeywordsMissing_.addElement("VERSION");
        }
    }

    public boolean isValidFileType() {
        return this.fileType_ != null && this.fileType_.length() >= 0 && (this.fileType_.equals("Instrument Summary") || this.fileType_.equals("Instrument Summmary"));
    }

    public void setManadatoryValues() {
        Vector vector = this.pafFile_.getIdVector();
        int n = 0;
        while (n < mandatoryInstrumentValues.length) {
            if (!vector.contains(mandatoryInstrumentValues[n])) {
                this.mandatoryValuesMissing_.addElement(mandatoryInstrumentValues[n]);
            }
            ++n;
        }
    }

    public boolean getCriticalStatus() {
        if (this.compileErrorMsg_ != null && this.compileErrorMsg_.length() > 0) {
            return true;
        }
        if (this.pafLinesMissing_ != null && this.pafLinesMissing_.length > 0) {
            return true;
        }
        return this.mandatoryValuesMissing_.size() > 0 || this.mandatoryKeywordsMissing_.size() > 0 || !this.isValidFileType() || this.pafLinesMissing_.length > 0;
    }

    public boolean mandatoryValuesMissing() {
        return this.mandatoryValuesMissing_.size() <= 0;
    }

    public boolean mandatoryKeywordsMissing() {
        return this.mandatoryKeywordsMissing_.size() <= 0;
    }

    public boolean isValidInstrumentName() {
        return this.instrumentName_.equals("Instrument Summary");
    }

    public PafFile getPafFile() {
        return this.pafFile_;
    }

    public String[] getPafLinesMissing() {
        return this.pafFile_.getPafLinesMissing();
    }

    public boolean hasMasks() {
        return false;
    }

    public String queryComponent(String string) {
        PafData[] pafDataArray = this.pafFile_.getIdentifierList();
        int n = 0;
        while (n < this.instrumentData_.length) {
            String string2 = this.instrumentData_[n].getIdentifier();
            if (string2.equals(string)) {
                return this.instrumentData_[n].getValue();
            }
            ++n;
        }
        return null;
    }

    public String getInstrumentRange(String string, String string2) {
        Object object;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        int n = this.instrumentData_.length;
        if (string2 != null && string2.length() > 0) {
            string4 = string + " " + string2;
        }
        int n2 = 0;
        while (n2 < n) {
            object = this.instrumentData_[n2].getValue();
            string3 = this.instrumentData_[n2].getIdentifier();
            if (string3.equals(string)) {
                bl = true;
                break;
            }
            if (object != null && ((String)object).length() > 0) {
                if (((String)object).equals(string)) {
                    bl = true;
                } else if (string4 != null && ((String)object).equals(string4)) {
                    bl = true;
                }
                if (string3.endsWith("ALIAS")) {
                    int n3 = string3.lastIndexOf(46);
                    string3 = string3.substring(0, n3);
                }
                if (bl) break;
            }
            ++n2;
        }
        if (bl && (object = (PafData)this.instrumentValues_.get(string3)) != null) {
            return ((PafData)object).getValue();
        }
        return null;
    }

    public String[] getModes() {
        return this.modes_;
    }

    public String getInstrumentName() {
        return this.instrumentName_;
    }

    public String getTSFDirectory() {
        return this.tsfDirectory_;
    }

    public String getCCDWindow(String string) {
        String string2 = null;
        boolean bl = false;
        if (this.instrumentData_ == null) {
            stdlog_.debug((Object)"No instrument data");
        }
        int n = 0;
        while (n < this.instrumentData_.length) {
            String string3;
            if (this.instrumentData_[n].getIdentifier().endsWith("CCD.WINDOW")) {
                string2 = this.instrumentData_[n].getValue();
            }
            if ((string3 = this.instrumentData_[n].getValue()) != null) {
                if (string3.startsWith("getCCDWINDOW") && string3.endsWith(string)) {
                    bl = true;
                }
            } else {
                stdlog_.debug((Object)("Error no data for id " + this.instrumentData_[n].getIdentifier()));
            }
            ++n;
        }
        return string2;
    }

    public String getTelescopeName() {
        return this.telescopeName_;
    }

    public TemplateSignatureSummary[] getTemplateSummaryList() {
        return this.templateSummaryList_;
    }

    public void setTemplateSummaryList(TemplateSignatureSummary[] templateSignatureSummaryArray) {
        stdlog_.debug((Object)("MIPS (" + this.getInstrumentName() + ") setTemplateSummaryList: " + templateSignatureSummaryArray.length));
        this.templateSummaryList_ = templateSignatureSummaryArray;
    }

    public String getTemplateDesc(String string) {
        int n = 0;
        while (n < this.templateSummaryList_.length) {
            if (string.equals(this.templateSummaryList_[n].getTemplateName())) {
                return this.templateSummaryList_[n].getTemplateDesc();
            }
            ++n;
        }
        return null;
    }

    public TemplateSignatureSummary[] getTemplateSummaryList(String string) {
        if (string.length() == 0) {
            return this.templateSummaryList_;
        }
        TemplateSignatureSummary templateSignatureSummary = null;
        TemplateSignatureSummary[] templateSignatureSummaryArray = new TemplateSignatureSummary[this.numRecords];
        int n = 0;
        int n2 = 0;
        while (n2 < this.templateSummaryList_.length) {
            templateSignatureSummary = this.templateSummaryList_[n2];
            if (templateSignatureSummary == null) {
                stdlog_.debug((Object)"Null value found");
            }
            if (string.equals(templateSignatureSummary.getTemplateType())) {
                templateSignatureSummaryArray[n] = templateSignatureSummary;
                ++n;
            }
            ++n2;
        }
        TemplateSignatureSummary[] templateSignatureSummaryArray2 = new TemplateSignatureSummary[n];
        int n3 = 0;
        while (n3 < n) {
            templateSignatureSummaryArray2[n3] = templateSignatureSummaryArray[n3];
            ++n3;
        }
        return templateSignatureSummaryArray2;
    }

    public String[] getTemplateNames(String string) {
        boolean bl = false;
        TemplateSignatureSummary[] templateSignatureSummaryArray = this.getTemplateSummaryList(string);
        if (templateSignatureSummaryArray != null) {
            String[] stringArray = new String[templateSignatureSummaryArray.length];
            int n = 0;
            while (n < templateSignatureSummaryArray.length) {
                stringArray[n] = templateSignatureSummaryArray[n].getTemplateName();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public String[] getTemplateNames() {
        return this.templateNames_;
    }

    public long getLastModified() {
        return this.lastModified_;
    }

    private void setTelescopeName(String string) {
        this.telescopeName_ = string;
    }

    private void setInstrumentName(String string) {
        this.instrumentName_ = string;
    }

    private void setModes(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = new String(stringTokenizer.nextToken());
            vector.addElement(string2);
        }
        this.modes_ = new String[vector.size()];
        vector.copyInto(this.modes_);
    }

    public String getVersion() {
        return this.version_;
    }

    public float getVersionNumber() {
        return this.versionNumber_;
    }

    private void setVersion(String string) {
        block2: {
            this.version_ = string;
            if (this.version_ == null) break block2;
            try {
                Float f = new Float(string);
                this.versionNumber_ = f.floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.versionNumber_ = -1.0f;
            }
        }
    }

    public boolean hasValidVersion() {
        return (double)this.versionNumber_ >= 0.0;
    }

    protected void setValuesFromIdentifierList() {
        PafData[] pafDataArray = this.pafFile_.getIdentifierList();
        Vector<PafData> vector = new Vector<PafData>();
        int n = 0;
        while (n < pafDataArray.length) {
            String string = pafDataArray[n].getIdentifier();
            String string2 = pafDataArray[n].getValue();
            if (string.equals("TELESCOPE")) {
                this.setTelescopeName(pafDataArray[n].getValue());
            } else if (string.equals("VERSION")) {
                this.setVersion(pafDataArray[n].getValue());
            } else if (!string.startsWith("PAF")) {
                if (string.equals("MODES")) {
                    this.setModes(pafDataArray[n].getValue());
                }
                vector.addElement(pafDataArray[n]);
                if (!string.endsWith("ALIAS")) {
                    this.instrumentValues_.put(string, pafDataArray[n]);
                }
            }
            ++n;
        }
        this.instrumentData_ = new PafData[vector.size()];
        vector.copyInto(this.instrumentData_);
    }

    private void readIndexFile(String string) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.numRecords = objectInputStream.readInt();
            if (this.numRecords == 0) {
                return;
            }
            this.templateSummaryList_ = new TemplateSignatureSummary[this.numRecords];
            this.templateNames_ = new String[this.numRecords];
            int n = 0;
            while (n < this.numRecords) {
                TemplateSignatureSummary templateSignatureSummary;
                this.templateSummaryList_[n] = templateSignatureSummary = (TemplateSignatureSummary)objectInputStream.readObject();
                this.templateNames_[n] = templateSignatureSummary.getTemplateName();
                ++n;
            }
        }
        catch (EOFException eOFException) {
            stdlog_.debug((Object)("Num Records = " + this.numRecords));
        }
        catch (IOException iOException) {
            stdlog_.error((Object)("Error opening index file:" + string + " " + iOException.getMessage()));
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            stdlog_.debug((Object)"Class definition not found in index file");
            classNotFoundException.printStackTrace();
        }
    }

    public void writeIndexFile(String string) throws IOException {
        Vector<TemplateSignatureSummary> vector = new Vector<TemplateSignatureSummary>();
        Vector<String> vector2 = new Vector<String>();
        File file = new File(this.tsfDirectory_);
        if (!file.isDirectory()) {
            stdlog_.debug((Object)("No Such Directory " + this.tsfDirectory_));
            return;
        }
        ExtFileList extFileList = new ExtFileList(this.tsfDirectory_, ".tsf");
        String[] stringArray = extFileList.getFileList();
        if (stringArray == null) {
            stdlog_.debug((Object)(" No tsf files in the directory " + this.tsfDirectory_));
            return;
        }
        try {
            Serializable serializable;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n].substring(0, stringArray[n].indexOf(46));
                stdlog_.debug((Object)("Instrument " + file.getName() + " Template " + string2));
                serializable = TemplateSignatureFactory.createTemplateMetaData(this, string2);
                if (serializable != null && !((TemplateSignatureMetaData)serializable).getCriticalStatus()) {
                    TemplateSignatureSummary templateSignatureSummary = new TemplateSignatureSummary();
                    templateSignatureSummary.setTemplateName(((TemplateSignatureMetaData)serializable).getTemplateName());
                    templateSignatureSummary.setTemplateDesc(((TemplateSignatureMetaData)serializable).getTemplateDesc());
                    templateSignatureSummary.setTemplateType(((TemplateSignatureMetaData)serializable).getTemplateType());
                    templateSignatureSummary.setTemplateMode(((TemplateSignatureMetaData)serializable).getMode());
                    vector.addElement(templateSignatureSummary);
                } else {
                    vector2.addElement(stringArray[n]);
                    stdlog_.debug((Object)("Critical Error in template " + stringArray[n]));
                }
                ++n;
            }
            this.tmplErrList_ = new String[vector2.size()];
            vector2.copyInto(this.tmplErrList_);
            stdlog_.debug((Object)("!!!!!!!!!!!!!!! Writing out integer of size " + vector.size()));
            objectOutputStream.writeInt(vector.size());
            int n2 = 0;
            while (n2 < vector.size()) {
                serializable = (TemplateSignatureSummary)vector.elementAt(n2);
                objectOutputStream.writeObject(serializable);
                ++n2;
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            stdlog_.debug((Object)("Invalid output file " + iOException.getMessage()));
        }
    }

    public String toEngString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.instrumentFile_.lastIndexOf(File.separator) + 1;
        String string = this.instrumentFile_.substring(n);
        stringBuffer.append("Processing instrument: " + string + "\n");
        if (this.getCriticalStatus()) {
            int n2;
            stringBuffer.append("A critical error has been found in the .isf file\n");
            if (this.compileErrorMsg_ != null) {
                stringBuffer.append(this.compileErrorMsg_ + "\n");
                return stringBuffer.toString();
            }
            if (this.pafLinesMissing_ != null && this.pafLinesMissing_.length > 0) {
                int n3 = 0;
                while (n3 < this.pafLinesMissing_.length) {
                    stringBuffer.append("Mandatory Paf keyword missing " + this.pafLinesMissing_[n3] + "\n");
                    ++n3;
                }
                return stringBuffer.toString();
            }
            if (this.mandatoryKeywordsMissing_.size() > 0) {
                n2 = 0;
                while (n2 < this.mandatoryKeywordsMissing_.size()) {
                    stringBuffer.append("Mandatory keyword missing " + (String)this.mandatoryKeywordsMissing_.elementAt(n2) + "\n");
                    ++n2;
                }
            }
            if (this.mandatoryValuesMissing_.size() > 0) {
                n2 = 0;
                while (n2 < this.mandatoryValuesMissing_.size()) {
                    stringBuffer.append("Mandatory value missing for keyword " + (String)this.mandatoryValuesMissing_.elementAt(n2) + "\n");
                    ++n2;
                }
            }
            if (!this.isValidFileType()) {
                stringBuffer.append("Set PAF.TYPE to Instrument Summary\n " + this.fileType_);
            }
        } else {
            stringBuffer.append("No critical errors in this instrument file");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Class Instrument\n");
        stringBuffer.append("Instrument name=" + this.instrumentName_ + "\n");
        stringBuffer.append("Telescope=" + this.telescopeName_ + "\n");
        stringBuffer.append("Version=" + this.version_ + "\n");
        stringBuffer.append("Instrument filename=" + this.instrumentFile_ + "\n");
        String[] stringArray = this.getModes();
        if (stringArray.length == 0) {
            stringBuffer.append("<ERROR Instrument Class> No modes set for instrument\n");
        } else {
            n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("Mode=" + stringArray[n] + "\n");
                ++n;
            }
        }
        n = 0;
        while (n < this.templateSummaryList_.length) {
            TemplateSignatureSummary templateSignatureSummary = this.templateSummaryList_[n];
            stringBuffer.append(templateSignatureSummary.toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public InstrumentConstraintConfig[] getCsConfList() {
        return this.csConfList;
    }

    public InstrumentConstraintConfig[] getReadmeConfList() {
        return this.readmeConfList;
    }

    public String[] getCsProps() {
        String[] stringArray = new String[this.csConfList.length];
        int n = 0;
        while (n < this.csConfList.length) {
            stringArray[n] = new String(this.csConfList[n].getName());
            ++n;
        }
        return stringArray;
    }

    public void setCsConfList(InstrumentConstraintConfig[] instrumentConstraintConfigArray) {
        this.csConfList = instrumentConstraintConfigArray;
    }

    public String getLabelInstComment() {
        return this.labelInstComment;
    }

    public void setLabelInstComment(String string) {
        this.labelInstComment = string;
    }

    public boolean hasInstComments() {
        return this.instComments;
    }

    public void setInstComments(boolean bl) {
        this.instComments = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

