/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

public class InstrumentConstraintMetaData {
    private String pattern = "N\\A";
    private double minExclusive = Double.NaN;
    private double maxExclusive = Double.NaN;
    private double minInclusive = Double.NaN;
    private double maxInclusive = Double.NaN;
    private int maxLength = 0;
    private String type;
    private String baseType;
    private String[] allowedValues;
    private String defaultValue;

    public String[] getAllowedValues() {
        if (this.allowedValues == null) {
            return new String[0];
        }
        return this.allowedValues;
    }

    public double getMaxInclusive() {
        return this.maxInclusive;
    }

    public double getMinInclusive() {
        return this.minInclusive;
    }

    public double getMinExclusive() {
        return this.minExclusive;
    }

    public double getMaxExclusive() {
        return this.maxExclusive;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getType() {
        return this.type;
    }

    public void setAllowedValues(String[] stringArray) {
        this.allowedValues = stringArray;
    }

    public void setMaxExclusive(double d) {
        this.maxExclusive = d;
    }

    public void setMinExclusive(double d) {
        this.minExclusive = d;
    }

    public void setMinInclusive(double d) {
        this.minInclusive = d;
    }

    public void setMaxInclusive(double d) {
        this.maxInclusive = d;
    }

    public boolean verify(String string, String string2) {
        if (string2.equals("string")) {
            return this.inAllowedValues(string);
        }
        return this.inRange(new Double(string));
    }

    public boolean inAllowedValues(String string) {
        int n = 0;
        while (n < this.allowedValues.length) {
            if (this.allowedValues[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean inRange(double d) {
        return !(d < this.minInclusive) && !(d > this.maxInclusive);
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Min Exlusive " + this.getMinExclusive());
        stringBuffer.append(" Max Exlusive " + this.getMaxExclusive());
        stringBuffer.append(" Min Inclusive " + this.getMinInclusive());
        stringBuffer.append(" Max Inclusive " + this.getMaxInclusive());
        stringBuffer.append("Pattern " + this.getPattern());
        int n = 0;
        while (n < this.allowedValues.length) {
            stringBuffer.append(this.allowedValues[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String string) {
        this.baseType = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }
}

