/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.instruments.DefaultInstrumentListFactory;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.InstrumentException;
import org.eso.ohs.instruments.InstrumentListFactory;
import org.eso.ohs.instruments.MaskInstrument;

public class InstrumentList {
    private static final String rcsid = "$Id: InstrumentList.java,v 1.38 2005/01/14 08:46:01 tcanavan Exp $";
    private static InstrumentListFactory ilFactory_ = null;
    public static final String defaultISF = "default.isf";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$InstrumentList == null ? (class$org$eso$ohs$instruments$InstrumentList = InstrumentList.class$("org.eso.ohs.instruments.InstrumentList")) : class$org$eso$ohs$instruments$InstrumentList));
    private static InstrumentList instance_ = null;
    private Hashtable instrumentList_ = new Hashtable();
    private static boolean singleIPMode_ = false;
    static /* synthetic */ Class class$org$eso$ohs$instruments$InstrumentList;

    protected InstrumentList() {
    }

    public static InstrumentList getInstance() {
        return instance_;
    }

    public static synchronized InstrumentList setupInstrumentList(boolean bl, String string, String string2) throws InstrumentException {
        if (instance_ == null) {
            singleIPMode_ = bl;
            Vector<String> vector = new Vector<String>();
            if (string != null && string.length() > 0) {
                vector.addElement(string);
            }
            if (string2 != null && string2.length() > 0) {
                vector.addElement(string2);
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            InstrumentList.setupInstrumentList((String[])objectArray, ".isf");
        }
        return instance_;
    }

    public static void reloadInstrumentList(boolean bl, String string, String string2) throws InstrumentException {
        InstrumentList.resetInstrumentList();
        InstrumentList.setupInstrumentList(bl, string, string2);
    }

    public static void resetInstrumentList() {
        instance_ = null;
    }

    public static synchronized InstrumentList setupInstrumentList(String string, String string2) throws InstrumentException {
        if (instance_ == null) {
            String[] stringArray = new String[]{string};
            InstrumentList.setupInstrumentList(stringArray, string2);
        }
        return instance_;
    }

    private static synchronized InstrumentList setupInstrumentList(String[] stringArray, String string) throws InstrumentException {
        try {
            if (instance_ == null) {
                stdlog_.debug((Object)"MIPS InstrumentList getInstance(dirs, ext)");
                instance_ = InstrumentList.create();
                stdlog_.debug((Object)("Instrument directories listed: " + stringArray.length));
                String string2 = singleIPMode_ ? "Single IP Mode" : "Multiple IP Mode";
                Hashtable<String, File> hashtable = new Hashtable<String, File>();
                int n = 0;
                while (n < stringArray.length) {
                    String string3 = stringArray[n];
                    File file = new File(string3);
                    String string4 = file.getCanonicalPath();
                    Object v = hashtable.get(string4);
                    if (v == null) {
                        hashtable.put(string4, file);
                        stdlog_.debug((Object)("Instrument directory[" + n + "]: " + string3 + ", Using IP Versioning, " + string2));
                        String[] stringArray2 = new File(string3).list();
                        int n2 = 0;
                        while (n2 < stringArray2.length) {
                            File file2;
                            File file3 = new File(string3 + File.separator + stringArray2[n2]);
                            if (file3.isDirectory() && (file2 = new File(file3, defaultISF)).exists()) {
                                Instrument instrument = null;
                                instrument = stringArray2[n2].indexOf("VIMOS") != -1 ? new MaskInstrument(file3.getPath(), file2.getPath()) : new Instrument(file3.getPath(), file2.getPath());
                                if (instrument.hasValidVersion()) {
                                    stdlog_.debug((Object)("Adding Instrument " + instrument.getInstrumentName() + " Version " + instrument.getVersion()));
                                    instance_.putInstrument(instrument);
                                    instrument.initIndexFile();
                                } else {
                                    stdlog_.debug((Object)("Instrument Package " + instrument.getInstrumentName() + " has an illegal version (" + instrument.getVersion() + ") and will be ignored."));
                                }
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InstrumentException(illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new InstrumentException(iOException);
        }
        return instance_;
    }

    public void putInstrument(Instrument instrument) throws InstrumentException {
        Object v;
        Hashtable<String, Instrument> hashtable = (Hashtable<String, Instrument>)this.instrumentList_.get(instrument.getInstrumentName());
        if (hashtable == null) {
            hashtable = new Hashtable<String, Instrument>();
            this.instrumentList_.put(instrument.getInstrumentName(), hashtable);
        }
        if ((v = hashtable.get(new Float(instrument.getVersionNumber()).toString())) != null) {
            Instrument instrument2 = this.getInstrument(instrument.getInstrumentName(), instrument.getVersionNumber());
            throw new InstrumentException("Instrument Package " + instrument.getInstrumentName() + " version " + instrument.getVersion() + " exists multiple times in the Instrument List\n" + "     " + instrument.getTSFDirectory() + "\n" + "     " + instrument2.getTSFDirectory());
        }
        hashtable.put(new Float(instrument.getVersionNumber()).toString(), instrument);
    }

    public Instrument getInstrument(String string, float f) {
        stdlog_.debug((Object)("MIPS GetInstrument: " + string + " version: " + f));
        Instrument instrument = null;
        Hashtable hashtable = (Hashtable)this.instrumentList_.get(string);
        if (hashtable != null) {
            if ((double)f < 0.0 || InstrumentList.isInSingleIPMode()) {
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    Instrument instrument2 = (Instrument)enumeration.nextElement();
                    if (instrument != null && !(instrument.getVersionNumber() < instrument2.getVersionNumber())) continue;
                    instrument = instrument2;
                }
            } else {
                instrument = (Instrument)hashtable.get(new Float(f).toString());
            }
        }
        if (instrument == null) {
            stdlog_.debug((Object)"MIPS GetInstrument: rc == null");
        } else {
            stdlog_.debug((Object)"MIPS GetInstrument: rc != null");
        }
        return instrument;
    }

    public Instrument findInstrumentByDirectory(File file) {
        Instrument[] instrumentArray = this.getInstrumentList();
        Instrument instrument = null;
        if (instrumentArray != null) {
            int n = 0;
            while (n < instrumentArray.length) {
                File file2 = new File(instrumentArray[n].getTSFDirectory());
                File file3 = null;
                try {
                    file3 = new File(file2.getCanonicalPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (file2.equals(file) || file3 != null && file3.equals(file)) {
                    instrument = instrumentArray[n];
                    break;
                }
                ++n;
            }
        }
        return instrument;
    }

    public Instrument removeInstrument(String string, float f) {
        Instrument instrument = null;
        Hashtable hashtable = (Hashtable)this.instrumentList_.get(string);
        if (hashtable != null) {
            instrument = (Instrument)hashtable.remove(new Float(f).toString());
            if (hashtable.size() == 0) {
                this.instrumentList_.remove(string);
            }
        }
        return instrument;
    }

    public Instrument getInstrument(String string) {
        return this.getInstrument(string, -1.0f);
    }

    public static boolean isInSingleIPMode() {
        return singleIPMode_;
    }

    public Instrument[] getInstrumentList() {
        Instrument[] instrumentArray = null;
        if (instance_ != null && this.instrumentList_ != null) {
            Vector vector = new Vector();
            Enumeration enumeration = this.instrumentList_.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)enumeration.nextElement();
                Enumeration enumeration2 = hashtable.elements();
                while (enumeration2.hasMoreElements()) {
                    vector.addElement(enumeration2.nextElement());
                }
            }
            instrumentArray = new Instrument[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                instrumentArray[n] = (Instrument)vector.elementAt(n);
                ++n;
            }
        }
        return instrumentArray;
    }

    public boolean instrumentExists(String string) {
        return this.instrumentExists(string, -1.0f);
    }

    public boolean instrumentExists(String string, float f) {
        return this.getInstrument(string, f) != null;
    }

    public String[] getInstrumentNames() {
        String[] stringArray = new String[this.instrumentList_.size()];
        Enumeration enumeration = this.instrumentList_.keys();
        int n = 0;
        while (n < this.instrumentList_.size()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String[] getTelescopeNames() {
        Object object;
        Enumeration enumeration = this.instrumentList_.keys();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.instrumentList_.size()) {
            object = (String)enumeration.nextElement();
            String string = this.getInstrument((String)object).getTelescopeName();
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void insertInstrument(Instrument instrument) throws IOException, InstrumentException {
        this.removeInstrument(instrument.getInstrumentName(), instrument.getVersionNumber());
        instrument.initIndexFile();
        this.putInstrument(instrument);
    }

    private static InstrumentList create() {
        InstrumentList instrumentList;
        if (ilFactory_ != null) {
            stdlog_.debug((Object)"Creating InstrumentList from Custom Factory.");
            instrumentList = ilFactory_.getInstrumentList();
        } else {
            stdlog_.debug((Object)"Creating InstrumentList from Default Factory.");
            instrumentList = new DefaultInstrumentListFactory().getInstrumentList();
        }
        return instrumentList;
    }

    public static void setInstrumentListFactory(InstrumentListFactory instrumentListFactory) {
        ilFactory_ = instrumentListFactory;
    }

    public static InstrumentListFactory getInstrumentListFactory() {
        return ilFactory_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

