/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.instruments.ParamMetaData;
import org.eso.ohs.instruments.Parameter;

public class IntegerParameter
extends Parameter {
    static final long serialVersionUID = 9091241679416306593L;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$IntegerParameter == null ? (class$org$eso$ohs$instruments$IntegerParameter = IntegerParameter.class$("org.eso.ohs.instruments.IntegerParameter")) : class$org$eso$ohs$instruments$IntegerParameter));
    private Integer minValue_;
    private Integer maxValue_;
    private Integer[] validValues_;
    static /* synthetic */ Class class$org$eso$ohs$instruments$IntegerParameter;

    public IntegerParameter(ParamMetaData paramMetaData) {
        super(paramMetaData);
        this.initValidValues();
    }

    public Integer getMinValue() {
        return this.minValue_;
    }

    public Integer getMaxValue() {
        return this.maxValue_;
    }

    public Integer[] getValidValues() {
        return this.validValues_;
    }

    public char getDBTypeCode() {
        return 'I';
    }

    public boolean verifyValue(String string) {
        Integer n = null;
        String string2 = this.getDefaultValue();
        if (string == null || string.length() <= 0) {
            return false;
        }
        if (string.equals("NODEFAULT")) {
            return false;
        }
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        String string3 = this.getRange();
        return string3 == null || string3.length() <= 0 || this.valueInRange(n);
    }

    public String getToolTipText() {
        boolean bl = false;
        String string = "Enter valid value";
        if (this.minValue_ != null && this.maxValue_ != null) {
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        if (this.validValues_ != null) {
            int n = 0;
            while (n < this.validValues_.length) {
                stringBuffer.append(this.validValues_[n] + " ");
                ++n;
            }
        }
        StringBuffer stringBuffer2 = null;
        if (bl) {
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append(this.getMinValue());
            stringBuffer2.append("..");
            stringBuffer2.append(this.getMaxValue());
        }
        if (bl && this.validValues_ == null) {
            string = "Integer within range " + stringBuffer2.toString();
        }
        if (!bl && this.validValues_ != null) {
            string = "Integer value from the list " + stringBuffer.toString();
        }
        if (bl && this.validValues_ != null) {
            string = "Integer value within " + stringBuffer2.toString() + " or in list " + stringBuffer.toString();
        }
        if (!bl && this.validValues_ == null) {
            string = "Enter integer value";
        }
        return string;
    }

    boolean valueInRange(Integer n) {
        if (this.maxValue_ != null && this.minValue_ != null && n <= this.maxValue_ && n >= this.minValue_) {
            return true;
        }
        if (this.validValues_ != null) {
            int n2 = 0;
            while (n2 < this.validValues_.length) {
                if (n.intValue() == this.validValues_[n2].intValue()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void initValidValues() {
        String string = this.getRange();
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer(20);
        StringBuffer stringBuffer2 = new StringBuffer(20);
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("..");
            if (n != -1) {
                int n2 = n - 1;
                while (n2 >= 0 && string2.charAt(n2) != ' ') {
                    stringBuffer.insert(0, string2.charAt(n2));
                    --n2;
                }
                n2 = n + 2;
                while (n2 < string2.length() && string2.charAt(n2) != ' ') {
                    stringBuffer2.append(string2.charAt(n2));
                    ++n2;
                }
                try {
                    this.minValue_ = new Integer(stringBuffer.toString());
                    this.maxValue_ = new Integer(stringBuffer2.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    stdlog_.debug((Object)("Invalid range in paramater " + this.getParameterName()));
                }
                continue;
            }
            try {
                Integer n3 = new Integer(string2);
                vector.addElement(n3);
            }
            catch (NumberFormatException numberFormatException) {
                stdlog_.debug((Object)("Invalid range in paramater " + this.getParameterName()));
            }
        }
        if (vector.size() > 0) {
            this.validValues_ = new Integer[vector.size()];
            vector.copyInto(this.validValues_);
        }
    }

    public String toString() {
        String string = super.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (this.minValue_ != null) {
            stringBuffer.append("Min value " + this.minValue_.toString() + "\n");
        }
        if (this.maxValue_ != null) {
            stringBuffer.append("MaxValue  " + this.maxValue_.toString() + "\n");
        }
        if (this.validValues_ != null && this.validValues_.length > 0) {
            int n = 0;
            while (n < this.validValues_.length) {
                stringBuffer.append("Valid values " + this.validValues_[n].toString());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

