/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import org.eso.ohs.instruments.InstrumentConstraintConfig;
import org.eso.ohs.instruments.InstrumentConstraintMetaData;
import org.eso.ohs.instruments.ReadmeAttribute;

public class ReadmeFloatAttribute
extends ReadmeAttribute {
    private static final long serialVersionUID = -4378250031968166601L;
    public static final String DB_TYPE = "F";

    public ReadmeFloatAttribute(InstrumentConstraintConfig instrumentConstraintConfig) {
        super(instrumentConstraintConfig);
    }

    public Object getRawValue() {
        return new Float(this.getValue());
    }

    public boolean isCompulsory() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        String string = this.getValue();
        return !instrumentConstraintConfig.isCompulsory() || this.hasValue();
    }

    public String verify() {
        String string = this.getValue();
        if (!this.isCompulsory()) {
            return "Not Defined";
        }
        try {
            float f = new Float(string).floatValue();
            InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
            InstrumentConstraintMetaData instrumentConstraintMetaData = instrumentConstraintConfig.getMetaData();
            float f2 = (float)instrumentConstraintMetaData.getMinInclusive();
            float f3 = (float)instrumentConstraintMetaData.getMaxInclusive();
            if (f < f2 || f > f3) {
                return "INVALID";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "INVALID";
        }
        return "OK";
    }

    public static String getDBType() {
        return DB_TYPE;
    }

    public String getToolTipText() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        InstrumentConstraintMetaData instrumentConstraintMetaData = instrumentConstraintConfig.getMetaData();
        float f = (float)instrumentConstraintMetaData.getMinInclusive();
        float f2 = (float)instrumentConstraintMetaData.getMaxInclusive();
        String string = "Enter value between " + f + " and " + f2;
        return string;
    }
}

