/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import org.eso.ohs.instruments.InstrumentConstraintConfig;
import org.eso.ohs.instruments.InstrumentConstraintMetaData;
import org.eso.ohs.instruments.ReadmeAttribute;

public class ReadmeIntAttribute
extends ReadmeAttribute {
    private static final long serialVersionUID = -4378250031968131801L;
    public static final String DB_TYPE = "I";

    public ReadmeIntAttribute(InstrumentConstraintConfig instrumentConstraintConfig) {
        super(instrumentConstraintConfig);
    }

    public Object getRawValue() {
        return new Integer(this.getValue());
    }

    public boolean isCompulsory() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        String string = this.getValue();
        return !instrumentConstraintConfig.isCompulsory() || this.hasValue();
    }

    public String verify() {
        String string = this.getValue();
        if (!this.isCompulsory()) {
            return "Not Defined";
        }
        try {
            float f = new Integer(string).floatValue();
            InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
            InstrumentConstraintMetaData instrumentConstraintMetaData = instrumentConstraintConfig.getMetaData();
            int n = (int)instrumentConstraintMetaData.getMinInclusive();
            int n2 = (int)instrumentConstraintMetaData.getMaxInclusive();
            if (f < (float)n || f > (float)n2) {
                return "INVALID";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "INVALID";
        }
        return "OK";
    }

    public static String getDBType() {
        return DB_TYPE;
    }

    public String getToolTipText() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        InstrumentConstraintMetaData instrumentConstraintMetaData = instrumentConstraintConfig.getMetaData();
        float f = (int)instrumentConstraintMetaData.getMinInclusive();
        float f2 = (int)instrumentConstraintMetaData.getMaxInclusive();
        String string = "Enter value between " + f + " and " + f2;
        return string;
    }
}

