/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.util.StringTokenizer;
import org.eso.ohs.instruments.InstrumentConstraintConfig;
import org.eso.ohs.instruments.InstrumentConstraintMetaData;
import org.eso.ohs.instruments.ReadmeAttribute;

public class ReadmeKeywordList
extends ReadmeAttribute {
    private static final long serialVersionUID = -4378250031958131801L;
    public static final String DB_TYPE = "K";

    public ReadmeKeywordList(InstrumentConstraintConfig instrumentConstraintConfig) {
        super(instrumentConstraintConfig);
    }

    public boolean isCompulsory() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        String string = this.getValue();
        return !instrumentConstraintConfig.isCompulsory() || this.hasValue();
    }

    public Object getRawValue() {
        return this.getValue();
    }

    public String[] getValueAsArray() {
        String[] stringArray;
        if (this.hasValue()) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getValue(), ":");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String verify() {
        String string = this.getValue();
        InstrumentConstraintMetaData instrumentConstraintMetaData = this.getReadmeConfig().getMetaData();
        String[] stringArray = instrumentConstraintMetaData.getAllowedValues();
        if (!this.isCompulsory()) {
            return "Not Defined";
        }
        String[] stringArray2 = this.getValueAsArray();
        int n = 0;
        while (n < stringArray2.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray2[n].equals(stringArray[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return "INVALID";
            }
            ++n;
        }
        return "OK";
    }

    public static String getDBType() {
        return DB_TYPE;
    }

    public String getToolTipText() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        InstrumentConstraintMetaData instrumentConstraintMetaData = instrumentConstraintConfig.getMetaData();
        InstrumentConstraintMetaData instrumentConstraintMetaData2 = this.getReadmeConfig().getMetaData();
        String[] stringArray = instrumentConstraintMetaData2.getAllowedValues();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n >= 0 && n < stringArray.length - 1) {
                stringBuffer.append(":");
            }
            ++n;
        }
        stringBuffer.toString();
        String string = "Enter value from list:- " + stringBuffer.toString();
        return string;
    }
}

