/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import org.eso.ohs.instruments.InstrumentConstraintConfig;
import org.eso.ohs.instruments.InstrumentConstraintMetaData;
import org.eso.ohs.instruments.ReadmeAttribute;

public class ReadmeMultiStateBooleanList
extends ReadmeAttribute {
    private static final long serialVersionUID = -4378250031958139901L;
    private static final String NOT_DEFINED = "ND";
    public static final String DB_TYPE = "M";

    public ReadmeMultiStateBooleanList(InstrumentConstraintConfig instrumentConstraintConfig) {
        super(instrumentConstraintConfig);
    }

    public String verify() {
        String string = this.getValue();
        InstrumentConstraintMetaData instrumentConstraintMetaData = this.getReadmeConfig().getMetaData();
        String[] stringArray = instrumentConstraintMetaData.getAllowedValues();
        boolean bl = false;
        if (!this.isCompulsory()) {
            return "Not Defined";
        }
        if (this.getReadmeConfig().isCompulsory()) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return "INVALID";
            }
        }
        return "OK";
    }

    public Object getRawValue() {
        return this.getValue();
    }

    public boolean isCompulsory() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        String string = this.getValue();
        return !instrumentConstraintConfig.isCompulsory() || this.hasValue() && !string.equals(NOT_DEFINED);
    }

    public static String getDBType() {
        return DB_TYPE;
    }

    public String getToolTipText() {
        InstrumentConstraintConfig instrumentConstraintConfig = this.getReadmeConfig();
        return instrumentConstraintConfig.getToolTip();
    }
}

