/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.PafData;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.instruments.CreateParam;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.InstrumentList;
import org.eso.ohs.instruments.ParamMetaData;
import org.eso.ohs.instruments.Parameter;
import org.eso.ohs.instruments.TemplateSignatureMetaData;

public class TemplateSignature
implements Cloneable,
Serializable {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$TemplateSignature == null ? (class$org$eso$ohs$instruments$TemplateSignature = TemplateSignature.class$("org.eso.ohs.instruments.TemplateSignature")) : class$org$eso$ohs$instruments$TemplateSignature));
    static final long serialVersionUID = -4378250031958131854L;
    private static final String rcsid = "$Id: TemplateSignature.java,v 1.88 2005/02/15 09:53:54 pnunes Exp $";
    private String instrumentName_;
    private float ipversion_ = -1.0f;
    private String templateName_;
    private long lastModified_;
    public static final int PARAM_VALUE_MAXLEN = 2000;
    private Parameter[] plist;
    private transient Parameter[] dispParam;
    private TemplateSignatureMetaData tsMetaData_;
    private transient TemplateSignatureMetaData newMetaData_;
    static /* synthetic */ Class class$org$eso$ohs$instruments$TemplateSignature;

    public TemplateSignature(TemplateSignatureMetaData templateSignatureMetaData, float f) {
        this.newMetaData_ = templateSignatureMetaData;
        this.ipversion_ = f;
        this.init();
    }

    public TemplateSignature(TemplateSignature templateSignature) {
        this(templateSignature.getMetaData(), templateSignature.getVersion());
        Parameter[] parameterArray = templateSignature.getParamList();
        int n = 0;
        while (n < this.plist.length) {
            this.plist[n].setValue(parameterArray[n].getValue());
            ++n;
        }
    }

    private void init() {
        ParamMetaData[] paramMetaDataArray = this.newMetaData_.getParamList();
        if (paramMetaDataArray != null) {
            this.initParamList(paramMetaDataArray);
        }
        this.instrumentName_ = this.newMetaData_.getInstrumentName();
        this.templateName_ = this.newMetaData_.getTemplateName();
        this.lastModified_ = this.newMetaData_.getLastModified();
    }

    public boolean getWarningStatus() {
        return this.newMetaData_.getWarningStatus();
    }

    private void initParamList(ParamMetaData[] paramMetaDataArray) {
        Parameter parameter = null;
        Vector<Parameter> vector = new Vector<Parameter>();
        int n = 0;
        stdlog_.debug((Object)"CLASS TemplateSignature - initParamList:");
        n = 0;
        while (n < paramMetaDataArray.length) {
            try {
                parameter = CreateParam.Create(paramMetaDataArray[n]);
            }
            catch (NullPointerException nullPointerException) {
                stdlog_.error((Object)nullPointerException);
            }
            vector.addElement(parameter);
            ++n;
        }
        stdlog_.debug((Object)("CLASS TemplateSignature - initParamList: loop: i =" + n));
        this.plist = new Parameter[vector.size()];
        vector.copyInto(this.plist);
        this.createDisplayParamList();
    }

    public void setMetaData(TemplateSignatureMetaData templateSignatureMetaData) {
        this.newMetaData_ = templateSignatureMetaData;
    }

    public void recreateParamMetaData() {
        ParamMetaData[] paramMetaDataArray = this.newMetaData_.getParamList();
        int n = 0;
        while (n < this.plist.length) {
            this.plist[n].setMetaData(paramMetaDataArray[n]);
            ++n;
        }
    }

    public TemplateSignatureMetaData getMetaData() {
        return this.newMetaData_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.tsMetaData_ != null) {
            this.instrumentName_ = this.tsMetaData_.getInstrumentName();
            this.templateName_ = this.tsMetaData_.getTemplateName();
            this.lastModified_ = this.tsMetaData_.getLastModified();
            this.tsMetaData_ = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        objectOutputStream.defaultWriteObject();
    }

    public Parameter[] getParamList() {
        return this.plist;
    }

    public Parameter[] getDisplayParamList() {
        return this.dispParam;
    }

    public void createDisplayParamList() {
        Vector<Parameter> vector = new Vector<Parameter>();
        int n = 0;
        while (n < this.plist.length) {
            if (this.plist[n].isDisplay()) {
                vector.addElement(this.plist[n]);
            }
            ++n;
        }
        this.dispParam = new Parameter[vector.size()];
        vector.copyInto(this.dispParam);
    }

    public void setParamList(Parameter[] parameterArray) {
        this.plist = new Parameter[parameterArray.length];
        int n = 0;
        while (n < parameterArray.length) {
            this.plist[n] = parameterArray[n];
            ++n;
        }
        this.createDisplayParamList();
    }

    public String[] getLabels() {
        String[] stringArray = new String[this.dispParam.length];
        int n = 0;
        while (n < this.dispParam.length) {
            stringArray[n] = this.dispParam[n].getLabel();
            ++n;
        }
        return stringArray;
    }

    public String getTemplateName() {
        if (this.templateName_ == null) {
            return "";
        }
        return this.templateName_;
    }

    public long getLastModified() {
        return this.lastModified_;
    }

    public String getTemplateDesc() {
        return this.newMetaData_.getTemplateDesc();
    }

    public String getTemplateType() {
        return this.newMetaData_.getTemplateType();
    }

    public String getResources() {
        return this.newMetaData_.getResources();
    }

    public int getAcquisitionTime() {
        if (this.getTemplateType().equals("acquisition")) {
            return this.newMetaData_.getExecTime();
        }
        return 0;
    }

    public String getMode() {
        return this.newMetaData_.getMode();
    }

    public String getInstrumentName() {
        if (this.instrumentName_ == null) {
            return "";
        }
        return this.instrumentName_;
    }

    public float getVersion() {
        return this.ipversion_;
    }

    public void setVersion(float f) {
        this.ipversion_ = f;
    }

    public Instrument getInstrument() {
        return InstrumentList.getInstance().getInstrument(this.getInstrumentName(), this.getVersion());
    }

    public boolean checkVersion(TemplateSignature templateSignature) {
        return templateSignature.getVersion() == this.getVersion();
    }

    public void setParameterValue(String string, String string2) {
        int n = 0;
        while (n < this.plist.length) {
            if (this.plist[n].getParameterName().equals(string)) {
                this.plist[n].setValue(string2);
            }
            ++n;
        }
    }

    public String[] verify() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.dispParam.length) {
            if (!this.dispParam[n].hasHiddenKeyword() && !this.dispParam[n].verify()) {
                vector.addElement(this.dispParam[n].getLabel());
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toReportString() {
        int n = 22;
        int n2 = 20;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTemplateName() + ":\n");
        int n3 = 0;
        while (n3 < this.dispParam.length) {
            String string = this.dispParam[n3].getLabel();
            String string2 = null;
            string2 = this.dispParam[n3].getDisplayValue();
            if (string.length() <= n) {
                stringBuffer.append(TextUtils.padString(string, n));
            } else {
                stringBuffer.append(string.substring(0, n - 2) + "..");
            }
            stringBuffer.append(" ");
            if (string2.length() <= n2) {
                stringBuffer.append(TextUtils.padString(string2, n2));
            } else {
                stringBuffer.append(string2.substring(0, n2 - 2) + "..");
            }
            if (n3 > 0 && n3 % 2 != 0) {
                stringBuffer.append("\n");
            } else {
                stringBuffer.append(" ");
            }
            ++n3;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getParameterValue(String string) {
        return this.getParameterValue(string, true);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.plist.length) {
            stringBuffer.append(this.plist[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getParameterValue(String string, boolean bl) {
        String string2 = null;
        Parameter[] parameterArray = this.getParamList();
        int n = 0;
        while (n < parameterArray.length) {
            if (parameterArray[n].getParameterName().equals(string)) {
                string2 = parameterArray[n].getValue();
                break;
            }
            ++n;
        }
        if (string2 == null && this.newMetaData_ != null && bl) {
            PafData[] pafDataArray = this.newMetaData_.getIdentifierList();
            int n2 = 0;
            while (pafDataArray != null && n2 < pafDataArray.length) {
                if (pafDataArray[n2].getIdentifier().equals(string)) {
                    string2 = pafDataArray[n2].getValue();
                }
                ++n2;
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public boolean equals(TemplateSignature templateSignature) {
        if (this.templateName_.compareTo(templateSignature.getTemplateName()) != 0) {
            return false;
        }
        Parameter[] parameterArray = this.getDisplayParamList();
        Parameter[] parameterArray2 = templateSignature.getDisplayParamList();
        int n = 0;
        while (n < parameterArray.length) {
            Parameter parameter = parameterArray[n];
            String string = parameter.getParameterName();
            String string2 = templateSignature.getParameterValue(string);
            if (string2.compareTo("") == 0) {
                return false;
            }
            if (parameter.getValue().compareTo(string2) != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

