/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.eso.ohs.instruments.CreateParam;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.ParamMetaData;
import org.eso.ohs.instruments.Parameter;
import org.eso.ohs.instruments.TemplateSignature;
import org.eso.ohs.instruments.TemplateSignatureMetaData;

public class TemplateSignatureFactory {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$TemplateSignatureFactory == null ? (class$org$eso$ohs$instruments$TemplateSignatureFactory = TemplateSignatureFactory.class$("org.eso.ohs.instruments.TemplateSignatureFactory")) : class$org$eso$ohs$instruments$TemplateSignatureFactory));
    private static final Hashtable cache_ = new Hashtable();
    static /* synthetic */ Class class$org$eso$ohs$instruments$TemplateSignatureFactory;

    public static TemplateSignature getTemplate(Instrument instrument, String string) throws IOException {
        stdlog_.debug((Object)("Get Template: " + instrument.getInstrumentName() + " v: " + instrument.getVersionNumber() + " Template: " + string));
        TemplateSignatureMetaData templateSignatureMetaData = TemplateSignatureFactory.getTemplateMetaData(instrument, string);
        if (templateSignatureMetaData != null) {
            stdlog_.debug((Object)"GetTemplate: Meta Data Found");
            return new TemplateSignature(templateSignatureMetaData, instrument.getVersionNumber());
        }
        stdlog_.debug((Object)"GetTemplate: Meta Data Not Found.");
        return null;
    }

    public static TemplateSignatureMetaData getTemplateMetaData(Instrument instrument, String string) throws IOException {
        TemplateSignatureMetaData templateSignatureMetaData;
        stdlog_.debug((Object)("MIPS GetTemplateMetaData file: " + instrument.getTSFDirectory() + File.separator + string + ".tsf"));
        File file = new File(instrument.getTSFDirectory() + File.separator + string + ".tsf");
        if (!file.exists()) {
            return null;
        }
        Hashtable<String, TemplateSignatureMetaData> hashtable = (Hashtable<String, TemplateSignatureMetaData>)cache_.get(instrument);
        if (hashtable == null) {
            hashtable = new Hashtable<String, TemplateSignatureMetaData>();
            cache_.put(instrument, hashtable);
        }
        if ((templateSignatureMetaData = (TemplateSignatureMetaData)hashtable.get(string)) == null || TemplateSignatureFactory.isOutOfDate(file, templateSignatureMetaData)) {
            templateSignatureMetaData = new TemplateSignatureMetaData(instrument.getTSFDirectory() + File.separator + string + ".tsf", instrument);
            if (templateSignatureMetaData != null && !templateSignatureMetaData.getCriticalStatus()) {
                hashtable.put(string, templateSignatureMetaData);
            } else {
                if (templateSignatureMetaData.getCriticalStatus()) {
                    templateSignatureMetaData.toEngString();
                }
                return null;
            }
        }
        return templateSignatureMetaData;
    }

    public static void removeInstrumentTemplates(Instrument instrument) {
        cache_.remove(instrument);
    }

    private static boolean isOutOfDate(File file, TemplateSignatureMetaData templateSignatureMetaData) {
        return file.lastModified() > templateSignatureMetaData.getLastModified();
    }

    public static TemplateSignatureMetaData createTemplateMetaData(Instrument instrument, String string) throws IOException {
        TemplateSignatureMetaData templateSignatureMetaData = new TemplateSignatureMetaData(instrument.getTSFDirectory() + File.separator + string + ".tsf", instrument);
        return templateSignatureMetaData;
    }

    public static boolean refreshTemplate(TemplateSignature templateSignature) throws IOException {
        return TemplateSignatureFactory.refreshTemplate(templateSignature, false);
    }

    public static boolean refreshTemplate(TemplateSignature templateSignature, boolean bl) throws IOException {
        TemplateSignatureMetaData templateSignatureMetaData = null;
        Instrument instrument = templateSignature.getInstrument();
        if (instrument != null && instrument.refreshRequired()) {
            TemplateSignatureFactory.removeInstrumentTemplates(instrument);
            instrument.refreshInstrument();
            instrument = templateSignature.getInstrument();
            bl = true;
        }
        if (instrument == null) {
            stdlog_.debug((Object)"REFRESH TEMPLATE: NO INST");
            return false;
        }
        File file = new File(instrument.getTSFDirectory() + File.separator + templateSignature.getTemplateName() + ".tsf");
        if (!file.exists()) {
            stdlog_.debug((Object)"REFRESH TEMPLATE: NO TSF");
            return false;
        }
        templateSignatureMetaData = TemplateSignatureFactory.getTemplateMetaData(instrument, templateSignature.getTemplateName());
        if (templateSignatureMetaData == null) {
            stdlog_.debug((Object)"REFRESH TEMPLATE: NO META DATA");
            return false;
        }
        if (bl || instrument.getVersionNumber() != templateSignature.getVersion() || file.lastModified() != templateSignature.getLastModified()) {
            TemplateSignatureFactory.refreshParameters(templateSignature, templateSignatureMetaData);
        } else {
            templateSignature.setMetaData(templateSignatureMetaData);
            templateSignature.recreateParamMetaData();
            templateSignature.createDisplayParamList();
        }
        return true;
    }

    private static void refreshParameters(TemplateSignature templateSignature, TemplateSignatureMetaData templateSignatureMetaData) {
        Parameter[] parameterArray = templateSignature.getParamList();
        templateSignature.setMetaData(templateSignatureMetaData);
        ParamMetaData[] paramMetaDataArray = templateSignatureMetaData.getParamList();
        Parameter[] parameterArray2 = new Parameter[paramMetaDataArray.length];
        int n = 0;
        while (n < paramMetaDataArray.length) {
            parameterArray2[n] = CreateParam.Create(paramMetaDataArray[n]);
            int n2 = 0;
            while (n2 < parameterArray.length) {
                if (paramMetaDataArray[n].getParameterName().equals(parameterArray[n2].getParameterName()) && paramMetaDataArray[n].getType().equals(parameterArray[n2].getType()) && !paramMetaDataArray[n].isFixed()) {
                    String string = parameterArray[n2].getValue();
                    parameterArray2[n].setValue(string);
                }
                ++n2;
            }
            ++n;
        }
        templateSignature.setParamList(parameterArray2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

