/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.persistence;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.DebugUtils;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.dfs.BusinessObject;
import org.eso.ohs.dfs.CalibrationBlock;
import org.eso.ohs.dfs.ConstraintSet;
import org.eso.ohs.dfs.ObservationBlock;
import org.eso.ohs.dfs.ObservationDescription;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.dfs.Summary;
import org.eso.ohs.dfs.Target;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.DirectoryEvent;
import org.eso.ohs.persistence.DirectoryListener;
import org.eso.ohs.persistence.DirectoryNode;
import org.eso.ohs.persistence.Media;
import org.eso.ohs.persistence.ObjectEvent;
import org.eso.ohs.persistence.ObjectListener;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class ObjectManager {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$persistence$ObjectManager == null ? (class$org$eso$ohs$persistence$ObjectManager = ObjectManager.class$("org.eso.ohs.persistence.ObjectManager")) : class$org$eso$ohs$persistence$ObjectManager));
    public static final long NO_OBJECT = 0L;
    protected static final Object[] NO_ARGS = new Object[0];
    protected static ObjectManager objMgr_ = new ObjectManager();
    protected Registry registry_;
    protected Hashtable mediaMgr_ = new Hashtable();
    protected EventListenerList objectListeners = new EventListenerList();
    protected EventListenerList dirListeners = new EventListenerList();
    static /* synthetic */ Class class$org$eso$ohs$persistence$ObjectManager;
    static /* synthetic */ Class class$org$eso$ohs$dfs$BusinessObject;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObservingRun;
    static /* synthetic */ Class class$org$eso$ohs$persistence$DirectoryListener;
    static /* synthetic */ Class class$org$eso$ohs$persistence$ObjectListener;

    protected ObjectManager() {
        this.createRegistry();
    }

    public static ObjectManager getObjectManager() {
        return objMgr_;
    }

    public static void setObjectManager(ObjectManager objectManager) {
        objMgr_ = objectManager;
    }

    public StorageManager getStorageManager(Media media) {
        StorageManager storageManager = (StorageManager)this.mediaMgr_.get(media);
        if (storageManager == null) {
            throw new IllegalArgumentException("unsupported media: " + media.toString());
        }
        return storageManager;
    }

    public void setStorageManager(Media media, StorageManager storageManager) throws ObjectIOException {
        this.mediaMgr_.put(media, storageManager);
        storageManager.initialise();
    }

    protected void createRegistry() {
        this.registry_ = new Registry();
    }

    public static void startup() {
        ObjectManager.setObjectManager(new ObjectManager());
    }

    public void shutdown() {
        objMgr_ = null;
    }

    public void createNewInstance() {
        ObjectManager.startup();
    }

    public void restart() throws ObjectIOException {
        this.shutdown();
        this.createNewInstance();
        Enumeration enumeration = this.mediaMgr_.keys();
        while (enumeration.hasMoreElements()) {
            Media media = (Media)enumeration.nextElement();
            objMgr_.setStorageManager(media, (StorageManager)this.mediaMgr_.get(media));
        }
    }

    public BusinessObject deepCopy(Media media, DirectoryNode directoryNode, BusinessObject businessObject) throws ObjectIOException {
        return this.deepCopy(media, directoryNode, businessObject, 0L);
    }

    public BusinessObject deepCopy(Media media, DirectoryNode directoryNode, BusinessObject businessObject, long l) throws ObjectIOException {
        BusinessObject businessObject2 = businessObject.deepCopy();
        this.recursiveRegister(media, directoryNode, businessObject2, l);
        return businessObject2;
    }

    public void recursiveRegister(Media media, DirectoryNode directoryNode, BusinessObject businessObject) throws ObjectIOException {
        this.recursiveRegister(media, directoryNode, businessObject, 0L);
    }

    public void recursiveRegister(Media media, DirectoryNode directoryNode, BusinessObject businessObject, long l) throws ObjectIOException {
        this.setBusObjId(media, businessObject, l);
        long l2 = businessObject.getId();
        this.setBusObjIdRecursive(media, businessObject, l2);
        this.recursiveRegisterInternal(media, directoryNode, businessObject);
    }

    private void recursiveRegisterInternal(Media media, DirectoryNode directoryNode, BusinessObject businessObject) throws ObjectIOException {
        BusinessObject[] businessObjectArray = businessObject.getBusObjChildren();
        int n = 0;
        while (n < businessObjectArray.length) {
            this.recursiveRegisterInternal(media, directoryNode, businessObjectArray[n]);
            ++n;
        }
        this.register(media, directoryNode, businessObject);
    }

    private void setBusObjIdRecursive(Media media, BusinessObject businessObject, long l) throws ObjectIOException {
        BusinessObject[] businessObjectArray = businessObject.getBusObjChildren();
        int n = 0;
        while (n < businessObjectArray.length) {
            this.setBusObjIdRecursive(media, businessObjectArray[n], l);
            ++n;
        }
        this.setBusObjId(media, businessObject, l);
    }

    public void putObHierarchy(CalibrationBlock calibrationBlock) throws ObjectIOException {
        StorageManager.MultiObjSpec[] multiObjSpecArray = this.toMultiObjSpecArray(calibrationBlock);
        RegistryEntry registryEntry = this.registry_.lookup(calibrationBlock.getId());
        StorageManager storageManager = registryEntry.getStorageManager();
        storageManager.multiStore(multiObjSpecArray);
        int n = multiObjSpecArray.length - 1;
        while (n >= 0) {
            StorableObject storableObject = multiObjSpecArray[n].obj.getObject();
            RegistryEntry registryEntry2 = this.registry_.lookup(storableObject.getId());
            registryEntry2.isNew_ = false;
            --n;
        }
    }

    protected StorageManager.MultiObjSpec[] toMultiObjSpecArray(CalibrationBlock calibrationBlock) throws ObjectIOException {
        Vector<StorageManager.MultiObjSpec> vector = new Vector<StorageManager.MultiObjSpec>();
        Target target = calibrationBlock instanceof ObservationBlock ? ((ObservationBlock)calibrationBlock).getTarget() : null;
        ObservationDescription observationDescription = calibrationBlock.getOd();
        ConstraintSet constraintSet = null;
        if (calibrationBlock instanceof ObservationBlock) {
            constraintSet = ((ObservationBlock)calibrationBlock).getConstraintSet();
        }
        if (target != null) {
            vector.addElement(this.createMultiObjSpec(target));
        }
        if (constraintSet != null) {
            vector.addElement(this.createMultiObjSpec(constraintSet));
        }
        vector.addElement(this.createMultiObjSpec(calibrationBlock));
        if (observationDescription != null) {
            vector.addElement(this.createMultiObjSpec(observationDescription));
        }
        RegistryEntry registryEntry = this.registry_.lookup(calibrationBlock.getId());
        StorageManager storageManager = registryEntry.getStorageManager();
        Object[] objectArray = new StorageManager.MultiObjSpec[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private StorageManager.MultiObjSpec createMultiObjSpec(BusinessObject businessObject) {
        RegistryEntry registryEntry = this.registry_.lookup(businessObject.getId());
        StorageManager.MultiObjSpec multiObjSpec = new StorageManager.MultiObjSpec();
        multiObjSpec.setNew(registryEntry.isNew());
        multiObjSpec.dir = registryEntry.getDirectory();
        multiObjSpec.setCls(businessObject.getClass());
        multiObjSpec.obj = this.disassembleReferences(businessObject);
        return multiObjSpec;
    }

    public DirectoryNode getRoot(Media media) throws ObjectIOException {
        return this.getStorageManager(media).getRoot();
    }

    protected void setBusObjId(Media media, StorableObject storableObject, long l) throws ObjectIOException {
        if (storableObject.getId() == 0L) {
            storableObject.setId(this.getNewId(media, storableObject.getClass(), l));
        }
    }

    public long getNewId(Media media, Class clazz) throws ObjectIOException {
        return this.getNewId(media, clazz, 0L);
    }

    protected long getNewId(Media media, Class clazz, long l) throws ObjectIOException {
        return this.getStorageManager(media).getNewId(clazz, l);
    }

    public boolean isInRegistry(long l) {
        return this.registry_.lookup(l) != null;
    }

    protected void linkBusObj(Media media, DirectoryNode directoryNode, boolean bl, StorableObject storableObject) {
        StorageManager storageManager = this.getStorageManager(media);
        RegistryEntry registryEntry = new RegistryEntry(storableObject, media, storageManager, directoryNode, bl);
        this.registry_.add(storableObject.getId(), registryEntry);
    }

    public RegistryEntry lookup(long l) {
        return this.registry_.lookup(l);
    }

    public boolean moveDirectory(Media media, DirectoryNode directoryNode, DirectoryNode directoryNode2) throws ObjectIOException, ObjectNotFoundException {
        StorageManager storageManager = this.getStorageManager(media);
        DirectoryNode directoryNode3 = directoryNode.getParent();
        boolean bl = storageManager.moveDirectory(directoryNode, directoryNode2);
        if (bl) {
            this.fireDirectoryEvent(2, media, directoryNode, directoryNode3);
        }
        return bl;
    }

    protected void dequeueObject(StorableObject storableObject) {
    }

    public void queueObject(StorableObject storableObject) {
    }

    public void moveBusObj(Media media, long l, Class clazz, DirectoryNode directoryNode) throws ObjectNotFoundException, ObjectIOException {
        StorageManager storageManager = this.getStorageManager(media);
        RegistryEntry registryEntry = this.registry_.lookup(l);
        DirectoryNode directoryNode2 = null;
        StorableObject storableObject = null;
        if (registryEntry != null) {
            directoryNode2 = registryEntry.getDirectory();
            storableObject = registryEntry.getObject();
            if (directoryNode2 == directoryNode) {
                return;
            }
            this.dequeueObject(registryEntry.getObject());
        }
        try {
            directoryNode2 = storageManager.find(l, clazz);
            storageManager.move(l, clazz, directoryNode2, directoryNode);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        if (directoryNode2 == null) {
            throw new ObjectNotFoundException("Unknown object: " + l);
        }
        if (registryEntry != null) {
            registryEntry.setDirectory(directoryNode);
            this.queueObject(registryEntry.getObject());
        }
        this.fireObjectEvent(3, media, directoryNode2, directoryNode, storableObject, l, clazz);
    }

    public void deleteBusObj(Media media, long l, Class clazz) throws ObjectNotFoundException, ObjectIOException {
        StorageManager storageManager = this.getStorageManager(media);
        RegistryEntry registryEntry = this.registry_.lookup(l);
        StorableObject storableObject = null;
        DirectoryNode directoryNode = null;
        if (registryEntry != null) {
            directoryNode = registryEntry.getDirectory();
            storableObject = registryEntry.getObject();
        } else {
            directoryNode = storageManager.find(l, clazz);
        }
        storageManager.delete(directoryNode, l, clazz);
        this.registry_.remove(l);
        this.fireObjectEvent(5, media, null, directoryNode, storableObject, l, clazz);
    }

    public void register(Media media, StorableObject storableObject) throws ObjectIOException {
        this.register(media, this.getRoot(media), storableObject, 0L);
    }

    public void register(Media media, StorableObject storableObject, long l) throws ObjectIOException {
        this.register(media, this.getRoot(media), storableObject, l);
    }

    public void register(Media media, DirectoryNode directoryNode, StorableObject storableObject) throws ObjectIOException {
        this.register(media, directoryNode, storableObject, 0L);
    }

    public void register(Media media, DirectoryNode directoryNode, StorableObject storableObject, long l) throws ObjectIOException {
        this.setBusObjId(media, storableObject, l);
        if (storableObject instanceof BusinessObject) {
            ((BusinessObject)storableObject).setOwnerId(Config.getCfg().getUserName());
        }
        this.linkBusObj(media, directoryNode, true, storableObject);
        this.fireObjectEvent(1, media, null, directoryNode, storableObject, storableObject.getId(), storableObject.getClass());
    }

    public void putBusObj(StorableObject storableObject) throws ObjectNotFoundException, ObjectIOException {
        RegistryEntry registryEntry = this.registry_.lookup(storableObject.getId());
        if (registryEntry == null) {
            throw new ObjectNotFoundException("object not in memory: " + storableObject.getId());
        }
        StorageManager.UnpackedStorableObject unpackedStorableObject = this.disassembleReferences(registryEntry.getObject());
        StorageManager storageManager = registryEntry.getStorageManager();
        stdlog_.debug((Object)("////////////////////// Using the following id: " + storableObject.getId()));
        if (registryEntry.isNew()) {
            storageManager.write(registryEntry.getDirectory(), storableObject.getId(), storableObject.getClass(), unpackedStorableObject);
        } else {
            storageManager.update(registryEntry.getDirectory(), storableObject.getId(), storableObject.getClass(), unpackedStorableObject);
        }
        registryEntry.setLocked(false);
        registryEntry.setNew(false);
    }

    public void forgetBusObj(Media media, long l, Class clazz) {
        RegistryEntry registryEntry = this.registry_.lookup(l);
        if (registryEntry != null) {
            DirectoryNode directoryNode = registryEntry.getDirectory();
            StorableObject storableObject = registryEntry.getObject();
            this.dequeueObject(registryEntry.getObject());
            this.registry_.remove(l);
            this.fireObjectEvent(6, media, null, directoryNode, storableObject, l, clazz);
        }
    }

    public void refreshBusObj(Media media, long l, Class clazz) throws ObjectNotFoundException, ObjectIOException {
        if (!(class$org$eso$ohs$dfs$BusinessObject == null ? (class$org$eso$ohs$dfs$BusinessObject = ObjectManager.class$("org.eso.ohs.dfs.BusinessObject")) : class$org$eso$ohs$dfs$BusinessObject).isAssignableFrom(clazz)) {
            throw new ObjectIOException("refreshBusObj: cannot refresh this type of object: " + clazz.getName());
        }
        if (!this.isInRegistry(l)) {
            return;
        }
        StorageManager storageManager = this.getStorageManager(media);
        DirectoryNode directoryNode = storageManager.find(l, clazz);
        StorageManager.UnpackedStorableObject unpackedStorableObject = storageManager.read(directoryNode, l, clazz);
        BusinessObject businessObject = (BusinessObject)unpackedStorableObject.getObject();
        BusinessObject businessObject2 = (BusinessObject)this.getBusObj(media, l, clazz);
        try {
            String[] stringArray = businessObject.simpleProperties();
            businessObject.copyProperties(stringArray, businessObject2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjectIOException("refreshBusObj: NoSuchMethod: " + noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjectIOException("refreshBusObj: InvocationTargetException:" + invocationTargetException.getTargetException().getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectIOException("refreshBusObj: IllegalAccess: " + illegalAccessException.getMessage());
        }
    }

    public void refreshBusObjRecursive(Media media, long l, Class clazz) throws ObjectNotFoundException, ObjectIOException {
        if (!this.isInRegistry(l)) {
            return;
        }
        BusinessObject businessObject = (BusinessObject)this.getBusObj(media, l, clazz);
        Stack<BusinessObject> stack = new Stack<BusinessObject>();
        stack.push(businessObject);
        while (!stack.isEmpty()) {
            BusinessObject businessObject2 = (BusinessObject)stack.pop();
            BusinessObject[] businessObjectArray = businessObject2.getBusObjChildren();
            int n = 0;
            while (n < businessObjectArray.length) {
                stack.push(businessObjectArray[n]);
                ++n;
            }
            this.refreshBusObj(media, businessObject2.getId(), Config.getCfg().getClassFromId(businessObject2.getId()));
        }
    }

    public StorableObject getBusObj(Media media, long l, Class clazz) throws ObjectNotFoundException, ObjectIOException {
        DirectoryNode directoryNode;
        RegistryEntry registryEntry = this.registry_.lookup(l);
        if (registryEntry != null) {
            stdlog_.debug((Object)("!!!!!!!!!! Returning from Registry " + l));
            return registryEntry.getObject();
        }
        StorageManager storageManager = this.getStorageManager(media);
        StorageManager.UnpackedStorableObject unpackedStorableObject = storageManager.read(directoryNode = storageManager.find(l, clazz), l, clazz);
        if (unpackedStorableObject == null) {
            DebugUtils.stackTrace("SHOULDN'T HAPPEN");
            return null;
        }
        StorableObject storableObject = unpackedStorableObject.getObject();
        this.reassembleReferences(media, unpackedStorableObject);
        this.linkBusObj(media, directoryNode, false, storableObject);
        this.fireObjectEvent(2, media, null, directoryNode, storableObject, storableObject.getId(), storableObject.getClass());
        return storableObject;
    }

    protected void reassembleReferences(Media media, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException, ObjectNotFoundException {
        StorableObject storableObject = unpackedStorableObject.getObject();
        Enumeration enumeration = unpackedStorableObject.getProperties();
        long l = storableObject instanceof BusinessObject ? ((BusinessObject)storableObject).getLastModifiedDate() : -1L;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            long l2 = unpackedStorableObject.getNestedObjId(string);
            StorableObject storableObject2 = null;
            try {
                Class<?> clazz = storableObject.getClass();
                Method method = clazz.getMethod("get" + string, new Class[0]);
                Method method2 = clazz.getMethod("set" + string, method.getReturnType());
                if (l2 != 0L) {
                    Class<?> clazz2 = method.getReturnType();
                    Media media2 = media;
                    if (clazz2 == (class$org$eso$ohs$dfs$ObservingRun == null ? ObjectManager.class$("org.eso.ohs.dfs.ObservingRun") : class$org$eso$ohs$dfs$ObservingRun) && media.equals(Media.PHASE2_DB)) {
                        media2 = Media.PHASE1_DB;
                    }
                    storableObject2 = this.getBusObj(media2, l2, clazz2);
                }
                method2.invoke((Object)storableObject, storableObject2);
            }
            catch (IllegalAccessException illegalAccessException) {
                stdlog_.error((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                stdlog_.error((Object)invocationTargetException.getTargetException());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                stdlog_.error((Object)noSuchMethodException);
                throw new IllegalArgumentException("corrupt data: " + string);
            }
        }
        if (l >= 0L) {
            ((BusinessObject)storableObject).setLastModifiedDate(l);
        }
    }

    protected StorageManager.UnpackedStorableObject disassembleReferences(StorableObject storableObject) {
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(storableObject);
        try {
            Class<?> clazz = storableObject.getClass();
            Method[] methodArray = clazz.getMethods();
            Class clazz2 = class$org$eso$ohs$dfs$BusinessObject == null ? (class$org$eso$ohs$dfs$BusinessObject = ObjectManager.class$("org.eso.ohs.dfs.BusinessObject")) : class$org$eso$ohs$dfs$BusinessObject;
            int n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                Class<?> clazz3 = method.getReturnType();
                if (method.getName().startsWith("get") && clazz2.isAssignableFrom(clazz3) && method.getParameterTypes().length == 0) {
                    BusinessObject businessObject = (BusinessObject)method.invoke((Object)storableObject, NO_ARGS);
                    unpackedStorableObject.addNestedObjId(method.getName().substring(3), businessObject == null ? 0L : businessObject.getId());
                }
                ++n;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            stdlog_.error((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            stdlog_.error((Object)invocationTargetException);
        }
        return unpackedStorableObject;
    }

    public long createDirectory(Media media, DirectoryNode directoryNode, long l) throws ObjectIOException {
        StorageManager storageManager = this.getStorageManager(media);
        if (storageManager.createDirectory(directoryNode, l)) {
            this.fireDirectoryEvent(1, media, directoryNode.getDirectory(l), directoryNode);
            return l;
        }
        return 0L;
    }

    protected boolean canDeleteDirectory(Media media, DirectoryNode directoryNode) throws ObjectIOException {
        return directoryNode.getChildCount() == 0 && !this.registry_.hasObjectsInDirectory(directoryNode);
    }

    protected void prepareDirectoryForDeletion(Media media, DirectoryNode directoryNode) throws ObjectIOException {
    }

    public boolean deleteDirectory(Media media, DirectoryNode directoryNode) throws ObjectIOException {
        DirectoryNode directoryNode2 = directoryNode.getParent();
        if (!this.canDeleteDirectory(media, directoryNode)) {
            stdlog_.debug((Object)"Cannot delete direcctory");
            return false;
        }
        this.prepareDirectoryForDeletion(media, directoryNode);
        if (this.getStorageManager(media).deleteDirectory(directoryNode)) {
            this.fireDirectoryEvent(4, media, directoryNode, directoryNode2);
            return true;
        }
        return false;
    }

    public Summary[] listObjects(Media media, DirectoryNode directoryNode) throws ObjectIOException {
        return this.getStorageManager(media).listObjects(directoryNode);
    }

    public ObservingRun getObservingRun(long l) throws ObjectIOException, ObjectNotFoundException {
        StorageManager storageManager = this.getStorageManager(Media.PHASE1_DB);
        StorageManager.UnpackedStorableObject unpackedStorableObject = storageManager.read(null, l, class$org$eso$ohs$dfs$ObservingRun == null ? (class$org$eso$ohs$dfs$ObservingRun = ObjectManager.class$("org.eso.ohs.dfs.ObservingRun")) : class$org$eso$ohs$dfs$ObservingRun);
        ObservingRun observingRun = (ObservingRun)unpackedStorableObject.getObject();
        return observingRun;
    }

    public void addDirectoryListener(DirectoryListener directoryListener) {
        this.dirListeners.add(class$org$eso$ohs$persistence$DirectoryListener == null ? (class$org$eso$ohs$persistence$DirectoryListener = ObjectManager.class$("org.eso.ohs.persistence.DirectoryListener")) : class$org$eso$ohs$persistence$DirectoryListener, directoryListener);
    }

    public void removeDirectoryListener(DirectoryListener directoryListener) {
        this.dirListeners.remove(class$org$eso$ohs$persistence$DirectoryListener == null ? (class$org$eso$ohs$persistence$DirectoryListener = ObjectManager.class$("org.eso.ohs.persistence.DirectoryListener")) : class$org$eso$ohs$persistence$DirectoryListener, directoryListener);
    }

    protected void fireDirectoryEvent(int n, Media media, DirectoryNode directoryNode, DirectoryNode directoryNode2) {
        DirectoryEvent directoryEvent = new DirectoryEvent(n, media, directoryNode, directoryNode2);
        Object[] objectArray = this.dirListeners.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            Object object = objectArray[n2 + 1];
            if (objectArray[n2] == (class$org$eso$ohs$persistence$DirectoryListener == null ? ObjectManager.class$("org.eso.ohs.persistence.DirectoryListener") : class$org$eso$ohs$persistence$DirectoryListener)) {
                if (n == 1) {
                    ((DirectoryListener)object).directoryAdded(directoryEvent);
                } else if (n == 2) {
                    ((DirectoryListener)object).directoryMoved(directoryEvent);
                } else if (n == 3) {
                    ((DirectoryListener)object).directoryChanged(directoryEvent);
                } else {
                    ((DirectoryListener)object).directoryRemoved(directoryEvent);
                }
            }
            n2 -= 2;
        }
    }

    public long getDbaseId(BusinessObject businessObject) {
        long l;
        Media media = ObjectManager.getObjectManager().lookup(businessObject.getId()).getMedia();
        long l2 = media.equals(Media.DBASE) ? businessObject.getDbaseId() : ((l = businessObject.getDbaseId()) != 0L ? Config.getCfg().uniqueToTableId(l) : businessObject.getId());
        return l2;
    }

    public void addObjectListener(ObjectListener objectListener) {
        this.objectListeners.add(class$org$eso$ohs$persistence$ObjectListener == null ? (class$org$eso$ohs$persistence$ObjectListener = ObjectManager.class$("org.eso.ohs.persistence.ObjectListener")) : class$org$eso$ohs$persistence$ObjectListener, objectListener);
    }

    public void removeObjectListener(ObjectListener objectListener) {
        this.objectListeners.remove(class$org$eso$ohs$persistence$ObjectListener == null ? (class$org$eso$ohs$persistence$ObjectListener = ObjectManager.class$("org.eso.ohs.persistence.ObjectListener")) : class$org$eso$ohs$persistence$ObjectListener, objectListener);
    }

    protected void fireObjectEvent(int n, Media media, DirectoryNode directoryNode, DirectoryNode directoryNode2, StorableObject storableObject, long l, Class clazz) {
        ObjectEvent objectEvent = new ObjectEvent(n, media, directoryNode, directoryNode2, storableObject, l, clazz);
        Object[] objectArray = this.objectListeners.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            Object object = objectArray[n2 + 1];
            if (objectArray[n2] == (class$org$eso$ohs$persistence$ObjectListener == null ? ObjectManager.class$("org.eso.ohs.persistence.ObjectListener") : class$org$eso$ohs$persistence$ObjectListener)) {
                if (n == 2 || n == 1) {
                    ((ObjectListener)object).objectAdded(objectEvent);
                } else if (n == 3) {
                    ((ObjectListener)object).objectMoved(objectEvent);
                } else if (n == 5) {
                    ((ObjectListener)object).objectRemoved(objectEvent);
                } else if (n == 6) {
                    ((ObjectListener)object).objectRemovedFromRegistry(objectEvent);
                }
            }
            n2 -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Registry {
        protected final Hashtable inMemory_ = new Hashtable();

        public RegistryEntry lookup(long l) {
            return this.lookup(new Long(l));
        }

        public synchronized RegistryEntry lookup(Long l) {
            return (RegistryEntry)this.inMemory_.get(l);
        }

        public synchronized void add(long l, RegistryEntry registryEntry) {
            if (registryEntry == null) {
                throw new NullPointerException("Bad Registry entry: " + registryEntry);
            }
            if (this.lookup(l) == null) {
                this.inMemory_.put(new Long(l), registryEntry);
            }
        }

        public synchronized RegistryEntry remove(long l) {
            return (RegistryEntry)this.inMemory_.remove(new Long(l));
        }

        public synchronized boolean hasObjectsInDirectory(DirectoryNode directoryNode) {
            return this.inMemory_.containsValue(directoryNode);
        }
    }

    public static class RegistryEntry {
        private StorableObject sobj_;
        private Media device_;
        private StorageManager stMgr_;
        private DirectoryNode dir_;
        private boolean isNew_;
        private boolean locked = false;

        public RegistryEntry(StorableObject storableObject, Media media, StorageManager storageManager, DirectoryNode directoryNode, boolean bl) {
            if (directoryNode == null) {
                throw new NullPointerException("Bad Registry entry: no dir");
            }
            if (storableObject == null) {
                throw new NullPointerException("Bad Registry entry: no object");
            }
            this.sobj_ = storableObject;
            this.device_ = media;
            this.stMgr_ = storageManager;
            this.dir_ = directoryNode;
            this.isNew_ = bl;
        }

        public StorableObject getObject() {
            return this.sobj_;
        }

        public Media getMedia() {
            return this.device_;
        }

        public StorageManager getStorageManager() {
            return this.stMgr_;
        }

        public void setDirectory(DirectoryNode directoryNode) {
            this.dir_ = directoryNode;
        }

        public DirectoryNode getDirectory() {
            return this.dir_;
        }

        public void setNew(boolean bl) {
            this.isNew_ = bl;
        }

        public boolean isNew() {
            return this.isNew_;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean bl) {
            this.locked = bl;
        }
    }
}

