/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DbrpcToken;
import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;

public class SrvDbrpcToken
extends DbrpcToken
implements Dumpable {
    protected int _totalLen;
    protected int _rpcnameLen;
    protected boolean _hasWidetableParams;

    public SrvDbrpcToken(TdsInputStream tdsInputStream) throws IOException {
        this._totalLen = tdsInputStream.readShort();
        this._rpcnameLen = tdsInputStream.readByte();
        this._rpcname = tdsInputStream.readString(this._rpcnameLen).trim();
        this._options = tdsInputStream.readShort();
    }

    public SrvDbrpcToken(String string, int n) throws IOException {
        this._rpcname = string;
        this._rpcnameLen = string.length();
        this._options = n;
        this._totalLen = this._rpcnameLen + 3;
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(230)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "DBRPC Token (0x" + HexConverts.hexConvert(230, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "DBRPC Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLen);
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(8)) {
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Name Length", 1, this._rpcnameLen);
                }
                dumpInfo.addText("Name", this._rpcnameLen, this._rpcname);
                String[] stringArray = new String[]{"RPC_UNUSED", "RPC_RECOMPILE", "RPC_PARAMS"};
                dumpInfo.addField("Options", 2, this._options, stringArray);
            }
        }
        return dumpInfo;
    }

    public String getName() {
        return this._rpcname;
    }

    public int getTokenType() {
        return 230;
    }

    public boolean hasParams() {
        return (this._options & 2) != 0;
    }

    public boolean includesWidetableParams() {
        return this._hasWidetableParams;
    }
}

