/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.ParamFormatToken;
import com.sybase.jdbc2.tds.SrvDataFormat;
import com.sybase.jdbc2.tds.SrvFormatToken;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.util.Vector;

public class SrvParamFormatToken
extends ParamFormatToken
implements SrvFormatToken,
Dumpable {
    protected Vector _dataformats = new Vector();
    private long _len;
    protected int _numParams;

    public SrvParamFormatToken() {
    }

    public SrvParamFormatToken(TdsInputStream tdsInputStream) throws IOException {
        this._len = this.readLength(tdsInputStream);
        this._numParams = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numParams);
    }

    public void addDataFormats(TdsInputStream tdsInputStream, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this._dataformats.addElement(this.dataFormatFactory(tdsInputStream));
            ++n2;
        }
    }

    public void addFormat(DataFormat dataFormat) {
        this._dataformats.addElement(dataFormat);
    }

    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new SrvDataFormat(tdsInputStream);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(236)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "PARAMFMT Token (0x" + HexConverts.hexConvert(236, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "PARAMFMT Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._len);
            }
            dumpInfo.addInt("Number of Params", 2, this._numParams);
            int n = 0;
            while (n < this.getFormatCount()) {
                dumpInfo.addInfo("TDSFmt", 0, "Param " + (n + 1));
                DataFormat dataFormat = this.formatAt(n);
                dumpInfo.addInfo(((SrvDataFormat)dataFormat).dump(dumpFilter));
                ++n;
            }
        }
        return dumpInfo;
    }

    public DataFormat formatAt(int n) {
        return (SrvDataFormat)this._dataformats.elementAt(n);
    }

    public int getByteLength(int n) {
        DataFormat dataFormat = this.formatAt(n);
        return DataFormat.lengthSize(dataFormat._datatype);
    }

    public int getFormatCount() {
        return this._dataformats.size();
    }

    public long getLength() {
        int n = 2;
        int n2 = 0;
        while (n2 < this._dataformats.size()) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(n2);
            n += srvDataFormat.length();
            ++n2;
        }
        return n;
    }

    public int getTokenType() {
        return 236;
    }

    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(n);
            srvDataFormat.send(tdsOutputStream);
            ++n;
        }
    }
}

