/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.ParamFormatToken;
import com.sybase.jdbc2.tds.RowFormat2Token;
import com.sybase.jdbc2.tds.RowFormatToken;
import com.sybase.jdbc2.tds.SrvAcceptor;
import com.sybase.jdbc2.tds.SrvCapabilityToken;
import com.sybase.jdbc2.tds.SrvDataFormat;
import com.sybase.jdbc2.tds.SrvDataInputStream;
import com.sybase.jdbc2.tds.SrvDbrpcToken;
import com.sybase.jdbc2.tds.SrvDoneToken;
import com.sybase.jdbc2.tds.SrvEedToken;
import com.sybase.jdbc2.tds.SrvEnvChangeToken;
import com.sybase.jdbc2.tds.SrvErrorToken;
import com.sybase.jdbc2.tds.SrvEventListener;
import com.sybase.jdbc2.tds.SrvFormatToken;
import com.sybase.jdbc2.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc2.tds.SrvLanguageToken;
import com.sybase.jdbc2.tds.SrvLoginAckToken;
import com.sybase.jdbc2.tds.SrvLoginToken;
import com.sybase.jdbc2.tds.SrvLogoutToken;
import com.sybase.jdbc2.tds.SrvNotifier;
import com.sybase.jdbc2.tds.SrvParamFormat2Token;
import com.sybase.jdbc2.tds.SrvParamsToken;
import com.sybase.jdbc2.tds.SrvProtocolException;
import com.sybase.jdbc2.tds.SrvRequestListener;
import com.sybase.jdbc2.tds.SrvReturnStatusToken;
import com.sybase.jdbc2.tds.SrvRowFormat2Token;
import com.sybase.jdbc2.tds.SrvRowFormatToken;
import com.sybase.jdbc2.tds.SrvRowToken;
import com.sybase.jdbc2.tds.SrvSQLTypeFormatter;
import com.sybase.jdbc2.tds.SrvSQLTypeFormatter2;
import com.sybase.jdbc2.tds.SrvSession;
import com.sybase.jdbc2.tds.SrvTypeException;
import com.sybase.jdbc2.tds.Token;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SrvReceiver
implements SrvRequestListener,
Runnable {
    protected Hashtable _sessions = new Hashtable();
    protected Hashtable _regProcs = new Hashtable();
    protected Vector _acceptors = new Vector();
    private SrvNotifier _notifier = null;
    protected String _server = null;
    private boolean _running = false;

    public SrvReceiver(String string) {
        this._server = string;
    }

    protected void addRegprocListener(SrvSession srvSession, String string, int n) {
        Hashtable hashtable = null;
        Object object = this._regProcs;
        synchronized (object) {
            if (this._notifier == null) {
                this._notifier = new SrvNotifier();
                this._notifier.start();
            }
            if ((hashtable = (Hashtable)this._regProcs.get(string)) == null) {
                hashtable = new Hashtable();
                this._regProcs.put(string, hashtable);
            }
        }
        object = (SrvEventListener)hashtable.get(srvSession);
        if (object != null) {
            ((SrvEventListener)object)._options = n;
            return;
        }
        object = new SrvEventListener(srvSession, n, hashtable);
    }

    public void attention(SrvSession srvSession) {
        this.handleAttention(srvSession);
    }

    public DataFormat[] buildDataFormat(SrvSession srvSession, ResultSet resultSet) throws SrvTypeException, SQLException, IOException {
        SrvSQLTypeFormatter srvSQLTypeFormatter;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData instanceof RowFormat2Token) {
            SrvRowFormat2Token srvRowFormat2Token = new SrvRowFormat2Token();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter2(srvRowFormat2Token, srvSession.getClientCapability());
        } else {
            SrvRowFormatToken srvRowFormatToken = new SrvRowFormatToken();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter(srvRowFormatToken, srvSession.getClientCapability());
        }
        return srvSQLTypeFormatter.buildDataFormat(resultSet);
    }

    public void bulk(SrvSession srvSession, SrvDataInputStream srvDataInputStream) {
        this.handleBulk(srvSession, srvDataInputStream);
    }

    private String checkNullValue(String[] stringArray, int n) {
        if (stringArray == null) {
            return null;
        }
        return stringArray[n];
    }

    public void connect(SrvSession srvSession, SrvLoginToken srvLoginToken) {
        this.handleLogin(srvSession, srvLoginToken.getUser(), srvLoginToken.getPassword(), srvLoginToken.getHost(), srvLoginToken.getLocale(), srvLoginToken.getPacketSize());
    }

    public Token createMessage(SrvSession srvSession, int n, String string, String string2, String string3, int n2) {
        if (srvSession.getClientCapability()._respCaps.get(2)) {
            return new SrvErrorToken(n, 0, 20, string, string2, string3, 1);
        }
        return new SrvEedToken(n, 0, 20, "UNKWN", 0, string, string2, string3, 1);
    }

    public SrvSession createSession(InputStream inputStream, OutputStream outputStream) throws IOException {
        return this.startSession(new SrvSession(inputStream, outputStream, false, false));
    }

    public SrvSession createSession(Socket socket) throws IOException {
        return this.startSession(new SrvSession(socket.getInputStream(), socket.getOutputStream(), false, false));
    }

    public SrvSession createSession(Socket socket, boolean bl, boolean bl2) throws IOException {
        return this.startSession(new SrvSession(socket.getInputStream(), socket.getOutputStream(), bl, bl2));
    }

    public void disconnect(SrvSession srvSession, SrvLogoutToken srvLogoutToken) {
        this.handleDisconnect(srvSession, srvLogoutToken);
        if (srvLogoutToken != null) {
            try {
                srvSession.send(new SrvDoneToken(0, 0, 0));
            }
            catch (Exception exception) {}
        }
        srvSession.close();
        this.removeSession(srvSession);
    }

    public void error(SrvSession srvSession, IOException iOException) {
        this.handleError(srvSession, iOException);
    }

    protected int getMaxCharLength(Object[][] objectArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            String string = (String)objectArray[n3][n];
            if (n2 < string.length()) {
                n2 = string.length();
            }
            ++n3;
        }
        return n2 + 1;
    }

    protected Thread getSession(SrvSession srvSession) {
        return (Thread)this._sessions.get(srvSession);
    }

    public abstract void handleAttention(SrvSession var1);

    public abstract void handleBulk(SrvSession var1, SrvDataInputStream var2);

    public abstract void handleDisconnect(SrvSession var1, SrvLogoutToken var2);

    protected void handleError(SrvSession srvSession, IOException iOException) {
        try {
            if (iOException instanceof EOFException || iOException instanceof SrvProtocolException) {
                srvSession.close();
                this.removeSession(srvSession);
            } else if (iOException instanceof SrvTypeException) {
                srvSession.send(this.createMessage(srvSession, 32000, "Server error: " + iOException, "Unknown", "", 0));
                srvSession.close();
                this.removeSession(srvSession);
            } else if (iOException instanceof IOException) {
                srvSession.close();
                this.removeSession(srvSession);
            }
        }
        catch (Exception exception) {}
    }

    public abstract void handleLanguage(SrvSession var1, String var2, Object[] var3);

    public abstract void handleLogin(SrvSession var1, String var2, String var3, String var4, String var5, int var6);

    public abstract void handleRPC(SrvSession var1, SrvDbrpcToken var2, Object[] var3);

    public void language(SrvSession srvSession, SrvLanguageToken srvLanguageToken) {
        ParamFormatToken paramFormatToken = null;
        SrvJavaTypeFormatter srvJavaTypeFormatter = null;
        SrvParamsToken srvParamsToken = null;
        Object[] objectArray = new Object[]{};
        if (srvLanguageToken.hasParams()) {
            try {
                paramFormatToken = (ParamFormatToken)srvSession.receive();
                srvParamsToken = (SrvParamsToken)srvSession.receive();
            }
            catch (ClassCastException classCastException) {
                this.error(srvSession, new SrvProtocolException("Did not get PARAMFMT, PARAMFMT2, PARAMS tokens for LANGUAGE request"));
                return;
            }
            catch (IOException iOException) {
                this.error(srvSession, iOException);
                return;
            }
            try {
                srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvFormatToken)((Object)paramFormatToken), srvSession.getClientCapability());
                objectArray = srvJavaTypeFormatter.convertData(srvParamsToken);
            }
            catch (IOException iOException) {
                this.error(srvSession, iOException);
                return;
            }
        }
        this.handleLanguage(srvSession, srvLanguageToken.getLanguage().trim(), objectArray);
    }

    private SrvEnvChangeToken makeEnvChangeToken(int n) {
        String string = new Integer(n).toString();
        SrvEnvChangeToken srvEnvChangeToken = new SrvEnvChangeToken();
        srvEnvChangeToken.addVariable(4, "", string);
        return srvEnvChangeToken;
    }

    protected void notifyRegprocListener(String string, Object[] objectArray) {
        Hashtable hashtable = (Hashtable)this._regProcs.get(string);
        if (hashtable == null || hashtable.isEmpty()) {
            return;
        }
        this._notifier.queueNotifications(hashtable, string, objectArray);
    }

    protected void passthruResults(SrvSession srvSession, Statement statement, String string) throws IOException, SQLException {
        boolean bl = string == null ? ((PreparedStatement)statement).execute() : statement.execute(string);
        int n = 0;
        do {
            if (bl) {
                this.sendDone(srvSession, this.sendResults(srvSession, statement.getResultSet()), false, false, true);
                continue;
            }
            n = statement.getUpdateCount();
            this.sendDone(srvSession, n, false, false, true);
        } while ((bl = statement.getMoreResults()) || n != -1);
        this.sendDone(srvSession, 0, false, true, true);
    }

    public void registerAcceptor(SrvAcceptor srvAcceptor) {
        this._acceptors.addElement(srvAcceptor);
    }

    protected boolean removeRegprocListener(SrvSession srvSession, String string) {
        Hashtable hashtable = (Hashtable)this._regProcs.get(string);
        if (hashtable == null) {
            return false;
        }
        SrvEventListener srvEventListener = (SrvEventListener)hashtable.get(srvSession);
        if (srvEventListener != null) {
            srvEventListener.close();
            return true;
        }
        return false;
    }

    protected void removeSession(SrvSession srvSession) {
        srvSession.removeSrvRequestListener(this);
        srvSession.close();
        Thread thread = this.getSession(srvSession);
        Object v = this._sessions.remove(srvSession);
        thread.stop();
    }

    public void rpc(SrvSession srvSession, SrvDbrpcToken srvDbrpcToken) {
        String string;
        SrvFormatToken srvFormatToken = null;
        SrvJavaTypeFormatter srvJavaTypeFormatter = null;
        SrvParamsToken srvParamsToken = null;
        Object[] objectArray = new Object[]{};
        if (srvDbrpcToken.hasParams()) {
            try {
                srvFormatToken = (SrvFormatToken)((Object)srvSession.receive());
                srvDbrpcToken._hasWidetableParams = srvFormatToken instanceof SrvParamFormat2Token;
                srvParamsToken = (SrvParamsToken)srvSession.receive();
            }
            catch (ClassCastException classCastException) {
                this.error(srvSession, new SrvProtocolException("Did not get PARAMFMT,PARAMFMT2,PARAMS tokens for RPC request"));
                return;
            }
            catch (IOException iOException) {
                this.error(srvSession, iOException);
                return;
            }
            try {
                srvJavaTypeFormatter = new SrvJavaTypeFormatter(srvFormatToken, srvSession.getClientCapability());
                objectArray = srvJavaTypeFormatter.convertData(srvParamsToken);
            }
            catch (IOException iOException) {
                this.error(srvSession, iOException);
                return;
            }
        }
        if ((string = srvDbrpcToken.getName()).equals("sp_regwatch")) {
            this.addRegprocListener(srvSession, (String)objectArray[0], ((Short)objectArray[1]).intValue());
            try {
                this.sendRPCParams(srvSession, 0, null, null, true);
            }
            catch (Exception exception) {}
        } else if (string.equals("sp_regnowatch")) {
            boolean bl = this.removeRegprocListener(srvSession, (String)objectArray[0]);
            try {
                if (!bl) {
                    srvSession.send(this.createMessage(srvSession, 16126, "This connection was not registered for procedure " + objectArray[0], "Unknown", "sp_regnowatch", 0));
                }
                this.sendRPCParams(srvSession, 0, null, null, false);
                this.sendDone(srvSession, 0, !bl, true, true);
            }
            catch (Exception exception) {}
        } else {
            this.handleRPC(srvSession, srvDbrpcToken, objectArray);
            this.notifyRegprocListener(string, objectArray);
        }
    }

    public void run() {
        this._running = true;
        while (this._running) {
            try {
                SrvReceiver srvReceiver = this;
                synchronized (srvReceiver) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void sendDone(SrvSession srvSession, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        srvSession.sendDone(n, bl, bl2, bl3);
    }

    protected void sendLogin(SrvSession srvSession, SrvCapabilityToken srvCapabilityToken, String string, boolean bl, int n) throws IOException {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[1] = 1;
        byte[] byArray2 = byArray;
        if (srvCapabilityToken == null) {
            srvCapabilityToken = srvSession.getClientCapability();
        }
        int n2 = 0;
        if (bl) {
            SrvEnvChangeToken srvEnvChangeToken = this.makeEnvChangeToken(n);
            srvSession.send(srvEnvChangeToken);
            if (srvSession._encodingChanged) {
                srvEnvChangeToken = new SrvEnvChangeToken();
                srvEnvChangeToken.addVariable(3, "", srvSession.getCharset());
                srvSession.send(srvEnvChangeToken);
            }
            srvSession.send(new SrvLoginAckToken(5, string, byArray2));
            srvSession.send(srvCapabilityToken);
        } else {
            srvSession.send(new SrvLoginAckToken(6, string, byArray2));
            n2 = 2;
        }
        srvSession.send(new SrvDoneToken(n2, 0, 0));
    }

    public void sendMessage(SrvSession srvSession, int n, String string, String string2, int n2) throws IOException {
        srvSession.send(this.createMessage(srvSession, n, string, this._server, string2, n2));
    }

    public void sendParams(SrvSession srvSession, Object[] objectArray, Object[] objectArray2, int n) throws IOException {
        srvSession.sendParams(objectArray, objectArray2, n);
    }

    public void sendRPCParams(SrvSession srvSession, int n, Object[] objectArray, Object[] objectArray2, boolean bl) throws IOException {
        srvSession.send(new SrvReturnStatusToken(n));
        if (objectArray2 != null) {
            this.sendParams(srvSession, objectArray, objectArray2, 1);
            this.sendDone(srvSession, 1, false, false, true);
        }
        this.sendDone(srvSession, 0, false, bl, true);
    }

    public int sendResults(SrvSession srvSession, SrvFormatToken srvFormatToken, Object[][] objectArray) throws IOException, SrvTypeException, SQLException {
        Object var4_4 = null;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        SrvJavaTypeFormatter srvJavaTypeFormatter = null;
        if (!srvCapabilityToken._reqCaps.get(59) && srvCapabilityToken._respCaps.get(45) && srvFormatToken instanceof SrvRowFormat2Token) {
            throw new SrvTypeException("Attempt to send a SrvRowFormat2 token when widetable has been disabled.");
        }
        srvJavaTypeFormatter = srvFormatToken instanceof SrvRowFormat2Token ? new SrvJavaTypeFormatter((SrvRowFormat2Token)srvFormatToken, srvCapabilityToken) : new SrvJavaTypeFormatter((SrvRowFormatToken)srvFormatToken, srvCapabilityToken);
        if (srvFormatToken != null && srvFormatToken.getFormatCount() != objectArray[0].length) {
            throw new SrvTypeException("Number of names do not match number of data elements in results send");
        }
        srvSession.send((Token)((Object)srvFormatToken));
        SrvRowToken srvRowToken = new SrvRowToken();
        int n = 0;
        while (n < objectArray.length) {
            srvJavaTypeFormatter.convertData(srvRowToken, objectArray[n]);
            srvSession.send(srvRowToken);
            ++n;
        }
        return objectArray.length;
    }

    private int sendResults(SrvSession srvSession, SrvSQLTypeFormatter srvSQLTypeFormatter, RowFormatToken rowFormatToken, ResultSet resultSet) throws IOException, SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        if (n != ((SrvFormatToken)((Object)rowFormatToken)).getFormatCount()) {
            throw new SrvTypeException("Number of SrvDataFormat do not match number of data elements in results send");
        }
        srvSession.send(rowFormatToken);
        int n2 = 0;
        try {
            while (resultSet.next()) {
                SrvRowToken srvRowToken = new SrvRowToken();
                srvSQLTypeFormatter.convertData(srvRowToken, resultSet);
                srvSession.send(srvRowToken);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new SrvProtocolException("SQL error on next row fetch: " + sQLException);
        }
        return n2;
    }

    public int sendResults(SrvSession srvSession, ResultSet resultSet) throws IOException, SrvTypeException, SQLException {
        return this.sendResults(srvSession, this.buildDataFormat(srvSession, resultSet), resultSet);
    }

    public int sendResults(SrvSession srvSession, DataFormat[] dataFormatArray, ResultSet resultSet) throws IOException, SrvTypeException, SQLException {
        SrvSQLTypeFormatter srvSQLTypeFormatter;
        RowFormatToken rowFormatToken;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData instanceof RowFormat2Token) {
            rowFormatToken = new SrvRowFormat2Token();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter2((SrvFormatToken)((Object)rowFormatToken), srvSession.getClientCapability());
        } else {
            rowFormatToken = new SrvRowFormatToken();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter((SrvFormatToken)((Object)rowFormatToken), srvSession.getClientCapability());
        }
        int n = 0;
        while (n < dataFormatArray.length) {
            srvSQLTypeFormatter.addFormat(dataFormatArray[n]);
            ++n;
        }
        return this.sendResults(srvSession, srvSQLTypeFormatter, rowFormatToken, resultSet);
    }

    public int sendResults(SrvSession srvSession, SrvDataFormat[] srvDataFormatArray, ResultSet resultSet) throws IOException, SrvTypeException, SQLException {
        SrvSQLTypeFormatter srvSQLTypeFormatter;
        RowFormatToken rowFormatToken;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData instanceof RowFormat2Token) {
            rowFormatToken = new SrvRowFormat2Token();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter2((SrvFormatToken)((Object)rowFormatToken), srvSession.getClientCapability());
        } else {
            rowFormatToken = new SrvRowFormatToken();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter((SrvFormatToken)((Object)rowFormatToken), srvSession.getClientCapability());
        }
        int n = 0;
        while (n < srvDataFormatArray.length) {
            srvSQLTypeFormatter.addFormat(srvDataFormatArray[n]);
            ++n;
        }
        return this.sendResults(srvSession, srvSQLTypeFormatter, rowFormatToken, resultSet);
    }

    public int sendResults(SrvSession srvSession, SrvDataFormat[] srvDataFormatArray, Object[][] objectArray) throws IOException, SrvTypeException, SQLException {
        RowFormatToken rowFormatToken = null;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        rowFormatToken = srvCapabilityToken._reqCaps.get(59) && !srvCapabilityToken._respCaps.get(45) ? new SrvRowFormat2Token() : new SrvRowFormatToken();
        SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvFormatToken)((Object)rowFormatToken), srvCapabilityToken);
        if (srvDataFormatArray.length != objectArray[0].length) {
            throw new SrvTypeException("Number of SrvDataFormat do not match number of data elements in results send");
        }
        int n = 0;
        while (n < objectArray[0].length) {
            srvJavaTypeFormatter.addFormat(srvDataFormatArray[n]);
            ++n;
        }
        srvSession.send(rowFormatToken);
        SrvRowToken srvRowToken = new SrvRowToken();
        int n2 = 0;
        while (n2 < objectArray.length) {
            srvJavaTypeFormatter.convertData(srvRowToken, objectArray[n2]);
            srvSession.send(srvRowToken);
            ++n2;
        }
        return objectArray.length;
    }

    public int sendResults(SrvSession srvSession, String[] stringArray, Object[][] objectArray) throws IOException, SrvTypeException, SQLException {
        return this.sendResults(srvSession, stringArray, objectArray, null);
    }

    public int sendResults(SrvSession srvSession, String[] stringArray, Object[][] objectArray, String[] stringArray2) throws IOException, SrvTypeException, SQLException {
        RowFormatToken rowFormatToken = null;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        SrvJavaTypeFormatter srvJavaTypeFormatter = null;
        if (srvCapabilityToken._reqCaps.get(59) && !srvCapabilityToken._respCaps.get(45)) {
            rowFormatToken = new SrvRowFormat2Token();
            srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvRowFormat2Token)rowFormatToken, srvCapabilityToken);
        } else {
            rowFormatToken = new SrvRowFormatToken();
            srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvFormatToken)((Object)rowFormatToken), srvCapabilityToken);
        }
        if (stringArray != null && stringArray.length != objectArray[0].length) {
            throw new SrvTypeException("Number of names do not match number of data elements in results send");
        }
        if (stringArray2 != null && stringArray2.length != objectArray[0].length) {
            throw new SrvTypeException("Number of locales do not match number of data elements in results send");
        }
        int n = 0;
        while (n < objectArray[0].length) {
            int n2 = 0;
            if (objectArray[0][n] instanceof String) {
                n2 = this.getMaxCharLength(objectArray, n);
            }
            srvJavaTypeFormatter.addFormat(objectArray[0][n], this.checkNullValue(stringArray, n), 0, n2, this.checkNullValue(stringArray2, n));
            ++n;
        }
        srvSession.send(rowFormatToken);
        SrvRowToken srvRowToken = new SrvRowToken();
        int n3 = 0;
        while (n3 < objectArray.length) {
            srvJavaTypeFormatter.convertData(srvRowToken, objectArray[n3]);
            srvSession.send(srvRowToken);
            ++n3;
        }
        return objectArray.length;
    }

    public synchronized void shutdown() {
        Object object;
        Enumeration enumeration = this._acceptors.elements();
        while (enumeration.hasMoreElements()) {
            object = (SrvAcceptor)enumeration.nextElement();
            ((SrvAcceptor)object).shutdown();
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = this._sessions.keys();
        while (object.hasMoreElements()) {
            SrvSession srvSession = (SrvSession)object.nextElement();
            Thread thread = (Thread)this._sessions.get(srvSession);
            srvSession.close();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this._running = false;
        this.notifyAll();
    }

    protected SrvSession startSession(SrvSession srvSession) {
        srvSession.addSrvRequestListener(this);
        Thread thread = new Thread(srvSession);
        Thread thread2 = this._sessions.put(srvSession, thread);
        thread.start();
        return srvSession;
    }
}

