/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.RowFormat2Token;
import com.sybase.jdbc2.tds.SrvFormatToken;
import com.sybase.jdbc2.tds.SrvRowDataFormat2;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class SrvRowFormat2Token
extends RowFormat2Token
implements SrvFormatToken,
Dumpable {
    protected Vector _dataformats = new Vector();
    protected long _len;

    public SrvRowFormat2Token() throws SQLException {
    }

    public SrvRowFormat2Token(TdsInputStream tdsInputStream) throws IOException, SQLException {
        this._len = this.readLength(tdsInputStream);
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    public void addDataFormats(TdsInputStream tdsInputStream, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this._dataformats.addElement(this.dataFormatFactory(tdsInputStream));
            ++n2;
        }
    }

    public void addFormat(DataFormat dataFormat) {
        this._dataformats.addElement(dataFormat);
    }

    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new SrvRowDataFormat2(tdsInputStream);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(97)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ROWFMT2 Token (0x" + HexConverts.hexConvert(97, 1) + ");");
            } else {
                dumpInfo.addInfo("Token", 1, "ROWFMT2 Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 4, this._len);
            }
            dumpInfo.addInt("Number of Columns", 2, this._numColumns);
            int n = 0;
            while (n < this.getFormatCount()) {
                dumpInfo.addInfo("TDSFmt", 0, "Column " + (n + 1));
                DataFormat dataFormat = this.formatAt(n);
                dumpInfo.addInfo(((SrvRowDataFormat2)dataFormat).dump(dumpFilter));
                ++n;
            }
        }
        return dumpInfo;
    }

    public DataFormat formatAt(int n) {
        return this.getDataFormat(n);
    }

    public int getByteLength(int n) {
        DataFormat dataFormat = this.formatAt(n);
        return DataFormat.lengthSize(dataFormat._datatype);
    }

    protected DataFormat getDataFormat(int n) {
        return (SrvRowDataFormat2)this._dataformats.elementAt(n);
    }

    public int getFormatCount() {
        return this._dataformats.size();
    }

    public long getLength() {
        long l = 2L;
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvRowDataFormat2 srvRowDataFormat2 = (SrvRowDataFormat2)this._dataformats.elementAt(n);
            l += (long)srvRowDataFormat2.length();
            ++n;
        }
        return l;
    }

    public int getTokenType() {
        return 97;
    }

    public boolean hasKeyColumns() {
        boolean bl = false;
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvRowDataFormat2 srvRowDataFormat2 = (SrvRowDataFormat2)this._dataformats.elementAt(n);
            if ((srvRowDataFormat2._status & 2) != 0) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(97);
        tdsOutputStream.writeLongAsUnsignedInt(this.getLength());
        tdsOutputStream.writeShort(this._dataformats.size());
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvRowDataFormat2 srvRowDataFormat2 = (SrvRowDataFormat2)this._dataformats.elementAt(n);
            srvRowDataFormat2.send(tdsOutputStream);
            ++n;
        }
    }

    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        int n = 0;
        while (n < this._dataformats.size()) {
            SrvRowDataFormat2 srvRowDataFormat2 = (SrvRowDataFormat2)this._dataformats.elementAt(n);
            srvRowDataFormat2.send(tdsOutputStream);
            ++n;
        }
    }
}

