/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.telnet;

import com.oroinc.net.telnet.TelnetClient;
import com.oroinc.net.telnet.TelnetOption;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

final class TelnetInputStream
extends BufferedInputStream
implements Runnable {
    static final int _STATE_DATA = 0;
    static final int _STATE_IAC = 1;
    static final int _STATE_WILL = 2;
    static final int _STATE_WONT = 3;
    static final int _STATE_DO = 4;
    static final int _STATE_DONT = 5;
    static final int _STATE_SB = 6;
    static final int _STATE_SE = 7;
    static final int _STATE_CR = 8;
    private boolean __hasReachedEOF;
    private boolean __isClosed;
    private boolean __readIsWaiting;
    private int __receiveState;
    private int __queueHead;
    private int __queueTail;
    private int __bytesAvailable;
    private int[] __queue;
    private TelnetClient __client;
    private Thread __thread;
    private IOException __ioException;

    TelnetInputStream(InputStream inputStream, TelnetClient telnetClient) {
        super(inputStream);
        this.__client = telnetClient;
        this.__receiveState = 0;
        this.__isClosed = true;
        this.__hasReachedEOF = false;
        this.__queue = new int[2049];
        this.__queueHead = 0;
        this.__queueTail = 0;
        this.__bytesAvailable = 0;
        this.__ioException = null;
        this.__readIsWaiting = false;
        this.__thread = new Thread(this);
    }

    void _start() {
        this.__isClosed = false;
        int n = Thread.currentThread().getPriority() + 1;
        if (n > 10) {
            n = 10;
        }
        this.__thread.setPriority(n);
        this.__thread.setDaemon(true);
        this.__thread.start();
    }

    private int __read() throws IOException {
        int n;
        block31: while (true) {
            if ((n = super.read()) < 0) {
                return -1;
            }
            n &= 0xFF;
            switch (this.__receiveState) {
                case 8: {
                    if (n == 0) continue block31;
                }
                case 0: {
                    TelnetClient telnetClient;
                    if (n == 255) {
                        this.__receiveState = 1;
                        continue block31;
                    }
                    if (n == 13) {
                        telnetClient = this.__client;
                        synchronized (telnetClient) {
                            this.__receiveState = this.__client._requestedDont(TelnetOption.BINARY) ? 8 : 0;
                            break block31;
                        }
                    }
                    this.__receiveState = 0;
                    break block31;
                }
                case 1: {
                    switch (n) {
                        case 251: {
                            this.__receiveState = 2;
                            continue block31;
                        }
                        case 252: {
                            this.__receiveState = 3;
                            continue block31;
                        }
                        case 253: {
                            this.__receiveState = 4;
                            continue block31;
                        }
                        case 254: {
                            this.__receiveState = 5;
                            continue block31;
                        }
                        case 255: {
                            this.__receiveState = 0;
                        }
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 2: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processWill(n);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 3: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processWont(n);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 4: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processDo(n);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 5: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processDont(n);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
            }
            break;
        }
        return n;
    }

    public int read() throws IOException {
        int[] nArray = this.__queue;
        synchronized (nArray) {
            while (true) {
                if (this.__ioException != null) {
                    IOException iOException = this.__ioException;
                    this.__ioException = null;
                    throw iOException;
                }
                if (this.__bytesAvailable != 0) break;
                if (this.__hasReachedEOF) {
                    int n = -1;
                    Object var3_6 = null;
                    return n;
                }
                this.__queue.notify();
                try {
                    this.__readIsWaiting = true;
                    this.__queue.wait();
                    this.__readIsWaiting = false;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Fatal thread interruption during read.");
                }
            }
            int n = this.__queue[this.__queueHead];
            if (++this.__queueHead >= this.__queue.length) {
                this.__queueHead = 0;
            }
            --this.__bytesAvailable;
            int n2 = n;
            Object var3_7 = null;
            return n2;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 1) {
            return 0;
        }
        int[] nArray = this.__queue;
        synchronized (nArray) {
            if (n2 > this.__bytesAvailable) {
                n2 = this.__bytesAvailable;
            }
        }
        int n3 = this.read();
        if (n3 == -1) {
            return -1;
        }
        int n4 = n;
        do {
            byArray[n++] = (byte)n3;
        } while (--n2 > 0 && (n3 = this.read()) != -1);
        return n - n4;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        int[] nArray = this.__queue;
        synchronized (nArray) {
            int n = this.__bytesAvailable;
            Object var3_3 = null;
            return n;
        }
    }

    public void close() throws IOException {
        super.close();
        int[] nArray = this.__queue;
        synchronized (nArray) {
            this.__hasReachedEOF = true;
            if (this.__thread.isAlive()) {
                this.__isClosed = true;
                this.__thread.interrupt();
            }
            this.__queue.notifyAll();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

