/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Logger {
    private Writer writer_ = null;
    private int userId_ = -1;
    private SimpleDateFormat isoTimeFormat_;

    public Logger(BufferedWriter bufferedWriter) {
        this.writer_ = bufferedWriter;
        TimeZone.setDefault(TimeZone.getTimeZone("ECT"));
        this.isoTimeFormat_ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public Logger(String string) throws IOException {
        this(new FileWriter(string, true));
    }

    public Logger(Writer writer) throws IOException {
        this(new BufferedWriter(writer));
    }

    public Logger() {
        this((BufferedWriter)null);
    }

    public void setUserId(int n) {
        this.userId_ = n;
    }

    public void close() {
        if (this.writer_ != null) {
            try {
                this.writer_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.writer_ = null;
    }

    public void setWriter(Writer writer) {
        this.close();
        this.writer_ = writer;
    }

    public void logStart(String string) {
        this.logStart(string, "", "");
    }

    public void logStart(String string, Object object) {
        this.logStart(string, object, "");
    }

    public void logStart(String string, Object object, Object object2) {
        this.log(string + " started " + object + " " + object2);
    }

    public void logComplete(String string) {
        this.log(string + " completed");
    }

    public void logSuccess(String string) {
        this.log(string + " succeeded");
    }

    public void logFailure(String string) {
        this.log(string + " failed");
    }

    public void logException(String string, Exception exception) {
        this.log(string + " Exception: " + exception.getClass().getName() + ": " + exception.getMessage());
        exception.printStackTrace();
    }

    public void log(String string) {
        this.log(string, true);
    }

    public void log(String string, boolean bl) {
        String string2 = this.isoTimeFormat_.format(new Date());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(string2);
        stringBuffer.append(']');
        stringBuffer.append(' ');
        if (bl && this.userId_ >= 0) {
            stringBuffer.append(this.userId_);
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        try {
            System.out.println(stringBuffer.toString());
            stringBuffer.append('\n');
            if (this.writer_ != null) {
                this.writer_.write(stringBuffer.toString());
                this.writer_.flush();
            }
        }
        catch (IOException iOException) {
            System.out.println("Writing to log file failed");
        }
    }
}

