/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.AssocList;
import org.eso.ohs.core.utilities.DebugUtils;
import org.eso.ohs.core.utilities.FileIOUtils;
import org.eso.ohs.core.utilities.NotASCIIException;
import org.eso.ohs.core.utilities.TextUtils;

public class Paramfile {
    private static final String rcsid = "$Id: Paramfile.java,v 1.6 2004/04/26 15:52:54 amchavan Exp $";
    private static RE reKeyword_ = null;
    private static final int defaultMaxNumLines_ = 100;
    private static final int asciiTestLength_ = 256;
    private int maxNumLines_;
    private AssocList kvPairs_;
    private String pathname_ = "<unknown>";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$core$utilities$Paramfile == null ? (class$org$eso$ohs$core$utilities$Paramfile = Paramfile.class$("org.eso.ohs.core.utilities.Paramfile")) : class$org$eso$ohs$core$utilities$Paramfile));
    static /* synthetic */ Class class$org$eso$ohs$core$utilities$Paramfile;

    public Paramfile() {
        this.kvPairs_ = new AssocList();
    }

    public Paramfile(String string) throws IOException, NotASCIIException {
        this(string, 100);
    }

    public Paramfile(Reader reader) throws IOException, NotASCIIException {
        this(reader, 100);
    }

    public Paramfile(Reader reader, int n) throws IOException, NotASCIIException {
        if (reKeyword_ == null) {
            this.initRegExps();
        }
        this.maxNumLines_ = n;
        this.kvPairs_ = new AssocList();
        String string = FileIOUtils.fileToString(reader);
        this.matchLines(string);
    }

    public Paramfile(String string, int n) throws IOException, NotASCIIException {
        if (reKeyword_ == null) {
            this.initRegExps();
        }
        this.maxNumLines_ = n;
        this.kvPairs_ = new AssocList();
        this.pathname_ = string;
        String string2 = FileIOUtils.fileToString(string);
        this.matchLines(string2);
    }

    private void initRegExps() {
        String string = "\\w+";
        String string2 = "(" + string + "(\\." + string + ")*)";
        String string3 = "\\s";
        String string4 = "\\S";
        String string5 = string3 + "+";
        String string6 = ".*";
        String string7 = string2 + string5 + string6;
        try {
            reKeyword_ = new RE((Object)string7);
        }
        catch (REException rEException) {
            DebugUtils.stackTrace("Invalid regexp");
        }
    }

    public int getMaxNumLines() {
        return this.maxNumLines_;
    }

    public int getDefaultMaxNumLines() {
        return 100;
    }

    public String getValue(String string) {
        String string2 = (String)this.kvPairs_.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public String readLine(String string) {
        return this.getValue(string);
    }

    public String[] readKeywordValues(String string) {
        String[] stringArray = null;
        String string2 = this.getValue(string);
        stringArray = string2 != null ? new String[]{string2} : new String[]{};
        return stringArray;
    }

    public String[] getKeywords() {
        return this.kvPairs_.keys();
    }

    public int getKeywordNumber() {
        return this.kvPairs_.size();
    }

    public String[] getIdentifierList() {
        return this.kvPairs_.keys();
    }

    private boolean matchLine(String string, int n) throws NotASCIIException {
        Object var3_3 = null;
        Object var4_4 = null;
        String string2 = string.trim();
        String string3 = null;
        String string4 = null;
        if (string2.length() == 0 || string2.charAt(0) == '#') {
            return false;
        }
        if (!reKeyword_.isMatch((Object)string2)) {
            return false;
        }
        REMatch rEMatch = reKeyword_.getMatch((Object)string2);
        string3 = rEMatch.toString(1);
        int n2 = string3.length();
        string2 = string2.substring(n2).trim();
        int n3 = string2.length();
        int n4 = -1;
        if (string2.charAt(0) != '\"') {
            int n5 = 0;
            while (n5 < n3) {
                if (string2.charAt(n5) == ';' && string2.charAt(n5 - 1) != '\\') {
                    n4 = n5;
                    break;
                }
                ++n5;
            }
            string4 = n4 < 0 ? string2 : string2.substring(0, n4);
        } else {
            boolean bl = false;
            int n6 = 1;
            while (n6 < n3) {
                char c = string2.charAt(n6);
                if (bl) {
                    bl = false;
                } else if (c == '\\') {
                    bl = true;
                } else if (c == '\"') {
                    n4 = n6;
                    break;
                }
                ++n6;
            }
            if (n4 < 0) {
                String string5 = "No closing double-quote char at line " + n;
                throw new NotASCIIException(string5);
            }
            string4 = string2.substring(1, n4);
        }
        this.kvPairs_.put(string3, TextUtils.revertEscapedString(string4));
        return true;
    }

    private void matchLines(String string) throws NotASCIIException {
        int n = TextUtils.isASCIIPrintable(string, this.maxNumLines_);
        if (n >= 0) {
            throw new NotASCIIException("at char " + n);
        }
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl && string2.equals("\n")) {
                bl = false;
                continue;
            }
            bl = true;
            this.matchLine(string2, ++n2);
            if (n2 >= this.maxNumLines_) break;
        }
    }

    public static boolean isValidKeyword(String string) {
        boolean bl = true;
        if (string != null && string.length() != 0) {
            int n = 0;
            while (bl && n < string.length()) {
                char c = string.charAt(n);
                bl = Character.isLetterOrDigit(c) || c == '.';
                ++n;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        Paramfile paramfile = null;
        int n = 0;
        while (n < stringArray.length) {
            try {
                paramfile = new Paramfile(stringArray[n], 100000);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String[] stringArray2 = paramfile.getKeywords();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String string = stringArray2[n2];
                String string2 = paramfile.getValue(string);
                System.out.println(n2 + "/" + paramfile.getKeywordNumber() + " " + string + " " + string2);
                ++n2;
            }
            ++n;
        }
        paramfile.reportToString();
    }

    public void report() {
        stdlog_.debug((Object)this.reportToString());
    }

    public String reportToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=================Identifier List============\n");
        String[] stringArray = this.getIdentifierList();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = this.getValue(string);
            stringBuffer.append("" + n + "\t<" + string + ">\t\t<" + string2 + ">\n");
            ++n;
        }
        stringBuffer.append("============================================\n");
        return stringBuffer.toString();
    }

    public static void report(String string) {
        Paramfile paramfile = null;
        try {
            paramfile = new Paramfile(string);
        }
        catch (Exception exception) {
            System.out.println("Error reading param file: " + exception.toString());
        }
        System.out.println(paramfile.reportToString());
    }

    public String getPathname() {
        return this.pathname_;
    }

    private boolean includesWhitespace(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (Character.isWhitespace(c)) {
                return true;
            }
            c = stringCharacterIterator.next();
        }
        return false;
    }

    public boolean equals(Paramfile paramfile) {
        String[] stringArray;
        String[] stringArray2 = this.getKeywords();
        if (stringArray2.length != (stringArray = paramfile.getKeywords()).length) {
            return false;
        }
        int n = 0;
        while (n < stringArray2.length) {
            String string = stringArray2[n];
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (string.equals(stringArray[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            if (!this.getValue(string).equals(paramfile.getValue(string))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getKeywords();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = this.getValue(string);
            boolean bl = this.includesWhitespace(string2);
            stringBuffer.append(string);
            stringBuffer.append('\t');
            if (bl) {
                stringBuffer.append('\"');
            }
            stringBuffer.append(string2);
            if (bl) {
                stringBuffer.append('\"');
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString(String string) {
        if (string == null) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("# ");
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append('\n');
        }
        stringBuffer.append(this.toString());
        return stringBuffer.toString();
    }

    public void toFile(String string) throws IOException {
        this.toFile(string, null);
    }

    public void toFile(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        String string3 = this.toString(string2);
        fileOutputStream.write(string3.getBytes());
        fileOutputStream.close();
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, null);
    }

    public void writeTo(Writer writer, String string) throws IOException {
        String string2 = this.toString(string);
        writer.write(string2);
        writer.flush();
    }

    public void put(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            this.kvPairs_.put(string, string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

