/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.core.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.CommandExecutionException;
import org.eso.ohs.core.utilities.TextUtils;

public class RunCommand {
    private String[] commandTokenList_ = null;
    private String simpleCommand_ = null;
    private StringBuffer outString;
    private StringBuffer errString;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$core$utilities$RunCommand == null ? (class$org$eso$ohs$core$utilities$RunCommand = RunCommand.class$("org.eso.ohs.core.utilities.RunCommand")) : class$org$eso$ohs$core$utilities$RunCommand));
    static /* synthetic */ Class class$org$eso$ohs$core$utilities$RunCommand;

    public RunCommand(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.commandTokenList_ = stringArray;
        this.outString = new StringBuffer();
        this.errString = new StringBuffer();
    }

    public RunCommand(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.simpleCommand_ = string;
        this.outString = new StringBuffer();
        this.errString = new StringBuffer();
    }

    public String getOutput() {
        return this.outString.toString();
    }

    public boolean outputContains(String string) {
        boolean bl = false;
        if (string != null && this.outString.indexOf(string) >= 0) {
            bl = true;
        }
        return bl;
    }

    public String getCommand() {
        if (this.simpleCommand_ != null) {
            return this.simpleCommand_;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.commandTokenList_.length) {
            stringBuffer.append('\'');
            stringBuffer.append(this.commandTokenList_[n]);
            stringBuffer.append('\'');
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getError() {
        return this.errString.toString();
    }

    public void executeCmd(OutputStream outputStream) throws CommandExecutionException, IOException {
        stdlog_.debug((Object)("Executing: '" + this.getCommand() + "'"));
        Object var2_2 = null;
        Process process = null;
        BufferedInputStream bufferedInputStream = null;
        BufferedReader bufferedReader = null;
        if (this.simpleCommand_ != null) {
            process = Runtime.getRuntime().exec(this.simpleCommand_);
            this.checkProcessStream(outputStream, process, bufferedInputStream, bufferedReader);
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (this.commandTokenList_.length > n) {
                Vector<String> vector = new Vector<String>();
                int n4 = n2;
                while (n4 < this.commandTokenList_.length) {
                    n3 = n4 - n2;
                    n = n4 + 1;
                    if (this.commandTokenList_[n4].equals("&") || this.commandTokenList_[n4].equals(";")) {
                        n2 = n4 + 1;
                        break;
                    }
                    vector.addElement(this.commandTokenList_[n4]);
                    ++n4;
                }
                String[] stringArray = vector.toArray(new String[n3]);
                stdlog_.debug((Object)("execute " + TextUtils.arrayToString(stringArray, " ", false)));
                process = Runtime.getRuntime().exec(stringArray);
                this.checkProcessStream(outputStream, process, bufferedInputStream, bufferedReader);
            }
        }
    }

    private void checkProcessStream(OutputStream outputStream, Process process, BufferedInputStream bufferedInputStream, BufferedReader bufferedReader) throws CommandExecutionException, IOException {
        try {
            String string;
            int n;
            bufferedInputStream = new BufferedInputStream(process.getInputStream());
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            byte[] byArray = new byte[2048];
            while (-1 != (n = bufferedInputStream.read(byArray, 0, byArray.length))) {
                outputStream.write(byArray, 0, n);
            }
            while ((string = bufferedReader.readLine()) != null) {
                this.errString.append(string);
                this.errString.append('\n');
            }
            bufferedReader.close();
            int n2 = process.waitFor();
            n2 = process.exitValue();
            if (n2 != 0) {
                stdlog_.error((Object)("Exit value: '" + n2 + "'; should be 0: " + this.errString.toString()));
                throw new CommandExecutionException("\nCommand:" + this.getCommand() + "\n**********\n " + this.errString.toString());
            }
            if (this.errString.length() != 0) {
                stdlog_.error((Object)("Standard error message not empty:'" + this.errString + "'. Throw exception"));
                throw new CommandExecutionException("\nCommand:" + this.getCommand() + "\n**********\n " + this.errString.toString());
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            stdlog_.error((Object)illegalThreadStateException);
            throw new CommandExecutionException(illegalThreadStateException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            stdlog_.error((Object)interruptedException);
            throw new CommandExecutionException(interruptedException.getMessage());
        }
        catch (IOException iOException) {
            stdlog_.error((Object)iOException);
            throw iOException;
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public void executeCmd() throws CommandExecutionException, IOException {
        stdlog_.debug((Object)("Executing: '" + this.getCommand() + "'"));
        Object var1_1 = null;
        this.outString = new StringBuffer();
        this.errString = new StringBuffer();
        if (this.simpleCommand_ != null) {
            Process process = Runtime.getRuntime().exec(this.simpleCommand_);
            this.checkProcessStream(process);
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (this.commandTokenList_.length > n) {
                Vector<String> vector = new Vector<String>();
                int n4 = n2;
                while (n4 < this.commandTokenList_.length) {
                    n3 = n4 - n2;
                    n = n4 + 1;
                    if (this.commandTokenList_[n4].equals("&") || this.commandTokenList_[n4].equals(";")) {
                        n2 = n4 + 1;
                        break;
                    }
                    vector.addElement(this.commandTokenList_[n4]);
                    ++n4;
                }
                String[] stringArray = vector.toArray(new String[n3]);
                stdlog_.debug((Object)("execute " + TextUtils.arrayToString(stringArray, " ", false)));
                Process process = Runtime.getRuntime().exec(stringArray);
                this.checkProcessStream(process);
            }
        }
    }

    private void checkProcessStream(Process process) throws CommandExecutionException, IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string = bufferedReader.readLine();
            while (string != null) {
                this.outString.append(string);
                string = bufferedReader.readLine();
                if (string == null) continue;
                this.outString.append('\n');
            }
            if (this.outString.length() != 0) {
                stdlog_.debug((Object)"Standard output:");
                stdlog_.debug((Object)this.outString);
            }
            while ((string = bufferedReader2.readLine()) != null) {
                this.errString.append(string);
                this.errString.append('\n');
            }
            int n = process.waitFor();
            n = process.exitValue();
            if (n != 0) {
                stdlog_.error((Object)("Exit value: '" + n + "'; should be 0"));
                throw new CommandExecutionException("\nCommand:" + this.getCommand() + "\n**********\n " + this.errString.toString());
            }
            if (this.errString.length() != 0) {
                stdlog_.error((Object)("Standard error message not empty:'" + this.errString + "'. Throw exception"));
                throw new CommandExecutionException("\nCommand:" + this.getCommand() + "\n**********\n " + this.errString.toString());
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            stdlog_.error((Object)illegalThreadStateException);
            throw new CommandExecutionException(illegalThreadStateException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            stdlog_.error((Object)interruptedException);
            throw new CommandExecutionException(interruptedException.getMessage());
        }
        catch (IOException iOException) {
            stdlog_.error((Object)iOException);
            throw iOException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

