/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dfs.Affiliation;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.dfs.EsoUser;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class DbaseHandlerEsoUser
extends DbaseIOHandler {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerEsoUser == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerEsoUser = DbaseHandlerEsoUser.class$("org.eso.ohs.dbase.phase1.DbaseHandlerEsoUser")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerEsoUser));
    private static DbaseHandlerEsoUser singleton_ = null;
    public static final String ID = "id";
    public static final String ITEM_NAME = "item_name";
    public static final String SURNAME = "surname";
    public static final String SURNAME_DL = "surname_dl";
    public static final String IGNORED = "ignored";
    public static final String PASSWD = "item_password";
    public static final String REF_ACRONYM = "referee_acronym";
    public static final String EMAIL = "email";
    public static final String PANEL = "panel";
    public static final String CHAIR = "chair";
    public static final String USER_ID = "user_id";
    public static final String PERIOD = "period";
    public static final String CYCLE_ID = "cycle_id";
    public static final String CYCLE_LABEL = "label";
    public static final String COUNTRY = "country_code";
    public static final String AFFILIATION = "affiliation";
    public static final String ACCESSED_LETTER = "accessed_letter";
    public static final String ROLE = "letters_role";
    public static final String LOGIN = "login";
    protected static final String user_fields = Phase1SelectStmt.usersTable.get() + "." + "id" + "," + Phase1SelectStmt.usersTable.get() + "." + "item_name" + "," + Phase1SelectStmt.usersTable.get() + "." + "surname" + "," + Phase1SelectStmt.usersTable.get() + "." + "surname_dl" + "," + Phase1SelectStmt.usersTable.get() + "." + "item_password" + "," + Phase1SelectStmt.usersTable.get() + "." + "ignored" + "," + Phase1SelectStmt.usersTable.get() + "." + "email";
    protected static final String user_obsolete_fields = Phase1SelectStmt.usersTable.get() + "." + "referee_acronym" + "," + Phase1SelectStmt.usersTable.get() + "." + "panel" + "," + Phase1SelectStmt.usersTable.get() + "." + "chair";
    protected static final String user_select_sql = "SELECT DISTINCT " + user_fields;
    protected static final String user_sql = user_select_sql + "\n FROM " + Phase1SelectStmt.usersTable.get() + " ";
    protected static final String roles_fields = Phase1SelectStmt.esoUsersRolesTable.get() + "." + "login" + "," + Phase1SelectStmt.esoUsersRolesTable.get() + "." + "letters_role";
    protected static final String aff_fields = Phase1SelectStmt.affiliationsTable.get() + "." + "user_id" + "," + Phase1SelectStmt.affiliationsTable.get() + "." + "cycle_id" + "," + Phase1SelectStmt.affiliationsTable.get() + "." + "accessed_letter" + "," + Phase1SelectStmt.affiliationsTable.get() + "." + "period" + "," + Phase1SelectStmt.affiliationsTable.get() + "." + "country_code" + "," + Phase1SelectStmt.affiliationsTable.get() + "." + "affiliation";
    protected final String aff_obj_fields = aff_fields + "," + Phase1SelectStmt.cyclesTable.get() + "." + "label";
    protected final String aff_sql = "SELECT DISTINCT " + this.aff_obj_fields + " FROM " + Phase1SelectStmt.affiliationsTable.get() + ", " + Phase1SelectStmt.cyclesTable.get() + " ";
    protected final String role_sql = "SELECT DISTINCT " + roles_fields + " FROM " + Phase1SelectStmt.esoUsersRolesTable.get() + " ";
    private static boolean loadAffiliationAndRoles_ = true;
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerEsoUser;
    static /* synthetic */ Class class$org$eso$ohs$dfs$EsoUser;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$EsoUser == null ? (class$org$eso$ohs$dfs$EsoUser = DbaseHandlerEsoUser.class$("org.eso.ohs.dfs.EsoUser")) : class$org$eso$ohs$dfs$EsoUser;
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectIOException, ObjectNotFoundException, SQLException {
        EsoUser esoUser = (EsoUser)this.newInstance();
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(esoUser);
        String string = user_sql + " WHERE " + ID + " = " + l;
        stdlog_.debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Object not found in database");
        }
        esoUser.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$EsoUser == null ? (class$org$eso$ohs$dfs$EsoUser = DbaseHandlerEsoUser.class$("org.eso.ohs.dfs.EsoUser")) : class$org$eso$ohs$dfs$EsoUser));
        this.setUserFields(esoUser, resultSet);
        resultSet.close();
        if (DbaseHandlerEsoUser.isLoadAffiliationAndRoles()) {
            this.loadAffiliationsAndRoles(statement, esoUser, l);
        }
        return new StorageManager.UnpackedStorableObject(esoUser);
    }

    public StorageManager.UnpackedStorableObject[] read(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        if (string2 == null) {
            string2 = "";
        }
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        EsoUser esoUser = null;
        String string3 = DbaseHandlerEsoUser.buildSqlQuery(string, string2);
        stdlog_.debug((Object)string3);
        ResultSet resultSet = statement.executeQuery(string3);
        try {
            LinkedHashSet<EsoUser> linkedHashSet = new LinkedHashSet<EsoUser>();
            while (resultSet.next()) {
                esoUser = (EsoUser)this.newInstance();
                long l = resultSet.getInt(ID);
                esoUser.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$EsoUser == null ? DbaseHandlerEsoUser.class$("org.eso.ohs.dfs.EsoUser") : class$org$eso$ohs$dfs$EsoUser));
                this.setUserFields(esoUser, resultSet);
                linkedHashSet.add(esoUser);
            }
            resultSet.close();
            EsoUser[] esoUserArray = linkedHashSet.toArray(new EsoUser[linkedHashSet.size()]);
            unpackedStorableObjectArray = new StorageManager.UnpackedStorableObject[esoUserArray.length];
            int n = 0;
            while (n < unpackedStorableObjectArray.length) {
                esoUser = esoUserArray[n];
                if (DbaseHandlerEsoUser.isLoadAffiliationAndRoles()) {
                    this.loadAffiliationsAndRoles(statement, esoUser, Config.getCfg().uniqueToTableId(esoUser.getId()));
                }
                unpackedStorableObjectArray[n] = new StorageManager.UnpackedStorableObject(esoUser);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return unpackedStorableObjectArray;
    }

    public static String buildSqlQuery(String string, String string2) {
        return user_sql + string2 + "\n WHERE " + string;
    }

    protected void setUserFields(EsoUser esoUser, ResultSet resultSet) throws SQLException {
        esoUser.setItemName(resultSet.getString(ITEM_NAME));
        esoUser.setSurname(resultSet.getString(SURNAME));
        esoUser.setSurnameDL(resultSet.getString(SURNAME_DL));
        esoUser.setPassword(resultSet.getString(PASSWD).trim());
        esoUser.setTableId(resultSet.getInt(ID));
        esoUser.setIgnored(resultSet.getBoolean(IGNORED));
    }

    protected void loadAffiliationsAndRoles(Statement statement, EsoUser esoUser, long l) throws ObjectIOException, ObjectNotFoundException, SQLException {
        Vector<String> vector = new Vector<String>();
        String string = this.role_sql + " WHERE " + LOGIN + " = '" + l + "'";
        stdlog_.debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            vector.addElement(resultSet.getString(ROLE));
        }
        String[] stringArray = vector.toArray(new String[vector.size()]);
        esoUser.setRoles(stringArray);
        resultSet.close();
        Vector<Affiliation> vector2 = new Vector<Affiliation>();
        Object[] objectArray = null;
        String string2 = this.aff_sql + " WHERE " + USER_ID + " = " + l + " AND " + Phase1SelectStmt.affiliationsTable.get() + "." + CYCLE_ID + " = " + Phase1SelectStmt.cyclesTable.get() + ".id " + " ORDER BY " + CYCLE_ID;
        stdlog_.debug((Object)string2);
        ResultSet resultSet2 = statement.executeQuery(string2);
        Affiliation affiliation = null;
        while (resultSet2.next()) {
            affiliation = new Affiliation(resultSet2.getLong(USER_ID), resultSet2.getInt(PERIOD), resultSet2.getInt(CYCLE_ID), resultSet2.getString(COUNTRY), resultSet2.getString(AFFILIATION), resultSet2.getLong(ACCESSED_LETTER));
            affiliation.setCycleLabel(resultSet2.getString(CYCLE_LABEL));
            vector2.addElement(affiliation);
        }
        if (vector2.size() > 0) {
            objectArray = new Affiliation[vector2.size()];
            vector2.copyInto(objectArray);
        }
        resultSet2.close();
        esoUser.setAffiliationArray((Affiliation[])objectArray);
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        EsoUser esoUser = (EsoUser)unpackedStorableObject.getObject();
        String string = DbaseHandlerEsoUser.buildInsertStmt(l, esoUser);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"INSERT error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public static String buildInsertStmt(long l, EsoUser esoUser) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l);
        stringBuffer.append(",'");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getItemName()));
        stringBuffer.append("','");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getSurname()));
        stringBuffer.append("','");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getSurnameDL()));
        stringBuffer.append("','");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getPassword()));
        stringBuffer.append("',");
        stringBuffer.append(esoUser.getIgnored() ? 1 : 0);
        stringBuffer.append(",'");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getEmail()));
        stringBuffer.append("','', '',0 ");
        StringBuffer stringBuffer2 = DbaseHandlerEsoUser.insertAffiliationsStmt(esoUser, l);
        StringBuffer stringBuffer3 = DbaseHandlerEsoUser.updateRolesStmt(esoUser, l);
        String string = "  \n INSERT INTO " + Phase1SelectStmt.usersTable.get() + " (" + user_fields + ", " + user_obsolete_fields + " ) " + " VALUES (" + stringBuffer.toString() + " ) " + stringBuffer2.toString() + stringBuffer3.toString();
        stdlog_.debug((Object)string);
        return string;
    }

    private static StringBuffer insertAffiliationsStmt(EsoUser esoUser, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        Affiliation[] affiliationArray = esoUser.getAffiliationArray();
        int n = 0;
        while (n < affiliationArray.length) {
            String string = null;
            if (affiliationArray[n].getAccessedLetter() > 0L) {
                string = String.valueOf(affiliationArray[n].getAccessedLetter());
            }
            stringBuffer.append("\n ").append(" INSERT INTO ").append(Phase1SelectStmt.affiliationsTable.get()).append(" (").append(aff_fields).append(" ) ").append(" VALUES (").append(l).append(",").append(affiliationArray[n].getCycleId()).append(",").append(string).append(",").append(affiliationArray[n].getPeriod()).append(",'").append(TextUtils.quoteSqlString(affiliationArray[n].getCountryCode())).append("','").append(TextUtils.quoteSqlString(affiliationArray[n].getInstitution())).append("'").append(" ) ");
            ++n;
        }
        return stringBuffer;
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        EsoUser esoUser = (EsoUser)unpackedStorableObject.getObject();
        this.update(statement, esoUser);
    }

    public void update(Statement statement, StorableObject storableObject) throws ObjectIOException {
        EsoUser esoUser = (EsoUser)storableObject;
        String string = DbaseHandlerEsoUser.buildUpdateStmt(esoUser);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"INSERT error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public static String buildUpdateStmt(EsoUser esoUser) {
        long l = Config.getCfg().uniqueToTableId(esoUser.getId());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ITEM_NAME);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getItemName()));
        stringBuffer.append("',");
        stringBuffer.append(SURNAME);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getSurname()));
        stringBuffer.append("',");
        stringBuffer.append(SURNAME_DL);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getSurnameDL()));
        stringBuffer.append("',");
        stringBuffer.append(PASSWD);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getPassword()));
        stringBuffer.append("',");
        stringBuffer.append(EMAIL);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(esoUser.getEmail()));
        stringBuffer.append("',");
        stringBuffer.append(IGNORED);
        stringBuffer.append(" = ");
        stringBuffer.append(esoUser.getIgnored() ? 1 : 0);
        stringBuffer.append(" ");
        StringBuffer stringBuffer2 = DbaseHandlerEsoUser.updateAffilStmt(esoUser, l);
        StringBuffer stringBuffer3 = DbaseHandlerEsoUser.updateRolesStmt(esoUser, l);
        String string = "  \n UPDATE " + Phase1SelectStmt.usersTable.get() + " SET " + stringBuffer.toString() + " WHERE id = " + l + stringBuffer2.toString() + stringBuffer3.toString();
        stdlog_.debug((Object)string);
        return string;
    }

    private static StringBuffer updateAffilStmt(EsoUser esoUser, long l) {
        Affiliation[] affiliationArray = esoUser.getAffiliationArray();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" \n DELETE FROM ");
        stringBuffer.append(Phase1SelectStmt.affiliationsTable.get());
        stringBuffer.append(" WHERE user_id = ");
        stringBuffer.append(l);
        int n = 0;
        while (n < affiliationArray.length) {
            String string = "null";
            if (affiliationArray[n].getAccessedLetter() > 0L) {
                string = String.valueOf(affiliationArray[n].getAccessedLetter());
            }
            stringBuffer.append(" \n ").append(" INSERT INTO ").append(Phase1SelectStmt.affiliationsTable.get()).append(" (").append(aff_fields).append(" ) ").append(" VALUES (").append(l).append(",").append(affiliationArray[n].getCycleId()).append(",").append(string).append(",").append(affiliationArray[n].getPeriod()).append(",'").append(TextUtils.quoteSqlString(affiliationArray[n].getCountryCode())).append("','").append(TextUtils.quoteSqlString(affiliationArray[n].getInstitution())).append("'").append(" ) ");
            ++n;
        }
        return stringBuffer;
    }

    private static StringBuffer updateRolesStmt(EsoUser esoUser, long l) {
        String[] stringArray = esoUser.getRoles();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(" \n DELETE FROM ").append(Phase1SelectStmt.esoUsersRolesTable.get()).append(" WHERE login = '").append(l).append("' AND letters_role = '").append(stringArray[n]).append("'");
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringBuffer.append(" \n ");
            stringBuffer.append(" INSERT INTO ").append(Phase1SelectStmt.esoUsersRolesTable.get());
            stringBuffer.append(" (").append(roles_fields).append(" ) ").append(" VALUES ('").append(String.valueOf(l)).append("','").append(TextUtils.quoteSqlString(stringArray[n2])).append("')");
            ++n2;
        }
        return stringBuffer;
    }

    public void delete(Statement statement, long l) throws ObjectIOException {
        throw new ObjectIOException("Operation not supported for this object");
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return null;
    }

    public static DbaseHandlerEsoUser getDbaseHandlerEsoUser() {
        if (singleton_ == null) {
            singleton_ = new DbaseHandlerEsoUser();
        }
        return singleton_;
    }

    public static void setLoadAffiliationAndRoles(boolean bl) {
        loadAffiliationAndRoles_ = bl;
    }

    public static boolean isLoadAffiliationAndRoles() {
        return loadAffiliationAndRoles_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

