/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dfs.ObsRun;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;
import org.eso.ohs.phrs.common.SuspendedRunType;

public class DbaseHandlerObsRun
extends DbaseIOHandler {
    public static final String BASIC_FLAG = "00000000000000000";
    public static final String FLAGS = "flags";
    public static final float INTFLOAT_CONV = 10.0f;
    public static final float TIME_CONV = 10.0f;
    public static final String[] RUN_DESC = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final Integer[] RUN_DESC_INT = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24), new Integer(25), new Integer(26), new Integer(27)};
    static final String run_sql = "SELECT " + Phase1SelectStmt.runsTable.get() + ".id,  " + Phase1SelectStmt.runsTable.get() + ".run_desc, " + Phase1SelectStmt.runsTable.get() + ".note, " + Phase1SelectStmt.runsTable.get() + ".status, " + Phase1SelectStmt.runsTable.get() + ".run_code, " + Phase1SelectStmt.runsTable.get() + ".programme_id, " + "d_grade = " + Phase1SelectStmt.runsTable.get() + ".grade/" + 10.0f + ", " + Phase1SelectStmt.runsTable.get() + ".rank, " + Phase1SelectStmt.runsTable.get() + ".scheduled, " + Phase1SelectStmt.runsTable.get() + ".period, " + Phase1SelectStmt.runsTable.get() + ".supersede," + Phase1SelectStmt.runsTable.get() + ".assigned_time," + "d_assigned_time = " + Phase1SelectStmt.runsTable.get() + ".assigned_time/" + 10.0f + ", " + "d_sigma = " + Phase1SelectStmt.runsTable.get() + ".sigma/" + 10.0f + ", " + Phase1SelectStmt.runsTable.get() + ".obs_mode, " + Phase1SelectStmt.runsTable.get() + ".tel_code, " + Phase1SelectStmt.runsTable.get() + ".inst_code, " + Phase1SelectStmt.runsTable.get() + ".requested_time, " + Phase1SelectStmt.runsTable.get() + ".month, " + Phase1SelectStmt.runsTable.get() + ".moon, " + Phase1SelectStmt.runsTable.get() + ".seeing, " + Phase1SelectStmt.runsTable.get() + ".proprietary_time, " + Phase1SelectStmt.runsTable.get() + ".flags, " + Phase1SelectStmt.runsTable.get() + ".sky_transparency \n" + "FROM " + Phase1SelectStmt.runsTable.get() + " ";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerObsRun == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerObsRun = DbaseHandlerObsRun.class$("org.eso.ohs.dbase.phase1.DbaseHandlerObsRun")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerObsRun));
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerObsRun;
    static /* synthetic */ Class class$org$eso$ohs$dfs$ObsRun;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$ObsRun == null ? (class$org$eso$ohs$dfs$ObsRun = DbaseHandlerObsRun.class$("org.eso.ohs.dfs.ObsRun")) : class$org$eso$ohs$dfs$ObsRun;
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectNotFoundException, IOException, SQLException {
        ResultSet resultSet = null;
        ObsRun obsRun = (ObsRun)this.newInstance();
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(obsRun);
        String string = run_sql + "WHERE " + Phase1SelectStmt.runsTable.get() + ".id = " + l + "\n";
        stdlog_.debug((Object)string);
        resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Object not found in database");
        }
        obsRun.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$ObsRun == null ? (class$org$eso$ohs$dfs$ObsRun = DbaseHandlerObsRun.class$("org.eso.ohs.dfs.ObsRun")) : class$org$eso$ohs$dfs$ObsRun));
        this.setRunFields(obsRun, resultSet);
        resultSet.close();
        return unpackedStorableObject;
    }

    public StorageManager.UnpackedStorableObject[] read(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        if (string2 == null) {
            string2 = "";
        }
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        ObsRun obsRun = null;
        String string3 = DbaseHandlerObsRun.buildSqlQuery(string, string2);
        stdlog_.debug((Object)string3);
        ResultSet resultSet = statement.executeQuery(string3);
        try {
            Vector<ObsRun> vector = new Vector<ObsRun>();
            while (resultSet.next()) {
                obsRun = (ObsRun)this.newInstance();
                vector.addElement(obsRun);
                obsRun.setId(Config.getCfg().tableToUniqueId(resultSet.getInt("id"), class$org$eso$ohs$dfs$ObsRun == null ? DbaseHandlerObsRun.class$("org.eso.ohs.dfs.ObsRun") : class$org$eso$ohs$dfs$ObsRun));
                this.setRunFields(obsRun, resultSet);
            }
            resultSet.close();
            unpackedStorableObjectArray = new StorageManager.UnpackedStorableObject[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                obsRun = (ObsRun)vector.elementAt(n);
                unpackedStorableObjectArray[n] = new StorageManager.UnpackedStorableObject(obsRun);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return unpackedStorableObjectArray;
    }

    public static String buildSqlQuery(String string, String string2) {
        String string3 = run_sql + string2 + " WHERE " + string;
        return string3;
    }

    protected void setRunFields(ObsRun obsRun, ResultSet resultSet) throws SQLException {
        obsRun.setTableId(resultSet.getInt("id"));
        obsRun.setStatus(resultSet.getString("status"));
        obsRun.setGrade(resultSet.getFloat("d_grade"));
        obsRun.setScheduled(resultSet.getString("scheduled"));
        obsRun.setPeriod(resultSet.getInt("period"));
        obsRun.setShowCommentFlag(resultSet.getInt("supersede"));
        obsRun.setNote(resultSet.getString("note"));
        obsRun.setRank(resultSet.getInt("rank"));
        obsRun.setAssignedTime(resultSet.getFloat("d_assigned_time"));
        obsRun.setIntAssignedTime(resultSet.getInt("assigned_time"));
        obsRun.setSigma(resultSet.getFloat("d_sigma"));
        obsRun.setObsMode(resultSet.getString("obs_mode"));
        obsRun.setTelescope(resultSet.getString("tel_code"));
        obsRun.setInstrument(resultSet.getString("inst_code"));
        obsRun.setReqTime(resultSet.getString("requested_time"));
        obsRun.setMonth(resultSet.getString("month"));
        obsRun.setMoon(resultSet.getString("moon"));
        obsRun.setSeeing(resultSet.getString("seeing"));
        obsRun.setProprietaryTime(resultSet.getInt("proprietary_time"));
        obsRun.setSkyTransparency(resultSet.getString("sky_transparency"));
        obsRun.setProgrammeId(resultSet.getLong("programme_id"));
        obsRun.setRunDesc(resultSet.getString("run_desc"));
        obsRun.setRunCode(resultSet.getString("run_code"));
        String string = resultSet.getString(FLAGS);
        this.checkDelayedInstrument(obsRun, string);
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        stdlog_.debug((Object)("the obj must be saved with id " + l));
        ObsRun obsRun = (ObsRun)unpackedStorableObject.getObject();
        String string = DbaseHandlerObsRun.buildWriteStmt(obsRun);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"INSERT error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public static String buildWriteStmt(ObsRun obsRun) {
        long l = Config.getCfg().uniqueToTableId(obsRun.getId());
        Float f = new Float(obsRun.getGrade() * 10.0f);
        int n = f.intValue();
        Float f2 = new Float(obsRun.getSigma() * 10.0f);
        int n2 = f2.intValue();
        Float f3 = new Float(obsRun.getAssignedTime() * 10.0f);
        int n3 = f3.intValue();
        String string = DbaseHandlerObsRun.buildFlags(obsRun);
        String string2 = "  \n INSERT INTO " + Phase1SelectStmt.runsTable.get() + " (programme_id, run_desc, status, id, tel_code, \n" + "inst_code, requested_time, grade, assigned_time, \n" + "note, rank, scheduled, period, supersede, obs_mode, \n" + "month, moon, seeing, " + "rank_class, rated_flag, sigma, sky_transparency, \n" + "run_code, proprietary_time, flags) \n VALUES (" + obsRun.getProgrammeId() + ", '" + obsRun.getRunDesc() + "', '" + obsRun.getStatus() + "', " + l + ", '" + obsRun.getTelescope() + "', \n '" + obsRun.getInstrument() + "', '" + obsRun.getReqTime() + "', " + n + ", " + n3 + ",\n '" + obsRun.getNote() + "', " + obsRun.getRank() + ", '" + obsRun.getScheduled() + "'," + obsRun.getPeriod() + ", 0 , '" + obsRun.getObsMode() + "', '" + obsRun.getMonth() + "', '" + obsRun.getMoon() + "', '" + obsRun.getSeeing() + "', 'A', 0, " + n2 + ", '" + obsRun.getSkyTransparency() + "',\n '" + obsRun.getRunCode() + "', " + obsRun.getProprietaryTime() + ", '" + string + "')";
        stdlog_.debug((Object)string2);
        return string2;
    }

    private static String buildFlags(ObsRun obsRun) {
        StringBuffer stringBuffer = new StringBuffer(BASIC_FLAG);
        if (obsRun.isDelayedInstrument()) {
            stringBuffer.replace(0, 1, "1");
        }
        return stringBuffer.toString();
    }

    public void update(Statement statement, StorableObject storableObject) throws SQLException {
        ObsRun obsRun = (ObsRun)storableObject;
        ObsRun obsRun2 = (ObsRun)storableObject;
        String string = DbaseHandlerObsRun.buildFlags(obsRun2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" tel_code = '");
        stringBuffer.append(TextUtils.quoteSqlString(obsRun.getTelescope()));
        stringBuffer.append("', inst_code = '");
        stringBuffer.append(TextUtils.quoteSqlString(obsRun.getInstrument()));
        stringBuffer.append("', requested_time = '");
        stringBuffer.append(TextUtils.quoteSqlString(obsRun.getReqTime()));
        stringBuffer.append("', grade = ");
        stringBuffer.append(obsRun.getGrade() * 10.0f);
        stringBuffer.append(", assigned_time = ");
        stringBuffer.append(obsRun.getAssignedTime() * 10.0f);
        stringBuffer.append(", rank = ");
        stringBuffer.append(obsRun.getRank());
        stringBuffer.append(", proprietary_time = ");
        stringBuffer.append(obsRun.getProprietaryTime());
        stringBuffer.append(", scheduled = '");
        stringBuffer.append(TextUtils.quoteSqlString(obsRun.getScheduled()));
        stringBuffer.append("', period = ");
        stringBuffer.append(obsRun.getPeriod());
        stringBuffer.append(", supersede = ");
        stringBuffer.append(obsRun.getShowCommentFlag());
        stringBuffer.append(", status = '");
        stringBuffer.append(TextUtils.quoteSqlString(obsRun.getStatus()));
        stringBuffer.append("', obs_mode = '");
        stringBuffer.append(TextUtils.quoteSqlString(obsRun.getObsMode()));
        stringBuffer.append("', run_code = '");
        stringBuffer.append(TextUtils.quoteSqlString(obsRun.getRunCode()));
        stringBuffer.append("', sigma = ");
        stringBuffer.append(obsRun.getSigma() * 10.0f);
        stringBuffer.append(", flags = '");
        stringBuffer.append(TextUtils.quoteSqlString(string));
        stringBuffer.append("', note = '");
        stringBuffer.append(TextUtils.quoteSqlString(obsRun.getNote()));
        stringBuffer.append("'");
        stringBuffer.append("\n");
        String string2 = "UPDATE " + Phase1SelectStmt.runsTable.get() + "" + " SET " + stringBuffer + " WHERE id = " + Config.getCfg().uniqueToTableId(obsRun.getId());
        stdlog_.debug((Object)string2);
        statement.executeUpdate(string2);
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws SQLException {
        stdlog_.debug((Object)"update object");
        StorableObject storableObject = unpackedStorableObject.getObject();
        this.update(statement, storableObject);
        stdlog_.debug((Object)"update object done");
    }

    public static long buildRunId(long l, String string) throws ObjectIOException {
        int n = -1;
        long l2 = 0L;
        int n2 = 0;
        while (n2 < RUN_DESC.length) {
            if (string.equals(RUN_DESC[n2])) {
                n = RUN_DESC_INT[n2];
                break;
            }
            ++n2;
        }
        if (n < 0) {
            throw new ObjectIOException("run description invalid value must be [A-Z]: \"" + string + "\"");
        }
        l2 = (long)n + l * 10L;
        return l2;
    }

    public void delete(Statement statement, long l) throws ObjectIOException {
        throw new ObjectIOException("Operation not supported for this object");
    }

    private void checkDelayedInstrument(ObsRun obsRun, String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == SuspendedRunType.DELAYEDINSTRUMENT_FLAG) {
            obsRun.setDelayedInstrument(true);
        } else {
            obsRun.setDelayedInstrument(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

