/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase1.DbaseHandlerEsoUser;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dfs.OpcReferee;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class DbaseHandlerOpcReferee
extends DbaseIOHandler {
    private static final int MAX_PHASE1_CYCLES = 100000;
    DbaseHandlerEsoUser esoUserHandler = new DbaseHandlerEsoUser();
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerOpcReferee == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerOpcReferee = DbaseHandlerOpcReferee.class$("org.eso.ohs.dbase.phase1.DbaseHandlerOpcReferee")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerOpcReferee));
    private static DbaseHandlerOpcReferee singleton_ = new DbaseHandlerOpcReferee();
    public static final String CYCLE_LABEL = "label";
    public static final String CYCLE_ID = "cycle_id";
    public static final String USER_ID = "user_id";
    public static final String PANEL = "panel";
    public static final String EMAIL = "email";
    public static final String CHAIR = "chair";
    public static final String OPC_MEMBER = "opc_member";
    public static final String SUBPANEL = "opc_subpanel";
    public static final String ACRONYM = "acronym";
    protected static final String ref_fields = Phase1SelectStmt.refereesTable.get() + "." + "cycle_id" + "," + Phase1SelectStmt.refereesTable.get() + "." + "user_id" + "," + Phase1SelectStmt.refereesTable.get() + "." + "panel" + "," + Phase1SelectStmt.refereesTable.get() + "." + "opc_subpanel" + "," + Phase1SelectStmt.refereesTable.get() + "." + "email" + "," + Phase1SelectStmt.refereesTable.get() + "." + "acronym" + "," + Phase1SelectStmt.refereesTable.get() + "." + "opc_member" + "," + Phase1SelectStmt.refereesTable.get() + "." + "chair";
    protected static final String ref_select_sql = "SELECT DISTINCT " + ref_fields + "," + Phase1SelectStmt.cyclesTable.get() + "." + "label";
    protected static final String cycle_join = Phase1SelectStmt.refereesTable.get() + "." + "cycle_id" + " = " + Phase1SelectStmt.cyclesTable.get() + ".id ";
    protected static final String referee_sql = ref_select_sql + " FROM " + Phase1SelectStmt.refereesTable.get() + ", " + Phase1SelectStmt.cyclesTable.get() + " ";
    static /* synthetic */ Class class$org$eso$ohs$dfs$OpcReferee;
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerOpcReferee;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$OpcReferee == null ? (class$org$eso$ohs$dfs$OpcReferee = DbaseHandlerOpcReferee.class$("org.eso.ohs.dfs.OpcReferee")) : class$org$eso$ohs$dfs$OpcReferee;
    }

    public static int cycleIndexFromId(long l) {
        return (int)(l % 100000L);
    }

    public static long userIdFromId(long l) {
        return l / 100000L;
    }

    public static long idForPhase1Referee(long l, int n) {
        return l * 100000L + (long)n;
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectIOException, ObjectNotFoundException, SQLException {
        OpcReferee opcReferee = (OpcReferee)this.newInstance();
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(opcReferee);
        String string = referee_sql + " WHERE " + CYCLE_ID + " = " + DbaseHandlerOpcReferee.cycleIndexFromId(l) + " AND    " + cycle_join + " AND    " + USER_ID + "  = " + DbaseHandlerOpcReferee.userIdFromId(l);
        stdlog_.debug((Object)("read referee: " + string));
        stdlog_.debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Object not found in database");
        }
        opcReferee.setId(l);
        this.setRefFields(opcReferee, resultSet);
        resultSet.close();
        return new StorageManager.UnpackedStorableObject(opcReferee);
    }

    public StorageManager.UnpackedStorableObject[] read(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        OpcReferee opcReferee = null;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = referee_sql + string2 + " WHERE " + cycle_join + " AND " + string;
        stdlog_.debug((Object)string3);
        ResultSet resultSet = statement.executeQuery(string3);
        try {
            Vector<OpcReferee> vector = new Vector<OpcReferee>();
            while (resultSet.next()) {
                opcReferee = (OpcReferee)this.newInstance();
                vector.addElement(opcReferee);
                this.setRefFields(opcReferee, resultSet);
                long l = DbaseHandlerOpcReferee.idForPhase1Referee(resultSet.getLong(USER_ID), resultSet.getInt(CYCLE_ID));
                opcReferee.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$OpcReferee == null ? DbaseHandlerOpcReferee.class$("org.eso.ohs.dfs.OpcReferee") : class$org$eso$ohs$dfs$OpcReferee));
            }
            resultSet.close();
            unpackedStorableObjectArray = new StorageManager.UnpackedStorableObject[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                opcReferee = (OpcReferee)vector.elementAt(n);
                unpackedStorableObjectArray[n] = new StorageManager.UnpackedStorableObject(opcReferee);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return unpackedStorableObjectArray;
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        OpcReferee opcReferee = (OpcReferee)unpackedStorableObject.getObject();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DbaseHandlerOpcReferee.cycleIndexFromId(l));
        stringBuffer.append(",");
        stringBuffer.append(DbaseHandlerOpcReferee.userIdFromId(l));
        stringBuffer.append(",'");
        stringBuffer.append(TextUtils.quoteSqlString(opcReferee.getPanel()));
        stringBuffer.append("',");
        stringBuffer.append(opcReferee.getOpcSubpanel());
        stringBuffer.append(",'");
        stringBuffer.append(TextUtils.quoteSqlString(opcReferee.getEmail()));
        stringBuffer.append("','");
        stringBuffer.append(TextUtils.quoteSqlString(opcReferee.getRefereeAcronym()));
        stringBuffer.append("',");
        stringBuffer.append(opcReferee.getOpcMember() ? 1 : 0);
        stringBuffer.append(",");
        stringBuffer.append(opcReferee.getChair() ? 1 : 0);
        stringBuffer.append(" ");
        String string = "  \n INSERT INTO " + Phase1SelectStmt.refereesTable.get() + " (" + ref_fields + " ) " + " VALUES (" + stringBuffer.toString() + " ) ";
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"update error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        OpcReferee opcReferee = (OpcReferee)unpackedStorableObject.getObject();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PANEL);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(opcReferee.getPanel()));
        stringBuffer.append("',");
        stringBuffer.append(SUBPANEL);
        stringBuffer.append(" = ");
        stringBuffer.append(opcReferee.getOpcSubpanel());
        stringBuffer.append(",");
        stringBuffer.append(EMAIL);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(opcReferee.getEmail()));
        stringBuffer.append("',");
        stringBuffer.append(ACRONYM);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(opcReferee.getRefereeAcronym()));
        stringBuffer.append("',");
        stringBuffer.append(OPC_MEMBER);
        stringBuffer.append(" = ");
        stringBuffer.append(opcReferee.getOpcMember() ? 1 : 0);
        stringBuffer.append(",");
        stringBuffer.append(CHAIR);
        stringBuffer.append(" = ");
        stringBuffer.append(opcReferee.getChair() ? 1 : 0);
        stringBuffer.append(" ");
        String string = "  \n UPDATE  " + Phase1SelectStmt.refereesTable.get() + " SET " + stringBuffer.toString() + " WHERE " + CYCLE_ID + " = " + DbaseHandlerOpcReferee.cycleIndexFromId(l) + " AND    " + USER_ID + "  = " + DbaseHandlerOpcReferee.userIdFromId(l);
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"update error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public void delete(Statement statement, long l) throws ObjectIOException {
        String string = "  \n  \n DELETE  FROM " + Phase1SelectStmt.refereesTable.get() + " WHERE " + CYCLE_ID + " = " + DbaseHandlerOpcReferee.cycleIndexFromId(l) + " AND    " + USER_ID + "  = " + DbaseHandlerOpcReferee.userIdFromId(l);
        stdlog_.debug((Object)string);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"update error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    protected void setRefFields(OpcReferee opcReferee, ResultSet resultSet) throws SQLException {
        opcReferee.setOpcSubpanel(resultSet.getInt(SUBPANEL));
        opcReferee.setPanel(resultSet.getString(PANEL));
        opcReferee.setEmail(resultSet.getString(EMAIL));
        opcReferee.setRefereeAcronym(resultSet.getString(ACRONYM));
        opcReferee.setChair(resultSet.getBoolean(CHAIR));
        opcReferee.setOpcMember(resultSet.getBoolean(OPC_MEMBER));
        opcReferee.setUserId(resultSet.getLong(USER_ID));
        opcReferee.setCycleId(resultSet.getInt(CYCLE_ID));
        opcReferee.setCycleLabel(resultSet.getString(CYCLE_LABEL));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

