/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.core.utilities.TextUtils;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase1.Phase1SelectStmt;
import org.eso.ohs.dfs.BusinessVisitor;
import org.eso.ohs.dfs.Phase1Target;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.eso.ohs.persistence.StorageManager;

public class DbaseHandlerPhase1Target
extends DbaseIOHandler {
    private static long MAX_PHASE1_TARGET = 10000L;
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase1$DbaseHandlerPhase1Target == null ? (class$org$eso$ohs$dbase$phase1$DbaseHandlerPhase1Target = DbaseHandlerPhase1Target.class$("org.eso.ohs.dbase.phase1.DbaseHandlerPhase1Target")) : class$org$eso$ohs$dbase$phase1$DbaseHandlerPhase1Target));
    private static DbaseHandlerPhase1Target singleton_ = null;
    private static String PROG_ID = "programme_id";
    public static final String ID = "id";
    public static final String ITEM_NAME = "item_name";
    public static final String R_A = "r_a";
    public static final String DEC = "dec";
    public static final String MAGNITUDE = "magnitude";
    public static final String DIAMETER = "angular_diam";
    public static final String COMMENT = "comments";
    public static final String EQUINOX = "equinox";
    public static final String TIME_ON_TARGET = "time_targets";
    public static final String RUN_REFERENCES = "run_references";
    public static final String REF_STARS_NAME = "item_name";
    public static final String REF_STARS_TARGET_ID = "target_id";
    private static String REF_STARS_PROG_ID = "programme_id";
    protected static final String target_fields = Phase1SelectStmt.targetsTable.get() + "." + "id" + "," + Phase1SelectStmt.targetsTable.get() + "." + PROG_ID + "," + Phase1SelectStmt.targetsTable.get() + "." + "item_name" + "," + Phase1SelectStmt.targetsTable.get() + "." + "r_a" + "," + Phase1SelectStmt.targetsTable.get() + "." + "dec" + "," + Phase1SelectStmt.targetsTable.get() + "." + "time_targets" + "," + Phase1SelectStmt.targetsTable.get() + "." + "magnitude" + "," + Phase1SelectStmt.targetsTable.get() + "." + "angular_diam" + "," + Phase1SelectStmt.targetsTable.get() + "." + "comments" + ",\n" + Phase1SelectStmt.targetsTable.get() + "." + "equinox" + "," + Phase1SelectStmt.targetsTable.get() + "." + "run_references";
    protected static final String star_fields = Phase1SelectStmt.targetsTable.get() + "." + "target_id" + "," + Phase1SelectStmt.targetsTable.get() + "." + REF_STARS_PROG_ID + "," + Phase1SelectStmt.targetsTable.get() + "." + "item_name";
    protected final String target_select_sql = "SELECT DISTINCT " + target_fields;
    protected final String target_sql = this.target_select_sql + "\n FROM " + Phase1SelectStmt.targetsTable.get() + " ";
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase1$DbaseHandlerPhase1Target;
    static /* synthetic */ Class class$org$eso$ohs$dfs$Phase1Target;

    public Class getManagedClass() {
        return class$org$eso$ohs$dfs$Phase1Target == null ? (class$org$eso$ohs$dfs$Phase1Target = DbaseHandlerPhase1Target.class$("org.eso.ohs.dfs.Phase1Target")) : class$org$eso$ohs$dfs$Phase1Target;
    }

    public static int targetIdFromId(long l) {
        return (int)(l % MAX_PHASE1_TARGET);
    }

    public static long programmeIdFromId(long l) {
        return l / MAX_PHASE1_TARGET;
    }

    public static long idForPhase1Target(long l, long l2) {
        return l2 * MAX_PHASE1_TARGET + l;
    }

    public StorageManager.UnpackedStorableObject read(Statement statement, long l) throws ObjectIOException, ObjectNotFoundException, SQLException {
        Phase1Target phase1Target = (Phase1Target)this.newInstance();
        StorageManager.UnpackedStorableObject unpackedStorableObject = new StorageManager.UnpackedStorableObject(phase1Target);
        String string = this.target_sql + " WHERE " + ID + " = " + DbaseHandlerPhase1Target.targetIdFromId(l) + " AND " + PROG_ID + " = " + DbaseHandlerPhase1Target.programmeIdFromId(l);
        stdlog_.debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Object not found in database");
        }
        phase1Target.setId(Config.getCfg().tableToUniqueId(l, class$org$eso$ohs$dfs$Phase1Target == null ? (class$org$eso$ohs$dfs$Phase1Target = DbaseHandlerPhase1Target.class$("org.eso.ohs.dfs.Phase1Target")) : class$org$eso$ohs$dfs$Phase1Target));
        this.setTargetFields(phase1Target, resultSet);
        resultSet.close();
        this.loadReferenceStars(statement, phase1Target);
        return new StorageManager.UnpackedStorableObject(phase1Target);
    }

    public StorageManager.UnpackedStorableObject[] read(Statement statement, String string, String string2) throws ObjectIOException, ObjectNotFoundException, SQLException {
        if (string2 == null) {
            string2 = "";
        }
        StorageManager.UnpackedStorableObject[] unpackedStorableObjectArray = null;
        Phase1Target phase1Target = null;
        String string3 = this.target_sql + string2 + "\n WHERE " + string;
        stdlog_.debug((Object)string3);
        ResultSet resultSet = statement.executeQuery(string3);
        try {
            LinkedHashSet<Phase1Target> linkedHashSet = new LinkedHashSet<Phase1Target>();
            while (resultSet.next()) {
                phase1Target = (Phase1Target)this.newInstance();
                long l = resultSet.getInt(ID);
                long l2 = resultSet.getInt(PROG_ID);
                phase1Target.setId(Config.getCfg().tableToUniqueId(DbaseHandlerPhase1Target.idForPhase1Target(l, l2), class$org$eso$ohs$dfs$Phase1Target == null ? DbaseHandlerPhase1Target.class$("org.eso.ohs.dfs.Phase1Target") : class$org$eso$ohs$dfs$Phase1Target));
                this.setTargetFields(phase1Target, resultSet);
                linkedHashSet.add(phase1Target);
            }
            resultSet.close();
            Phase1Target[] phase1TargetArray = linkedHashSet.toArray(new Phase1Target[linkedHashSet.size()]);
            unpackedStorableObjectArray = new StorageManager.UnpackedStorableObject[phase1TargetArray.length];
            int n = 0;
            while (n < unpackedStorableObjectArray.length) {
                phase1Target = phase1TargetArray[n];
                this.loadReferenceStars(statement, phase1Target);
                unpackedStorableObjectArray[n] = new StorageManager.UnpackedStorableObject(phase1Target);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)sQLException);
            throw new ObjectIOException(sQLException);
        }
        return unpackedStorableObjectArray;
    }

    protected void setTargetFields(Phase1Target phase1Target, ResultSet resultSet) throws SQLException {
        phase1Target.setTargetId(resultSet.getInt(ID));
        phase1Target.setProgId(resultSet.getInt(PROG_ID));
        phase1Target.setItemName(resultSet.getString("item_name"));
        phase1Target.setRa(resultSet.getInt(R_A));
        phase1Target.setDeclination(resultSet.getInt(DEC));
        phase1Target.setTimeOnTarget(resultSet.getInt(TIME_ON_TARGET));
        phase1Target.setMagnitude(resultSet.getString(MAGNITUDE));
        phase1Target.setDiameter(resultSet.getString(DIAMETER));
        phase1Target.setUserComment(resultSet.getString(COMMENT));
        phase1Target.setEquinox(resultSet.getDouble(EQUINOX));
        phase1Target.setMagnitude(resultSet.getString(MAGNITUDE));
    }

    protected void loadReferenceStars(Statement statement, Phase1Target phase1Target) throws ObjectIOException, ObjectNotFoundException, SQLException {
        Vector vector = new Vector();
        String string = star_fields + " WHERE " + REF_STARS_TARGET_ID + " = " + phase1Target.getTargetId() + " AND " + REF_STARS_PROG_ID + " = " + phase1Target.getProgId();
        stdlog_.debug((Object)string);
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Object not found in database");
        }
        String string2 = resultSet.getString("item_name");
        phase1Target.setReferenceStar(string2);
        resultSet.close();
    }

    public void write(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        Phase1Target phase1Target = (Phase1Target)unpackedStorableObject.getObject();
        String string = DbaseHandlerPhase1Target.buildInsertStmt(phase1Target);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"INSERT error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public static String buildInsertStmt(Phase1Target phase1Target) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(phase1Target.getTargetId());
        stringBuffer.append(",");
        stringBuffer.append(phase1Target.getProgId());
        stringBuffer.append(",'");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getItemName()));
        stringBuffer.append("',");
        stringBuffer.append(phase1Target.getRa());
        stringBuffer.append(",");
        stringBuffer.append(phase1Target.getDeclination());
        stringBuffer.append(",");
        stringBuffer.append(phase1Target.getTimeOnTarget());
        stringBuffer.append(",'");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getMagnitude()));
        stringBuffer.append("','");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getDiameter()));
        stringBuffer.append("','");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getUserComment()));
        stringBuffer.append("',");
        stringBuffer.append(phase1Target.getEquinox());
        stringBuffer.append(",'");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getRunReferences()));
        stringBuffer.append("'");
        StringBuffer stringBuffer2 = DbaseHandlerPhase1Target.insertStarsStmt(phase1Target);
        String string = "INSERT INTO " + Phase1SelectStmt.targetsTable.get() + " (" + target_fields + " ) \n" + " VALUES (" + stringBuffer.toString() + " )\n " + stringBuffer2.toString();
        stdlog_.debug((Object)string);
        return string;
    }

    private static StringBuffer insertStarsStmt(Phase1Target phase1Target) {
        StringBuffer stringBuffer = new StringBuffer();
        phase1Target.getReferenceStar();
        stringBuffer.append("\n ").append(" INSERT INTO ").append(Phase1SelectStmt.refStarTable.get()).append(" (").append(star_fields).append(" ) ").append(" VALUES (").append(phase1Target.getTargetId()).append(",").append(phase1Target.getProgId()).append(",'").append(TextUtils.quoteSqlString(phase1Target.getReferenceStar())).append("')");
        return stringBuffer;
    }

    public void update(Statement statement, long l, StorageManager.UnpackedStorableObject unpackedStorableObject) throws ObjectIOException {
        Phase1Target phase1Target = (Phase1Target)unpackedStorableObject.getObject();
        this.update(statement, phase1Target);
    }

    public void update(Statement statement, StorableObject storableObject) throws ObjectIOException {
        Phase1Target phase1Target = (Phase1Target)storableObject;
        String string = DbaseHandlerPhase1Target.buildUpdateStmt(phase1Target);
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            stdlog_.error((Object)"INSERT error", (Throwable)sQLException);
            throw new ObjectIOException("Error executing write: " + string);
        }
    }

    public static String buildUpdateStmt(Phase1Target phase1Target) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("item_name");
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getItemName()));
        stringBuffer.append("',");
        stringBuffer.append(R_A);
        stringBuffer.append(" = ");
        stringBuffer.append(phase1Target.getRa());
        stringBuffer.append(",");
        stringBuffer.append(DEC);
        stringBuffer.append(" = ");
        stringBuffer.append(phase1Target.getDeclination());
        stringBuffer.append(",");
        stringBuffer.append(TIME_ON_TARGET);
        stringBuffer.append(" = ");
        stringBuffer.append(phase1Target.getTimeOnTarget());
        stringBuffer.append(",");
        stringBuffer.append(MAGNITUDE);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getMagnitude()));
        stringBuffer.append(",");
        stringBuffer.append(DIAMETER);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getDiameter()));
        stringBuffer.append(",");
        stringBuffer.append(EQUINOX);
        stringBuffer.append(" = ");
        stringBuffer.append(phase1Target.getEquinox());
        stringBuffer.append(",");
        stringBuffer.append(COMMENT);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getUserComment()));
        stringBuffer.append("',");
        stringBuffer.append(RUN_REFERENCES);
        stringBuffer.append(" = '");
        stringBuffer.append(TextUtils.quoteSqlString(phase1Target.getRunReferences()));
        stringBuffer.append("' ");
        String string = DbaseHandlerPhase1Target.updateRefStarStmt(phase1Target);
        String string2 = string + " \n " + "UPDATE " + Phase1SelectStmt.targetsTable.get() + " SET " + stringBuffer.toString() + " WHERE " + ID + " = " + phase1Target.getTargetId() + " AND " + PROG_ID + " = " + phase1Target.getProgId();
        stdlog_.debug((Object)string2);
        return string2;
    }

    private static String updateRefStarStmt(Phase1Target phase1Target) {
        String string = "UPDATE " + Phase1SelectStmt.targetsTable.get() + " SET " + "item_name" + " = '" + phase1Target.getReferenceStar() + "' WHERE " + REF_STARS_TARGET_ID + " = " + phase1Target.getTargetId() + " AND " + REF_STARS_TARGET_ID + " = " + phase1Target.getProgId();
        return string;
    }

    public void delete(Statement statement, long l) throws ObjectIOException {
        throw new ObjectIOException("Operation not supported for this object");
    }

    public Object accept(BusinessVisitor businessVisitor, Object object) {
        return null;
    }

    public static DbaseHandlerPhase1Target getDbaseHandlerEsoUser() {
        if (singleton_ == null) {
            singleton_ = new DbaseHandlerPhase1Target();
        }
        return singleton_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

