/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.dbase.phase2;

import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.apps.OHSApplication;
import org.eso.ohs.core.utilities.Convert;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.dbase.DbaseIOHandler;
import org.eso.ohs.dbase.phase2.InstrumentPackageDBIO;
import org.eso.ohs.dbase.phase2.USDFileDBIO;
import org.eso.ohs.dfs.CommentDetails;
import org.eso.ohs.dfs.ObservationBlock;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.Readme;
import org.eso.ohs.dfs.ReadmeHistory;
import org.eso.ohs.instruments.AttribComparison;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.InstrumentList;
import org.eso.ohs.instruments.ReadmeAttribComparison;
import org.eso.ohs.instruments.ReadmeAttribute;
import org.eso.ohs.instruments.ReadmeAttributesFactory;
import org.eso.ohs.persistence.Config;
import org.eso.ohs.persistence.ObjectNotFoundException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class ReadmeFileDBIO {
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$dbase$phase2$ReadmeFileDBIO == null ? (class$org$eso$ohs$dbase$phase2$ReadmeFileDBIO = ReadmeFileDBIO.class$("org.eso.ohs.dbase.phase2.ReadmeFileDBIO")) : class$org$eso$ohs$dbase$phase2$ReadmeFileDBIO));
    private static String obrepDbName = Config.getCfg().getDbName(ObservationBlock.getSuffix());
    public static String readmeFile = obrepDbName + "..readme";
    private static String readmeStatusHistory = obrepDbName + "..readme_status_history";
    private static String readmeHistory = obrepDbName + "..readme_history";
    public static String RP = obrepDbName + "..readme_replicate";
    private static String OB = obrepDbName + "..obs_blocks";
    public static String usgFile = obrepDbName + "..usg_file";
    static /* synthetic */ Class class$org$eso$ohs$dbase$phase2$ReadmeFileDBIO;

    public static Readme read(Connection connection, ObservingRun observingRun) throws SQLException, ObjectIOException, JDOMException, IOException {
        ReadmeFileDBIO.setTextSize(connection);
        Object var2_2 = null;
        long l = Config.getCfg().uniqueToTableId(observingRun.getId());
        String string = "SELECT " + obrepDbName + "..readme.readme_data, " + obrepDbName + "..readme.last_mod_date, " + obrepDbName + "..readme.status, " + obrepDbName + "..readme.version, " + obrepDbName + "..readme.ip_version from " + obrepDbName + "..readme where " + obrepDbName + "..readme.run_id = ?";
        stdlog_.debug((Object)string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        float f = -1.0f;
        int n = -1;
        while (resultSet.next()) {
            string2 = resultSet.getString("readme_data");
            string3 = resultSet.getString("status");
            f = resultSet.getFloat("ip_version");
            long l2 = resultSet.getLong("last_mod_date");
            n = resultSet.getInt("version");
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        if (!bl) {
            throw new ObjectIOException("No readme file has been checked in for this ObservingRun");
        }
        Readme readme = new Readme(f);
        readme.setStatus(string3);
        readme.setVersion(n);
        Instrument instrument = InstrumentList.getInstance().getInstrument(observingRun.getInstCode(), f);
        if (instrument == null) {
            throw new ObjectIOException("Instrument package not available for this observing run " + f);
        }
        readme.setRedmeAttributes(ReadmeAttributesFactory.creteReadmeAttribFromXMLString(instrument, string2));
        ReadmeFileDBIO.processReadmeHistoryAttributes(connection, readme, l);
        readme.setCommentArray(ReadmeFileDBIO.getCommentDetails(connection, l));
        readme.setUsdReadmeFileDetails(USDFileDBIO.read(connection, l));
        return readme;
    }

    public static Readme readReadmeReplicate(Connection connection, ObservingRun observingRun) throws SQLException, ObjectIOException, JDOMException, IOException {
        ReadmeFileDBIO.setTextSize(connection);
        Object var2_2 = null;
        long l = Config.getCfg().uniqueToTableId(observingRun.getId());
        String string = "SELECT " + RP + ".readme_data, " + RP + ".ip_version " + " FROM " + RP + " WHERE " + RP + ".run_id = ?";
        stdlog_.debug((Object)string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        String string2 = null;
        Object var10_9 = null;
        float f = -1.0f;
        int n = -1;
        while (resultSet.next()) {
            string2 = resultSet.getString("readme_data");
            f = resultSet.getFloat("ip_version");
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        if (!bl) {
            throw new ObjectIOException("Accepted Readme file not available");
        }
        Readme readme = new Readme(f);
        Instrument instrument = InstrumentList.getInstance().getInstrument(observingRun.getInstCode(), f);
        if (instrument == null) {
            throw new ObjectIOException("Instrument package not available for this observing run " + f);
        }
        readme.setRedmeAttributes(ReadmeAttributesFactory.creteReadmeAttribFromXMLString(instrument, string2));
        readme.setCommentArray(ReadmeFileDBIO.getCommentDetails(connection, l));
        readme.setUsdReadmeFileDetails(USDFileDBIO.readReplicate(connection, l));
        return readme;
    }

    private static void setTextSize(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("set TEXTSIZE 1000000");
        statement.close();
    }

    private static void processReadmeHistoryAttributes(Connection connection, Readme readme, long l) throws SQLException {
        Object[] objectArray;
        String string = "SELECT " + obrepDbName + "..readme_history.event_time, " + obrepDbName + "..readme_history.version," + obrepDbName + "..readme_history.change_status," + obrepDbName + "..readme_history.data_value_old," + obrepDbName + "..readme_history.data_value_new," + obrepDbName + "..readme_history.data_type, " + obrepDbName + "..readme_attribute_name.readme_attribute_name," + obrepDbName + "..readme_attribute_name.readme_attribute_label" + " FROM " + obrepDbName + "..readme_history," + obrepDbName + "..readme_attribute_name" + " WHERE " + obrepDbName + "..readme_history.run_id = ?" + " AND " + obrepDbName + "..readme_history.readme_attribute_name_id = " + obrepDbName + "..readme_attribute_name.readme_attribute_name_id";
        stdlog_.debug((Object)string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Object[]> vector = new Vector<Object[]>();
        while (resultSet.next()) {
            objectArray = new ReadmeHistory();
            String string2 = resultSet.getString("data_value_old");
            if (string2 == null) {
                string2 = "";
            }
            objectArray.setOldValue(string2.trim());
            String string3 = resultSet.getString("data_value_new");
            if (string3 == null) {
                string3 = "";
            }
            objectArray.setNewValue(string3.trim());
            objectArray.setStatus(resultSet.getString("change_status").trim());
            objectArray.setVersion(resultSet.getInt("version"));
            objectArray.setName(resultSet.getString("readme_attribute_name").trim());
            objectArray.setLabel(resultSet.getString("readme_attribute_label").trim());
            objectArray.setEventTime(resultSet.getLong("event_time"));
            vector.addElement(objectArray);
        }
        resultSet.close();
        preparedStatement.close();
        stdlog_.debug((Object)("Historyt list " + vector.size()));
        objectArray = new ReadmeHistory[vector.size()];
        vector.copyInto(objectArray);
        readme.setReadmeHistoryItems((ReadmeHistory[])objectArray);
    }

    public static String checkOut(Connection connection, long l) throws SQLException, ObjectIOException {
        long l2 = DbaseIOHandler.getDbId(connection);
        ReadmeFileDBIO.setTextSize(connection);
        String string = "";
        int n = -1;
        String string2 = "SELECT " + obrepDbName + "..readme.readme_data," + obrepDbName + "..readme.version from " + obrepDbName + "..readme where " + obrepDbName + "..readme.run_id = ?";
        stdlog_.debug((Object)string2);
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        while (resultSet.next()) {
            string = resultSet.getString(1);
            n = resultSet.getInt(2);
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        if (!bl) {
            throw new ObjectIOException("No readme file has been checked in for this ObservingRun");
        }
        ReadmeFileDBIO.updateStatusHistory(connection, l, "P");
        ReadmeFileDBIO.insertStatusHistory(connection, l, "P", l2, n);
        return string;
    }

    public static int getReadmeExists(Connection connection, long l) throws SQLException {
        String string = "SELECT count(*) from " + obrepDbName + "..readme where " + obrepDbName + "..readme.run_id = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = -1;
        while (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        preparedStatement.close();
        return n;
    }

    public static boolean notAcceptedAndCheckedOut(Connection connection, long l) throws SQLException {
        boolean bl = ReadmeFileDBIO.hasBeenAccepted(connection, l);
        boolean bl2 = ReadmeFileDBIO.isCheckedOut(connection, l);
        return !bl && bl2;
    }

    public static boolean hasBeenAccepted(Connection connection, long l) throws SQLException {
        String string = "SELECT count(*) from " + readmeStatusHistory + " where " + readmeStatusHistory + ".readme_status = ?" + " AND " + readmeStatusHistory + ".run_id = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setString(1, "+");
        preparedStatement.setLong(2, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        while (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        preparedStatement.close();
        return n != 0;
    }

    public static boolean isCheckedOut(Connection connection, long l) throws SQLException {
        String string = "SELECT " + readmeFile + ".status from " + readmeFile + " where " + readmeFile + ".run_id = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string2 = null;
        while (resultSet.next()) {
            string2 = resultSet.getString(1);
        }
        resultSet.close();
        preparedStatement.close();
        return string2.equals("P");
    }

    public static int getHasObs(Connection connection, long l) throws SQLException {
        String string = "SELECT count(*) from " + obrepDbName + "..obs_blocks where " + obrepDbName + "..obs_blocks.run_id = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = -1;
        while (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        preparedStatement.close();
        return n;
    }

    public static String write(Connection connection, ObservingRun observingRun) throws ObjectIOException, SQLException, IOException, ObjectNotFoundException {
        stdlog_.debug((Object)"CLASS ReadmeFileDBIO - write:");
        String string = null;
        ReadmeFileDBIO.checkIPPackage(observingRun);
        StringBuffer stringBuffer = new StringBuffer();
        Statement statement = connection.createStatement();
        long l = -1L;
        long l2 = Config.getCfg().uniqueToTableId(observingRun.getId());
        String string2 = null;
        int n = -1;
        float f = InstrumentPackageDBIO.getIPVFromObsRun(statement, l2);
        statement.close();
        stdlog_.debug((Object)("Latest DB IPVersion " + f));
        stdlog_.debug((Object)("Observing Run IPVersion " + observingRun.getIPVersion()));
        if (f != observingRun.getIPVersion()) {
            throw new ObjectIOException("The instrument package you are using is out of date\n Please select download refresh observing runs and try checking in the readme again");
        }
        ReadmeFileDBIO.setTextSize(connection);
        statement = connection.createStatement();
        String string3 = "SELECT " + obrepDbName + "..readme.run_id," + obrepDbName + "..readme.readme_data," + obrepDbName + "..readme.version," + obrepDbName + "..readme.status" + " from " + obrepDbName + "..readme" + " WHERE " + obrepDbName + "..readme.run_id = " + l2;
        ResultSet resultSet = statement.executeQuery(string3);
        while (resultSet.next()) {
            l = resultSet.getLong("run_id");
            string2 = resultSet.getString("readme_data");
            n = resultSet.getInt("version");
        }
        resultSet.close();
        statement.close();
        Readme readme = observingRun.getReadme();
        stdlog_.debug((Object)("Readme IP VERSION " + readme.getIpVersion()));
        if (readme == null) {
            throw new ObjectIOException("Readme Not Defined for this Observing Run");
        }
        String string4 = "false";
        boolean bl = false;
        ReadmeAttribute[] readmeAttributeArray = readme.getRedmeAttributes();
        int n2 = 0;
        while (n2 < readmeAttributeArray.length) {
            if (readmeAttributeArray[n2].getName().equals("emailaddress")) {
                string = readmeAttributeArray[n2].getValue();
            }
            if (readmeAttributeArray[n2].getName().equals("IsPreImaging")) {
                string4 = readmeAttributeArray[n2].getValue();
            }
            ++n2;
        }
        if (string4.equals("true")) {
            bl = true;
        }
        String string5 = readme.toAttributesXMLString();
        long l3 = DbaseIOHandler.getDbId(connection);
        if (l == -1L) {
            connection.setAutoCommit(false);
            ReadmeFileDBIO.insertReadme(connection, string, l2, readme, bl, string5, l3);
        } else {
            SAXBuilder sAXBuilder = new SAXBuilder();
            StringReader stringReader = new StringReader(string2.trim());
            try {
                Document document = sAXBuilder.build(new InputSource(stringReader));
                Element element = document.getRootElement();
                List list = element.getChildren();
                AttribComparison[] attribComparisonArray = ReadmeAttribComparison.compareAttributes(readme.getRedmeAttributes(), list);
                if (attribComparisonArray.length == 0) {
                    connection.setAutoCommit(false);
                    ReadmeFileDBIO.updateStatusHistory(connection, l2, readme.getStatus());
                    ReadmeFileDBIO.insertStatusHistory(connection, l2, readme.getStatus(), l3, n);
                    return ReadmeFileDBIO.getUSDEmailAddress(connection, l2);
                }
                long[] lArray = new long[attribComparisonArray.length];
                int n3 = 0;
                while (n3 < attribComparisonArray.length) {
                    lArray[n3] = DbaseIOHandler.getDbId(connection);
                    ++n3;
                }
                HashMap hashMap = ReadmeFileDBIO.extractIds(connection, attribComparisonArray);
                ReadmeFileDBIO.updateReadme(connection, string, l2, n, readme, bl, string5, l3, attribComparisonArray, lArray, hashMap);
            }
            catch (JDOMException jDOMException) {
                throw new ObjectIOException("Error Reading Readme File");
            }
        }
        return ReadmeFileDBIO.getUSDEmailAddress(connection, l2);
    }

    private static void updateReadme(Connection connection, String string, long l, int n, Readme readme, boolean bl, String string2, long l2, AttribComparison[] attribComparisonArray, long[] lArray, HashMap hashMap) throws SQLException {
        connection.setAutoCommit(false);
        ReadmeFileDBIO.addCompHistory(connection, attribComparisonArray, l, n, lArray, hashMap);
        String string3 = "UPDATE " + obrepDbName + "..readme SET " + "status = ? , version = ? , readme_data = ? , email_address = ?,ip_version = ?,last_mod_date = ?" + " WHERE run_id=?";
        stdlog_.debug((Object)string3);
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setString(1, "D");
        preparedStatement.setInt(2, ++n);
        preparedStatement.setString(3, string2);
        preparedStatement.setString(4, string);
        preparedStatement.setFloat(5, readme.getIpVersion());
        preparedStatement.setLong(6, Convert.getCurrentTime());
        preparedStatement.setLong(7, l);
        preparedStatement.execute();
        preparedStatement.close();
        string3 = "UPDATE " + obrepDbName + "..usg_file SET pre_imaging = ? " + " WHERE run_id = ?";
        preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setBoolean(1, bl);
        preparedStatement.setLong(2, l);
        preparedStatement.execute();
        preparedStatement.close();
        ReadmeFileDBIO.insertStatusHistory(connection, l, "D", l2, n);
    }

    private static void insertReadme(Connection connection, String string, long l, Readme readme, boolean bl, String string2, long l2) throws SQLException {
        String string3 = "INSERT INTO " + obrepDbName + "..readme " + " (run_id,status,version,readme_data,email_address,ip_version,last_mod_date)" + " VALUES (?,?,?,?,?,?,?)";
        stdlog_.debug((Object)string3);
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setLong(1, l);
        preparedStatement.setString(2, "D");
        preparedStatement.setInt(3, 1);
        preparedStatement.setString(4, string2);
        preparedStatement.setString(5, string);
        preparedStatement.setFloat(6, readme.getIpVersion());
        preparedStatement.setLong(7, Convert.getCurrentTime());
        preparedStatement.execute();
        preparedStatement.close();
        string3 = "INSERT INTO " + obrepDbName + "..usg_file (run_id,pre_imaging)" + " VALUES (?,?)";
        preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setLong(1, l);
        preparedStatement.setBoolean(2, bl);
        preparedStatement.execute();
        preparedStatement.close();
        ReadmeFileDBIO.insertStatusHistory(connection, l, "D", l2, 1);
    }

    public static void updateStatusHistory(Connection connection, long l, String string) throws SQLException {
        String string2 = "UPDATE " + obrepDbName + "..readme SET status = ?,last_mod_date = ?" + " WHERE run_id = ?";
        stdlog_.debug((Object)string2);
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setString(1, string);
        preparedStatement.setLong(2, Convert.getCurrentTime());
        preparedStatement.setLong(3, l);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public static void insertStatusHistory(Connection connection, long l, String string, long l2, int n) throws SQLException {
        String string2 = "INSERT INTO " + obrepDbName + "..readme_status_history (run_id,readme_status_history_id,readme_status,event_time,version,application_name) " + " VALUES (?,?,?,?,?,?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setLong(1, l);
        preparedStatement.setLong(2, l2);
        preparedStatement.setString(3, string);
        preparedStatement.setLong(4, Convert.getCurrentTime());
        preparedStatement.setLong(5, n);
        preparedStatement.setString(6, OHSApplication.getShortDesc());
        preparedStatement.execute();
        preparedStatement.close();
    }

    private static void addCompHistory(Connection connection, AttribComparison[] attribComparisonArray, long l, int n, long[] lArray, HashMap hashMap) throws SQLException {
        String string = null;
        PreparedStatement preparedStatement = null;
        int n2 = 0;
        while (n2 < attribComparisonArray.length) {
            Long l2 = (Long)hashMap.get(attribComparisonArray[n2].getName());
            string = "INSERT INTO " + obrepDbName + "..readme_history " + " (run_id,readme_history_id,readme_attribute_name_id,event_time, " + " version,data_type,change_status, " + " data_value_new,data_value_old)" + " VALUES (?,?,?,?,?,?,?,?,?)";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, lArray[n2]);
            preparedStatement.setLong(3, l2);
            preparedStatement.setLong(4, Convert.getCurrentTime());
            preparedStatement.setInt(5, n);
            preparedStatement.setString(6, attribComparisonArray[n2].getDBType());
            preparedStatement.setString(7, attribComparisonArray[n2].getStatus());
            preparedStatement.setString(8, attribComparisonArray[n2].getNewValue());
            preparedStatement.setString(9, attribComparisonArray[n2].getOldValue());
            preparedStatement.execute();
            preparedStatement.close();
            ++n2;
        }
    }

    private static HashMap extractIds(Connection connection, AttribComparison[] attribComparisonArray) throws SQLException, ObjectIOException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string = null;
        PreparedStatement preparedStatement = null;
        int n = 0;
        while (n < attribComparisonArray.length) {
            long l = -1L;
            string = "SELECT " + obrepDbName + "..readme_attribute_name.readme_attribute_name_id " + " from " + obrepDbName + "..readme_attribute_name " + " WHERE " + obrepDbName + "..readme_attribute_name.readme_attribute_name = ?";
            stdlog_.debug((Object)string);
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, attribComparisonArray[n].getName());
            stdlog_.debug((Object)attribComparisonArray[n].getName());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (l == -1L) {
                l = DbaseIOHandler.getDbId();
                string = "INSERT INTO " + obrepDbName + "..readme_attribute_name (readme_attribute_name_id,readme_attribute_name,readme_attribute_label) VALUES (?,?,?)";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setLong(1, l);
                preparedStatement.setString(2, attribComparisonArray[n].getName());
                preparedStatement.setString(3, attribComparisonArray[n].getLabel());
                preparedStatement.execute();
            }
            hashMap.put(attribComparisonArray[n].getName(), new Long(l));
            ++n;
        }
        return hashMap;
    }

    private static void checkIPPackage(ObservingRun observingRun) throws IOException {
        Instrument instrument = InstrumentList.getInstance().getInstrument(observingRun.getInstCode(), observingRun.getIPVersion());
        instrument = InstrumentList.getInstance().getInstrument(observingRun.getInstCode(), observingRun.getIPVersion());
        if (instrument == null) {
            stdlog_.debug((Object)("IP Template Not Found: " + observingRun.getInstCode() + " version: " + observingRun.getIPVersion()));
            String string = InstrumentList.isInSingleIPMode() ? "" : " version " + observingRun.getIPVersion();
            throw new IOException("Instrument Package for " + observingRun.getInstCode() + string + " could not be found.");
        }
    }

    public static String getUSDEmailAddress(Connection connection, long l) throws SQLException {
        String string = "SELECT " + obrepDbName + "..usg_staff.email " + " from " + obrepDbName + "..run_states," + obrepDbName + "..usg_staff" + " WHERE " + obrepDbName + "..run_states.run_id = ?" + " AND " + obrepDbName + "..run_states.cs_acronym" + " = " + obrepDbName + "..usg_staff.cs_acronym";
        stdlog_.debug((Object)string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string2 = null;
        while (resultSet.next()) {
            string2 = resultSet.getString(1);
        }
        resultSet.close();
        preparedStatement.close();
        return string2;
    }

    public static void setReadmeFileStatus(Connection connection, String string, long l) throws SQLException, ObjectIOException {
        long l2 = Config.getCfg().uniqueToTableId(l);
        long l3 = DbaseIOHandler.getDbId(connection);
        ReadmeFileDBIO.setTextSize(connection);
        String string2 = "SELECT " + readmeFile + ".readme_data," + readmeFile + ".version," + readmeFile + ".status," + readmeFile + ".ip_version " + " from " + readmeFile + " WHERE " + readmeFile + ".run_id = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setLong(1, l2);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = -1;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        int n2 = -1;
        float f = -1.0f;
        while (resultSet.next()) {
            string3 = resultSet.getString("readme_data");
            string4 = resultSet.getString("status");
            n2 = resultSet.getInt("version");
            f = resultSet.getFloat("ip_version");
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        if (!bl) {
            throw new SQLException("No Readme file available for this Observong Run");
        }
        if (string.equals(string4)) {
            throw new SQLException("Readme has already status " + string4);
        }
        connection.setAutoCommit(false);
        ReadmeFileDBIO.updateStatusHistory(connection, l2, string);
        ReadmeFileDBIO.insertStatusHistory(connection, l2, string, l3, n2);
        if (string.equals("+")) {
            string2 = "SELECT count(*) from " + RP + " WHERE " + RP + ".run_id = ?";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, l2);
            resultSet = preparedStatement.executeQuery();
            n = -1;
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (n == 0) {
                string2 = "INSERT INTO " + RP + " (run_id,readme_data,ip_version) " + " VALUES (?,?,?)";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setLong(1, l2);
                preparedStatement.setString(2, string3);
                preparedStatement.setFloat(3, f);
                preparedStatement.execute();
                preparedStatement.close();
            } else {
                string2 = "UPDATE " + RP + " SET readme_data = ?,ip_version = ? WHERE run_id = ?";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string3);
                preparedStatement.setFloat(2, f);
                preparedStatement.setLong(3, l2);
                preparedStatement.execute();
                resultSet.close();
                preparedStatement.close();
            }
        }
    }

    public static void delete(Connection connection, long l) throws SQLException {
        Statement statement = connection.createStatement();
        long l2 = Config.getCfg().uniqueToTableId(l);
        String string = "delete " + readmeStatusHistory + " where " + readmeStatusHistory + ".run_id = " + l2;
        statement.executeUpdate(string);
        string = "delete  " + readmeHistory + " where " + readmeHistory + ".run_id = " + l2;
        statement.executeUpdate(string);
        string = "delete  " + RP + " where " + RP + ".run_id = " + l2;
        statement.executeUpdate(string);
        string = "delete  " + USDFileDBIO.usgSupportNotes + " where " + USDFileDBIO.usgSupportNotes + ".run_id = " + l2;
        statement.executeUpdate(string);
        string = "delete  " + usgFile + " where " + usgFile + ".run_id = " + l2;
        statement.executeUpdate(string);
        string = "delete  " + readmeFile + " where " + readmeFile + ".run_id = " + l2;
        statement.executeUpdate(string);
        statement.close();
    }

    public static CommentDetails[] getCommentDetails(Connection connection, long l) throws SQLException {
        String string = "SELECT " + OB + ".ob_id," + OB + ".item_name," + OB + ".inst_comments," + OB + ".userComments," + OB + ".userPriority," + OB + ".status FROM " + OB + " WHERE " + OB + ".run_id = ? " + " order by " + OB + ".ob_id";
        stdlog_.debug((Object)string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<CommentDetails> vector = new Vector<CommentDetails>();
        while (resultSet.next()) {
            String string2;
            boolean bl = false;
            CommentDetails commentDetails = new CommentDetails();
            commentDetails.setObId(resultSet.getLong("ob_id"));
            commentDetails.setName(resultSet.getString("item_name"));
            String string3 = resultSet.getString("inst_comments");
            if (string3 != null && string3.length() > 0) {
                commentDetails.setInstSpecificComment(string3.trim());
                bl = true;
            }
            if ((string2 = resultSet.getString("userComments").trim()) != null && string2.length() > 0) {
                commentDetails.setUserComment(resultSet.getString("userComments").trim());
                bl = true;
            }
            commentDetails.setUserComment(resultSet.getString("userComments").trim());
            commentDetails.setUserPriority(resultSet.getString("userPriority").trim());
            if (!bl) continue;
            vector.addElement(commentDetails);
        }
        Object[] objectArray = new CommentDetails[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

