/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import org.eso.ohs.core.utilities.Convert;
import org.eso.ohs.instruments.ParamMetaData;
import org.eso.ohs.instruments.Parameter;

public class CoordParameter
extends Parameter {
    static final long serialVersionUID = -3984228626336657848L;

    public CoordParameter(ParamMetaData paramMetaData) {
        super(paramMetaData);
    }

    public String getToolTipText() {
        String string = this.getRange();
        if (string == null) {
            return "The TSF contains a wrong PARAMETER definition";
        }
        if (string.equalsIgnoreCase("ra")) {
            return "Enter Right Ascension value";
        }
        if (string.equalsIgnoreCase("dec")) {
            return "Enter Declination value";
        }
        return "The TSF contains a wrong PARAMETER definition";
    }

    public String getRange() {
        boolean bl = false;
        String string = null;
        String string2 = "ra";
        String string3 = "dec";
        string = super.getParameterName();
        if (string.endsWith("ALPHA")) {
            return string2;
        }
        if (string.endsWith("DELTA")) {
            return string3;
        }
        return null;
    }

    public char getDBTypeCode() {
        return 'C';
    }

    public boolean verifyValue(String string) {
        block13: {
            int n = 0;
            String string2 = this.getRange();
            if (string2 == null) {
                return false;
            }
            if (string == null || string.equals("NODEFAULT")) {
                return false;
            }
            if (string.equals(this.getDefaultValue()) || string.length() == 0) {
                return true;
            }
            try {
                if (this.getRange().equalsIgnoreCase("ra")) {
                    try {
                        n = Convert.DDMMSSToMilliarcsec(string, true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                    if (!Convert.isValidRA(n)) {
                        return false;
                    }
                    break block13;
                }
                if (this.getRange().equalsIgnoreCase("dec")) {
                    try {
                        n = Convert.DDMMSSToMilliarcsec(string, true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                    if (!Convert.isValidDec(n)) {
                        return false;
                    }
                    break block13;
                }
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

