/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.Serializable;
import org.eso.ohs.instruments.ExclParameter;
import org.eso.ohs.instruments.Parameter;
import org.eso.ohs.instruments.TemplateSignatureConstants;

public class ParamMetaData
implements Serializable {
    static final long serialVersionUID = -6384701931650553429L;
    private String parameterName_;
    private String type_;
    private String range_;
    private String defaultValue_;
    private String label_;
    private String miniHelp_;
    private boolean isFixed_;
    private boolean hide_ = false;
    private boolean hasHiddenKeyword_ = false;
    private String value_;

    public ParamMetaData(String string) {
        this.parameterName_ = string;
        this.isFixed_ = false;
    }

    public static boolean validParamKeyword(String string) {
        if (string != null && string.length() > 0) {
            if (string.length() > 3) {
                String string2 = string.substring(3, string.length());
                try {
                    new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                string = string.substring(0, 3);
                if (TemplateSignatureConstants.firstKeywords.containsKey(string)) {
                    Boolean bl = (Boolean)TemplateSignatureConstants.firstKeywords.get(string);
                    return bl;
                }
            } else if (TemplateSignatureConstants.firstKeywords.containsKey(string)) {
                Boolean bl = (Boolean)TemplateSignatureConstants.firstKeywords.get(string);
                return bl;
            }
        }
        return false;
    }

    public boolean isDisplay() {
        if (this.isHidden()) {
            return false;
        }
        int n = 0;
        while (n < ExclParameter.tgParam.length) {
            if (this.getParameterName().equals(ExclParameter.tgParam[n]) || this.isFixed()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean samePrefix(String string) {
        String string2;
        if (this.parameterName_.indexOf(string) != -1) {
            return true;
        }
        String string3 = this.parameterName_.substring(0, this.parameterName_.indexOf("."));
        return Parameter.validParamKeyword(string3) && (string2 = this.parameterName_.substring(string3.length(), this.parameterName_.length())).indexOf(string) != -1;
    }

    public void setHiddenKeyword(boolean bl) {
        this.hasHiddenKeyword_ = bl;
    }

    public boolean hasHiddenKeyword() {
        return this.hasHiddenKeyword_;
    }

    public String getParameterName() {
        return this.parameterName_;
    }

    public String getType() {
        return this.type_;
    }

    public String getRange() {
        return this.range_;
    }

    public String getDefaultValue() {
        return this.defaultValue_;
    }

    public String getLabel() {
        return this.label_;
    }

    public String getMiniHelp() {
        return this.miniHelp_;
    }

    public boolean isFixed() {
        return this.isFixed_;
    }

    public String getValue() {
        return this.value_;
    }

    public void setHidden(boolean bl) {
        this.hide_ = bl;
    }

    public boolean isHidden() {
        return this.hide_;
    }

    public void setType(String string) {
        this.type_ = string;
    }

    public void setRange(String string) {
        this.range_ = string;
    }

    public void setDefault(String string) {
        this.defaultValue_ = string;
    }

    public void setValue(String string) {
        this.value_ = string;
    }

    public void setLabel(String string) {
        this.label_ = string;
    }

    public void setMiniHelp(String string) {
        this.miniHelp_ = string;
    }

    public void setFixed(boolean bl) {
        this.isFixed_ = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Class Parameter\n");
        stringBuffer.append("Parameter Name=" + this.getParameterName() + "\n");
        stringBuffer.append("Range  =" + this.getRange() + "\n");
        stringBuffer.append("Default Value=" + this.getDefaultValue() + "\n");
        stringBuffer.append("Value=" + this.value_ + "\n");
        stringBuffer.append("Label =" + this.getLabel() + "\n");
        stringBuffer.append("Label =" + this.getType() + "\n");
        stringBuffer.append("Minihelp =" + this.getMiniHelp() + "\n");
        return stringBuffer.toString();
    }
}

