/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.Serializable;
import org.eso.ohs.instruments.InstrumentConstraintConfig;

public abstract class ReadmeAttribute
implements Serializable {
    public static final String VERIFY_OK = "OK";
    public static final String VERIFY_INVALID = "INVALID";
    public static final String VERIFY_TRUNCATED = "DATA TRUNCATED";
    public static final String VERIFY_EMPTY = "Not Defined";
    private static final long serialVersionUID = -4378250031958131200L;
    private String name;
    private String type;
    private String value_;
    private transient InstrumentConstraintConfig readmeConfig_ = null;

    public ReadmeAttribute(InstrumentConstraintConfig instrumentConstraintConfig) {
        this.readmeConfig_ = instrumentConstraintConfig;
        this.name = instrumentConstraintConfig.getName();
        this.setValue(instrumentConstraintConfig.getMetaData().getDefaultValue());
        this.setType(instrumentConstraintConfig.getSuperType());
    }

    public String getValue() {
        if (this.value_ == null) {
            return "";
        }
        return this.value_.trim();
    }

    public String getDisplayValue() {
        return this.getValue();
    }

    public boolean hasValue() {
        String string = this.getValue();
        return string != null && string.length() > 0;
    }

    public void setValue(String string) {
        this.value_ = string;
    }

    public InstrumentConstraintConfig getReadmeConfig() {
        return this.readmeConfig_;
    }

    public String toReadmeAttributeString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    <");
        stringBuffer.append(this.readmeConfig_.getName());
        stringBuffer.append(">");
        stringBuffer.append("\n");
        stringBuffer.append("        <Label>");
        stringBuffer.append(this.readmeConfig_.getLabel());
        stringBuffer.append("</Label>");
        stringBuffer.append("\n");
        stringBuffer.append("        <Data>");
        stringBuffer.append(this.getValue());
        stringBuffer.append("</Data>");
        stringBuffer.append("\n");
        stringBuffer.append("    </");
        stringBuffer.append(this.readmeConfig_.getName());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public void setReadmeConfig(InstrumentConstraintConfig instrumentConstraintConfig) {
        this.readmeConfig_ = instrumentConstraintConfig;
    }

    public void postProecess() {
    }

    public String getName() {
        return this.name;
    }

    public abstract Object getRawValue();

    public void setName(String string) {
        this.name = string;
    }

    public abstract boolean isCompulsory();

    public abstract String verify();

    public abstract String getToolTipText();

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean equalsMeta(Object object) {
        ReadmeAttribute readmeAttribute;
        return object instanceof ReadmeAttribute && (readmeAttribute = (ReadmeAttribute)object).getType().equals(this.getType()) && readmeAttribute.getName().equals(this.getName());
    }
}

