/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.instruments;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.ohs.core.utilities.PafData;
import org.eso.ohs.core.utilities.PafFile;
import org.eso.ohs.instruments.Instrument;
import org.eso.ohs.instruments.ParamMetaData;
import org.eso.ohs.instruments.Parameter;
import org.eso.ohs.instruments.TemplateSignatureConstants;

public class TemplateSignatureMetaData
implements Serializable {
    static final long serialVersionUID = -9032502422738435508L;
    static final String id_TemplateSignatureMetaData = "$Id: TemplateSignatureMetaData.java,v 1.54 2005/01/13 08:47:51 tcanavan Exp $";
    private static Logger stdlog_ = Logger.getLogger((Class)(class$org$eso$ohs$instruments$TemplateSignatureMetaData == null ? (class$org$eso$ohs$instruments$TemplateSignatureMetaData = TemplateSignatureMetaData.class$("org.eso.ohs.instruments.TemplateSignatureMetaData")) : class$org$eso$ohs$instruments$TemplateSignatureMetaData));
    private transient String[] duplicateNameList_ = new String[0];
    private transient Instrument instrument_;
    private Hashtable tplKeywords_ = new Hashtable();
    private String templateName_;
    private String templateDesc_;
    private String tsfName_;
    private ParamMetaData[] paramList_;
    private transient Vector mandatoryKeywordsMissing_ = new Vector();
    private transient Vector mandatoryValuesMissing_ = new Vector();
    private transient Hashtable paramErrorStatus_ = new Hashtable();
    private transient Hashtable paramWarningStatus_ = new Hashtable();
    private transient Vector paramErrors_ = new Vector();
    private transient Vector paramWarnings_ = new Vector();
    private transient String fileType_;
    private transient String[] pafLinesMissing_ = new String[0];
    private transient PafData[] unLinkedParamData_ = new PafData[0];
    private transient PafData[] invalidParamKeywords_ = new PafData[0];
    private long lastModified_;
    private int execTime_;
    private transient String compileErrorMsg_;
    private transient boolean isValidInstrument_ = true;
    private PafData[] identifierList_ = new PafData[0];
    public final String SPACES = "      ";
    static /* synthetic */ Class class$org$eso$ohs$instruments$TemplateSignatureMetaData;

    public TemplateSignatureMetaData(String string, Instrument instrument) throws IOException {
        this(string, instrument, TemplateSignatureConstants.mandatoryTemplateKeywords, TemplateSignatureConstants.mandatoryTemplateValues, true);
    }

    public TemplateSignatureMetaData(String string, Instrument instrument, String[] stringArray, String[] stringArray2, boolean bl) throws IOException {
        this.instrument_ = instrument;
        this.tsfName_ = string;
        PafFile pafFile = new PafFile(string);
        File file = new File(string);
        this.lastModified_ = file.lastModified();
        if (pafFile.compileError()) {
            this.compileErrorMsg_ = pafFile.getCompileErrorMsg();
            return;
        }
        if (!pafFile.isPafFile()) {
            this.pafLinesMissing_ = pafFile.getPafLinesMissing();
            return;
        }
        this.identifierList_ = pafFile.getIdentifierList();
        this.templateName_ = pafFile.getPafName();
        this.templateDesc_ = pafFile.getPafDescription();
        this.fileType_ = pafFile.getPafType();
        this.setValuesFromIdentifierList();
        this.setMandatoryKeywordsMissing(stringArray);
        this.setMandatoryValuesMissing(stringArray2);
        String string2 = this.getInstrumentName();
        if (string2 == null || !string2.equals(instrument.getInstrumentName())) {
            this.isValidInstrument_ = false;
        }
        if (!this.isValidInstrument() || !this.isValidTemplateName()) {
            return;
        }
        this.createParameters(bl);
    }

    public static String getStack(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public boolean getCriticalStatus() {
        Throwable throwable = new Throwable();
        String string = TemplateSignatureMetaData.getStack(throwable);
        if (this.compileErrorMsg_ != null && this.compileErrorMsg_.length() > 0) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 01");
            return true;
        }
        if (this.pafLinesMissing_.length > 0) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 02");
            return true;
        }
        if (!this.isValidInstrument()) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 03");
            return true;
        }
        if (this.mandatoryKeywordsMissing_.size() > 0) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 04");
            return true;
        }
        if (this.mandatoryValuesMissing_.size() > 0) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 05");
            return true;
        }
        if (this.paramErrorStatus_.size() > 0) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 06");
            return true;
        }
        if (this.invalidParamKeywords_.length > 0) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 07");
            return true;
        }
        if (!this.isValidTemplateType()) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 08");
            return true;
        }
        if (!this.isValidFileType()) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 09");
            return true;
        }
        if (!this.isValidTemplateName()) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 10");
            return true;
        }
        if (this.execTime_ == -1) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 11");
            return true;
        }
        if (this.duplicateNameList_.length > 0) {
            stdlog_.debug((Object)"CLASS TemplateSignatureMetaData - getCriticalStatus: 12");
            return true;
        }
        return false;
    }

    public boolean getWarningStatus() {
        return this.paramWarningStatus_.size() > 0 || this.unLinkedParamData_.length > 0;
    }

    public boolean isValidTemplateName() {
        int n = this.tsfName_.lastIndexOf(".");
        String string = this.tsfName_.substring(0, n);
        return this.templateName_ != null && string.endsWith(this.templateName_);
    }

    public long getLastModified() {
        return this.lastModified_;
    }

    public void setTplKeyword(String string, String string2) {
        this.tplKeywords_.put(string, string2);
    }

    public String getTplKeywordValue(String string) {
        return (String)this.tplKeywords_.get(string);
    }

    public void setExecTime(int n) {
        this.execTime_ = n;
    }

    public int getExecTime() {
        return this.execTime_;
    }

    private void setMandatoryKeywordsMissing(String[] stringArray) {
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.identifierList_.length) {
                if (this.identifierList_[n2].getIdentifier().equals("TPL." + stringArray[n])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.mandatoryKeywordsMissing_.addElement(stringArray[n]);
            }
            ++n;
        }
    }

    private void setMandatoryValuesMissing(String[] stringArray) {
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            int n2 = 0;
            while (n2 < this.identifierList_.length) {
                if (this.identifierList_[n2].getIdentifier().equals("TPL." + stringArray[n]) && !this.identifierList_[n2].hasValue()) {
                    this.mandatoryValuesMissing_.addElement(this.identifierList_[n2]);
                    break;
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean isValidInstrument() {
        return this.isValidInstrument_;
    }

    private boolean isValidTemplateType() {
        boolean bl = false;
        String string = this.getTemplateType();
        if (string == null || string.length() <= 0) {
            return false;
        }
        int n = 0;
        while (n < TemplateSignatureConstants.allowedTemplateTypes.length) {
            if (TemplateSignatureConstants.allowedTemplateTypes[n].compareTo(string) == 0) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean isValidFileType() {
        return this.fileType_ != null && this.fileType_.length() > 0 && (this.fileType_.equals("Template") || this.fileType_.equals("Template Signature"));
    }

    private void setValuesFromIdentifierList() {
        String string;
        PafData pafData = null;
        String string2 = null;
        int n = 0;
        while (n < this.identifierList_.length) {
            pafData = this.identifierList_[n];
            if (pafData.getIdentifier().equals("TPL.EXECTIME")) {
                string2 = pafData.getValue();
                if (string2 != null && string2.length() > 0 && !string2.equals("computed")) {
                    try {
                        this.setExecTime(new Integer(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setExecTime(-1);
                    }
                }
            } else {
                this.setTplKeyword(pafData.getIdentifier(), pafData.getValue());
            }
            ++n;
        }
        if (string2 != null && string2.equals("computed") && (string = this.getTemplateType()) != null && string.equals("acquisition")) {
            this.execTime_ = -1;
        }
    }

    public ParamMetaData[] getParamList() {
        return this.paramList_;
    }

    public String getMode() {
        return this.getTplKeywordValue("TPL.MODE");
    }

    public String getInstrumentName() {
        return this.getTplKeywordValue("TPL.INSTRUM");
    }

    public String getTemplateType() {
        return this.getTplKeywordValue("TPL.TYPE");
    }

    public String getResources() {
        return this.getTplKeywordValue("TPL.RESOURCES");
    }

    public String getTemplateName() {
        return this.templateName_;
    }

    public String getTemplateDesc() {
        return this.templateDesc_;
    }

    public String getVersion() {
        return this.getTplKeywordValue("TPL.VERSION");
    }

    private boolean isValidParam(String string, Hashtable hashtable) {
        boolean bl = true;
        String string2 = string + "." + TemplateSignatureConstants.manadatoryParamKeywords[0];
        String string3 = string + "." + TemplateSignatureConstants.manadatoryParamKeywords[1];
        String string4 = string + "." + TemplateSignatureConstants.manadatoryParamKeywords[2];
        String string5 = string + "." + "VALUE";
        int n = ((PafData)hashtable.get("TPL.PARAM")).getLineNumber();
        if (hashtable.containsKey(string5)) {
            PafData pafData = (PafData)hashtable.get(string5);
            if (!pafData.hasValue()) {
                this.paramWarnings_.addElement("Warning Line (" + pafData.getLineNumber() + ") : " + "Please enter value into .VALUE parameter");
            }
            return true;
        }
        if (!hashtable.containsKey(string2)) {
            this.paramErrors_.addElement("Error Line (" + n + ") : " + "Please define a type for parameter " + string);
            bl = false;
        }
        if (!hashtable.containsKey(string4)) {
            this.paramErrors_.addElement("Error Line (" + n + ") : " + "Please define a default value for this parameter " + string);
            bl = false;
        }
        if (!(string2 == null || string2.equals("boolean") || string2.equals("file") || hashtable.containsKey(string3))) {
            this.paramErrors_.addElement("Error Line (" + n + ") : " + "Please define a valid range for this parameter " + string);
            bl = false;
        }
        return bl;
    }

    private boolean isValidParamType(String string) {
        boolean bl = false;
        int n = 0;
        while (n < TemplateSignatureConstants.validParamTypes.length) {
            if (TemplateSignatureConstants.validParamTypes[n].equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private String getValueFromInstrument(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
        }
        string2 = this.instrument_.getInstrumentRange(string2, this.getMode());
        return string2;
    }

    private String initValueFromInst(ParamMetaData paramMetaData, String string, PafData pafData) {
        String string2 = this.getValueFromInstrument(string);
        String string3 = paramMetaData.getType();
        if (string2 == null) {
            if (paramMetaData.isDisplay()) {
                this.paramErrors_.addElement("Error Line (" + pafData.getLineNumber() + ") : " + "No reference to " + string + " in instrument file");
            } else {
                this.paramWarnings_.addElement("Warning Line (" + pafData.getLineNumber() + ") : " + "No reference to " + string + " in instrument file");
            }
        } else if (string2.length() <= 0) {
            this.paramWarnings_.addElement("Warning Line (" + pafData.getLineNumber() + ") : " + "No value entered for " + string + " in instrument file");
        }
        return string2;
    }

    private ParamMetaData createParameter(String string, Hashtable hashtable) {
        ParamMetaData paramMetaData = null;
        PafData pafData = null;
        String string2 = "";
        this.paramWarnings_ = new Vector();
        this.paramErrors_ = new Vector();
        int n = ((PafData)hashtable.get("TPL.PARAM")).getLineNumber();
        if (this.isValidParam(string, hashtable)) {
            String string3 = string + ".TYPE";
            if (hashtable.containsKey(string3)) {
                pafData = (PafData)hashtable.get(string3);
                if (pafData.hasValue()) {
                    string2 = pafData.getValue();
                } else {
                    this.paramErrors_.addElement("Error Line (" + n + "): " + "No value entered for parameter type");
                    return null;
                }
            }
            if (this.isValidParamType(string2)) {
                String string4;
                String string5;
                int n2;
                String string6;
                String string7;
                String string8;
                paramMetaData = new ParamMetaData(string);
                paramMetaData.setType(string2);
                String string9 = string + ".VALUE";
                if (hashtable.containsKey(string9)) {
                    pafData = (PafData)hashtable.get(string9);
                    string8 = pafData.getValue();
                    if (string8.startsWith("ISF") || string8.startsWith("QUERY-INST")) {
                        string8 = this.initValueFromInst(paramMetaData, string8, pafData);
                    }
                    paramMetaData.setFixed(true);
                    paramMetaData.setValue(string8);
                }
                if (hashtable.containsKey(string8 = string + ".HIDE") && (pafData = (PafData)hashtable.get(string8)).hasValue()) {
                    paramMetaData.setHiddenKeyword(true);
                    string7 = pafData.getValue().toUpperCase();
                    if (string7.indexOf("OHS") != -1) {
                        stdlog_.debug((Object)"Setting hidden to true");
                        paramMetaData.setHidden(true);
                    }
                }
                string7 = string + ".RANGE";
                String string10 = "";
                if (hashtable.containsKey(string7) && (pafData = (PafData)hashtable.get(string7)).hasValue() && ((string10 = pafData.getValue()).startsWith("ISF") || string10.startsWith("QUERY-INST"))) {
                    string10 = string6 = this.initValueFromInst(paramMetaData, string10, pafData);
                }
                paramMetaData.setRange(string10);
                if ((string2.equals("number") || string2.equals("numberlist") || string2.equals("integer") || string2.equals("intlist")) && string10 != null && string10.length() > 0 && (n2 = string10.indexOf("...")) != -1) {
                    this.paramErrors_.addElement("Error line (" + pafData.getLineNumber() + ") : " + "Illegal substring ... in range : " + string10);
                }
                if (hashtable.containsKey(string6 = string + ".DEFAULT")) {
                    pafData = (PafData)hashtable.get(string6);
                    string5 = "";
                    if (pafData.hasValue()) {
                        string5 = pafData.getValue();
                        if (string5.startsWith("ISF") || string5.startsWith("QUERY-INST")) {
                            string5 = string4 = this.initValueFromInst(paramMetaData, string5, pafData);
                        }
                        if (!paramMetaData.isFixed()) {
                            paramMetaData.setValue(string5);
                        }
                        paramMetaData.setDefault(string5);
                    } else if (string2.equals("coord")) {
                        if (string.indexOf("GS1.ALPHA") != -1 || string.indexOf("GS1.DELTA") != -1) {
                            stdlog_.debug((Object)("Setting default for Guide star " + string));
                            paramMetaData.setDefault("0");
                            paramMetaData.setValue("0");
                        } else {
                            paramMetaData.setDefault("");
                            paramMetaData.setValue("");
                        }
                    } else if (!paramMetaData.isHidden()) {
                        paramMetaData.setDefault("NODEFAULT");
                        paramMetaData.setValue("NODEFAULT");
                    } else {
                        paramMetaData.setDefault("");
                        paramMetaData.setValue("");
                    }
                }
                if (hashtable.containsKey(string5 = string + ".MINIHELP")) {
                    pafData = (PafData)hashtable.get(string5);
                    if (pafData.hasValue()) {
                        paramMetaData.setMiniHelp(pafData.getValue());
                    } else if (paramMetaData.isDisplay()) {
                        this.paramWarnings_.addElement("Warning Line (" + pafData.getLineNumber() + ") : " + "No mini help entered for " + paramMetaData.getParameterName());
                    }
                } else if (paramMetaData.isDisplay()) {
                    this.paramWarnings_.addElement("Warning Line (" + n + ") : " + "No mini help for parameter " + paramMetaData.getParameterName());
                }
                string4 = string + ".LABEL";
                if (hashtable.containsKey(string4)) {
                    pafData = (PafData)hashtable.get(string4);
                    if (pafData.hasValue()) {
                        paramMetaData.setLabel(pafData.getValue());
                    } else {
                        paramMetaData.setLabel(string);
                    }
                } else {
                    if (paramMetaData.isDisplay()) {
                        this.paramWarnings_.addElement("Warning Line (" + n + ") : " + "No label for parameter " + paramMetaData.getParameterName());
                    }
                    paramMetaData.setLabel(string);
                }
            } else {
                this.paramErrors_.addElement("Error Line (" + n + ") : " + "Invalid parameter tpye " + string2);
            }
        }
        return paramMetaData;
    }

    private void initunLinkedParamData(Hashtable hashtable) {
        Vector<PafData> vector = new Vector<PafData>();
        int n = 0;
        while (n < this.identifierList_.length) {
            String string;
            String string2;
            String string3 = this.identifierList_[n].getIdentifier();
            if (string3.indexOf(".") != -1 && Parameter.validParamKeyword(string2 = string3.substring(0, string3.indexOf("."))) && (string = string3.substring(0, string3.lastIndexOf("."))) != null && !hashtable.containsKey(string)) {
                vector.addElement(this.identifierList_[n]);
            }
            ++n;
        }
        this.unLinkedParamData_ = new PafData[vector.size()];
        vector.copyInto(this.unLinkedParamData_);
    }

    private void createParameters(boolean bl) {
        Object object;
        int n = this.identifierList_.length;
        Hashtable hashtable = new Hashtable();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<PafData> vector3 = new Vector<PafData>();
        int n2 = 0;
        while (n2 < n) {
            object = this.identifierList_[n2].getIdentifier();
            if (((String)object).equals("TPL.PARAM")) {
                String string = this.identifierList_[n2].getValue();
                if (string.indexOf(46) == -1) {
                    vector3.addElement(this.identifierList_[n2]);
                } else if (bl && !ParamMetaData.validParamKeyword(string.substring(0, string.indexOf(46)))) {
                    vector3.addElement(this.identifierList_[n2]);
                } else if (!hashtable.containsKey(string)) {
                    hashtable.put(string, new Hashtable());
                    vector.addElement(string);
                } else {
                    vector2.addElement(this.identifierList_[n2].getValue());
                }
            }
            ++n2;
        }
        this.setParamData(hashtable);
        this.initunLinkedParamData(hashtable);
        object = new Vector();
        int n3 = 0;
        while (n3 < vector.size()) {
            Hashtable hashtable2;
            String string = (String)vector.elementAt(n3);
            ParamMetaData paramMetaData = this.createParameter(string, hashtable2 = (Hashtable)hashtable.get(string));
            if (paramMetaData != null) {
                ((Vector)object).addElement(paramMetaData);
            }
            if (this.paramErrors_.size() > 0) {
                this.paramErrorStatus_.put(string, this.paramErrors_);
            }
            if (this.paramWarnings_.size() > 0) {
                this.paramWarningStatus_.put(string, this.paramWarnings_);
            }
            ++n3;
        }
        this.paramList_ = new ParamMetaData[((Vector)object).size()];
        ((Vector)object).copyInto(this.paramList_);
        this.duplicateNameList_ = new String[vector2.size()];
        vector2.copyInto(this.duplicateNameList_);
        this.invalidParamKeywords_ = new PafData[vector3.size()];
        vector3.copyInto(this.invalidParamKeywords_);
    }

    public String[] getDuplicateNameList() {
        return this.duplicateNameList_;
    }

    private String getWarningString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.paramWarningStatus_.containsKey(string)) {
            Vector vector = (Vector)this.paramWarningStatus_.get(string);
            int n = 0;
            while (n < vector.size()) {
                stringBuffer.append((String)vector.elementAt(n) + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private String getUnLinkedString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.unLinkedParamData_.length) {
            PafData pafData = this.unLinkedParamData_[n];
            stringBuffer.append("Warning Line (" + pafData.getLineNumber() + ") : " + pafData.getIdentifier() + " should have an associated TPL.PARAM\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toEngString() {
        int n = this.tsfName_.lastIndexOf(File.separator) + 1;
        String string = this.tsfName_.substring(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Processing template signature file: " + string + "\n");
        if (this.getCriticalStatus()) {
            int n2;
            stringBuffer.append("A critical error has been found:\n");
            if (this.compileErrorMsg_ != null) {
                stringBuffer.append(this.compileErrorMsg_ + "\n");
            }
            if (this.duplicateNameList_ != null) {
                n2 = 0;
                while (n2 < this.duplicateNameList_.length) {
                    stringBuffer.append("Duplicate Parameter found " + this.duplicateNameList_[n2] + "\n");
                    ++n2;
                }
            }
            if (this.pafLinesMissing_.length > 0) {
                n2 = 0;
                while (n2 < this.pafLinesMissing_.length) {
                    stringBuffer.append("Mandatory Paf keyword missing " + this.pafLinesMissing_[n2] + "\n");
                    ++n2;
                }
            }
            if (this.invalidParamKeywords_.length > 0) {
                n2 = 0;
                while (n2 < this.invalidParamKeywords_.length) {
                    stringBuffer.append("Incorrect parameter prefix at linenumber " + this.invalidParamKeywords_[n2].getLineNumber() + "\n");
                    ++n2;
                }
            }
            if (!this.isValidTemplateName()) {
                stringBuffer.append("Set PAF.NAME to the name of the file\n");
            }
            if (this.mandatoryKeywordsMissing_.size() > 0) {
                n2 = 0;
                while (n2 < this.mandatoryKeywordsMissing_.size()) {
                    stringBuffer.append("Mandatory keyword missing " + (String)this.mandatoryKeywordsMissing_.elementAt(n2) + "\n");
                    ++n2;
                }
            }
            if (this.mandatoryValuesMissing_.size() > 0) {
                n2 = 0;
                while (n2 < this.mandatoryValuesMissing_.size()) {
                    stringBuffer.append("Mandatory value missing for keyword " + (String)this.mandatoryValuesMissing_.elementAt(n2) + "\n");
                    ++n2;
                }
            }
            if (!this.isValidFileType()) {
                stringBuffer.append("Set PAF.TYPE to Template\n");
            }
            String string2 = this.getTemplateType();
            if (!this.isValidTemplateType()) {
                if (string2 == null || string2.length() <= 0) {
                    stringBuffer.append("TPL.PARAM value not set\n");
                } else {
                    stringBuffer.append("Invalid Template Type in TPL.TYPE " + string2 + "\n");
                }
            }
            if (string2 != null && string2.equals("acquisition") && this.execTime_ == -1) {
                stringBuffer.append("Enter an integer value into the TPL.EXECTIME value in the acquisition .tsf file\n");
                stringBuffer.append("Acquisition template cannot have computed value in TPL.EXECTIME\n");
            }
            if (!this.isValidInstrument()) {
                if (this.getInstrumentName() == null) {
                    stringBuffer.append("No instrument specified for this template in TPL.INSTRUM\n");
                } else {
                    stringBuffer.append("Template refers to an invalid instrument " + this.getInstrumentName() + " in TPL.INSTRUM" + "\n");
                }
            }
            if (this.paramErrorStatus_.size() > 0) {
                Enumeration enumeration = this.paramErrorStatus_.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    Vector vector = (Vector)this.paramErrorStatus_.get(string3);
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        stringBuffer.append((String)vector.elementAt(n3) + "\n");
                        ++n3;
                    }
                    stringBuffer.append(this.getWarningString(string3));
                }
            }
            return stringBuffer.toString();
        }
        stringBuffer.append("No critical errors found in this file\n");
        if (this.getWarningStatus()) {
            stringBuffer.append("Warning(s) have been found in this file\n");
        } else {
            stringBuffer.append("No warnings have been found in this file\n");
        }
        if (this.paramWarningStatus_.size() > 0) {
            Enumeration enumeration = this.paramWarningStatus_.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (this.paramErrorStatus_.containsKey(string4)) continue;
                stringBuffer.append(this.getWarningString(string4));
            }
        }
        stringBuffer.append(this.getUnLinkedString());
        stringBuffer.append("Finished processing template " + this.templateName_ + "\n");
        return stringBuffer.toString();
    }

    private void setParamData(Hashtable hashtable) {
        Object var2_2 = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(string);
            hashtable2.put("TPL.PARAM", this.getPafDataForParamName(string));
            int n = 0;
            while (n < this.identifierList_.length) {
                String string2 = this.identifierList_[n].getIdentifier();
                if (string2.indexOf(string) != -1) {
                    hashtable2.put(string2, this.identifierList_[n]);
                }
                ++n;
            }
        }
    }

    private PafData getPafDataForParamName(String string) {
        int n = 0;
        while (n < this.identifierList_.length) {
            if (this.identifierList_[n].getIdentifier().equals("TPL.PARAM") && string.equals(this.identifierList_[n].getValue())) {
                return this.identifierList_[n];
            }
            ++n;
        }
        return null;
    }

    public PafData[] getIdentifierList() {
        return this.identifierList_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

