/*
 * Decompiled with CFR 0.152.
 */
package org.eso.ohs.persistence;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eso.ohs.core.utilities.EmptyEnumeration;
import org.eso.ohs.core.utilities.ObjectIOException;
import org.eso.ohs.dfs.CalibrationBlock;
import org.eso.ohs.dfs.FindingChart;
import org.eso.ohs.dfs.ObservingRun;
import org.eso.ohs.dfs.Readme;
import org.eso.ohs.dfs.StorableObject;
import org.eso.ohs.dfs.Summary;
import org.eso.ohs.instruments.TemplateVersionInfo;
import org.eso.ohs.persistence.DirectoryNode;
import org.eso.ohs.persistence.Media;
import org.eso.ohs.persistence.ObjectNotFoundException;

public interface StorageManager {
    public DirectoryNode getRoot() throws ObjectIOException;

    public String[] verifyTemplateSignatures(TemplateVersionInfo[] var1) throws ObjectIOException;

    public FindingChart[] populateFindingCharts(long var1) throws ObjectIOException;

    public byte[] downloadInstrumentPackage(String var1, float var2) throws ObjectIOException;

    public Media getMedia();

    public long getNewId(Class var1, long var2) throws ObjectIOException;

    public void initialise() throws ObjectIOException;

    public DirectoryNode find(long var1, Class var3) throws ObjectNotFoundException, ObjectIOException;

    public void setUserId(int var1) throws ObjectIOException;

    public int getUserId();

    public boolean loginUser(String var1) throws ObjectIOException;

    public UnpackedStorableObject read(DirectoryNode var1, long var2, Class var4) throws ObjectIOException, ObjectNotFoundException;

    public void write(DirectoryNode var1, long var2, Class var4, UnpackedStorableObject var5) throws ObjectIOException;

    public void update(DirectoryNode var1, long var2, Class var4, UnpackedStorableObject var5) throws ObjectIOException;

    public void delete(DirectoryNode var1, long var2, Class var4) throws ObjectIOException;

    public void move(long var1, Class var3, DirectoryNode var4, DirectoryNode var5) throws ObjectIOException, ObjectNotFoundException;

    public boolean createDirectory(DirectoryNode var1, long var2) throws ObjectIOException;

    public boolean moveDirectory(DirectoryNode var1, DirectoryNode var2) throws ObjectNotFoundException, ObjectIOException;

    public boolean deleteDirectory(DirectoryNode var1) throws ObjectIOException;

    public Summary[] listObjects(DirectoryNode var1) throws ObjectIOException;

    public void checkIn(MultiObjSpec[] var1) throws ObjectIOException;

    public void checkInReadme(ObservingRun var1) throws ObjectIOException;

    public Readme populateReadmeFile(ObservingRun var1) throws ObjectIOException;

    public Readme populateReadmeFileReplicate(ObservingRun var1) throws ObjectIOException;

    public void setReadmeFileStatus(String var1, long var2) throws ObjectIOException;

    public void usdSubmit(ObservingRun var1) throws ObjectIOException;

    public boolean verifyObject(MultiObjSpec[] var1) throws ObjectIOException;

    public void checkOut(IdType[] var1) throws ObjectNotFoundException, ObjectIOException;

    public String checkOutReadme(ObservingRun var1) throws ObjectIOException;

    public void multiStore(MultiObjSpec[] var1) throws ObjectIOException;

    class 1 {
        static /* synthetic */ Class class$org$eso$ohs$dfs$ObservingRun;

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class IdType
    implements Serializable {
        static final long serialVersionUID = -9161241158498319561L;
        public long id;
        public Class objType;

        public IdType(long l, Class clazz) {
            this.id = l;
            this.objType = clazz;
        }

        public int hashCode() {
            return this.objType == null ? (int)this.id : (int)(this.id ^ (long)this.objType.hashCode());
        }

        public boolean equals(Object object) {
            if (object instanceof IdType) {
                IdType idType = (IdType)object;
                return idType.objType == this.objType && idType.id == this.id;
            }
            return false;
        }

        public String toString() {
            return "IdType[id=" + this.id + ",objType=" + this.objType + "]";
        }
    }

    public static class UnpackedStorableObject
    implements Serializable {
        static final long serialVersionUID = 4696495710324895272L;
        private StorableObject sobj_;
        private Hashtable nestedObjects_;

        public UnpackedStorableObject(StorableObject storableObject) {
            if (storableObject == null) {
                throw new IllegalArgumentException("UnpackedStorableObject: StorableObject was null");
            }
            this.sobj_ = storableObject;
        }

        public StorableObject getObject() {
            return this.sobj_;
        }

        public void addNestedObjId(String string, StorableObject storableObject) {
            this.addNestedObjId(string, storableObject.getId());
        }

        public void addNestedObjId(String string, long l) {
            if (this.nestedObjects_ == null) {
                this.nestedObjects_ = new Hashtable();
            }
            this.nestedObjects_.put(string, new Long(l));
        }

        public boolean isKnown(String string) {
            return this.nestedObjects_ != null && this.nestedObjects_.get(string) != null;
        }

        public long getNestedObjId(String string) {
            Long l;
            if (this.nestedObjects_ != null && (l = (Long)this.nestedObjects_.get(string)) != null) {
                return l;
            }
            return 0L;
        }

        public Enumeration getProperties() {
            return this.nestedObjects_ == null ? new EmptyEnumeration() : this.nestedObjects_.keys();
        }

        private boolean checkPropertyExists(String string) {
            Class<?> clazz = this.sobj_.getClass();
            try {
                Method method = clazz.getMethod("get" + string, new Class[0]);
                Method method2 = clazz.getMethod("set" + string, method.getReturnType());
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
        }
    }

    public static class MultiObjSpec
    implements Serializable {
        static final long serialVersionUID = -3402500148904197774L;
        private boolean isNew;
        public DirectoryNode dir;
        private Class cls;
        public UnpackedStorableObject obj;

        public StorableObject getStorableObject(long l) {
            if (this.obj.getObject().getId() == l) {
                return this.obj.getObject();
            }
            return null;
        }

        public static CalibrationBlock fromMultiObjSpecToCalBlock(MultiObjSpec[] multiObjSpecArray, StorageManager storageManager) throws IllegalArgumentException, IOException {
            Object object;
            Serializable serializable;
            CalibrationBlock calibrationBlock = null;
            boolean bl = false;
            long l = -1L;
            int n = 0;
            while (n < multiObjSpecArray.length) {
                serializable = multiObjSpecArray[n].obj.getObject();
                if (serializable instanceof CalibrationBlock) {
                    bl = true;
                    object = multiObjSpecArray[n].obj.getProperties();
                    block8: while (object.hasMoreElements()) {
                        String string = (String)object.nextElement();
                        long l2 = multiObjSpecArray[n].obj.getNestedObjId(string);
                        if (string.equals("ObsRun")) {
                            l = l2;
                        }
                        int n2 = 0;
                        while (n2 < multiObjSpecArray.length) {
                            StorableObject storableObject = multiObjSpecArray[n2].getStorableObject(l2);
                            if (storableObject != null) {
                                try {
                                    Class<?> clazz = serializable.getClass();
                                    Method method = clazz.getMethod("get" + string, new Class[0]);
                                    Method method2 = clazz.getMethod("set" + string, method.getReturnType());
                                    method2.invoke((Object)serializable, storableObject);
                                    continue block8;
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    throw new IOException(illegalAccessException.getMessage());
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    throw new IOException(invocationTargetException.getMessage());
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    throw new IllegalArgumentException("corrupt data: " + string);
                                }
                            }
                            ++n2;
                        }
                    }
                    calibrationBlock = (CalibrationBlock)serializable;
                }
                ++n;
            }
            if (l != -1L && storageManager != null) {
                try {
                    serializable = storageManager.read(null, l, 1.class$org$eso$ohs$dfs$ObservingRun == null ? (1.class$org$eso$ohs$dfs$ObservingRun = 1.class$("org.eso.ohs.dfs.ObservingRun")) : 1.class$org$eso$ohs$dfs$ObservingRun);
                    object = (ObservingRun)((UnpackedStorableObject)serializable).getObject();
                    calibrationBlock.setObsRun((ObservingRun)object);
                }
                catch (ObjectIOException objectIOException) {
                    throw new IOException(objectIOException.getMessage());
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    throw new IOException(objectNotFoundException.getMessage());
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("CalBlock/ObsBlock not found in multi obj list");
            }
            calibrationBlock.refreshTemplates(false);
            return calibrationBlock;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setNew(boolean bl) {
            System.out.println("Is New" + bl + " Class " + this.cls);
            this.isNew = bl;
        }

        public Class getCls() {
            return this.cls;
        }

        public void setCls(Class clazz) {
            this.cls = clazz;
        }
    }
}

