/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.SrvDataToken;
import com.sybase.jdbc2.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc2.tds.SrvRowToken;
import com.sybase.jdbc2.tds.SrvTypeFormatter;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;

public class SrvAltRowToken
extends SrvRowToken
implements SrvDataToken,
Dumpable {
    int _id;

    public SrvAltRowToken(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
        this._id = tdsInputStream.readShort();
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        if (this._formatter == null) {
            throw new Error("Ya godda have a formatter to dump rows.");
        }
        DumpInfo dumpInfo = null;
        SrvJavaTypeFormatter srvJavaTypeFormatter = (SrvJavaTypeFormatter)this._formatter;
        Object[] objectArray = srvJavaTypeFormatter.convertData(this);
        if (dumpFilter.includesToken(211)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ALTROW Token (0x" + HexConverts.hexConvert(211, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "ALTROW Token");
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(6)) {
                dumpInfo.addInt("ID", 2, this._id);
                int[] nArray = srvJavaTypeFormatter.getDataLengths();
                int[] nArray2 = srvJavaTypeFormatter.getLengthSizes();
                int n = 0;
                while (n < objectArray.length) {
                    dumpInfo.addInfo("TDSFmt", 0, "Column " + (n + 1));
                    if (dumpFilter.includesDetail(1)) {
                        dumpInfo.addInt("Length", nArray2[n], nArray[n]);
                    }
                    if (objectArray[n] instanceof byte[]) {
                        dumpInfo.addHex("Row Data", nArray[n], (byte[])objectArray[n]);
                    } else {
                        dumpInfo.addInfo("Row Data", nArray[n], objectArray[n]);
                    }
                    ++n;
                }
            }
        }
        return dumpInfo;
    }

    public int getId() {
        return this._id;
    }

    public TdsInputStream getStream() {
        return this._in;
    }

    public int getTokenType() {
        return 211;
    }

    public void setFormatter(SrvTypeFormatter srvTypeFormatter) {
        this._formatter = srvTypeFormatter;
    }
}

