/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.SrvTextImageData;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import java.io.IOException;

public class SrvDataFormat
extends DataFormat
implements Dumpable {
    protected SrvDataFormat() {
    }

    public SrvDataFormat(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
    }

    public SrvDataFormat(String string, int n, int n2, int n3, int n4, int n5, Object object) {
        this(string, n, n2, n3, object);
        this._precision = n4;
        this._scale = n5;
    }

    public SrvDataFormat(String string, int n, int n2, int n3, Object object) {
        this(string, n, n2, n3, object, null);
    }

    public SrvDataFormat(String string, int n, int n2, int n3, Object object, String string2) {
        this._name = string;
        this._nameLen = this._name != null ? string.length() : 0;
        this._status = n2;
        this._usertype = 0;
        switch (n) {
            case 9217: {
                this._datatype = 36;
                this._blobType = 1;
                if (object != null) {
                    this._className = object.getClass().getName();
                    this._classIdLen = this._className.length();
                    break;
                }
                this._classIdLen = 0;
                break;
            }
            case 9219: {
                this._datatype = 36;
                this._blobType = 3;
                this._classIdLen = 0;
                break;
            }
            case 9220: {
                this._datatype = 36;
                this._blobType = 4;
                this._classIdLen = 0;
                break;
            }
            case 34: 
            case 35: {
                if (object != null && object instanceof SrvTextImageData) {
                    this._tableName = ((SrvTextImageData)object).getTableName();
                }
            }
            default: {
                this._datatype = n;
            }
        }
        this._length = n3;
        this._precision = 0;
        this._scale = 0;
        this._locale = string2;
        this._localeLen = string2 == null ? 0 : string2.length();
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = dumpFilter.getDumpInfo();
        if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(7)) {
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Name Length", 1, this._nameLen);
            }
            if (this._nameLen > 0) {
                dumpInfo.addText("Name", this._nameLen, this._name);
            }
            String[] stringArray = new String[]{"<unrecognized>", "ROW_HIDDEN", "ROW_KEY", "ROW_VERSION", "ROW_NODATA", "ROW_UPDATABLE", "ROW_NULLALLOWED", "ROW_IDENTITY ", "ROW_PADCHAR"};
            dumpInfo.addBitfield("Status", 1, this._status, stringArray);
            dumpInfo.addInt("User Type", 4, this._usertype);
            dumpInfo.addInfo("Data Type", 1, DataFormat.getDataTypeString(this._datatype));
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", DataFormat.lengthSize(this._datatype), this._length);
            }
            if (this._datatype == 106 || this._datatype == 108) {
                dumpInfo.addHex("Precision", 1, this._precision);
                dumpInfo.addHex("Scale", 1, this._scale);
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Locale Length", 1, this._localeLen);
            }
            if (this._datatype == 36) {
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Class ID Length", 2, this._classIdLen);
                }
                if (this._classIdLen > 0) {
                    dumpInfo.addText("ClassID", this._classIdLen, this._className);
                }
            }
            if (this._localeLen > 0) {
                dumpInfo.addText("Locale", this._localeLen, this._locale);
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return -1;
    }
}

