/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.RowToken;
import com.sybase.jdbc2.tds.SrvDataToken;
import com.sybase.jdbc2.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc2.tds.SrvTypeFormatter;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;

public class SrvRowToken
extends RowToken
implements SrvDataToken,
Dumpable {
    SrvTypeFormatter _formatter = null;
    TdsInputStream _in = null;

    public SrvRowToken() {
    }

    public SrvRowToken(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
        this._in = tdsInputStream;
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        if (this._formatter == null) {
            throw new Error("Ya godda have a formatter to dump rows.");
        }
        DumpInfo dumpInfo = null;
        SrvJavaTypeFormatter srvJavaTypeFormatter = (SrvJavaTypeFormatter)this._formatter;
        Object[] objectArray = srvJavaTypeFormatter.convertData(this);
        if (dumpFilter.includesToken(209)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ROW Token (0x" + HexConverts.hexConvert(209, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "ROW Token");
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(6)) {
                int[] nArray = srvJavaTypeFormatter.getDataLengths();
                int[] nArray2 = srvJavaTypeFormatter.getLengthSizes();
                int n = 0;
                while (n < objectArray.length) {
                    dumpInfo.addInfo("TDSFmt", 0, "Column " + (n + 1));
                    if (dumpFilter.includesDetail(1)) {
                        dumpInfo.addInt("Length", nArray2[n], nArray[n]);
                    }
                    dumpInfo.addValue("Row data", nArray[n], objectArray[n]);
                    ++n;
                }
            }
        }
        return dumpInfo;
    }

    public TdsInputStream getStream() {
        return this._in;
    }

    public int getTokenType() {
        return 209;
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(209);
        this._formatter.sendDataStream(tdsOutputStream);
    }

    public void setFormatter(SrvTypeFormatter srvTypeFormatter) {
        this._formatter = srvTypeFormatter;
    }
}

