/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.Selector;

public abstract class IdentityConstraint {
    public static final short UNIQUE = 0;
    public static final short KEY = 1;
    public static final short KEYREF = 2;
    protected short type;
    protected String fIdentityConstraintName;
    protected String fElementName;
    protected Selector fSelector;
    protected int fFieldCount;
    protected Field[] fFields;

    protected IdentityConstraint(String identityConstraintName, String elemName) {
        this.fIdentityConstraintName = identityConstraintName;
        this.fElementName = elemName;
    }

    public short getType() {
        return this.type;
    }

    public String getIdentityConstraintName() {
        return this.fIdentityConstraintName;
    }

    public void setSelector(Selector selector) {
        this.fSelector = selector;
    }

    public Selector getSelector() {
        return this.fSelector;
    }

    public void addField(Field field) {
        if (this.fFields == null) {
            this.fFields = new Field[4];
        } else if (this.fFieldCount == this.fFields.length) {
            this.fFields = IdentityConstraint.resize(this.fFields, this.fFieldCount * 2);
        }
        this.fFields[this.fFieldCount++] = field;
    }

    public int getFieldCount() {
        return this.fFieldCount;
    }

    public Field getFieldAt(int index) {
        return this.fFields[index];
    }

    public String getElementName() {
        return this.fElementName;
    }

    public String toString() {
        String s = super.toString();
        int index1 = s.lastIndexOf(36);
        if (index1 != -1) {
            return s.substring(index1 + 1);
        }
        int index2 = s.lastIndexOf(46);
        if (index2 != -1) {
            return s.substring(index2 + 1);
        }
        return s;
    }

    public boolean equals(IdentityConstraint id) {
        boolean areEqual = this.fIdentityConstraintName.equals(id.fIdentityConstraintName);
        if (!areEqual) {
            return false;
        }
        areEqual = this.fSelector.toString().equals(id.fSelector.toString());
        if (!areEqual) {
            return false;
        }
        boolean bl = areEqual = this.fFieldCount == id.fFieldCount;
        if (!areEqual) {
            return false;
        }
        int i = 0;
        while (i < this.fFieldCount) {
            if (!this.fFields[i].toString().equals(id.fFields[i].toString())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static final Field[] resize(Field[] oldArray, int newSize) {
        Field[] newArray = new Field[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, newSize);
        return newArray;
    }
}

