/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMLocator;
import org.apache.xerces.xni.parser.XMLParseException;

public class DOMErrorImpl
implements DOMError {
    short fSeverity = 0;
    String fMessage = null;
    DOMLocator fLocation = null;
    Exception fException = null;

    public DOMErrorImpl() {
    }

    public DOMErrorImpl(short severity, XMLParseException exception) {
        this.fSeverity = severity;
        this.fException = exception;
        this.fMessage = exception.getMessage();
        this.fLocation = this.createDOMLocator(exception);
    }

    public short getSeverity() {
        return this.fSeverity;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public Object getException() {
        return this.fException;
    }

    public DOMLocator getLocation() {
        return this.fLocation;
    }

    private DOMLocator createDOMLocator(XMLParseException exception) {
        return new DOMLocatorImpl(exception.getLineNumber(), exception.getColumnNumber(), exception.getExpandedSystemId());
    }

    public void setSeverity(short error) {
        this.fSeverity = error;
    }

    public void setMessage(String msg) {
        this.fMessage = msg;
    }

    public void setLocator(DOMLocator locator) {
        this.fLocation = locator;
    }

    public void setException(Exception ex) {
        this.fException = ex;
    }

    public void reset() {
        this.fSeverity = 0;
        this.fMessage = null;
        this.fLocation = null;
        this.fException = null;
    }
}

